/**************************************************************************/
/*                                                                        */
/*                                  SCRN2.C                               */
/*                          Parameter Entry Screen                        */
/*                                (text mode)                             */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include "scrn2.h"

struct Parameters param_screen()
{
   char ans    [ANSWERLEN],
        minstr [ANSWERLEN];
   struct Parameters params;

      clrscr();
      textbackground( H_COL );
      textcolor( HTEXT_COL );
      cprintf( TOP_MESSAGE );

      textbackground( BACKGROUND_COL );
      textcolor( TEXT_COL );
      printf( "\n" );
      cprintf( "Name of word file to use (default is %s)? ", DEFAULTSTRF );
      gets( params.filename );
      if( !strlen( params.filename ) )
           strcpy( params.filename, DEFAULTSTRF );
      PRINT_STRIPE;
      
      textbackground( BACKGROUND_COL );
      cprintf( "Maximum time for this run, in minutes (default is %s)? ",
               DEFAULTSTRT );
      gets( ans );
      if( !strlen( ans ) )
          params.maxtime = DEFAULTTIME;
      else
         params.maxtime = atoi( ans ) * SEC_PER_MIN;
      if( params.maxtime < MINTIME )
          params.maxtime = MINTIME;
      PRINT_STRIPE;

      textbackground( BACKGROUND_COL );
      cprintf( "Maximum number of words to display (default is %d)? ",
                DEFAULTWORDS );
      gets( ans );
      if( !strlen( ans ) )
          params.maxwords = DEFAULTWORDS; 
      else
          params.maxwords = atoi( ans );
      if( params.maxwords < MINWORDS )
          params.maxwords = MINWORDS;
      PRINT_STRIPE;
      

      textbackground( BACKGROUND_COL );
      cprintf( "Display frequency in \"speed units\" (default is %3.2f)? ",
                DEFAULTFREQ );
      gets( ans );
      if( !strlen( ans ) )
          params.frequency = DEFAULTFREQ; 
      else
          params.frequency = atof( ans );
      if( params.frequency < MINFREQ )
          params.frequency = MINFREQ;
      if( params.frequency > MAXFREQ )
          params.frequency = MAXFREQ;
      PRINT_STRIPE;

      textbackground( BACKGROUND_COL );
      cprintf(
      "Do you wish to skip the next screen and start immediately (default is NO)? " );
      gets( ans );
      if( *ans == 'y' || *ans == 'Y' )
          params.cdnscr = OFF;
      else
          params.cdnscr = ON;
      PRINT_STRIPE;

     /************************************/

      textbackground( BACKGROUND_COL );
      textcolor( TEXT_COL2 );
      cprintf( "\n\n" );
      cprintf( "The parameters for this round are the following:" );
      printf( "\n\nWord file to use is %s.\n", strupr( params.filename ) );

      if( params.maxtime == 1 * SEC_PER_MIN ) 
          strcpy( minstr, "minute" );
      else
          strcpy( minstr, "minutes" );
      printf( "Maximum time limit = %d %s.",
               params.maxtime / SEC_PER_MIN, minstr );

      printf( "\nMaximum number of words to display = %d.", params.maxwords );

      printf( "\nRequested display frequency = %1.2f \"speed units\".",
               params.frequency );
      printf( "\nSelected  display frequency = %1.2f \"speed units\".",
             FF / (int)(FF/params.frequency) );
      textcolor( TEXT_COL3 ); //White
      highvideo(); //HIGH INTENSITY
      cprintf(
      "                               Note: \"Speed units\" correspond to words/sec. at lower frequencies only." );
      normvideo(); //NORMAL


/*****************************final***************************************/

      textbackground( BACKGROUND_COL );
      textcolor( TEXT_COL_FINAL );
      _setcursortype( _NOCURSOR );     //Make cursor go away.
      cprintf( "\n\n" );
      cprintf( "                                     " );
      cprintf( "Press a key to continue." );
      getch( );
      _setcursortype( _NORMALCURSOR ); //Hello, again, Mr. Cursor.
 

/***************************************************************************/

      return( params );

}

struct Parameters set_defaults()
{
   struct Parameters DefaultParams;

      /* Initialize to default values defined in scrn2.h */
      /****************************************************/
      strcpy( DefaultParams.filename, DEFAULTSTRF );
      DefaultParams.maxtime = DEFAULTTIME;
      DefaultParams.maxwords = DEFAULTWORDS;
      DefaultParams.frequency = DEFAULTFREQ;
      DefaultParams.cdnscr = OFF;
      /***************************************************/

      return( DefaultParams );
}
