/**
 ** This is file GRDRIVER.H
 **
 ** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
 ** Copyright (C) 1992 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** Copyright (C) 1993 Grzegorz Mazur, gbm@ii.pw.edu.pl
 **
 ** This file is distributed under the terms listed in the document
 ** "copying.dj", available from DJ Delorie at the address above.
 ** A copy of "copying.dj" should accompany this file; if not, a copy
 ** should be available from where this file was obtained.  This file
 ** may not be distributed without a verbatim copy of "copying.dj".
 **
 ** This file is distributed WITHOUT ANY WARRANTY; without even the implied
 ** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **/

#ifndef _GRDRIVER_H_
#define _GRDRIVER_H_

#if defined(__GNUC__) && !defined(near)
# define near
# define far
# define huge
#endif

/* ================================================================== */
/*		      DRIVER HEADER STRUCTURES			      */
/* ================================================================== */

typedef struct {
    /*
     * ---------------------- GRD ----------------------------
     * slots present in all (.GRD, .GRN, .VDR) driver versions
     */
    unsigned short  modeset_routine;
    unsigned short  paging_routine;
    unsigned short  driver_flags;
    unsigned short  def_tw;
    unsigned short  def_th;
    unsigned short  def_gw;
    unsigned short  def_gh;
    /*
     * ---------------------- GRN ----------------------------
     * The next fields are present only in the ".GRN" (introduced with GRX 1.01)
     * format drivers. ".GRN" format drivers are indicated by the 'GR_NEW_DRIVER'
     * bit (see below) set in the 'driver_flags' word. The text and graphics
     * table entries are offsets to tables of GR_DRIVER_MODE_ENTRY structures.
     */
    unsigned short  def_numcolor;
    unsigned short  driver_init_routine;
    unsigned short  text_table;
    unsigned short  graphics_table;
    /*
     * The following entry was defined for GRX 1.02, but page flipping was never
     * implemented in this form. The new virtual screen feature of GRX 1.03
     * makes this obsolete.
     */
    unsigned short  pageflip_routine;
    /*
     * ---------------------- VDR ----------------------------
     * All subsequent fields are present only in the ".VDR" driver format
     * introduced with GO32 1.11 and GRX 1.03. ".VDR" format drivers can be
     * recognized by first checking for the ".GRN" format, then comparing
     * the 'vdr_magic' string with ".VDR driver".
     * The next fields are hard-coded in the driver binary:
     */
    unsigned char   vdr_magic[12];	/* indicates VDR format */
    unsigned short  driver_name_offset; /* just for documentation */
    unsigned short  set_screen_start;	/* page flip/scroll function */
    /*
     * field configured by GO32 from env. var. options when driver is loaded:
     */
    unsigned short  driver_options;	/* driver control bits: see defs below */
    /*
     * fields filled out by the driver initialization routine
     */
    unsigned short  memory_size;	/* total video adapter memory in 4KByte units */
    /*
     * fields read/written both by the driver and GO32 during every mode set
     */
    unsigned short  virt_x_res;		/* virtual X res; GO32: writes desired, drv: reports actual */
    unsigned short  virt_y_res;		/* virtual Y res; GO32: writes desired, drv: reports actual */
    void     far  (*VESA_paging_fnc)(); /* VESA paging fn; drv: reports real mode, GO32: cvt to prot */
    /*
     * driver uses these after every mode set to report mode dependent
     * parameters to the extender and graphics libraries
     */
    unsigned short  line_offset;	/* scan line length */
    unsigned short  wr_page_start;	/* start paragraph of the writable (or single R/W) page */
    unsigned short  rd_page_start;	/* start paragraph of the readable page (FFFF => single) */
    unsigned char   page_size_shift;	/* log2 of page size/4kB */
    unsigned char   page_gran_shift;	/* log2 of VESA page size/granularity */
    unsigned char   r_mask,r_offs;	/* pixel format info in VESA 1.2 style: */
    unsigned char   g_mask,g_offs;	/*   used in TrueColor modes by the */
    unsigned char   b_mask,b_offs;	/*   GRX (1.03+) graphics library   */
    unsigned char   f_mask,f_offs;	/* VESA 1.2 says there may be fill bits */
    /*
     * these are here to support future GRX and GO32 developments
     */
    unsigned long   linear_addr;	/* starting at this extended memory address */
    unsigned short  linear_size;	/* if > 0 then map this many 4 kByte pages */
    unsigned short  paging_fnc32;	/* offset of 32 bit paging function */
} GrDriverHeader;

typedef struct {
    unsigned short  width;
    unsigned short  height;
    unsigned short  number_of_colors;
    union {
#if defined(__GNUC__) || defined(__TURBOC__)
       struct {
	   unsigned short BIOS_mode:12;
	   unsigned short custom_setup_index:4;
       } vdr;
#else
#      error Check how your compiler aligns bitfields before you use this code!
#endif
       struct {
	   unsigned char  BIOS_mode;
	   unsigned char  custom_setup_index;
       } grn;
    } mode;
} GrModeEntry,GR_DRIVER_MODE_ENTRY;


/* ================================================================== */
/*	   DRIVER FLAG (THIRD WORD IN DRIVER HEADER) BITS	      */
/* ================================================================== */

#define GRD_NEW_DRIVER  0x0008		/* NEW FORMAT DRIVER IF THIS IS SET */

#define GRD_PAGING_MASK 0x0007		/* mask for paging modes */
#define GRD_NO_RW	0x0000		/* standard paging, no separate R/W */
#define GRD_RW_64K	0x0001		/* two separate (formerly 64K only) R/W pages */
/* !!! THE FOLLOWING THREE OPTIONS ARE NOT SUPPORTED AND/OR OBSOLETE !!! */
#define GRD_RW_32K	0x0002		/* two separate 32Kb pages */
#define GRD_MAP_128K	0x0003		/* 128Kb memory map -- some Tridents do it */
#define GRD_MAP_EXTMEM  0x0004		/* Can be mapped extended, above 1M. */
/* !!! */

#define GRD_TYPE_MASK	0xf000		/* adapter type mask */
#define GRD_VGA		0x0000		/* vga */
#define GRD_EGA		0x1000		/* ega */
#define GRD_HERC	0x2000		/* hercules */
#define GRD_8514A	0x3000		/* IBM 8514A or compatible */
#define GRD_S3		0x4000		/* S3 graphics accelerator */
/* ++ GRX 1.03 ".VDR" format */
#define GRD_W9000	0x5000		/* Weitek 9000 accelerator */

#define GRD_PLANE_MASK  0x0f00		/* bitplane number mask */
#define GRD_8_PLANES	0x0000		/* 8 planes = 256 colors */
#define GRD_4_PLANES	0x0100		/* 4 planes = 16 colors */
#define GRD_1_PLANE	0x0200		/* 1 plane = 2 colors */
#define GRD_16_PLANES	0x0300		/* VGA with 32K colors (really only 15 planes) */
#define GRD_8_X_PLANES  0x0400		/* VGA in mode X w/ 256 colors */
/* ++ GRX 1.03 ".VDR" format */
#define GRD_8_F_PLANES  0x0500		/* VGA 256c switchable betw. linear and modeX */
#define GRD_16_R_PLANES 0x0600		/* The "real" 16 plane mode with 64K colors */
#define GRD_24_PLANES	0x0700		/* 24 plane "TrueColor" mode */

#define GRD_MEM_MASK	0x00f0		/* memory size mask */
#define GRD_M_NOTSPEC	0x0000		/* memory amount not specified */
#define GRD_64K		0x0010		/* 64K display memory */
#define GRD_128K	0x0020		/* 128K display memory */
#define GRD_256K	0x0030		/* 256K display memory */
#define GRD_512K	0x0040		/* 512K display memory */
#define GRD_1024K	0x0050		/* 1MB display memory */
#define GRD_192K	0x0060		/* 192K -- some 640x480 EGA-s */
/* ++ GRX 1.03 ".VDR" format */
#define GRD_1536K	0x0070		/* 1.5 MB */
#define GRD_2048K	0x0080		/* 2.0 MB */
#define GRD_3072K	0x0090		/* 3.0 MB */
#define GRD_4096K	0x00a0		/* 4.0 MB */


/* ================================================================== */
/*	 DRIVER CONTROL BITS (SET BY GO32 WHEN DRIVER IS LOADED)      */
/* ================================================================== */

#define GRD_FAST_256_MODE	1	/* switch betw. lin. and planar 256 c. modes */
#define GRD_PROTECTED_PAGING	2	/* use paging function in protected mode */
#define GRD_15_PLANE_MODE	4	/* VESA reported 16 bpp mode is really only 15 */
#define GRD_ENABLE_LINEAR_VRAM  8	/* ext. memory linear mapping (not sup yet) */


/* ================================================================== */
/*		     COMPILER-DEPENDENT CONSTANTS		      */
/* ================================================================== */

#ifdef __GNUC__
# define VGA_FRAME	0xd0000000	/* VGA video RAM */
# define HERC_FRAME	0xe00b0000	/* Hercules frame addr */
# define EGA_FRAME	0xe00a0000	/* EGA frame addr */
# define RDONLY_OFF	0x00100000	/* VGA dual page: Read only */
# define WRONLY_OFF	0x00200000	/* VGA dual page: Write only */
# define BIG_VGA_FRAME  0xd1000000	/* 16MB VGA video RAM */
# define BIG_RDONLY_OFF 0x01000000	/* 16MB VGA dual page: Read only */
# define BIG_WRONLY_OFF 0x02000000	/* 16MB VGA dual page: Write only */
#endif

#ifdef __TURBOC__
# define VGA_FRAME	0xa0000000UL	/* VGA video RAM */
# define EGA_FRAME	0xa0000000UL	/* EGA video RAM */
# define HERC_FRAME	0xb0000000UL	/* Hercules frame addr */
# define RDONLY_OFF	0		/* VGA dual page: Read only */
# define WRONLY_OFF	0		/* VGA dual page: Write only */
#endif


/* ================================================================== */
/*		      DRIVER INTERFACE FUNCTIONS		      */
/* ================================================================== */

extern long _GrGetDriverModes(GrModeEntry far **t,GrModeEntry far **g);
extern long _GrLowSetMode(int mode,int width,int height,int colors);

#ifdef __TURBOC__
extern void _GrSetVideoPage(int page);
extern void _GrSetAsmPage(void);	/* takes page(s) in AL, AH */
#endif

#define GrGetDriverModes _GrGetDriverModes

/*
 * Values returned by _GrGetDriverModes and _GrLowSetMode in the
 * upper half of their returned long. (The lower half is the driver
 * option word.) This was introduced in GO32 1.11, before that
 * this word was either zero or sign extended. (Does not matter which
 * since neither can match these return values.) These values can be
 * used by the graphics libraries to determine what version of the
 * extender they are talking to.
 */
#define GR_DRV_VER_GRD  0x19910000L
#define GR_DRV_VER_GRN  0x19920000L
#define GR_DRV_VER_VDR  0x19930000L

#endif /* whole file */

