DECLARE SUB PRtxt (S$, a$)
DECLARE SUB CLRtxt (L!, S$, c!)
DECLARE SUB PR (S$, a$)
DECLARE SUB Noise (n!)
REM MAPFIX.bas PROGRAM.  SEE MAPFIX.TXT for HELP info


Ver$ = "2.0"  ' See text below for upgrade info
MaxNumMAPS = 150' Maximum number of maps allowed in MAPLIST
MaxNumPoints = 3000  'APRS limit. Six times this many are permitted in MAPFIX
MaxNumLABELS = 199 'was 99 prior to 68c
MaxNumLines = 1900
Maplist$ = "\APRS\MAPLIST.USA"
REM $DYNAMIC
   ScrnType$ = "EGA": Ycen = 175: Yfactr = 1: YfacTXT = 350 / 350: SCREEN 9
   COLOR 15, 0
   REM for EGA test, Cfactr = 14: bln = 25
   GBLn = 43: Cfactr = 8: bln = 43
   WIDTH 80, 43

   PALETTE 6, 6
   DIM Crsr(16)
   CIRCLE (4, 3), 4, 14
   GET (0, 0)-(8, 6), Crsr
   REM PSET (40, 50), 10
   REM PUT (40 - 4, 50 - 3), Crsr, XOR
   REM LOCATE 23, 1: INPUT a$
GOTO BEGIN

Info: COLOR 15, 4: CLS
   PRINT " Ver 2.0    * TOTALLY NEW COMMAND structure!  (hopefully more user friendly)"
   PRINT "            * Better Aspect Ratio for TRIM and IMPORT commands"
   PRINT "            * Added LABELS-IMPORT, and LABELS-MOVE commands"
   PRINT
   PRINT " ********** YOU WILL HAVE TO READ THE HELP SCREEN CAREFULLY!  **************"
   PRINT : BEEP
   PRINT
   PRINT
   PRINT " **********  MAPFIX can build and edit APRS maps in a variety of ways:  *****"
   PRINT
   PRINT " FREE-HAND:  Good for filling in missing roads, but hard to make roads exact"
   PRINT " CDROM:      Gets points from 2,000,000:1 and 100,000:1 USGS CD ROM.   See"
   PRINT "             MAPS-CD.txt.   It still takes time to fine tune to a good map"
   PRINT " TABLET:     Connect a serial data digitizer tablet and draw!     BEST METHOD!"
   PRINT " GPS DATA:   Replay any APRS GPS track history file and DRAW map lines over it"
   PRINT " CONVERSION: Change origin or scale on-line "
   PRINT " IMPORTING:  Import features from other maps with auto-point conversion!"
   PRINT " OVERLAY:    Overlay any map onto present map to compare and move lines to fit"
   PRINT
   PRINT
   PRINT " FOR MORE INFO, BE SURE TO READ THE MAPS.txt, <APMAKIN.txt and MAPFIX.TXT file!"
   PRINT
   PRINT
   Display$ = "UNKnown"
   RETURN

GetChar: a$ = "": DO UNTIL a$ <> "": a$ = INKEY$: LOOP: RETURN

BEGIN: GOSUB Info:
   PRINT " HIT ANY KEY to proceed onto the HELP screen...";
   GOSUB GetChar

   DIM x%(6 * MaxNumPoints), y%(6 * MaxNumPoints)
   DIM LN$(MaxNumLines) ' (no limit in APRS)
   nn = 2 * MaxNumLABELS
   DIM ML$(nn), MLa(nn), MLo(nn), MLr(nn) 'Map Labels, lengths and coordinates
   nn = 2 * MaxNumMAPS
   DIM MapName$(nn), LatCen(nn), LonCen(nn), MapMax(nn), Comment$(nn)
   i = 1000
   DIM HLAT(i), HLONG(i)'For lat/longs from big GPS history files
   Mpath$ = ""
INIT: ON ERROR GOTO ErrorTrap
   RdsOn = -1: LabelsON = -1:  KP = 1: Changed = 0: MapSize = 256
   Redraw = -1: Acenter = 0: nmp = 0: z = 0: nml = 0: LNi = 0
   Path$ = "C:\MAPS\S01_": Epts = -1

SCREEN , , 0, 0: Display$ = "HELP": GOSUB HELP: GOSUB LoadMap
REM ON ERROR GOTO 0

Main: GOSUB DrwMPaCur
  DO
GoAgain: Fault = 0
    a$ = ""
    IF Digitizer THEN
       IF LOC(1) > 9 THEN
          GOSUB GetXY
          REM Here is where ANY digitizer input ADDS a point EXCEPT if it was
          REM due to a button 3.  If button 3, then just the cursor moves.
          REM To configure MAPFIX to recognize your buttons, see GetXY.
          REM If you have no, or just 1 button, then F1 will simulate a button
          REM 3 so you can use the digitizer to only move the cursor
          IF JustCur OR Btn = 3 THEN
             GOSUB Cursor: GOSUB DrwMpPt' Only move cursor and clear JustCur
          ELSEIF Btn = 1 THEN a$ = CHR$(0) + CHR$(62) 'same as F4
          ELSEIF Btn = 2 THEN a$ = CHR$(0) + CHR$(65) 'same as F7
          ELSE GOSUB Cursor: GOSUB AddPoint'
          END IF
       END IF
    END IF
    IF Mouse THEN
       IF LOC(1) > 2 THEN
       c$ = INPUT$(1, 1)
       IF c$ > CHR$(191) THEN
         a = ASC(c$) - 192
         x = 0: y = 0
         c$ = INPUT$(1, 1): IF c$ > CHR$(127) THEN x = ASC(c$) - 128
         c$ = INPUT$(1, 1): IF c$ > CHR$(127) THEN y = ASC(c$) - 128
         IF x > 31 THEN x = x - 64
         IF y > 31 THEN y = y - 64
         CPX = CPX - x * degpmh
         CPY = CPY - y * degpmv
         GOSUB Cursor
         IF a > 31 THEN a = a - 32: a$ = CHR$(0) + CHR$(30)
         IF a > 15 THEN a = a - 16: a$ = "F"
       END IF
     END IF
    END IF
    IF a$ = "" THEN a$ = INKEY$
    IF a$ <> "" THEN
       IF LEN(a$) = 1 THEN a$ = UCASE$(a$)
       Key$ = a$
       IF ELock THEN
          CALL CLRtxt(43, "*** EDIT IS LOCKED ON ***  |  COMMANDS ARE:  ADD,  DELETE,  LOCKoff,  MOVE", 14)
          IF a$ = "A" THEN GOSUB AddPoint: a$ = ""
          IF a$ = "D" THEN GOSUB DelPT: a$ = ""
          IF a$ = "L" THEN GOSUB Elockdo: a$ = ""
          IF a$ = "M" THEN GOSUB MakePT: a$ = "": IF Redraw THEN GOSUB DrawMap
       END IF
       IF LabMov AND a$ = CHR$(13) THEN
          MLa(HkLab) = CPY: MLo(HkLab) = CPX: LabMov = 0: GOSUB DrawMap
       END IF
       SELECT CASE a$
       CASE CHR$(13): LnStrt = 0: StrtSrch = 1: GOSUB FindPoint
       CASE CHR$(10): LnStrt = LnPtr: StrtSrch = z + 1: GOSUB FindPoint
       CASE "C": GOSUB MenuCHANGE
       CASE "E": GOSUB MenuEdit
       CASE "F": GOSUB MenuFILES
       CASE "L": GOSUB MenuLABELS
       CASE "T": GOSUB MenuTasks
       CASE "D": GOSUB MenuDisplay
       CASE "G": GOSUB CurToPoint: GOSUB CurDrwMap
       CASE "H"
          IF Display$ <> "HELP" THEN
             SCREEN , , 0, 0: COLOR 15, 1: GOSUB HELP
          ELSE GOSUB Info
             LOCATE bln, 1: PRINT " H for HELP or SPACE BAR for map..."; : a$ = ""
          END IF
       CASE "N": GOSUB NextLine: GOSUB Cursor
       CASE "P": GOSUB Previous: GOSUB Cursor
       CASE "Q": GOSUB Quit
       CASE "R": z = 2: LnPtr = 1        'HOME key
       CASE "T": GOSUB Scrunch
       CASE "U": GOSUB GetUSGS
       CASE " "
                 Display$ = "MAP": Redraw = -1: USGS = 0:
                 IF Scrn = 0 THEN SCREEN , , 1, 1: COLOR 15, 0
                 IF Scrn = 1 THEN GOSUB DrwMPaCur
                 Scrn = 1
       CASE "+": z = z + 1: GOSUB MapPoint  ' moves to next map point
       CASE "-": z = z - 1: GOSUB MapPoint  ' moves backwards
       CASE "7": CDX = LONo: CDY = LATo: GOSUB DrwMPaCur 'ShiftHOME
       CASE "6": CPX = CPX - 20 / (Sfac): GOSUB Cursor 'SHIFT Cursor by 4
       CASE "4": CPX = CPX + 20 / (Sfac): GOSUB Cursor
       CASE "8": CPY = CPY + 20 / (Sfac): GOSUB Cursor
       CASE "2": CPY = CPY - 20 / (Sfac): GOSUB Cursor

       END SELECT
      
       B$ = "": IF LEN(a$) = 2 THEN B$ = RIGHT$(a$, 1): REM process arrow & special keys
       SELECT CASE B$
       REM CASE CHR$(1) TO CHR$(127): PRINT ASC(B$)
       CASE "I": RS = RS * 2: GOSUB CurDrwMap: REM change scale
       CASE "Q": RS = RS / 2: GOSUB CurDrwMap
       CASE CHR$(132): RS = RS * 8: GOSUB CurDrwMap: REM change scale by factor of 4
       CASE CHR$(118): RS = RS / 8: GOSUB CurDrwMap
       CASE "G": GOSUB CurDrwMap 'Home key
       
       CASE "O": CDX = LonCen: CDY = LatCen: Acenter = 0: GOSUB DrwMPaCur'End Key
       CASE "M": CPX = CPX - 4 / (Sfac): GOSUB Cursor
       CASE "K": CPX = CPX + 4 / (Sfac): GOSUB Cursor
       CASE "H": CPY = CPY + 4 / (Sfac): GOSUB Cursor
       CASE "P": CPY = CPY - 4 / (Sfac): GOSUB Cursor
       REM Here are the special MapFIx routines
       CASE CHR$(30)                          'alt-A  (also left mouse button!)
          SELECT CASE MsInit
          CASE 0: GOSUB AddPoint              'alt-ADD point
          CASE 4: LAb = CPY
          CASE 3
                CALL Noise(1)
                CALL PRtxt("Enter total LAT moved in Degrees", z$)
                degpmv = VAL(z$) / (Sfac * (CPY - LAb))
          CASE 2: LOb = CPX
          CASE 1
                CALL Noise(1)
                CALL PRtxt("Enter total LONG moved in Degrees", z$)
                degpmh = VAL(z$) / (Sfac * (CPX - LOb))
          END SELECT
          IF MsInit THEN MsInit = MsInit - 1
       
       CASE CHR$(22): GOSUB GetUSGS                     'alt-U
       CASE CHR$(59): JustCur = -1: GOSUB DrwMpPt       'F1
       CASE CHR$(61)                                    'F3 for smaller Maps
          IF MpLstLdd THEN
             MapSize = MapSize / 2: IF MapSize < 1 THEN MapSize = 1
             GOSUB ShowMaps
          ELSE SavClr = 3: a$ = "Stream": GOSUB HotKey
          END IF
       CASE CHR$(62)                                    'F4 for larger Maps
          IF MpLstLdd THEN
             MapSize = MapSize * 2: IF MapSize > 1000 THEN MapSize = 1000
             GOSUB DrwAndShow
          ELSE SavClr = 4: a$ = "Red Rd": GOSUB HotKey
          END IF
       CASE CHR$(63): Slower = NOT Slower                           'F5
       CASE CHR$(64): SavClr = 6: a$ = "Brder": GOSUB HotKey       'F6
       CASE CHR$(65): SavClr = 7: a$ = "St": GOSUB HotKey   'F7
       CASE CHR$(66): SavClr = 8: a$ = "RR": GOSUB HotKey     'F8
       CASE CHR$(67): GOSUB InitMouse                   'F9
       CASE CHR$(68): SavClr = 10: a$ = "Interstate": GOSUB HotKey  'F10
       CASE CHR$(84): SavClr = 11: a$ = "Water": GOSUB HotKey       'F11
       CASE CHR$(85): SavClr = 12: a$ = "Big Rd": GOSUB HotKey  'F12
       CASE CHR$(86): Comp = -1: abort = 0                          'F3 shift
            FOR i = 1 TO nmp
                IF x%(i) < 0 OR x%(i) > 2047 THEN abort = -1
                IF y%(i) < 0 OR y%(i) > 1023 THEN abort = -1
            NEXT i
            IF abort THEN
                LOCATE 20, 10: Comp = 0: abort = 0
                PRINT "POINTS OUT OF RANGE.  CANNOT COMPRESS"
            ELSE Changed = Changed + 1
            END IF
            GOSUB Redraw
       CASE CHR$(87): Comp = 0: GOSUB Redraw                       'F4 shift
       CASE CHR$(91): GOSUB AddMark                                'F8 shift
       END SELECT
          
    END IF
  LOOP
  SYSTEM 'you should never get here
MenuEdit:  CALL PR("EDIT CMDS:  Add, Begin, Color, Delete, KillFeature, Lock, Move, New-feature", a$)
           SELECT CASE a$
           CASE "A": GOSUB AddPoint
           CASE "B":
              IF Digitizer THEN
                 Key$ = "B": GOSUB NewFeature
              ELSE CALL CLRtxt(41, "This command ONLY used in DIGITIZER mode", 12)
              END IF
           CASE "C": GOSUB ChgColr
           CASE "D": GOSUB DelPT
           CASE "L": GOSUB Elockdo
           CASE "K": GOSUB KillFeature
           CASE "M": GOSUB MakePT: IF Redraw THEN GOSUB DrawMap
           CASE "N": Key$ = "N": GOSUB NewFeature
           END SELECT
           RETURN
Elockdo: ELock = NOT ELock
         IF ELock THEN Bclr = 15 ELSE Bclr = 0
         GOSUB LockBox
         IF NOT ELock THEN GOSUB Post43
         RETURN

MenuFILES: CALL PR("FILES CMDS:  Directory, Load, OpenDgtzrCom, Quit, Save, ViewMaplst", a$)
           SELECT CASE a$
           CASE "D": GOSUB MapDIR
           CASE "L": GOTO INIT
           CASE "O": GOSUB WhichDgtzr
           CASE "Q": GOTO Quit
           CASE "S": GOSUB SaveMap
           CASE "V": GOSUB ListMAPlist
           END SELECT
           RETURN
MenuLABELS: D = 0: GOSUB LabelHook
           CALL PR("LABEL COMMANDS:  Add,  Import,  Kill,  Move,  NewRange,  On/Off,  Show-all", a$)
           SELECT CASE a$
           CASE "A": GOSUB LabelADD
           CASE "I": Overlay = -1: LImp = -1: GOSUB Import
           CASE "K": GOSUB LabelKILL: D = 1
           CASE "M": GOSUB LabelMove
           CASE "N": GOSUB LabelNwRng
           CASE "S": Key$ = "S"
           CASE "O": LabelsON = NOT LabelsON: IF NOT LabelsON THEN D = 1
           END SELECT
           IF D THEN GOSUB DrawMap ELSE GOSUB Labels
           RETURN
MenuTasks: CALL PR("TASKS:  ClearSinglePts, GPStrack, Import, Join, Overlay, Scrunch, Trim", a$)
           SELECT CASE a$
           CASE "C": GOSUB Clr1Pts
           CASE "G": GOSUB LoadHST
           CASE "I": GOSUB Import
           CASE "J": GOSUB Join
           CASE "O": Overlay = -1: LImp = 0: Redraw = 0: GOSUB Import
           CASE "T": GOSUB TRIM
           CASE "S": Key$ = "S": GOSUB Scrunch
           END SELECT
           RETURN
MenuDisplay: CALL PR("DISPLAY:  AutoCntr, BOXppd, Endpoints, Mplst-bordrs, Points, Redraw, WhiteRR", a$)
           SELECT CASE a$
           CASE "A": Acenter = NOT Acenter
           CASE "B": GOSUB BOXppd
           CASE "M": GOSUB DrwAndShow
           CASE "P": Points = NOT Points: GOSUB DrawMap
           CASE "E": Epts = NOT Epts: GOSUB DrawMap
           CASE "W": Wrr = NOT Wrr: GOSUB DrawMap
           CASE "R": Redraw = NOT Redraw: GOSUB Redraw
           END SELECT
           RETURN
MenuCHANGE: CALL PR("CHANGE:   Beeps,  Center,  Origin,  Range", a$)
           SELECT CASE a$
           CASE "B": Quiet = NOT Quiet
           CASE "C": GOSUB NewCenter
           CASE "R": GOSUB MapRange
           CASE "O": GOSUB MapCnvrt
           END SELECT
           RETURN

LabelHook: HkLab = 0: k = RS / 1000
           FOR i = 1 TO nml
               IF ABS(CPX - MLo(i)) < k AND ABS(CPY - MLa(i)) < k THEN
                  CPX = MLo(i): CPY = MLa(i): GOSUB Cursor
                  HkLab = i: i = nml: CIRCLE (CUX, CUY), 10, 13
                  IF MLr(HkLab) < RS THEN Key$ = "S": GOSUB Labels
               END IF
           NEXT i
           RETURN
               
LabelKILL: IF HkLab THEN
              FOR i = HkLab TO nml
                    ML$(i) = ML$(i + 1): MLa(i) = MLa(i + 1)
                    MLo(i) = MLo(i + 1): MLr(i) = MLr(i + 1)
              NEXT: HkLab = 0: D = 1
              nml = nml - 1
           ELSE CALL Noise(1)
           END IF
           RETURN

LabelMove: IF HkLab THEN LabMov = 1: CALL CLRtxt(43, "Move cursor and then press ENTER...", 13)
           RETURN
LabelNwRng: IF HkLab THEN
               CALL PRtxt("Enter new range scale for Label to begin showing", a$)
               IF a$ <> "" THEN MLr(HkLab) = VAL(a$)
            END IF
            RETURN


AddMark: a$ = "Ref Point": SavClr = 14
   GOSUB BeginF: GOSUB MakePT
   CUY = CUY - 6: GOSUB AddPoint
   CUX = CUX + 10: GOSUB AddPoint
   CUY = CUY + 6: GOSUB AddPoint
   CUX = CUX - 10: GOSUB AddPoint
   CUY = CUY - 6: GOSUB AddPoint
   CUX = CUX + 5: CUY = CUY + 3: GOSUB Cursor
   RETURN

WhichDgtzr: CALL PRtxt("Select (P)oor-Man's-Mouse-Mode or (D)igitizer [D]", a$)
   IF a$ <> "P" THEN GOSUB DigiInit: GOTO DrawMap
   IF NOT Mouse THEN GOSUB InitMouse
   CLS : LOCATE 6, 1
   PRINT "POOR-MANS-MOUSE-MODE  (Digitizer)"
   PRINT
   PRINT "You must first calibrate the mouse to actual LAT/LONG movements."
   PRINT "Perform the following steps in sequence.  If you mess up, START PROGRAM OVER!"
   PRINT
   PRINT "During this process, ignore the cursor on the screen."
   PRINT
   PRINT "Lift and move mouse to a low LATITUDE mark.  Hit left button."
   PRINT "     move mouse carefully up to an UPPER LATTITUDE mark.  Hit left button."
   PRINT
   PRINT "Lift and move mouse to a right LONGITUDE mark.  Hit left button."
   PRINT "     move mouse carefully to a LEFT LONGITUDE mark.  Hit left button."
   MsInit = 4
   RETURN



InitMouse: CALL PRtxt("Mouse on COM 1, 2 or None", a$)
    IF a$ = "1" OR a$ = "2" THEN
       OPEN "com" + a$ + ":1200,n,8,1,CS0,DS0,CD0" FOR RANDOM AS #1
       Mouse = -1
       
       PRINT "Left button is EDIT-ADD.  Right button is FIND."; ""
       degpmh = 1 / Sfac: degpmv = 1 / Sfac
    END IF
    RETURN

Redraw: LOCATE 1, 24: PRINT "LOADtime"; LEFT$(STR$(LdTime), 5); " ";
    LOCATE 1, 38: IF Comp THEN PRINT "COMPRESSED";  ELSE PRINT SPACE$(10)
    LOCATE 1, 49: IF Redraw THEN PRINT "REDRAW-ON" ELSE PRINT "redrw-off"
    LOCATE 1, 59: IF LabelsON THEN PRINT SPACE$(11) ELSE PRINT "LABELS-OFF!"
    LINE (178, 0)-(552, 9), 12, B'Box around it
    RETURN

Quit: CLS : CALL Noise(1): CALL PR("Really quit MAPFIX (Y/N) [Y]", a$)
    IF a$ = "N" THEN GOSUB DrawMap: RETURN
    IF Changed THEN
       CALL PR("**** MAP HAS BEEN MODIFIED" + STR$(Changed) + "TIMES BUT NOT SAVED!!!  SAVE NOW? (Y)", a$)
       IF a$ <> "N" THEN GOSUB SaveMap
    END IF
    SYSTEM

TRIM: CLS : PRINT "TRIM ALL POINTS AND LABELS OUTSIDE OF MAPRANGE"
    PRINT
    PRINT "This command removes all points and labels outside of the white map border"
    PRINT "defined with the CHANGE-CENTER and CHANGE-RANGE commands."
    PRINT : PRINT
    PRINT "To avoid errors near the edge, make the CENTER/RANGE box about 10% larger"
    PRINT
    PRINT "You might consider stopping now and doing a FILES-SAVE before proceeding."
    PRINT
    PRINT : PRINT
    INPUT "Are you ready to proceed? (Y/N) (N)"; ans$
    CDX = LonCen: CDY = LatCen: GOSUB DrwMPaCur
    IF UCASE$(ans$) <> "Y" THEN RETURN
    c = 0: LOCATE bln - 2, 1: PRINT "Processing...";
    REM dx and dy are num pix of center of map
    REM bx and by are borders of map based on MapRng
    by = ppdv * MapRng / 60
    REM bx = by / Lfac
    bx = by * 1.8
    z = 0
    DO
      z = z + 1
      IF x%(z) = 0 THEN z = z + 2
      IF x%(z) > dx + bx OR y%(z) > dy + by THEN bad = 1 ELSE bad = 0
      IF x%(z) < dx - bx OR y%(z) < dy - by THEN bad = 1
      IF bad THEN
         REM IF x%(z - 1) <> 0 AND x%(z + 1) <> 0 THEN
            GOSUB DelPT: z = z - 1
            c = c + 1
         REM END IF
      END IF
      IF z >= nmp - 4 THEN EXIT DO
    LOOP
    LOCATE bln - 2, 1: PRINT "Now removing labels...";
    i = 0
    DO UNTIL i > nml
    REM FOR i = 1 TO nml: REM now eliminate all labels outside
        i = i + 1
        bad = 0: Xm = MapRng / (60 * Lfac): Ym = MapRng / 60
        IF MLo(i) > LonCen + Xm OR MLa(i) > LatCen + Ym THEN bad = 1
        IF MLo(i) < LonCen - Xm OR MLa(i) < LatCen - Ym THEN bad = 1
        IF bad = 1 THEN
           FOR j = i TO nml
               ML$(j) = ML$(j + 1): MLa(j) = MLa(j + 1)
               MLo(j) = MLo(j + 1): MLr(j) = MLr(j + 1)
           NEXT j: nml = nml - 1: i = i - 1: PRINT ".";
        END IF
    REM NEXT i
    LOOP
    GOTO DrawMap
   
FindPoint: CurX = INT(.5 + dx + (CUX - 320) / (KP * Hfac))
           CurY = INT(.5 + dy + (CUY - Ycen) / KP)

    CALL CLRtxt(43, "SEARCHING THROUGH ALL POINTS IN FILE...", 10)
    REM SaveZ = Z: SaveLNptr = LnPtr
Agn: FOR j = 0 TO 30            ' Go through abt 20 times lookin pt.
        IF j > 10 THEN j = j + 1' first with 0 delta, then bigger
        PRINT ".";
        LnCtr = LnStrt
        FOR i = StrtSrch TO nmp
            IF x%(i) = 0 THEN LnCtr = LnCtr + 1
            IF LnCtr >= LNi THEN i = nmp
            IF x%(i) > CurX - j AND x%(i) < CurX + j THEN
               IF y%(i) > CurY - j AND y%(i) < CurY + j THEN
                  z = i: LnPtr = LnCtr: GOSUB CurToPoint
                  j = 99: i = nmp
               END IF
            END IF
        NEXT i:
    NEXT j
    IF j < 99 AND Key$ = CHR$(10) THEN StrtSrch = 2: LnCtr = 1: Key$ = CHR$(13): GOTO Agn
    IF j < 99 THEN PRINT "None found!"; : RETURN
    GOSUB MapPoint: SavClr = 0
    GOSUB Find1st: LineColor = 15: dots = &HCCCC: GOSUB DP
    RETURN
                 
HotKey: IF NOT Digitizer THEN RETURN
        GOSUB BeginF: GOSUB GetXY: GOSUB Cursor: GOSUB MakePT
        RETURN

NewFeature: LOCATE bln - 1, 1: PRINT SPACE$(27);
    CALL PRtxt("Enter reference name for new feature", a$)
    IF a$ = "" THEN RETURN
    GOSUB Rainbow: IF abort THEN RETURN
    GOSUB BeginF
    IF Key$ = "B" THEN
       CALL CLRtxt(43, "NOW USE DIGITIZER TO ADD NEW POINTS TO THIS FEATURE...", 10)
       GOSUB GetXY: GOSUB Cursor
    ELSE
       CALL CLRtxt(43, "NOW MOVE CURSOR AND USE EDIT-ADD TO ADD POINTS TO THIS NEW FEATURE...", 10)
    END IF
    GOSUB MakePT
    RETURN

Rainbow: LOCATE bln, 1
    FOR i = 0 TO 14
        PRINT RIGHT$(" " + MID$(STR$(i + 1), 2), 2); "   ";
        LINE (16 + i * 40, 335 * YfacTXT)-(40 + i * 40, 349 * YfacTXT), i + 1, BF
    NEXT i
    CALL PRtxt("Select color (4,7,10-Hwys 11-Water 12-Hwy 13-Spcl 14-City)", B$)
    SavClr = VAL(B$): IF SavClr > 15 OR SavClr < 1 THEN abort = -1 ELSE abort = 0
    RETURN

           
BeginF: x%(nmp) = 0: y%(nmp) = SavClr   'Store feature color 0,c
    LN$(LNi + 1) = LN$(LNi): LnPtr = LNi'Bump up present LN$ comment
    LN$(LNi) = a$: LNi = LNi + 1'Store feature name
    nmp = nmp + 1: z = nmp
    nmp = nmp + 1: x%(nmp) = 0: y%(nmp) = 0'nmp points to ending 0,0
    RETURN

NewCenter: LatCen = CPY: LonCen = CPX: Changed = Changed + 1: GOTO CurDrwMap

MapRange: CALL PRtxt("Enter map range", a$)
    IF VAL(a$) <> 0 THEN MapRng = VAL(a$)
    Changed = Changed + 1: GOTO DrwMPaCur

AddPoint: x% = dx + (CUX - 320) / (KP * Hfac)
    IF x% = 0 THEN CALL Noise(1): PRINT "X=0!!!": RETURN
    nmp = nmp + 1: z = z + 1
    FOR i = nmp TO z STEP -1
        x%(i) = x%(i - 1): y%(i) = y%(i - 1)
    NEXT
    GOSUB MakePT
    IF SavClr = 0 AND Redraw THEN GOTO DrawMap
    LineColor = SavClr
    S = z - 1: GOTO DP

MakePT: x%(z) = dx + (CUX - 320) / (KP * Hfac)
    y%(z) = dy + (CUY - Ycen) / KP
    Changed = Changed + 1
    GOTO MapPoint

CurToPoint:
    CPX = CDX - (x%(z) - dx) / ppdv
    CPY = CDY - (y%(z) - dy) / (ppdv * Yfactr)
    GOTO Cursor

Clr1Pts: Didit = 0
         FOR i = 1 TO nmp
             IF x%(i) = 0 THEN
                IF x%(i + 1) = 0 THEN z = i + 1: GOSUB DelZ
                IF x%(i + 2) = 0 THEN z = i + 2: GOSUB DelZ
                IF y%(i) = 0 THEN y%(i) = 15
             END IF
         NEXT i: IF Didit THEN CALL Noise(1): GOSUB DrawMap
         RETURN

DelPT: GOSUB DelZ
    REM if 1st pt, it stays as 1st pt

    IF x%(z) = 0 THEN z = z - 1: REM if end pt, it stays as end
    IF x%(z + 1) = 0 AND x%(z - 1) = 0 THEN 'It is LAST point
       GOSUB Kline: LnPtr = LnPtr - 1       'So Kill Line
       GOSUB DelZ                           'And Kiil it
       z = z - 1: GOSUB DelZ: z = z - 1     'Kill 0,color
    END IF                                  'and -1 to end point
    IF B$ = CHR$(32) AND Redraw THEN GOSUB DrawMap ELSE GOSUB MapPoint
    RETURN

DelZ: nmp = nmp - 1
      FOR i = z TO nmp
          x%(i) = x%(i + 1): y%(i) = y%(i + 1)
      NEXT: Changed = Changed + 1: Didit = -1: RETURN

NextLine: IF z >= nmp - 1 THEN z = nmp - 1: CALL Noise(1): RETURN
    DO UNTIL x%(z) = 0: z = z + 1: LOOP
    IF z < nmp - 1 THEN z = z + 1: LnPtr = LnPtr + 1
    SavClr = 0: GOTO MapPoint

Previous: DO UNTIL z = 1 OR x%(z) = 0: z = z - 1: LOOP
    IF z > 3 THEN z = z - 1: LnPtr = LnPtr - 1
    SavClr = 0: GOTO MapPoint

KillFeature: GOSUB Find1st: REM Stop at Beginning (0) point of the feature to kill
    ni = S' Now scan for next feature
    DO UNTIL x%(ni) = 0: ni = ni + 1: LOOP
    REM now move down rest of array to fill
    DO UNTIL ni = nmp + 1
       x%(S - 1) = x%(ni): y%(S - 1) = y%(ni)
       S = S + 1: ni = ni + 1
    LOOP
    nmp = nmp - (ni - (S - 1)): y%(nmp) = 0
    GOSUB Kline
    GOTO DrawMap
    
Find1st: S = z: DO UNTIL x%(S - 1) = 0: S = S - 1: LOOP
         REM z = Bi + 1
         RETURN

ChgColr: GOSUB Find1st: GOSUB Rainbow: IF abort THEN RETURN
         y%(S - 1) = SavClr: Changed = Changed + 1
         LineColor = SavClr
         GOSUB DP
         RETURN


Kline: FOR i = LnPtr TO LNi
           LN$(i) = LN$(i + 1)
       NEXT i
       LNi = LNi - 1
       RETURN

MapPoint:
     IF z < 2 THEN z = 2: LnPtr = 1: CALL Noise(1): SavClr = 0
     IF z > nmp - 1 THEN z = z - 1: CALL Noise(1): SavClr = 0
     IF x%(z) = 0 THEN
        IF a$ = "-" THEN
             LnPtr = LnPtr - 1: z = z - 1
        ELSE LnPtr = LnPtr + 1: z = z + 1
        END IF: SavClr = 0
     END IF
     IF LnPtr < 0 THEN LnPtr = 0
     IF Display$ = "MAP" THEN
          LOCATE bln - 3, 1
          PRINT "Fture#"; LnPtr; TAB(12); LEFT$(LN$(LnPtr) + "            ", 12);
     END IF
DrwMpPt: IF Display$ <> "MAP" THEN RETURN
     IF JustCur THEN pc = 12 ELSE pc = 15
     CIRCLE (Xtest, Ytest), 10, 0 'Erase old circle
     Xtest = 320 + KP * (x%(z) - dx) * Hfac
     Ytest = Ycen + KP * (y%(z) - dy) * Yfactr
     IF Acenter AND (Xtest > 600 OR Xtest < 40 OR Ytest > 300 OR Ytest < 40) THEN
        GOSUB CurToPoint: GOSUB CurDrwMap
        Xtest = 320 + KP * (x%(z) - dx) * Hfac
        Ytest = Ycen + KP * (y%(z) - dy) * Yfactr
     END IF
     CIRCLE (Xtest, Ytest), 10, pc
     
     LOCATE bln - 2, 1: PRINT "MapPt#"; z;
     IF z > 999 THEN PRINT TAB(13); "val:";  ELSE PRINT TAB(12); "vals:";
     PRINT TAB(17); x%(z); TAB(23); y%(z)
     RETURN

LabelADD: nml = nml + 1
     MLa(nml) = CPY: MLo(nml) = CPX
     CALL CLRtxt(41, "Enter Label Name", 14)
     INPUT ML$(nml)
     CALL PRtxt("Begin displaying label at what range?", a$)
     IF a$ <> "" THEN a = VAL(a$) ELSE a = RS
     MLr(nml) = a
     Changed = Changed + 1
     RETURN

ErrorTrap: Fault = ERR: 'Error handling routine
     IF ERR = 57 THEN PRINT "  I/O-error-User-logoff"; : RESUME
     IF ERR = 69 THEN PRINT "  Comm-buffer-overflow"; : RESUME
     IF ERR = 53 THEN PRINT "  file-"; F$; "-not-found": CLOSE : RESUME NEXT
     IF ERR = 62 THEN RESUME NEXT
     IF ERR = 64 THEN RESUME NEXT
     IF ERR = 52 THEN RESUME NEXT
     IF ERR = 55 THEN RESUME NEXT
     IF ERR = 2 THEN PRINT "SYNTAX-error"
     IF ERR = 70 THEN PRINT " WRITE PROTECTED!...": RESUME NEXT
     IF ERR = 76 THEN PRINT "Wrong Path!": RESUME NEXT
     IF ERR = 71 THEN PRINT "no disk!": RESUME NEXT
     RESET
     PRINT : PRINT "Error beyond repair. Number = "; ERR;
     INPUT "Hit RETURN to return to DOS"; a$
     SYSTEM

MapDIR: CLS : PRINT "MAP FILES DIRECTORY": PRINT
     PRINT "To display your MAP file directory, enter the path to your xxxxxxx.MAP files."
     PRINT "For example, the default '\APRS\MAPS\*.MAP' will show all maps in the APRS"
     PRINT "directory.  Similarly '*.map' will search your present directory."
     PRINT ""
     F$ = "\aprs\MAPS\*.map"
     PRINT "Enter Filespec for searching the DIRECTORY ("; F$; ")";
     INPUT a$: IF a$ <> "" THEN F$ = a$
     PRINT : PRINT : FILES F$
     RETURN


LoadMap: CALL PRtxt(" MAP FILENAME, or NEW, ? for list, or Q to quit)" + Mpath$, a$)
    IF a$ = "" THEN GOTO LoadMap
    IF a$ = "Q" THEN SYSTEM
    IF a$ = "?" THEN GOSUB MapDIR: GOTO LoadMap
    IF a$ = "NEW" THEN Key$ = "NEW": GOSUB NewMap: RETURN
    a = INSTR(3, a$, "."): IF a = 0 THEN a$ = a$ + ".MAP"
    Strtime = TIMER
    IF INSTR(a$, "\") = 0 AND INSTR(a$, ":") = 0 THEN MapFile$ = Mpath$ + a$ ELSE MapFile$ = a$
    F$ = MapFile$: OPEN F$ FOR INPUT AS #3
    IF Fault = 53 OR Fault = 76 THEN Fault = 0: PRINT : CLOSE #3: GOTO LoadMap
    a = 1
    DO UNTIL a = 0: wa = a: a = INSTR(wa + 1, F$, "\"): LOOP
    IF wa > 1 THEN Mpath$ = LEFT$(F$, wa)
    CALL CLRtxt(43, " Loading " + F$ + "...", 10)
    INPUT #3, LATo: LINE INPUT #3, LATtext$
    INPUT #3, LONo: LINE INPUT #3, LONtext$
    INPUT #3, ppdv: LINE INPUT #3, VS$'Pixels per degree horiz
    INPUT #3, LatCen: LINE INPUT #3, LatCen$
    INPUT #3, LonCen: LINE INPUT #3, LonCen$
    INPUT #3, MapRng: LINE INPUT #3, MapRng$
    INPUT #3, MinRng: LINE INPUT #3, MR$
    LINE INPUT #3, TextLine$ ' Line of comments or instrutcitons
    IF TextLine$ = "Compressed" THEN Comp = -1 ELSE Comp = 0
    IF LEFT$(TextLine$, 14) = "Map generated " THEN Redraw = 0
    RS = 2 ^ INT(LOG(MapRng) / LOG(2))'Rng is intgr of VERTrng
    i = 0: LNi = 0:
    REM ON ERROR GOTO 0
    DO WHILE NOT EOF(3)
       i = i + 1
       IF Comp THEN
            LINE INPUT #3, a$
            IF a$ = " 0,0" THEN
                 x%(i) = 0: y = 0
            ELSEIF a$ = " 0,-1" THEN x%(i) = 0: y = -1
            ELSE 'abc where c = .xxxxyyy
                 '          x = 16*a + xxxx  and  y = 8*b +yyy
                 c$ = RIGHT$(a$, 1): B$ = MID$(a$, 2, 1): a$ = LEFT$(a$, 1)
                 cx% = INT((ASC(c$) - 27) / 8): cy% = (ASC(c$) - 27) - cx% * 8
                 x%(i) = 16 * (ASC(a$) - 27) + cx%
                 y%(i) = 8 * (ASC(B$) - 27) + cy%
            END IF
       ELSE INPUT #3, x%(i), y: y%(i) = y * Yfactr
       END IF
       IF x%(i) = 0 AND NOT EOF(3) THEN ' Get line color & store with x=0
          INPUT #3, y%(i): LNi = LNi + 1: LINE INPUT #3, LN$(LNi)' Save line name
          IF y = -1 THEN GOSUB LoadLabels ' All labels listed at end of file
       END IF
    LOOP: nmp = i  'nmp points to 0,-1 that ends all data (but the value
                   'of X% and y% are 0,0 until file is saved.
    CDY = LatCen: CDX = LonCen'Center display on ORIGIN
    CPX = CDX: CPY = CDY 'Cursor Posn to Center of Display
    z = 2: LnPtr = 1: REM start at first point and first line segment
    CLOSE #3:     REM first X% value is map color.  2nd val is 1st pt
    LdTime = TIMER - Strtime
    RETURN


LoadLabels: k = 0
     DO WHILE NOT EOF(3)
        k = k + 1: INPUT #3, ML$(k), MLa(k), MLo(k), MLr(k)
     LOOP
     IF MLa(k) = 0 OR MLo(k) = 0 THEN nml = k - 1 ELSE nml = k
     RETURN
       
SaveMap: CALL PRtxt("Enter file name to save (" + MapFile$ + ")", a$)
   IF a$ <> "" THEN
      IF INSTR(a$, ".") = 0 THEN a$ = a$ + ".map"
      MapFile$ = a$
   END IF
   F$ = MapFile$
   CALL CLRtxt(43, "Saving map to file named " + F$ + " ...", 10)
   OPEN F$ FOR OUTPUT AS #4
   IF Fault = 70 OR Fault = 71 THEN Fault = 0: CLOSE #4: GOTO SaveMap
   PRINT #4, LATo; ","; LATtext$
   PRINT #4, LONo; ","; LONtext$
   PRINT #4, ppdv; ","; VS$
   PRINT #4, LatCen; ","; LatCen$
   PRINT #4, LonCen; ","; LonCen$
   PRINT #4, MapRng; ","; MapRng$
   PRINT #4, MinRng; ","; MR$
   j = 1: abort = 0
   IF Comp THEN
      REM ON ERROR GOTO 0
      PRINT #4, "Compressed"
      'abc where c = .xxxxyyy
      '          x = 16*a + xxxx  and  y = 8*b +yyy
      FOR i = 1 TO nmp
          IF x%(i) <> 0 THEN 'WRITE #4, x%(i), INT((y%(i) / Yfactr) + .5)
             a% = INT(x%(i) / 16): cx% = x%(i) - a% * 16
             B% = INT(y%(i) / 8): cy% = y%(i) - B% * 8
             c% = 8 * cx% + cy%
             PRINT #4, CHR$(a% + 27); CHR$(B% + 27); CHR$(c% + 27)
          END IF
          IF i = nmp THEN PRINT #4, " 0,-1"
          IF x%(i) = 0 AND i <> nmp THEN
             PRINT #4, " 0,0"
             PRINT #4, y%(i); ","; LN$(j): j = j + 1
          END IF
      NEXT i
   ELSE
      IF TextLine$ <> "Compressed" THEN PRINT #4, TextLine$ ELSE PRINT #4, "ASCII"
      FOR i = 1 TO nmp
          IF x%(i) <> 0 THEN WRITE #4, x%(i), INT((y%(i) / Yfactr) + .5)
          IF i = nmp THEN PRINT #4, " 0,-1"  'Used to be AND X%(i)=0
          IF x%(i) = 0 AND i <> nmp THEN
             PRINT #4, "0,0"
             PRINT #4, y%(i); ","; LN$(j): j = j + 1
          END IF
      NEXT i
   END IF
   PRINT #4, "0,"; LN$(LNi)
   a = 4
   IF ppdv > 60 THEN a = 5
   IF ppdv > 240 THEN a = 6
   IF ppdv > 900 THEN a = 7
   IF ppdv > 2400 THEN a = 8
   x = a: y = a
   FOR k = 1 TO nml
       IF MLa(k) < 0 THEN y = a + 1
       IF MLo(k) < 0 THEN x = a + 1
       PRINT #4, ML$(k); ",";
       PRINT #4, LEFT$(LTRIM$(STR$(MLa(k))), y); ",";
       PRINT #4, LEFT$(LTRIM$(STR$(MLo(k))), x + 1); ",";
       PRINT #4, LTRIM$(STR$(MLr(k)))
   NEXT k: CLOSE #4: LOCATE bln - 1, 1:
   Changed = 0
   IF nmp > MaxNumPoints OR nml > MaxNumLABELS THEN
      CLS : LOCATE 9, 29: PRINT "CAUTION!": PRINT : PRINT
      IF nmp > MaxNumPoints THEN
         PRINT "            The number of points,"; nmp; "is greater than"; MaxNumPoints
      END IF
      IF nml > MaxNumLABELS THEN
         PRINT "            The number of LABELS,"; nml; "is greater than"; MaxNumLABELS
      END IF
      LOCATE 18, 12
      PRINT " Therefore this map will not work with APRS (yet) "
      LOCATE bln - 2, 1: INPUT "HIT Enter to continue..."; a$
   END IF
   GOTO DrwMPaCur

CurDrwMap: CDX = CPX: CDY = CPY: GOTO DrawMap: REM Re-center at CURSOR location

DrwMPaCur: CPX = CDX: CPY = CDY: GOSUB DrawMap
           REM After drawing map, Put cursor at center
           RETURN

DrawMap: IF USGS THEN RETURN
    SCREEN , , 1, 1: Scrn = 1: CLS : CUX = 0
    Display$ = "MAP"
    COLOR 15, 0
    WIDTH 80, GBLn: bln = GBLn
   'Draw to range scale RS and center display CDX and CDY
  
   DO WHILE RS < 320 / ppdv: RS = RS * 2: LOOP
   IF RS > 8192 THEN RS = 8192
   KP = 100 * 100 / (RS * ppdv)' this is kinda arbitrary..??
   Sfac = 50 * 200 / RS

   Lfac = COS(CDY / 57.296)
   Hfac = (640 / 350) * (3 / 4) * Lfac
   dx = ppdv * (LONo - CDX)
   dy = ppdv * (LATo - CDY)
        
   LOCATE 1, 2: PRINT "Redrawing Map"
   REM first put ORIGIN and 1024 by 75% of 2048 BOX (and CENTER) on the map
   x0 = 320 - (dx * KP * Hfac): y0 = Ycen - (dy * KP * Yfactr)
   Xm = 320 + (2048 - dx) * KP * Hfac: Ym = Ycen + (1024 - dy) * KP * Yfactr
   REM 1512 is 3/4ths of 2048
   LINE (x0, y0)-(Xm, Ym), 14, B
   CMX = 320 + Sfac * (CDX - LonCen) * Hfac'new
   CMY = Ycen + Sfac * (CDY - LatCen) * Yfactr
   LINE (CMX - 27, CMY)-(CMX + 27, CMY), 15
   LINE (CMX, CMY - 20)-(CMX, CMY + 20), 15
   CIRCLE (CMX, CMY), 10, 15
   CIRCLE (320 - dx * KP * Hfac, Ycen - KP * dy), 12, 14
   S = 0: GOSUB MapPoint: REM Redraw MapPoint
   StrtPt = 0
   
DP: 'Speeded this up by 33% but is harder to follow
    HfacK = KP * Hfac
    YfactrK = KP * Yfactr
    FOR i = S TO nmp - 1
       x = 320 + (x%(i) - dx) * HfacK
       y = Ycen + (y%(i) - dy) * YfactrK
       X1 = 320 + (x%(i + 1) - dx) * HfacK
       Y1 = Ycen + (y%(i + 1) - dy) * YfactrK
       IF StrtPt THEN
          'x = 320 + (x%(i) - dx) * HfacK
          'y = Ycen + (y%(i) - dy) * YfactrK
          PSET (x, y), LineColor
          IF Epts THEN CIRCLE (x, y), 2, 9
          StrtPt = 0
          LINE -(X1, Y1), LineColor, , dots
       ELSE
          IF x%(i + 1) <> 0 THEN
             LINE -(X1, Y1), LineColor, , dots
             IF Points THEN CIRCLE (X1, Y1), 1, 15
          ELSE
             IF Epts THEN CIRCLE (x, y), 3, 10
             StrtPt = -1
             LineColor = y%(i + 1): i = i + 1
             dots = &HFFFF
             IF LineColor = 8 THEN dots = &HF0F0: IF Wrr THEN LineColor = 15
             IF LineColor = 0 OR LineColor = 15 THEN dots = &HCCCC: LineColor = 15
             x = 320 + (x%(i + 1) - dx) * HfacK
             y = Ycen + (y%(i + 1) - dy) * YfactrK
             IF Display$ = "SHOW" AND LineColor > 8 THEN LineColor = LineColor - 8
          END IF
       END IF
       IF i = z THEN SavClr = LineColor
   NEXT i
   GOSUB Cursor
   GOSUB Redraw
   GOSUB DrawHist: REM draw GPS history track
   IF Key$ <> CHR$(0) + CHR$(30) THEN GOSUB ShowBox
   IF Display$ = "SHOW" THEN
      GOSUB ShowMaps
   ELSE GOSUB Post43
   END IF

Labels:
   IF LabelsON THEN
      FOR i = 1 TO nml ' Now plot labels on map
      IF RS <= MLr(i) OR Key$ = "S" THEN
         LET x = 320 + Sfac * (CDX - MLo(i)) * Hfac'new
         LET y = Ycen + Sfac * (CDY - MLa(i)) * Yfactr
         CIRCLE (x, y), 1, 14
         IF y > Cfactr * Yfactr AND y < bln * Cfactr * Yfactr AND x > 8 * (LEN(ML$(i)) + 1) AND x < 632 THEN
            LOCATE y / (Cfactr * Yfactr), (x / 8) - LEN(ML$(i)): PRINT ML$(i);
         END IF
      END IF
      NEXT i
   END IF
   GOSUB ShowMap
   Bclr = 15
   IF ELock THEN GOSUB LockBox
   RETURN
LockBox: LINE (0, 0)-(639, 349), Bclr, B
         LINE (3, 2)-(636, 347), Bclr, B
         CALL CLRtxt(43, "*** EDIT IS LOCKED ON ***|    COMMANDS ARE:  ADD,  DELETE,  LOCKoff,  MOVE", 14)
         RETURN
        
Post43: CALL CLRtxt(43, "Use +/- to move MAPpoint.   N/P for Next/Previous Feature.   H for HELP!. ", 0)
        LOCATE 1, 71 ' was 61
        PRINT "PTS"; nmp ' ; "= "; INT((nmp / MaxNumPoints) * 100); "%";
        LOCATE 2, 71 ' was 61
        PRINT "LBLS "; nml '; "= "; INT((nml / MaxNumLABELS) * 100); "%";
        LOCATE 3, 71: PRINT "PPD"; ppdv
        LOCATE 4, 71: PRINT "Rng"; LEFT$(STR$(MapRng), 5)
        RETURN
ShowMap: REM this shows the map boarder of the loaded map
    x = 320 + KP * (CDX - LonCen) * ppdv * Hfac'new
    y = Ycen + KP * (CDY - LatCen) * ppdv * Yfactr
      by = MapRng * Sfac * Yfactr / 60
      REM bx = by * 640 / (400 * Yfactr) * Lfac'old
      bx = 1.8 * by
      c = 15
    LINE (x - bx, y - by)-(x + bx, y + by), c, B
    RETURN

Cursor: JustCur = 0: IF pc = 12 THEN GOSUB DrwMpPt
     REM circle(CUX, CUY), 4, 0
     IF CUX > 4 AND CUY > 3 AND CUX < 635 AND CUY < 343 * Yfactr THEN PUT (CUX - 4, CUY - 3), Crsr, XOR
     CUX = 320 + Sfac * (CDX - CPX) * Hfac'new
     CUY = Ycen + Sfac * (CDY - CPY) * Yfactr
     REM CIRCLE (CUX, CUY), 4, 14
     IF CUX > 4 AND CUY > 3 AND CUX < 635 AND CUY < 343 * Yfactr THEN PUT (CUX - 4, CUY - 3), Crsr, XOR
     IF CPX > 0 THEN
          x = INT(CPX): Xm = (CPX - x) * 60
     ELSE x = INT(-CPX): Xm = -(CPX + x) * 60
     END IF
     IF CPY > 0 THEN
          y = INT(CPY): Ym = (CPY - y) * 60
     ELSE y = INT(-CPY): Ym = -(CPY + y) * 60
     END IF
     x$ = RIGHT$(STR$(x), 3) + " "
     LOCATE 1, 2: PRINT "RNG"; RIGHT$("   " + STR$(RS), 4) + " Miles"
     LOCATE 2, 2: PRINT "LAT "; y; : PRINT USING "##.##  "; Ym
     LOCATE 3, 2: PRINT "LON "; x$; : PRINT USING "##.##  "; Xm
     
     LOCATE bln - 1, 1: PRINT "Cursor coordnts:"; TAB(17);
     PRINT INT(.5 + dx + (CUX - 320) / (KP * Hfac)); TAB(23); INT(.5 + dy + (CUY - Ycen) / KP);
     REM LOCATE BLn-1, 55: PRINT "Degrees: ";
     REM PRINT LEFT$(STR$(CPY) + " ", 7); LEFT$(STR$(CPX) + "   ", 7);
     LOCATE 1, 16: PRINT "Decimal";
     LOCATE 2, 15: PRINT LEFT$(STR$(CPY) + " ", 8);
     LOCATE 3, 15: PRINT LEFT$(STR$(CPX) + "   ", 8);
     LINE (0, 0)-(178, 3 * Cfactr * Yfactr), 12, B'Box around it
     LINE (0, 0)-(116, 3 * Cfactr * Yfactr), 12, B'Box around it
     LET a$ = "": LET B$ = ""
     RETURN


HELP: SCREEN , , 0, 0: Scrn = 0: CLS
      REM WIDTH 80, 25: BLn = 25
      COLOR 15, 1
      LINE (0, 0)-(639, 18 * Yfactr), 4, BF
      LOCATE 1, 20: PRINT " MAPFIX.bas HELP SCREEN Ver "; Ver$
      LOCATE 3, 1
      PRINT
      PRINT " The ORIGIN, CENTER and BORDER are shown (but only the CENTER and RANGE in the"
      PRINT " MAPLIST.xxx are used by APRS.  Labels are right justified.  Callsigns and OBJ"
      PRINT " names will be plotted left justified.  Use the first letter of any command."
      PRINT ""
      PRINT
      PRINT " F- FILES      C- CHANGE  D- DISPLAY     E- EDIT        L- LABELS  T- TASKS "
      PRINT "    MENU          MENU       MENU           MENU           MENU       MENU     "
      PRINT " ------------  ---------  ------------   -------------  ---------  ------------"
      PRINT " D- Directory  B- BEEPS   A- AutoCentr   A- Add point   A- Add     C- Clear Pts"
      PRINT " L- Load       C- Center  B- BOX ppd     C- Change Clr  K- Kill    G- GPStrack "
      PRINT " O- Opn Dgtzr  O- Origin  E- END pts     D- Delete Pt   I- Import  I- Import "
      PRINT " Q- Quit       R- Range   M- MplstBrdrs  L- LockEDIT    M- Move    J- Join"
      PRINT " S- Save                  P- Points      K- Killfeature N- New Rng O- Overlay"
      PRINT " V- ViewMpLst             R- Redraw      M- Move Pt     O- On/Off  T- Trim"
      PRINT "                          W- White RR    N- New Feature S- Show    S- Scrunch"
      PRINT
      PRINT " DISPLAY COMMANDS     POINTER MOVEMENTS  USGS CD ROM CMDS  DIGITIZER/MOUSE"
      PRINT " -------------------  -----------------  ----------------  ------------------"
      PRINT " SPACE to draw map    N- Next Feature     U- USGA overlay  F1- Move cursor"
      PRINT " ARROWS cursr (shft)  P- Prev Feature    @U- USGS Load     F3, F4, F6, F7, F8"
      PRINT " PgUP/DN (ctrl)       G- Go to Pointer                     F10,shifted F1, F2"
      PRINT " HOME map to Cursor   +  Move to next                          are all hotkeys"
      PRINT " HOME(shft) to Orign  -  Previous pt                           to begin that"
      PRINT " END to map center    R- RESET to 1st Pt                       color line"
      PRINT
      PRINT " CR or ENTER will search the MAP for the closest point to the cursor.  There"
      PRINT " may be many points at a junction.  Hit CTRL-ENTER to continue the search."
      PRINT ""
      PRINT " F1 Temporarily re-defines Digitizer click to move cursor vice ADD point"
      PRINT " F3 (SHFT) Mark mapfile to be saved in COMPRESSED format"
      PRINT " F4 (SHFT) Mark mapfile to be saved in ASCII format"
      PRINT " F5        Slow GPS overlay so U can see chronologically"
      PRINT " F8 (shft) Adds MARKER to map.  Useful for re-calibrating MOUSE"
      PRINT " F9        Init Mouse (Microsoft serial mouse only)"
      PRINT
      PRINT : REM LINE (0, 190 * Yfactr)-(639, 190 * Yfactr), 15
              
      IF Display$ <> "HELP" THEN
       LOCATE bln, 1
       PRINT " HIT H AGAIN FOR MORE HELP SCREENS, OR SPACE BAR FOR MAP...";
      END IF
      Display$ = "HELP"
      LINE (0, 0)-(639, 348 * Yfactr), 15, B
      RETURN

LdMapLst: CALL PRtxt("Enter FileSpec for MAPLIST (" + Maplist$ + ")", a$)
    IF a$ <> "" THEN Maplist$ = a$
    F$ = Maplist$
    OPEN F$ FOR INPUT AS #3: IF Fault <> 0 THEN RETURN
    i = 1: NumGood = 0
    INPUT #3, DfltY: LINE INPUT #3, a$
    INPUT #3, DfltX: LINE INPUT #3, a$
    INPUT #3, BestRng: LINE INPUT #3, a$: DfltR = BestRng
    INPUT #3, GMToffset: LINE INPUT #3, a$
    WHILE a$ <> "* BEGIN *": LINE INPUT #3, a$: WEND ' Skip comment block
    WHILE NOT EOF(3) AND i <= UBOUND(MapName$)
       INPUT #3, MapName$(i), LatCen(i), LonCen(i), MapMax(i)
       LINE INPUT #3, Comment$(i)
       IF LEFT$(MapName$(i), 1) <> "*" THEN NumGood = NumGood + 1
       NumMaps = i: i = i + 1
    WEND: CLOSE #3
    MpLstLdd = -1
    IF NumGood >= MaxNumMAPS - 1 THEN
       CLS : LOCATE 2, 5
       PRINT "WARNING: Too many ACTIVE MAPS (more than"; MaxNumMAPS; ") in MAPLIST.map file for APRS"
       LOCATE 4, 10: PRINT "Use EDITOR to suppress mapnames with an (*) that you don't need."
       PRINT : PRINT : PRINT
       INPUT "HIT RETURN to continue"; a$
    END IF
    RETURN

ListMAPlist: IF NOT MpLstLdd THEN GOSUB LdMapLst
   GOSUB ListHeader
   FOR i = 1 TO NumMaps
       IF i / 19 = INT(i / 19) THEN
          LOCATE bln, 1: PRINT "HIT RETURN to continue"; : INPUT a$
          GOSUB ListHeader
       END IF
       PRINT MapName$(i); TAB(14);
       PRINT INT(LatCen(i) * 100) / 100; TAB(21); INT(LonCen(i) * 100) / 100;
       PRINT TAB(29); MapMax(i); TAB(36); LEFT$(LTRIM$(Comment$(i)), 43)
   NEXT i
   
   LOCATE bln, 1: PRINT "LIST COMPLETE. CONTINUE WITH NEXT MAPFIX COMMAND...";
   RETURN

ListHeader: CLS
   PRINT "MAPS in MAPLIST.map (*MAPS are suppressed)     [For now, use EDITOR to modify]"
   PRINT :
   PRINT "MAP NAME      LATcen LONcen  RANGE COmments"
   PRINT "------------  ------ ------- ----- -------------------------------------------"
   RETURN

DrwAndShow: IF NOT MpLstLdd THEN GOSUB LdMapLst
            Display$ = "SHOW": REM GOSUB DrwMPaCur

ShowMaps: IF MapSize > RS / 2 THEN MapSize = RS / 2
    CALL CLRtxt(43, " Displaying map borders >" + STR$(MapSize) + "mi.  ZOOM and re-do to see smaller.", 10)
    FOR i = 1 TO NumMaps
    x = 320 + Sfac * (CDX - LonCen(i)) * Hfac
    y = Ycen + Sfac * (CDY - LatCen(i)) * Yfactr
      REM dx = dy * 640 / (400 * Yfactr) * Lfac
      dy = MapMax(i) * Sfac * Yfactr / 60
      dx = dy * 1.8
      c = 15
      IF MapMax(i) > 32 THEN c = 14
      IF MapMax(i) > 64 THEN c = 12
      IF MapMax(i) > 128 THEN c = 11
      IF MapMax(i) > 256 THEN c = 13
          
    IF MapMax(i) > MapSize THEN
       LINE (x - dx, y - dy)-(x + dx, y + dy), c, B
       IF y + dy > Cfactr * Yfactr AND y + dy < bln * Cfactr * Yfactr THEN
          IF x + dx > 8 * (LEN(MapName$(i)) + 1) AND x + dx < 632 THEN
             LOCATE (y + dy) / (Cfactr * Yfactr), (x + dx) / 8 - LEN(MapName$(i))
             IF MapMax(i) > RS / 4 THEN PRINT MapName$(i);
          END IF
       END IF
    END IF
    NEXT i: RETURN
        
REM Next routines added by W7KKE for overlyaying GPS track histoiries

Hstdir: CLS : PRINT "HISTORY FILES DIRECTORY": PRINT
    PRINT "Enter the path to your xxxxxxx.HST files.  For example, the default of"
    PRINT "\APRS\HSTS\*.HST will show your APRS histories.  Similarly  *.hst will"
    PRINT "search your present QBasic directory."
    PRINT ""
         
    PRINT "Enter Filespec for searching the DIRECTORY (\APRS\HSTS\*.hst)";
    INPUT F$: IF F$ = "" THEN F$ = "\APRS\HSTS\*.hst"
    IF INSTR(F$, ".") = 0 THEN F$ = F$ + ".HST"
    PRINT : PRINT : FILES F$
    RETURN

LoadHST: CALL PRtxt("Which history file to load (ENTER for list, Q to quit)", F$)
    IF F$ = "Q" THEN RETURN
    IF F$ = "" THEN GOSUB Hstdir: GOTO LoadHST
    a = INSTR(3, F$, "."): IF a = 0 THEN F$ = F$ + ".hst"
    Fault = 0: F$ = UCASE$(F$): OPEN F$ FOR INPUT AS #3
   
    IF Fault = 53 OR Fault = 62 THEN Fault = 0: RETURN
    CALL CLRtxt(41, "Loading track history from " + F$, 10)
      
    DO WHILE NOT EOF(3)
       i = i + 1
       INPUT #3, a$
       HLAT(i) = VAL(MID$(a$, 26, 2)) + (VAL(MID$(a$, 28, 5)) / 60)
       HLONG(i) = VAL(MID$(a$, 35, 3)) + (VAL(MID$(a$, 38, 5)) / 60)
       IF MID$(a$, 33, 1) = "S" THEN HLAT(i) = -HLAT(i)
       IF MID$(a$, 43, 1) = "E" THEN HLONG(i) = -HLONG(i)
       maxhist = i
     LOOP
     CLOSE #3: Histloaded = -1
     CALL CLRtxt(41, "File loading is complete.  GPS data is plotted.", 0)
     REM fall through...

DrawHist:  'put history track on map
     IF Histloaded THEN
        size = 3: IF RS < 2 THEN size = size * 2 / RS
        FOR i = 1 TO maxhist
            HMX = 320 + KP * (CDX - HLONG(i)) * ppdv * Hfac'new
            HMY = Ycen + KP * (CDY - HLAT(i)) * ppdv * Yfactr
            CIRCLE (HMX, HMY), size, 13
            IF Slower THEN FOR zz = 1 TO 1500: NEXT zz
        NEXT i
     END IF
     RETURN

NewMap: CLS : PRINT "BEGINNING A NEW MAP FROM SCRATCH...": PRINT
   PRINT "All points in an APRS map are measured to the right and down from an origin."
   PRINT
   INPUT "Enter the LATITUDE  of the ORIGIN in degrees , minutes (DD, mm.xx)"; LATo, LAm
   PRINT
   INPUT "Enter the LONGITUDE of the ORIGIN in degrees , minutes (DDD, mm.xx)"; LONo, LOm
   LATo = LATo + SGN(LATo) * LAm / 60
   LONo = LONo + SGN(LONo) * LOm / 60
   PRINT
   PRINT
   PRINT "Choose the number of pixels per degree to set the map scale:"
   PRINT
   PRINT "Approximate size              Range from center  Resolution Pixels/Deg"
   PRINT "----------------              -----------------  ---------- ----------"
   PRINT "Typical state                        128 mi       400 yds      240"
   PRINT "Several County region                 64 mi       200 yds      450"
   PRINT "Typical VHF range                     32 mi       100 yds      900"
   PRINT "Big metro area     1:100,000 scale    16 mi       160 ft      1800"
   PRINT "Four 7.5 min maps                      8 mi        80 ft      3600"
   PRINT "One 7.5 min map    1: 24,000 scale     4 mi        40 ft      7200"
   PRINT ""
   INPUT "Enter desired Pixels/Deg"; ppdB
   IF ppdB = 0 THEN GOTO NewMap
   REM In following lines, 500 is half of 999 (maximum nominal value for pts)
   LatCen = LATo - (500 * Yfactr / ppdB)
   LonCen = LONo - (756 / ppdB) 'had been 500. Now .75 of 2048 % 2
   GOSUB StartMap: ppdv = ppdB
   CLS : PRINT "YOU ARE NOW READY TO DRAW A NEW MAP...": PRINT : PRINT
   PRINT
   PRINT "The YELLOW box shows the maximum values permitted for this ORIGIN and SCALE."
   PRINT
   PRINT "The PURPLE box shows the same limits, but moves with the current map center."
   PRINT
   PRINT "The WHITE  box shows the current map range to be entered into MAPLIST.xxx."
   PRINT
   PRINT
   PRINT "USING CURSOR WITHOUT DIGITIZER:  Move coursor to starting point for a NEW"
   PRINT "feature and hit EDIT-NEW. Then enter new feature name (not used except for"
   PRINT "your own reference) and continue moving cursor and hitting EDIT-ADD."
   PRINT
   PRINT
   PRINT "USING A DIGITIZER:  First, use FILES-OPEN to OPEN the digitizer COM port. Then"
   PRINT "use EDIT-BEGIN to BEGIN each new map feature.  Enter the name and color of the"
   PRINT "new feature.  Then use the digitizer mouse to add more points."
   PRINT : PRINT : PRINT
   PRINT "Add LABELS on the map at the current cursor location by using LABELS-ADD. "
   PRINT
   PRINT
   PRINT "When you are finished, be sure to SAVE the map using FILES-SAVE..."
   PRINT : PRINT : PRINT
   PRINT "FOR HELP, REMEMBER THE  H  KEY!"
   PRINT : PRINT : PRINT "Hit ENTER to proceed..."; : INPUT a$
   RETURN

StartMap: REM This called by NEW and in middle of USGS build
   LatCen$ = "LAT of CENTER": LonCen$ = "LON of CENTER"
   MapRng = 60 * 500 * Yfactr / ppdB: REM 500 is half of full map size
   MapRng$ = "Map range from center"
   VS$ = "Pixels per degree"
   MinRng = 1: MR$ = "Reserved"
   TextLine$ = "NEW Map generated by MAPFIX.bas routine..."
   IF Key$ = "NEW" THEN RS = 2 ^ INT(LOG(MapRng) / LOG(2))'Rng is intgr of VERTrng
   CDX = LonCen: CDY = LatCen: CPX = CDX: CPY = CDY
   nmp = 1: nml = 0
   LNi = 1: LN$(1) = "Labels begin here"
   RETURN


DigiInit:
   CLS : PRINT : Digitizer = -1: MpLstLdd = 0
   PRINT "DIGITIZER INITIALIZATION:"
   PRINT
   PRINT "This routine will replace many CURSOR functions with the Digitizer's MOUSE."
   PRINT "Assuming your digitizer can output an X,Y,C format."
   PRINT
   PRINT "Only Mercator projection charts will give absolutely accurate results.  Other"
   PRINT "types, Lambert Conformal, Conical, etc will induce distortions."
   PRINT
   PRINT : PRINT
   PRINT "The digitizr should operate at 9600,N,8,1 in POINT mode with 200 LPI resolution."
   PRINT "The FORMAT outputs X,Y,C values separated by commas (C is for button pressed."
   PRINT
   PRINT "Set up the digitizer according to your model's instructions.  For the model"
   PRINT "23360, use the drawing board menu by pressing the mouse button 0 on the SETUP"
   PRINT "label so that the LED is ON.  Then move the mouse to each other label and"
   PRINT "use the 0 button to toggle the value ON or off as follows:"
   PRINT
   PRINT "POINT is ON                             PARITY 7/8 and 1 are ON "
   PRINT "BAUDRATE 3 is ON                        FORMAT is ON ON off ON"
   PRINT "DATA RATE doesn't matter                RESOLUTION off off ON"
   PRINT : PRINT
   INPUT "Is DIGITIZER connected to COM1 or COM2 (1)"; a$
   IF a$ <> "2" THEN a$ = "COM1" ELSE a$ = "COM2"
   INPUT "9600 baud.  Is digitizer set for 7 or 8 bits (8)"; B$
   IF B$ = "7" THEN B$ = "E,7" ELSE B$ = "N,8"
   Port$ = a$ + ":9600," + B$ + ",1,cs0,ds0,cd0"
   OPEN Port$ FOR RANDOM AS #1
   

   CLS : PRINT "FIRST LETS TEST THE DIGITIZER, AND GET THE MAP ON STRAIGHT.": PRINT
   PRINT "Move your mouse (or pen) and hit the 0 button (or touch tablet) to see if the"
   PRINT "digitizer is outputting in the desired format.  While doing this, it is a good"
   PRINT "idea to verify that your map is on straight.  The Y values from the mouse"
   PRINT "should give the same values for the same LATITUDE line on both the right and"
   PRINT "left edges of the map.  If not, move your map to get it horizontal. Play with"
   PRINT "this as long as you like until you get the map on straight & the right format."
   PRINT
   PRINT "OUTPUT FORMAT:"
   PRINT
   PRINT "XXXXX,YYYYY,APn (Only the X and Y values are important (4 or 5 digits are OK)"
   PRINT "                (APn usually represents the buttons.  A four button mouse will"
   PRINT "                (output a 0,1,2, or 3.  The 0 ADDS a point, the 1 begins a RED"
   PRINT "                (road, a 2 begins a GRAY road and the 3 only moves the cursor."
   PRINT ""
   PRINT "                If your mouse is not putting out these numbers (Especially 0),"
   PRINT "                then select ONE BUTTON mode when asked."
   PRINT
   LOCATE bln, 1: PRINT "Hit ENTER and press 0 button on mouse to continue...";
   LOCATE 13, 1
   DO UNTIL INKEY$ <> "": LINE INPUT #1, a$: PRINT a$: LOOP
   CALL PR("Is your digitizer FOUR (4) or more buttons, OR a PEN (1). [1]", a$)
   IF a$ = CHR$(13) OR a$ = "1" THEN Buttons = 1
   CLS : PRINT
   PRINT "NEXT YOU MUST ESTABLISH THE SCALE OF YOUR DIGITIZER."
   PRINT
   PRINT "Both the HORZ and VERT scale are established by two points, the first near the"
   PRINT "top, the second near the bottom.  THese points must also be WIDELY separated"
   PRINT "both Vertically AND Horizontally."
   PRINT
   PRINT "To get the best accuracy on maps not exactly MERCATOR, use points within the "
   PRINT "area where you are working, not on the extreme corners.  IE:  choose points"
   PRINT "that are in the center of the upper left quadrant and the lower right quadrant."
   PRINT "(or the opposite diagonal)"
   PRINT
   PRINT "To establish the upper reference point:"
   INPUT "     Enter lat  (deg,min)"; LATref1, M
   LATref1 = LATref1 + SGN(LATref1) * M / 60
   INPUT "     Enter long (deg,min)"; LONref1, M
   LONref1 = LONref1 + SGN(LONref1) * M / 60
   PRINT

   PRINT "Place the mouse or pen on the upper point and press the 0 button."
   LINE INPUT #1, a$: CALL Noise(2)
        digix1 = 5000 - VAL(LEFT$(a$, 5))
        digiy1 = VAL(MID$(a$, 7, 5))
        PRINT "Digitizer reads "; digix1, digiy1; " for this point.": PRINT

   PRINT "NOW Establish the lower reference point:"
   INPUT "      Enter lat  (deg,min)"; LATref2, M
   LATref2 = LATref2 + SGN(LATref2) * M / 60
   INPUT "      Enter long (deg,min)"; LONref2, M
   LONref2 = LONref2 + SGN(LONref2) * M / 60
   PRINT
   PRINT "Place digitizer pen or mouse on lower reference point."
   LINE INPUT #1, a$: CALL Noise(2)
        digix2 = 5000 - VAL(LEFT$(a$, 5))
        digiy2 = VAL(MID$(a$, 7, 5))
        PRINT "Digitizer reads "; digix2, digiy2; " for this point.": PRINT

   REM Find delta lat/long between reference points
   REM Calculate degrees per x/y unit
        degx# = (LONref1 - LONref2) / (digix1 - digix2)
        degy# = (LATref1 - LATref2) / (digiy1 - digiy2)

   CLS : PRINT "YOU ARE NOW READY TO USE THE DIGITIZER TO ENTER POINTS INTO MAPFIX..."
   PRINT
   PRINT "The digitizer works just about like the cursor and arrow keys in MAPFIX.  Any"
   PRINT "point identified by the digitizer will be ADDED just as if you had hit the"
   PRINT "EDIT-ADD command.  All points are added to a feature after the current MapPoint"
   PRINT "identified by the white circle. "
   PRINT
   PRINT "With the digitizer, do NOT use the EDIT-NEW command which always begins at the"
   PRINT "current cursor location.  For the digitizer, use EDIT-BEGIN to BEGIN a new"
   PRINT "feature.  You will be asked to identify the name and color of the new feature."
   PRINT "From then on, just move the digitizer mouse (or pen) to ADD new points.  "
   PRINT
   PRINT "If your digitizer mouse has 4 buttons, use the first (left) button for ADDing "
   PRINT "points, use the 4th (right) button to just move the cursor with no action."
   PRINT "With point-pens or single button mice, press F1 and the next use of the Pen "
   PRINT "will just move the cursor, NOT add a point."
   PRINT
   PRINT "On a four button mouse, the 2nd will BEGIN a RED #4 line, and the 3rd will"
   PRINT "begin a gray color #7 line."
   PRINT : PRINT
   INPUT "Hit ENTER to continue with MAPFIX..."; a$
   RETURN

GetXY: LINE INPUT #1, a$: CALL Noise(2)
   a = INSTR(a$, ","): IF a = 0 THEN RETURN
       x = 5000 - VAL(LEFT$(a$, a - 1))
   B = INSTR(a + 1, a$, ",")
   c = B: IF B = 0 THEN c = LEN(a$)
       y = VAL(MID$(a$, a + 1, c - (a)))
   IF B THEN Btn = VAL(RIGHT$(a$, 1))' Get the BUTTON value from 3rd field
   IF Buttons = 1 THEN Btn = 0
   CPY = ((y - digiy2) * degy#) + LATref2
   CPX = ((x - digix2) * degx#) + LONref2
   IF LOC(1) <> 0 THEN a$ = INPUT$(LOC(1), #1)'Clear input buffer
   RETURN

BOXppd:  CALL PRtxt("Enter the desired PPD (enter 0 to eliminate purple box)", a$)
         IF a$ <> "" THEN ppdB = VAL(a$): gotthem = 0' To force re-evaluation
ShowBox: IF ppdB > 1 THEN
             y = (30000 / ppdB) * Sfac * Yfactr / 60 'had been 30000 thn 36000
             x = y * 820 / (400 * Yfactr) * Lfac 'had been 640 then 560
             LINE (CUX - x, CUY - y)-(CUX + x, CUY + y), 13, B
            CALL CLRtxt(41, "Purple box shows the largest APRS map that can be made with that scale.", 10)
         END IF
         RETURN
        
GetUSGS: REM This used for both U=OVERLAY and by ALT-U = USGS BUILD!
   Redraw = 0: USGS = -1: ni = 0: nt = 0: j = 0: NumLines = 0
   IF Key$ <> "U" THEN
      IF ppdB = 0 THEN GOSUB BOXppd
      ppdv = ppdB
      IF gotthem = 0 THEN
         LATo = CDY + (500 * Yfactr / ppdv)
         LONo = CDX + (756 / ppdv) 'had been 500 (now .75 of 2048)/2
         LE = 1: OE = 1
         gotthem = 1
      END IF
      CALL PRtxt("Round-off LAT ORIGIN of " + STR$(LATo), a$)
            IF a$ <> "" THEN LATo = VAL(a$)
      CALL PRtxt("Round-off LON ORIGIN of " + STR$(LONo), a$)
            IF a$ <> "" THEN LONo = VAL(a$)
      CALL PRtxt("LATitude extent (100%)", a$)
            IF a$ <> "" THEN LE = VAL(a$) / 100
      CALL PRtxt("LONgitude extent (100%)", a$)
            IF a$ <> "" THEN OE = VAL(a$) / 100
      dx = ppdv * (LONo - CDX)
      dy = ppdv * (LATo - CDY)
      KP = 100 * 100 / (RS * ppdv)
      LatCen = CDY: LonCen = CDX: GOSUB StartMap
      LATtext$ = "Decimal LAT  of map ORIGIN"
      LONtext$ = "Decimal LONG of map ORIGIN"
      TextLine$ = "Map generated by MAPFIX from USGS 2,000,000:1 CD ROM (data valid mid-1980's)"
   END IF
   Slope = 1.2: REM IF ppdV < 600 THEN Slope = 1.5 ELSE Slope = 1.2
   SlopeI = 1 / Slope
   IF ppdv < 610 THEN mindel = .004 ELSE mindel = 2.4 / ppdv
   REM this .004 seems to be magic for 2,000,000 source data

   Lmax = 500 + 500 * LE: Lmin = 501 - 500 * LE 'Max=1000 and Min =1
   Omax = 756 + 756 * OE: Omin = 757 - 756 * OE 'Max=1512 and min =1
   IF Lmin < 1 THEN Lmin = 1
   IF Omin < 1 THEN Omin = 1

   CALL PRtxt("Which category (AB,CF,PB,RD,RR,ST,WB) (" + Cat$ + ")", a$)
   IF a$ <> "" THEN
      a = INSTR(a$, "."): IF a = 0 THEN a$ = a$ + ".GRF"
      Cat$ = a$
   END IF
   LOCATE bln - 1, 1: PRINT "MAPFIX will add the CATEGORY (RD,ST,WB,etc).GRF to the PATH\FILENAME above.    ";
   CALL PRtxt("Enter DRIVE:PATH\filename up to CATEGORY (" + Path$ + ")", a$)
   IF a$ <> "" THEN Path$ = a$
  
   USGS$ = Path$ + Cat$
   TY$ = UCASE$(LEFT$(Cat$, 2))
   LowMax = 99: HiMin = 0
   SELECT CASE TY$
      CASE "RD", "PB", "AB", "CF", "RR": MaxRnk = 99: MinRNk = 0
      CASE "WB": MaxRnk = 20: MinRNk = 0: LowMax = 0: HiMin = 5
      CASE "ST": MaxRnk = 50: MinRNk = 5: LowMax = 16: HiMin = 43
               ' Does not include canals
               ' Make minRNK=7 normal, 10 Alaska, 3 alaska for full map
   END SELECT
   OPEN USGS$ FOR INPUT AS #3
   IF Fault <> 0 THEN RETURN
   REM PRINT "raw data format.....", "   LineID", "#-Rnk-Atbts", "  NumPts"
   LOCATE 5, 72: PRINT "RNG"; INT(30000 / ppdv): LOCATE bln - 1, 1
   IF Key$ = "U" THEN
      PRINT "While USGS OVERLAYED, do not redraw map or you will have to do it again...";
   ELSE PRINT "Blue circles start lines, Green Box ends.  Red points discarded, Yellow Kept!";
   END IF
   LOCATE 1, 71: PRINT "PTS     ";
   LOCATE 2, 71: PRINT "USED    ";
   LOCATE 3, 71: PRINT "LINE    ";
   LOCATE 4, 71: PRINT "USED    ";
   LOCATE 6, 72: PRINT "RNK";

 DO UNTIL EOF(3) OR LNi = MaxNumLines - 1
   IF INKEY$ <> "" THEN EXIT DO
   NumLines = NumLines + 1
   LOCATE 1, 75: PRINT nt
   LOCATE 2, 75: PRINT ni
   LOCATE 3, 75: PRINT NumLines
   LOCATE 4, 75: PRINT LNi
   a$ = INPUT$(20, 3): REM PRINT a$;
        LnID$ = LEFT$(a$, 7)
        Rank$ = MID$(a$, 8, 2): Rank = VAL(Rank$): LOCATE 6, 75: PRINT Rank
        Npts$ = MID$(a$, 10, 6): Npts = VAL(Npts$)
        AtCd$ = MID$(a$, 16, 5)
        a$ = LTRIM$(LnID$) + "-" + Rank$ + "-" + AtCd$
        REM PRINT , LnID$, a$, Npts$
   IF Rank < 24 THEN SavClr = 4 ELSE SavClr = 7
   IF Rank < 20 THEN SavClr = 12
   IF Rank < 14 THEN SavClr = 10
   IF TY$ = "WB" THEN SavClr = 11
   IF TY$ = "ST" THEN SavClr = 3
   IF TY$ = "CF" THEN SavClr = 14
   IF TY$ = "RR" THEN SavClr = 8
   IF TY$ = "PB" THEN SavClr = 6
   IF TY$ = "AB" THEN SavClr = 14
   LineOK = 0: IF Key$ <> "U" THEN GOSUB BeginF
   REM IF ppdV < 610 THEN mindel = .004 ELSE mindel = 2.4 / ppdV
   REM this .004 seems to be magic for 2,000,000 source data
   FOR i = 1 TO Npts
    a$ = INPUT$(20, 3)
    IF Rank > MaxRnk OR Rank < MinRNk THEN IF Rank > 2 OR TY$ <> "ST" THEN GOTO Skp
    IF Rank > LowMax AND Rank < HiMin THEN GOTO Skp
    REM IF VAL(Rank$) > 99 THEN GOTO Skp
    LA = VAL(LEFT$(a$, 2)) + VAL(MID$(a$, 3, 2)) / 60 + VAL(MID$(a$, 5, 2)) / 3600
    LO = VAL(MID$(a$, 8, 3)) + VAL(MID$(a$, 11, 2)) / 60 + VAL(MID$(a$, 13, 2)) / 3600
    IF Key$ = "U" THEN
        REM Following lines used to limit points if just doing an OVERLAY only
        IF LA > CDY + RS / 60 OR LA < CDY - RS / 50 THEN GOTO Skp 'off screen
        IF LO > CDX + RS / (35 * Hfac) OR LO < CDX - RS / (35 * Hfac) THEN GOTO Skp
        REM s$ = MID$(a$, 16, 5)
        REM PRINT S$, LA, LO
    END IF 'oops stack problem here if too many times...
    y% = (LATo - LA) * ppdv
    x% = (LONo - LO) * ppdv: IF x% = 0 THEN x% = -1
    IF Key$ <> "U" AND (x% > Omax OR x% < Omin) THEN GOTO Skp'this ignores points off PPD
    IF Key$ <> "U" AND (y% > Lmax OR y% < Lmin) THEN GOTO Skp'scale
    LineOK = -1
       X1 = 320 + KP * (x% - dx) * Hfac
       Y1 = Ycen + KP * (y% - dy) * Yfactr
       IF i > 2 THEN
          REM LINE (x, y)-(X1, Y1), 6
          dd = LO - LOb: IF dd = 0 THEN dd = .0000001
          dn = LA - LAb
          S = dn / dd' Note that 1>s>.01 for Xdelta of 1 to 100
          IF ABS(S) < .1 AND ABS(Lsp) < .1 THEN
             sd = 1
          ELSEIF ABS(S) > 10 AND ABS(Lsp) > 10 THEN sd = 1
          ELSEIF ABS(dd) < mindel AND ABS(dn) < mindel THEN sd = 1
          REM this had been .004 for 2,000,000 CD rom and ppdV 300 to 600
          REM now is 2.4/ppdV for 100,000
          ELSEIF S <> 0 THEN sd = Lsp / S
          ELSE sd = 0
          END IF
          IF sd > Slope OR sd < SlopeI OR i = Npts THEN
             PSET (x, y), 14
             IF Key$ <> "U" THEN GOSUB KeepLine
          ELSE PSET (x, y), 4
          END IF
          Lsp = S: nt = nt + 1
       ELSE Lsp = 0: CIRCLE (X1, Y1), 2, 9
          IF Key$ <> "U" THEN GOSUB KeepLine 'keeps first two lines
       END IF
       LAb = LA: LOb = LO
       x = X1: y = Y1
       
Skp: NEXT i
     IF Key$ <> "U" THEN
        IF LineOK THEN
           nmp = nmp - 1: z = z - 1: ni = ni + 1
        ELSE
           nmp = nmp - 2: z = Kz
           LNi = LNi - 1: LN$(LNi) = LN$(LNi + 1): RETURN
        END IF
     END IF
     LINE (x - 1, y - 1)-(x + 1, y + 1), 10, B ' Last Point
 LOOP
 IF LNi > MaxNumLines - 2 THEN LOCATE 12, 20: PRINT "PROCESSING STOPPED... TOO MANY LLINES!..."
   CLOSE #3
   IF x%(nmp) <> 0 THEN x%(nmp) = 0: y%(nmp) = 0
   CALL Noise(3)
   RETURN

KeepLine: x%(z) = x%: y%(z) = y%: nmp = nmp + 1: z = z + 1: ni = ni + 1: RETURN


Scrunch: i = 0: Pt = 0: nt = 0: ni = 0
    CALL PRtxt("Enter slope filter ratio 1.1 to 1.5 (typically 1.2)", a$)
    IF a$ = "" THEN Slope = 1.2 ELSE Slope = VAL(a$)
    DO UNTIL i >= nmp - 1
      i = i + 1
      X1 = 320 + KP * (x%(i) - dx) * Hfac
      Y1 = Ycen + KP * (y%(i) - dy) * Yfactr
      IF x%(i) <> 0 THEN
        Pt = Pt + 1
        IF Pt > 2 THEN
          REM LINE (x, y)-(x1, y1), 6
          dd = x - X1
          dn = y - Y1
          IF dd = 0 AND dn = 0 THEN
            sd = Slope: S = Lsp  'Here the points are identical
            CIRCLE (x, y), 9, 13
          ELSE
            IF dd = 0 THEN dd = .01
            dst = ((dd * dd) + (dn * dn)) ^ .5
            S = dn / dd' Note that 1>s>.01 for Xdelta of 1 to 100
            IF S = 0 THEN S = .05
            IF ABS(S) < .2 THEN S = .2 * SGN(S)
            IF ABS(S) > 5 THEN S = 5 * SGN(S)
            IF ABS(S) <= .2 AND ABS(Lsp) <= .2 THEN
               sd = 1
            ELSEIF ABS(S) >= 5 AND ABS(Lsp) >= 5 THEN sd = 1
            ELSE sd = Lsp / S
            END IF
            IF ABS(dd) > 50 * KP OR ABS(dn) > 30 * KP THEN sd = 0
            REM IF ABS(dd) < 5 OR ABS(dn) < 4 THEN sd = 1
          END IF
          IF sd > Slope OR sd < 1 / Slope OR x%(i + 1) = 0 OR NumRej > 4 THEN
            ni = ni + 1: CIRCLE (x, y), 1, 15: NumRej = 0
          ELSE PSET (x, y), 4: NumRej = NumRej + 1: Changed = Changed + 1
            IF Key$ <> "T" THEN
               i = i - 1: nmp = nmp - 1
               FOR ii = i TO nmp
                   x%(ii) = x%(ii + 1): y%(ii) = y%(ii + 1)
               NEXT ii
            END IF
          END IF
          Lsp = S: nt = nt + 1
        ELSE Lsp = 0: nt = nt + 1: ni = ni + 1: CIRCLE (X1, Y1), 4, 9
        END IF
      ELSE Pt = 0: nt = nt + 1: ni = ni + 1
        LOCATE 1, 71: PRINT "PTS "; nt
        LOCATE 2, 71: PRINT "SAVD"; ni
      END IF
      x = X1: y = Y1
    LOOP
    CALL Noise(3)
    RETURN

Join: REM Search for end=begin point values and CONCATONATE if equal!
   LnPtr = 0: i = 0: k = 0: CALL CLRtxt(41, "Lines joined: ", 0)
   DO UNTIL i >= nmp
      i = i + 1
       IF x%(i) = x%(i + 2) AND y%(i) = y%(i + 2) AND y%(i + 1) = LCOlor THEN
          nmp = nmp - 2: LNi = LNi - 1: k = k + 1: LOCATE bln - 2, 15: PRINT k
          FOR j = i + 1 TO nmp: x%(j) = x%(j + 2): y%(j) = y%(j + 2): NEXT j
          FOR j = LnPtr TO LNi: LN$(j) = LN$(j + 1): NEXT j
       ELSEIF x%(i) = 0 THEN LCOlor = y%(i): LnPtr = LnPtr + 1
       END IF
   LOOP: GOSUB DrawMap
   CALL Noise(3)
   RETURN

MapCnvrt: CALL PRtxt("Enter desired SCALE in pixels-per-deg (" + STR$(ppdv) + ")", a$)
   PPDD = ppdv: IF a$ <> "" THEN PPDD = VAL(a$)
   Changed = Changed + nmp
   CALL PRtxt("Enter New Latitude of origin (" + STR$(LATo) + ")", a$)
   IF a$ = "" THEN Nlat = LATo ELSE Nlat = VAL(a$)
   CALL PRtxt("Enter New Longitude of origin (" + STR$(LONo) + ")", a$)
   IF a$ = "" THEN Nlon = LONo ELSE Nlon = VAL(a$)
     ChgFac = PPDD / ppdv
     LOfset = LONo - Nlon
     LAfset = LATo - Nlat
     CALL PRtxt("This will convert all points...  Are you sure (Y/N) [Y]", a$)
     IF a$ <> "" AND a$ <> "Y" THEN RETURN
     CALL CLRtxt(41, "Now processing map points.", 15)

     FOR i = 1 TO nmp'DO WHILE NOT EOF(3)
         IF x%(i) <> 0 THEN
            x%(i) = ChgFac * (x%(i) - ppdv * LOfset)
            y%(i) = ChgFac * (y%(i) - ppdv * LAfset)
            IF x%(i) = 0 THEN x%(i) = 1: PRINT "ZERO value of X!  Converted to 1,"; y%
        ELSEIF y%(i) = -1 THEN i = nmp 'shuldnt occur since -1 is NOT in array
        END IF                         'but is only writen at end of file
     NEXT i
     CALL CLRtxt(41, "CONVERSION SUCCESSFUL.", 0)
     LATo = Nlat
     LONo = Nlon
     ppdv = PPDD
     Display$ = "MAP": Redraw = -1: USGS = 0: GOSUB DrwMPaCur
     RETURN

Import: 'Also this does TASK-OVERLAY and LABELS-IMPORT
   LoopCNTR = 0
   IF (CDX <> LonCen OR CDY <> LatCen) AND (NOT Overlay OR LImp) THEN
      CDX = LonCen: CDY = LatCen: GOSUB DrwMPaCur
      'Cuz TRIM calcs are based on range from CDX,CDY vice alt-CENTER
   END IF: IF Import$ = "" THEN Import$ = "    "
   LOCATE 42, 1: PRINT "IMPORT ALL FEATURES (of one color) FROM ANOTHER MAP THAT FIT INSIDE THIS MAP'S";
   CALL PRtxt("Enter map filename (" + Import$ + ")", a$)
   IF a$ <> "" THEN
      Import$ = a$
      IF INSTR(a$, ".") = 0 THEN Import$ = Import$ + ".MAP"
   END IF: F$ = Import$
   Fault = 0: OPEN Import$ FOR INPUT AS #2
   IF Fault <> 0 THEN RETURN
   a$ = ""
   IF NOT LImp THEN CALL PRtxt("Color of feature to import (1 to 15) or ALL", a$)
   IF a$ = "ALL" OR a$ = "" THEN All = -1 ELSE All = 0
   IF a$ <> "" THEN Fcolr = VAL(a$)
   INPUT #2, LATa: LINE INPUT #2, a$:
   INPUT #2, LONa: LINE INPUT #2, a$: IF Nlon = 0 THEN Nlon = LONa
   INPUT #2, OppdV: LINE INPUT #2, a$'Pix-per-deg-Vert
   INPUT #2, oLatCen: LINE INPUT #2, a$
   INPUT #2, oLonCen: LINE INPUT #2, a$
   INPUT #2, oMapRng: LINE INPUT #2, a$
   INPUT #2, oMinRnga: LINE INPUT #2, a$
   LINE INPUT #2, a$
   IF a$ = "Compressed" THEN PRINT "OOPS, Cannot use a map in COMPRESSED format!"
   IF a$ = "Compressed" THEN CALL Noise(1): CLOSE #2: RETURN
   i = 0
   REM now make offset and scale calculations
   Nfac = ppdv / OppdV
   LOfset = LONa - LONo
   LAfset = LATa - LATo
    by = ppdv * MapRng / 60 ' These the same as TRIM borders
    bx = by / Lfac
    S = nmp'start for RE-DRAW at end of this routine
    x% = 1: y% = 1' To get around first test
    DO WHILE NOT EOF(2)
      IF x% = 0 AND y% = 0 THEN
         StrtPt = -1
         INPUT #2, LCOlor: LINE INPUT #2, a$'get color and name
         IF LCOlor = Fcolr OR All THEN
            IF NOT Overlay THEN
               x%(nmp) = 0: y%(nmp) = LCOlor ' over top of previous 0,0 at nmp
               LNi = LNi + 1: LN$(LNi) = a$
            END IF
            NofPts = 0' helps us not delete pts until line has at least 2 pts
            DO
               INPUT #2, x%, y%: REM PRINT x%, y%
               IF NOT Overlay THEN nmp = nmp + 1: Changed = Changed + 1
               IF x% = 0 THEN EXIT DO
               x = Nfac * (x% - OppdV * LOfset)
               y = Nfac * (y% - OppdV * LAfset)
               IF x = 0 THEN
                  x = 1
                  IF NOT Overlay THEN PRINT "ZERO value of X!  Converted to 1,"; y%
               END IF
               IF NOT Overlay THEN x%(nmp) = x: y%(nmp) = y
               IF x > dx + bx OR y > dy + by THEN bad = 1 ELSE bad = 0
               IF x < dx - bx OR y < dy - by THEN bad = 1
               IF bad AND NofPts > 1 THEN
                  IF NOT Overlay THEN nmp = nmp - 1
               ELSE REM IF NOT LImp THEN
                    NofPts = NofPts + 1
                    Xc = 320 + (x - dx) * HfacK
                    Yc = Ycen + (y - dy) * YfactrK
                    IF StrtPt THEN
                       PSET (Xc, Yc), LCOlor
                       CIRCLE (Xc, Yc), 2, 9: StrtPt = 0
                    ELSE
                       LINE -(Xc, Yc), LCOlor
                    END IF
               END IF
            LOOP
            IF NofPts = 2 AND bad AND NOT Overlay THEN LNi = LNi - 1: nmp = nmp - 3
            IF NOT Overlay THEN
               x%(nmp) = 0: y%(nmp) = 0
            ELSE CIRCLE (Xc, Yc), 3, 10
            END IF
         END IF
      ELSE INPUT #2, x%, y%
      END IF
      LoopCNTR = LoopCNTR + 1: REM PRINT LoopCNTR
      IF x% = 0 AND y% = -1 THEN EXIT DO
   LOOP
   LOCATE 42, 1: PRINT SPACE$(80);
   CALL CLRtxt(43, "All map points converted...", 10)
      LINE INPUT #2, a$
      Yp = CDY + MapRng / 60: Xp = CDX + (MapRng / 60) / Lfac
      Ym = CDY - MapRng / 60: Xm = CDX - (MapRng / 60) / Lfac
      DO WHILE NOT EOF(2)
         INPUT #2, ML$, MLa, MLo, MLr
         IF MLa < Yp AND MLa > Ym AND MLo < Xp AND MLo > Xm THEN
            IF NOT Overlay OR LImp THEN
               nml = nml + 1
               ML$(nml) = ML$: MLa(nml) = MLa
               MLo(nml) = MLo: MLr(nml) = MLr
            END IF
         END IF
      LOOP: CLOSE #2
      IF NOT Overlay THEN GOSUB DP
      Overlay = 0: LImp = 0
      CALL Noise(3)
      RETURN
END

REM $STATIC
SUB CLRtxt (L, S$, c)

 LOCATE L, 1: PRINT LEFT$(S$ + SPACE$(80), 80);
 LOCATE L, LEN(S$) + 2
 IF L = 41 THEN
    LINE (0, 318)-(639, 329), c, B
 ELSE
    LINE (0, 334)-(639, 345), c, B
 END IF

END SUB

SUB Noise (n)
 SHARED Quiet
 IF NOT Quiet THEN
    IF n = 1 THEN SOUND 1200, 1.5
    IF n = 2 THEN SOUND 150, 3
    IF n = 3 THEN SOUND 800, 4: SOUND 1500, 3: SOUND 500, 2
 END IF

END SUB

SUB PR (S$, a$)

 LOCATE 43, 1: PRINT LEFT$(S$ + SPACE$(80), 80);
 LOCATE 43, LEN(S$) + 2: PRINT "? _";
 LINE (0, 334)-(639, 345), 14, B
 a$ = ""
 DO UNTIL a$ <> "": a$ = INKEY$: LOOP
 a$ = UCASE$(a$)
 CALL CLRtxt(43, "", 0)
 
END SUB

SUB PRtxt (S$, a$)

 LOCATE 41, 1: PRINT LEFT$(S$ + SPACE$(80), 80);
 LOCATE 41, LEN(S$) + 2
 LINE (0, 318)-(639, 329), 14, B
 INPUT a$
 a$ = UCASE$(a$)
 LOCATE 41, 1: PRINT SPACE$(80);
 LINE (0, 318)-(639, 329), 0, B

END SUB

