/**************************************************************
 *
 *   MIDPLAY - Grin's Simple MIDi Jukeboxx
 *
 *    Usage: MIDPLAY [file pattern] [[file pattern] ...]
 *
 *  version 2.31
 *
 *  Copyright 1995-96, Grin.  Free for personal use.
 *
 * Usage:
 *   MidPlay [<file pattern>]
 *      
 * Examples:
 *   MidPlay
 *     Plays all *.MID files in the current directory
 *   MidPlay E:\TMP\MIDI\A*.MID M:\IDI\"C64 Evergreens"\*
 *     Plays the given files of the given directory
 *
 * (This program eats up very few CPU cycles. You can use it in the
 * background.)
 *
 * License
 *  If you are using the program in a non-commercial environment
 *  then you're free to use, copy, or delete it. You must not sell it.
 *  You can include it on CDRoms or in shareware catalogs.
 *  Commercial users should contact me about the license fees.
 *  
 *  This program is copyrighted material of Peter Gervai, Hungary.
 *  Please do not distribute modified versions without my approval. Thanks!
 *
 *  PLEASE tell me about your ideas about the program!
 *
 * History:
 *   1.0  - Release the in-house version
 *   1.1  - Pause song, bad MIDi file handling
 *   1.2  - Error control, restart
 *   1.3  - Handle HPFS extreme filenames (space, comma, etc in names)
 *   1.99 - Seeking
 *   2.0  - New interface ;-) : direct keyboard, pos display, volumes
 *   2.1  - New interface strikes back: borders, volume, buttons'n'boxes
 *   2.2  - More paths on commandline (the song counter cheats, though!)
 *   2.21 - Use the more general "sequencer" device instead of "sequencerNN"
 *   2.3  - Don't close sequencer instance. This helps playing type0
 *          MIDis without exact channel programming (uses the already loaded
 *          intruments... <sigh>)
 *        - The INIT midi created
 *        - inet email address changed :(
 *   2.31 - volume won't change to 100% after play a new song
 *        - volume can be preset [now only in the source]
 *        - The INIT midi is searched where MidPlay resides. Hopefully. :)
 *        - nasty logical error fixed when multiple filenames on
 *          commandline were with spaces in them. It wasn't my fault... ;->
 *
 * TODO:
 *        - using playlists
 *        - random/shuffle play
 *        - using command line params for preset volume?? :)
 *        - ? your ideas ?
 *
 * Author
 *  Peter "Grin" Gervai, 2:370/15@fidonet, 81:436/3@OS2Net,
 *                       grin@lifeforce.fido.elte.hu
 */
call RxFuncAdd "SysFileTree", "RexxUtil", "SysFileTree"
call RxFuncAdd "SysSleep", "RexxUtil", "SysSleep"
call RxFuncAdd "SysCls", "RexxUtil", "SysCls"
call RxFuncAdd "SysGetKey", "RexxUtil", "SysGetKey"
call RxFuncAdd "SysCurPos", "RexxUtil", "SysCurPos"

/* Record error and get back to work*/
Call on failure name error1
Call on halt name error2
/*signal on syntax name error3*/


/*         12345678901234          graph schemes for tables and buttons */
B_Plain = "+-+|+-+| ++++#"
B_Pc    = "Ŀٳ ô"

ProgVersion = "2.31"

/*******************************************************************
 *
 * You can change these
 *
 */
 
/* we use PC characters to display graphics :) */
styp = B_Pc

/* use 90% as the starting volume [value: 0-100] */
lvol = 90
rvol = 90

/*
 * ...do not change after that.
 * 
 *******************************************************************/

LastLeftVol  = -1
LastRightVol = -1
LastTotalsBar = -1
StereoUnchecked = 1

CALL SysCls
Call SetupScreen

/* Load the DLL, initialize MCI REXX support */
rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Send commands to OS/2 command processor.  */
address cmd      

FILE=''
Parse Arg pattern

Call ParseNextName

/*
 ** Open it
 */
MciCmd = 'open sequencer alias rexxalias wait'
MacRC = SendString(MciCmd)

/* Check if your sequencer doesn't support stereo volumes */
If StereoUnchecked Then Call CheckStereoVol
  
Call MIDiVol lvol,rvol,0,0
  
parse source . . myself
mypath = SubStr(myself,1,LastPos('\',myself))
/*=================================================================
 * The INIT MIDi file. If you don't need 'em don't use 'em....
 *   (comment out that stuff if you don't want to have it)
 */
MciCmd = 'load rexxalias "'mypath'~~init~~.Mid" wait'
MacRC = SendString(MciCmd)
MciCmd = 'play rexxalias wait'
MacRC = SendString(MciCmd)
/*
 *=================================================================
 */
  
if pattern=='' then pattern='*.MID'

Do while pattern \== ''
  CALL SysFileTree pattern,'file','F'
  
  If file.0 = 0 Then Do
    Call SysCls
    Say ' '
    Say 'You selected no MIDi files and there is no MIDi files'
    Say 'in the actual directory.'
    Say ' '
    Say 'USAGE: '
    Say '  MIDPLAY [<file pattern>]'
    Say ' '
    Say 'Examples:'
    Say '  MIDPLAY                               plays the MIDis in the actual dir'
    Say '  MIDPLAY M:\IDI\"James Bond"\g*.MID    plays the given MIDis'
    Say ' '
    exit 1;
    return;
  end;
  
  do SongNum=1 to file.0
  nextmusic:
    MIDiName = SubStr(file.SongNum,38,Length(file.SongNum)-37)
    Call ScrMidiName MIDiName
    Call ScrSeqNumber SongNum,file.0,styp
    CALL PlayMIDi MIDiName
    pressed = Result
    /**  Keys:
     ** S = Stop                V = Prev            Enter=next
     ** P = Pause               
     ** [ = -1min               ] = +1min           1 = left vol.up
     ** < = -30sec              > = +30sec          2 = left vol.dn
     ** - = -10sec              + = +10sec          3 = right vol.up
     ** 8 = global vol.up       9 = glob.vol.dn     4 = right vol.dn
     */
    Select
      When pressed='A' Then SongNum=SongNum-1;
      When pressed='S' Then Do
      /*
       ** close the instance.
       */
        MacRC = SendString("close rexxalias wait")
        if MacRC <> 0 then signal ErrExit
        
        Call SysCls
        say "Thank you for using Grin's Simple MIDi JukeBoxx v"ProgVersion"!"
        exit;
        End;
      When pressed='V' & SongNum>1 Then Do
        SongNum=SongNum-2;
        End;
      Otherwise Nop;
    end;
  end;
    
/* read the rest of the command line */
/*    parse var restPattern pattern restPattern*/
    pattern = restPattern
    call ParseNextName
                              
end; /* do while pattern\==''*/
  
    MacRC = SendString("close rexxalias wait")
    
    Call SysCls
    say "Thank you for listening to Grin's Simple MIDi JukeBoxx v"ProgVersion"!"
    exit 0;
  
  /******************************************************************
   **     Play the MIDi file
   **/
PlayMIDi:
  Parse Arg FileName
  LastPercent = -1;
  /*
   ** Open it
   */
   
   /* The Mci interface don't really like spaces in names.
    * we quote it, and hope that it liked that way, since
    * it's not documented. :( (we killed internal quotes earlier.)
    */
  MciCmd = 'load rexxalias "'FileName'" wait'
  MacRC = SendString(MciCmd)
  
  MciCmd = 'play rexxalias'
  
  /*
   ** actually send the play string.
   */
  MacRC = SendString(MciCmd)
  if MacRC <> 0 then
  do
    /* junk = SendString("close rexxalias wait")*/
    signal ErrExit
  end
  
  /* Set time format to milliseconds */
  State = SendString('SET rexxalias time format ms wait')
  /* ...and get total music length */
  State = SendString('STATUS rexxalias length wait')
  TotalLen = RetSt
  Call ScrTotalTime TotalLen/1000
  
  /******************************************************************
   **     Play and parse keybored
   **/
  choice=''
  do forever
    State = SendString('STATUS rexxalias mode wait')
    if RetSt<>'playing' Then Signal FinishedSong
    State = SendString('STATUS rexxalias position wait')
    LastPos = RetSt
    State = SendString('STATUS rexxalias volume wait')
    LastVol = RetSt
    Parse Var lastVol lvol':'rvol
    
    Call ScrPercent LastPos/1000,TotalLen/1000
    Call ScrVolumes lvol,rvol
    Do While Chars()>0
      choice = TRANSLATE(SysGetKey('noecho'))
      Select
        When choice='P' Then CALL PauseSong
        When choice='-' Then CALL MIDISeek LastPos-10000
        When choice='+' Then CALL MIDISeek LastPos+10000
        When choice='<' Then CALL MIDISeek LastPos-30000
        When choice='>' Then CALL MIDISeek LastPos+30000
        When choice='[' Then CALL MIDISeek LastPos-60000
        When choice=']' Then CALL MIDISeek LastPos+60000
        
        When SupportStereoVol & choice='1' Then CALL MIDIVol  lvol,rvol, 10,  0
        When SupportStereoVol & choice='2' Then CALL MIDIVol  lvol,rvol,-10,  0
        When SupportStereoVol & choice='3' Then CALL MIDIVol  lvol,rvol,  0, 10
        When SupportStereoVol & choice='4' Then CALL MIDIVol  lvol,rvol,  0,-10
        When choice='8' Then CALL MIDIVol  lvol,rvol, 10, 10
        When choice='9' Then CALL MIDIVol  lvol,rvol,-10,-10
        When choice='0d'x | choice='A' | choice='S' | choice='V' Then Signal FinishedSong
        Otherwise Nop;
      end;
      /* this is here for updating even if the user sleeps on the keybored :) */
      State = SendString('STATUS rexxalias mode wait')
      if RetSt<>'playing' Then Signal FinishedSong
      State = SendString('STATUS rexxalias position wait')
      LastPos = RetSt
      State = SendString('STATUS rexxalias volume wait')
      LastVol = RetSt
      Parse Var lastVol lvol':'rvol
      Call ScrPercent LastPos/1000,TotalLen/1000
      Call ScrVolumes lvol,rvol
    end;
    CALL SysSleep 1;
  end;
  
FinishedSong:
  /*
   ** close the instance.
   */
  /*MacRC = SendString("close rexxalias wait")
  if MacRC <> 0 then signal ErrExit*/
  
ErrExit:
  Return choice;
  
  /******************************************************************
   **     Seek in MIDi file (jump)
   **/
MIDIseek: Parse Arg newpos
  If newpos<0 then newpos = 0
  State = SendString('SEEK rexxalias to' newpos 'wait')
  State = SendString('PLAY rexxalias')
return;
  
  /******************************************************************
   **     Set volume
   **/
MIDiVol: Procedure Expose SupportStereoVol
  Parse Arg lvol,rvol,ldif,rdif
  
  lvol = lvol+ldif
  rvol = rvol+rdif
  If lvol>100 then lvol=100
  If rvol>100 then rvol=100
  If lvol<0   then lvol=0
  If rvol<0   then rvol=0
  If SupportStereoVol Then Do
    State = SendString('SET rexxalias audio volume left'  lvol 'wait')
    State = SendString('SET rexxalias audio volume right' rvol 'wait')
  end
  Else
    State = SendString('SET rexxalias audio volume ' lvol 'wait')
return;
  
  /******************************************************************
   **     Pause song
   **/
PauseSong:
  MacRC = SendString("PAUSE rexxalias wait")
  if MacRC <> 0 then signal ErrExit
  
  styp1 = Overlay(SubStr(styp,14,1),styp,9)  /* "shaded" button fill pattern */
  
  /* Fancy button flash ;-) */
  Do Forever
    Call DrawBorder PauseButX,PauseButY,PauseButX+PauseButSize,PauseButY+3,styp1
    Call SysSleep 1
    If Chars()>0 Then Leave
    Call ButtPutt  PauseButX,PauseButY,PauseButSize,styp,'[P]','pause'
    Call SysSleep 1
    If Chars()>0 Then Leave
  end;
  Do While Chars()>0
    Call SysGetKey('noecho')
  end;
  
  MacRC = SendString("RESUME rexxalias wait")
  if MacRC <> 0 then signal ErrExit
  Call ButtPutt  PauseButX,PauseButY,PauseButSize,styp,'[P]','pause'
  Return;
  
  /*   --- SendString --
   ** Call DLL function.  Pass the command to process and the
   ** name of a REXX variable that will receive textual return
   ** information.
   */
SendString:
  Parse Arg CmndTxt
  /* Last two parameters are reserved, must be set to 0           */
  /* Future use of last two parms are for notify window handle    */
  /* and userparm.                                                 */
  MacRC = mciRxSendString(CmndTxt, 'RetSt', '0', '0')
  if MacRC<>0 then
  do
    ErrRC = MacRC
    /*say 'MciCmd=' CmndTxt
    say 'Err:mciRxSendString RC=' ErrRC RetSt*/
    MacRC = mciRxGetErrorString(ErrRC, 'ErrStVar')
    /*say 'mciRxGetErrorString('ErrRC') =' ErrStVar*/
    Call StrXY 6,23,' Error @' CmndTxt' '
    Call StrXY 7,24,' 'ErrRC':' ErrStVar' ' 
    MacRC = ErrRC             /* return the error rc */
  end
return MacRC
  
  /******************************************************************
   **     Pause song
   **/
error1:
  Call StrXY 1,1,Left('*** Error Failure - next',70)
  signal errorquit
error2:
  Call StrXY 1,1,Left('*** Error HALT - next',70)
  signal errorquit
error3:
  Call StrXY 1,1,Left('*** Bad MIDi file - next   [/REXX Syntax error]',70)
  
errorquit:
/*
 ** close the instance.
 */
  /*MacRC = SendString("close rexxalias wait")*/
  
  SongNum=SongNum+1
  signal nextmusic
  
  /******************************************************************
   **     Check volume setting ability :-(
   **/
CheckStereoVol:
  /* It's set to 90% because some patterns got distorted at 100% */
  CmndTxt = 'SET rexxalias audio left volume 90'
  SupportStereoVol = (mciRxSendString(CmndTxt, 'RetSt', '0', '0') = 0)
  If \SupportStereoVol Then Do
    Do i=0 to 3
      Call StrXY VolButX, VolButY+i,Copies(' ',VolButSize+1)
      Call StrXY VolBut2X,VolButY+i,Copies(' ',VolButSize+1)
      Call StrXY VolBut3X,VolButY+i,Copies(' ',VolButSize+1)
      Call StrXY VolBut4X,VolButY+i,Copies(' ',VolButSize+1)
    end;
  end;
  /* we don't want to set volume to 90% EVERYTIME, do we? */
  StereoUnchecked = 0
return;
  
  /******************************************************************
   **     Draw a border (box)
   **/
DrawBorder: Procedure
  Parse Arg x1,y1,x2,y2,typ
  /* upper horiz */
  Call SysCurPos y1,x1
  Call CharOut ,SubStr(typ,1,1)
  If x2-x1>1 Then Call CharOut ,Copies(SubStr(typ,2,1),x2-x1-1)
  If x2-x1>0 Then Call CharOut ,SubStr(typ,3,1)
  /* lower horiz */
  Call SysCurPos y2,x1
  Call CharOut ,SubStr(typ,5,1)
  If x2-x1>1 Then Call CharOut ,Copies(SubStr(typ,6,1),x2-x1-1)
  If x2-x1>0 Then Call CharOut ,SubStr(typ,7,1)
  /* vert */
  Do i=y1+1 to y2-1
    Call SysCurPos i,x1
    Call CharOut ,SubStr(typ,8,1)
    Call CharOut ,Copies(SubStr(typ,9,1),x2-x1-1)
    Call CharOut ,SubStr(typ,4,1)
  end;
return;
  
  /******************************************************************
   **     Horizontal line connected to the border
   **/
DrawHCLine: Procedure
  Parse Arg x1,x2,y,typ
  Call SysCurPos y,x1
  Call CharOut ,SubStr(typ,10,1)
  If x2-x1>1 Then Call CharOut ,Copies(SubStr(typ,2,1),x2-x1-1)
  If x2-x1>0 Then Call CharOut ,SubStr(typ,11,1)
return;
  
  /******************************************************************
   **     Vertical line connected to the border
   **/
DrawVCLine: Procedure
  Parse Arg y1,y2,x,typ
  
  Call SysCurPos y1,x
  Call CharOut ,SubStr(typ,12,1)
  Do i=y1+1 to y2-1
    Call SysCurPos i,x
    Call CharOut ,SubStr(typ,4,1)
  end;
  Call SysCurPos y2,x
  Call CharOut ,SubStr(typ,13,1)
return;
  
  /******************************************************************
   **     Write String @ x,y
   **/
StrXY: Procedure
  Parse Arg x,y,st
  Call SysCurPos y,x
  Call CharOut ,st
return;
  
  /******************************************************************
   **     Write String @ x,y, centered
   **/
StrXYCenter: Procedure
  Parse Arg x1,x2,y,st
  Call SysCurPos y,x1+( ( x2-x1-Length(st)+1 ) % 2 )
  Call CharOut ,st
return;
  
  /******************************************************************
   **     Setup Main Screen
   **/
SetupScreen:
  scry = 23
  Call DrawBorder 5,0,75,scry,styp
  st = 'MIDi Jukeboxx v'ProgVersion
  Call StrXYCenter 5,75,0,st
  st = '(C)Copyright Grin, 1995-96, Free for non-commercial use'
  Call StrXYCenter 5,75,scry,st
  
  diffy = 1
  Call DrawHCLine 5,75,diffy+1,styp
  Call StrXY 6,diffy,'Now Playing: INITIALISING'
  
  diffy = diffy+2
  Call DrawHCLine 5,75,diffy+1,styp
  
  diffy = diffy+1
  Call DrawHCLine 5,75,diffy+3,styp
  Call DrawVCLine diffy,diffy+3,8,styp
  Call StrXY 6,diffy+2,'0s'
  Call DrawVCLine diffy,diffy+3,60,styp
  Call DrawVCLine diffy,diffy+3,68,styp
  Call StrXY 61,diffy+2,'0000.0s'
  Call StrXY 69,diffy+2,'000.0%'
  Call StrXY 61,diffy+1,' total'
  Call StrXY 69,diffy+1,' pos'
  
  diffy = diffy+3
  Call DrawHCLine 5,75,diffy+3,styp
  Call DrawVCLine diffy,diffy+3,40,styp
  Call StrXYCenter 5,40,diffy+1,'Left volume'
  Call StrXYCenter 40,75,diffy+1,'Right volume'
  
  /* first row */
  butSize=10
  butInc = 13
  butX = 9
  butY = diffy+4
  Call ButtPutt  ButX,ButY,ButSize,styp,'[S]','stop'
  butX = butX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[V]','prev.'
  butX = butX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[P]','pause'
  PauseButX = ButX
  PauseButY = ButY
  PauseButSize = ButSize
  butX = butX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[ENTER]','next'
  butX = butX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[A]','again'
  
  /* second row */
  butSize = 9
  butInc = 11
  butX = 8
  butY = butY+4
  Call ButtPutt  ButX,ButY,ButSize,styp,'[1]','l.vol.up'
  VolButX = ButX
  VolButY = ButY
  VolButSize = ButSize
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[2]','l.vol.dn'
  VolBut2X = ButX
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[8]','vol.up'
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[9]','vol.dn'
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[3]','r.vol.up'
  VolBut3X = ButX
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[4]','r.vol.dn'
  VolBut4X = ButX
  
  /* third row */
  butSize = 9
  butInc = 11
  butX = 8
  butY = butY+4
  Call ButtPutt  ButX,ButY,ButSize,styp,'[','-1min'
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[<]','-30sec'
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[-]','-10sec'
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[+]','+10sec'
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,'[>]','+30sec'
  butX = ButX + ButInc
  Call ButtPutt  ButX,ButY,ButSize,styp,']','+1min'
  
return;
  
  /******************************************************************
   **     Put a nice butt :-)
   **/
ButtPutt: Procedure
  Parse Arg x,y,sx,styp,st1,st2
  sy = 3
  Call DrawBorder  x,y,x+sx,y+sy,styp
  Call StrXYCenter x,x+sx,y+1,st1
  Call StrXYCenter x,x+sx,y+2,st2
return;
  
  /******************************************************************
   **     Refreshing parts of the screen
   **/
ScrMidiName: Procedure
  Parse Arg st
  st = Left(st,56)
  Call StrXY 18,1,st
return;
  
ScrSeqNumber: Procedure Expose LastTotalsBar
  Parse Arg actualMid,totalMid,styp
  perc = 100 * actualMid / totalMid
  stlen = Length(totalMid)
  Call StrXY 6,3,Right(actualMid,stlen) 'of' totalMid
  Call DrawVCLine 2,4,6+stlen*2+5,styp
  LastTotalsBar = PutPercentBar(LastTotalsBar,perc,6+stlen*2+6,3,74,'',0)
return;
  
ScrTotalTime: Procedure
  Parse Arg totaltime
  st = Format(totaltime,4,1) || 's'
  Call StrXYCenter 61,67,6,st
return;
  
ScrPercent: Procedure Expose LastPercent
  Parse Arg actualsec,totalsec
  
  /* actual time */
  st = '   ' || Format(actualsec,,1) || 's   '
  Call StrXYCenter 9,59,5,st
  
  /* percent */
  If totalsec>0 Then 
    percent = 100 * actualsec / totalsec
  else 
    percent = 0
  st = Format(percent,3,1) || '%'
  Call StrXY 69,6,st
  
  LastPercent = PutPercentBar(LastPercent,percent,9,6,59,'',0)
  Call SysCurPos 24,79
return;
  
ScrVolumes: Procedure Expose LastLeftVol LastRightVol
  Parse Arg lvol, rvol
  /*Call StrXY 7,8,Right(lvol,3)
   Call StrXY 71,8,Right(rvol,3)*/
  lastLeftVol = PutPercentBar(LastLeftVol,lvol,6,9,39,'',1)
  lastRightVol = PutPercentBar(LastRightVol,rvol,41,9,74,'',0)
return;
  
  /******************************************************************
   **     Draw a percent bar
   **
   ** lastbar: the last length (in characters)
   ** perc   : percent value of the bar
   ** x1,y1  : start of the bar
   ** x2     : end of the bar (max,100%)
   ** fillchr: texture of the bar
   ** rightbar: if true, the bar goes from right to left
   **/
PutPercentBar: Procedure
  Parse Arg lastbar,perc,x1,y1,x2,fillchr,rightbar
  xs = x2-x1+1
  newPos = perc % (100 / xs)
  If newPos \= lastbar Then Do
    If \rightbar Then 
      Call StrXY x1,y1,Left(Copies(fillchr,newPos),xs)
    else
      Call StrXY x1,y1,Right(Copies(fillchr,newPos),xs)
    return newPos;
  end;
return lastbar;

/******************************************************************
 **     Parse name on commandline
 **
 ** the problem is about the quoted filenames containing space
 ** PARSE will parse them separately what is bad for me. :(
 **/
ParseNextName:
  parse var pattern param.1 param.2
  
  /* if it doesn't contain quotes then it's all right */
  If Pos('"',param.1) = 0 Then Do
    pattern = param.1
    restPattern = param.2
    drop param.
    return
  end
  
  /* quote status. when we have an open quote it equals 1 */
  flipflop = 0
  param.0 = ''
  
  do ForEver
    inpos = 1
    /* count quotes in first word */
    do while pos('"',param.1,inpos)>0
      inpos = pos('"',param.1,inpos)
      /* del quote */
      param.1 = DelStr(param.1,inpos,1)
      flipflop = 1-flipflop
    end
    
    /* if we have even number of quotes it's finished */
    if \flipflop then do
      pattern = param.0 || param.1
      restPattern = param.2
      drop param.
      return
    end
    
    /* ..and if not we look after the closing quote in next words */
    param.0 = param.0 || param.1 || ' '
    If param.2 == '' then do
      say "Ehm... non matched quote!!"
      pattern = param.0
      restPattern = param.2
      drop param.
      return
    end
      
    parse var param.2 param.1 param.2
  end
    

/**************************************************************
 * lic
 */
License:
  SAY
  SAY versionStr
  /* Read license text from top of command file */
  CALL LINEIN commandPath, 1, 0
  DO  3; CALL LINEIN commandPath;                     END
  DO 19; CALL LINEOUT, SUBSTR(LINEIN(commandPath),4); END
  EXIT
