/*****************************************************************************
  GENCLDOC.CPP

  Purpose:
  
    In this application, it is the document that is automated.  The document
	implements all of the dispatch interfaces and overrides various CDocument
	functions.

  Functions:

  	CGenClientDoc::OnNewDocument      
	Initializes the document, starts the Generat server, and passes 
	our IDispatch pointer to the server.

	CGenClientDoc::OnCloseDocument    
	Requests that the server Release our IDispatch pointer.

	CGenClientDoc::SetAnimateUI       
	Called by server to toggle flag which controls the Animate Color menu
	choice.

	CGenClientDoc::NotifyColorChange  
	Called by server when the server has generated a new color.

  Development Team: Robert Duke

  Written by Microsoft Product Support Services, Languages Developer Support
  Copyright (c) 1993 Microsoft Corporation. All rights reserved.
\****************************************************************************/

#include "stdafx.h"
#include "GenClnt.h"

#include "GenDisp.h"
#include "GenCldoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGenClientDoc

IMPLEMENT_DYNCREATE(CGenClientDoc, CDocument)

BEGIN_MESSAGE_MAP(CGenClientDoc, CDocument)
	//{{AFX_MSG_MAP(CGenClientDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CGenClientDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CGenClientDoc)
	DISP_FUNCTION(CGenClientDoc, "SetAnimateUI", SetAnimateUI, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CGenClientDoc, "NotifyColorChange", NotifyColorChange, VT_EMPTY, VTS_VARIANT)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGenClientDoc construction/destruction

CGenClientDoc::CGenClientDoc()
{
	// TODO: add one-time construction code here

	EnableAutomation();

	AfxOleLockApp();
}

CGenClientDoc::~CGenClientDoc()
{
	AfxOleUnlockApp();
}

/************************************************************************
  CGenClientDoc::OnNewDocument

  Purpose:

    Initializes the document, starts the Generat server, and passes the
	our IDispatch pointer to the server.

  Parameters: None

  Returns: 
  
    BOOL

  Comments:    

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGenClientDoc::OnNewDocument()
{
	COleException exceptionDispGen;

	if (!CDocument::OnNewDocument())
		return FALSE;

	// this starts the server
	if(0 == m_GeneratorDispatch.CreateDispatch("Generator.Document", &exceptionDispGen))
		TRACE("CreateDispatch failed in CGenClientDoc::OnNewDocument\n");

	// no need to AddRef the server will alway be in the context
	// of the client
	LPDISPATCH pDispInterface = GetIDispatch(FALSE);
	ASSERT(NULL != pDispInterface);

	// pass our dispatch to the server
	if(!m_GeneratorDispatch.SetAdviseDI(pDispInterface))		
		return FALSE;

	m_dwColor = RGB(255,255,255);  
	m_bAnimate = FALSE;
													   
	return TRUE;									   
}

/************************************************************************
  CGenClientDoc::OnCloseDocument

  Purpose:

    Requests that the server Release our IDispatch pointer.

  Parameters: None

  Returns: void

  Comments:  

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGenClientDoc::OnCloseDocument() 
{
	// call into the server and release the dispatch that we send
	// it in OnNewDocument()

	m_GeneratorDispatch.ReleaseAdviseDI();
	
	CDocument::OnCloseDocument();
}

/////////////////////////////////////////////////////////////////////////////
// CGenClientDoc serialization

void CGenClientDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CGenClientDoc diagnostics

#ifdef _DEBUG
void CGenClientDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CGenClientDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGenClientDoc commands


/////////////////////////////////////////////////////////////////////////////
// CGenClientDoc methods

/************************************************************************
  CGenClientDoc::SetAnimateUI

  Purpose:

    Called by server to toggle flag which controls the Animate Color menu
	choice.

  Parameters: None

  Returns: void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGenClientDoc::SetAnimateUI() 
{
	// this will get called by the server when its animation state 
	// is toggled via the servers menu

	m_bAnimate = !m_bAnimate;
}

/************************************************************************
  CGenClientDoc::NotifyColorChange

  Purpose:

    Called by server when the server has generated a new color.

  Parameters: 
  
    refColor is a reference to a variant that contains a SafeArray.
	The SafeArray is an array of three short integers which represent
	an RGB value.

  Returns: void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGenClientDoc::NotifyColorChange(const VARIANT FAR& refColor) 
{
	// unpack the color from the variant that we have been passed a 
	// pointer to - we cannot hold on to this pointer after we use it	 

 	short	tempArray[3];
	long	lIndex;

	for(lIndex = 0; lIndex < 3; lIndex++)
	{
	 	if(FAILED(SafeArrayGetElement(refColor.parray, &lIndex, &tempArray[lIndex])))
			TRACE("SafeArrayGetElement failed in CGenClientDoc::NotifyColorChange\n"); 
	}

	m_dwColor = RGB(tempArray[0], tempArray[1], tempArray[2]);

	UpdateAllViews(NULL);
}
										   
										   
										   
										   
