/*****************************************************************************
  GENCLDOC.H

  Contains the declaration of the CGenClientDoc document class.

  Classes Declared:

    CGenClientDoc
  
  Development Team: Robert Duke

  Written by Microsoft Product Support Services, Languages Developer Support
  Copyright (c) 1993 Microsoft Corporation. All rights reserved.
\****************************************************************************/

class CGenClientDoc : public CDocument
{
protected: // create from serialization only
	CGenClientDoc();
	DECLARE_DYNCREATE(CGenClientDoc)

// Attributes
public:
	IGenera m_GeneratorDispatch;

	COLORREF m_dwColor;	 // we generate this either via our GenColor 
						 // method or directly via CGeneratorView::OnGenColor(); 

	BOOL m_bAnimate;  // TRUE if we want to animate the colors

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGenClientDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void OnCloseDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CGenClientDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
private:
	//{{AFX_MSG(CGenClientDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CGenClientDoc)
	afx_msg void SetAnimateUI();
	afx_msg void NotifyColorChange(const VARIANT FAR& refColor);
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
};

/////////////////////////////////////////////////////////////////////////////
