/*****************************************************************************
  GENCLVW.CPP

  Purpose:
  
    Handles the drawing and UI for the view.

  Functions:

  	CGenClientView::OnDraw                                  
	Paint a message refecting what the RGB value of the color.

	CGenClientView::OnEraseBkgnd                            
	Paints the background of the view the color of the RGB value contained
	in the document.

	CGenClientView::OnGeneratorGencolor                     
	Request that the generat server gererate a new color.

	CGenClientView::OnUpdateGeneratorGencolor               
	This menu choice will not be available if color is being animated.

	CGenClientView::OnUpdateGeneratorAnimatecolor           
	Request that the Generat server animate color generation.

	CGenClientView::OnGeneratorAnimatecolor                 
	Check on or off the Animate Colors menu choice.


  Development Team: Robert Duke

  Written by Microsoft Product Support Services, Languages Developer Support
  Copyright (c) 1993 Microsoft Corporation. All rights reserved.
\****************************************************************************/

#include "stdafx.h"
#include "GenClnt.h"

#include "GenDisp.h"
#include "GenCldoc.h"
#include "GenClvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGenClientView

IMPLEMENT_DYNCREATE(CGenClientView, CView)

BEGIN_MESSAGE_MAP(CGenClientView, CView)
	//{{AFX_MSG_MAP(CGenClientView)
	ON_COMMAND(ID_GENERATOR_GENCOLOR, OnGeneratorGencolor)
	ON_UPDATE_COMMAND_UI(ID_GENERATOR_GENCOLOR, OnUpdateGeneratorGencolor)
	ON_COMMAND(ID_GENERATOR_ANIMATECOLOR, OnGeneratorAnimatecolor)
	ON_UPDATE_COMMAND_UI(ID_GENERATOR_ANIMATECOLOR, OnUpdateGeneratorAnimatecolor)
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGenClientView construction/destruction

CGenClientView::CGenClientView()
{
	// TODO: add construction code here

}

CGenClientView::~CGenClientView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CGenClientView drawing

/************************************************************************
  CGenClientView::OnDraw

  Purpose:

    Paint a message refecting what the RGB value of the color.

  Parameters: 
  
    pDC points to the device context to be used for rendering an 
    image of the document.

  Returns: void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGenClientView::OnDraw(CDC* pDC)
{
	CGenClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CString strMessage;
	strMessage.Format( "Red = %d, Green = %d, Blue = %d",
						GetRValue(pDoc->m_dwColor), 
						GetGValue(pDoc->m_dwColor), 
						GetBValue(pDoc->m_dwColor));

	pDC->TextOut(10, 10, strMessage);
}

/************************************************************************
  CGenClientView::OnEraseBkgnd

  Purpose:

    Paints the background of the view the color of the RGB value 
    contained in the document.

  Parameters: 
  
    pDC specifies the device-context object.

  Returns: 
  
    TRUE if it erases the background; otherwise FALSE.

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGenClientView::OnEraseBkgnd(CDC* pDC) 
{
	CGenClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// Set brush to desired background color
	CBrush backBrush(pDoc->m_dwColor);

	// Save old brush
	CBrush* pOldBrush = pDC->SelectObject(&backBrush);

	CRect rect;
	pDC->GetClipBox(&rect);     // Erase the area needed

	pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(),
	  PATCOPY);
	pDC->SelectObject(pOldBrush);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CGenClientView diagnostics

#ifdef _DEBUG
void CGenClientView::AssertValid() const
{														   
	CView::AssertValid();								   
}

void CGenClientView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CGenClientDoc* CGenClientView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGenClientDoc)));
	return (CGenClientDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGenClientView message handlers

/************************************************************************
  CGenClientView::OnGeneratorGencolor

  Purpose:
             
	Request that the generat server gererate a new color.

  Parameters: None

  Returns: void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGenClientView::OnGeneratorGencolor() 
{
	CGenClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// the server will generate a color and notify us of a color change
	pDoc->m_GeneratorDispatch.GenNewColor();
}

/************************************************************************
  CGenClientView::OnUpdateGeneratorGencolor

  Purpose:
             
	This menu choice will not be available if color is being animated.

  Parameters: 
  
    pCmdUI points to a CCmdUI object to be used to update the menu.

  Returns: void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGenClientView::OnUpdateGeneratorGencolor(CCmdUI* pCmdUI) 
{
	CGenClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// gray menu chioce if animation is enabled		   
	pCmdUI->Enable(!pDoc->m_bAnimate);				   
}													   

/************************************************************************
  CGenClientView::OnGeneratorAnimatecolor

  Purpose:

	Request that the Generat server animate color generation.

  Parameters: None

  Returns: void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/
													   
void CGenClientView::OnGeneratorAnimatecolor() 		   
{
	CGenClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);	
	
	//toggle our animation flag to control our menu choice
	pDoc->m_bAnimate = !pDoc->m_bAnimate;

	// set animation flag in server
	// server will return false if it couldn't generate a timer
	if(FALSE == pDoc->m_GeneratorDispatch.AnimateColors())
	{
		MessageBox("Server unable to automate colors.", "Server Error");	
		pDoc->m_bAnimate = FALSE;
	}
}

/************************************************************************
  CGenClientView::OnUpdateGeneratorAnimatecolor

  Purpose:
        
	Check on or off the Animate Colors menu choice.

  Parameters: 
  
    pCmdUI points to a CCmdUI object to be used to update the menu.

  Returns: void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGenClientView::OnUpdateGeneratorAnimatecolor(CCmdUI* pCmdUI) 
{
	CGenClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);	

	pCmdUI->SetCheck(pDoc->m_bAnimate);	
}


				 
				 
				 
				 
				 
				 
