/*****************************************************************************
  GENERAT.CPP

  Purpose:
  
    Provides the implementation of the CGeneratorApp class, handles the 
    registration of the application as a local server, handles the UI behavior
    of the application in that the server will always be visible, and makes 
    sure that the application can not be shut down if it is serving a client.

    Contians the implementation of COleVisibleTemplateServer which is 
    necessary with the way that I have chosen to make the application 
    visible at all times.

    Contains the implementation for the default CAboutDlg box.

  Functions:

    COleVisibleTemplateServer::OnCreateObject
    Handles creation of the document object.

	CGeneratorApp::InitInstance
	Initializes the application

	CGeneratorApp::CanCloseApp
	Prevents the server from closing if any of it's objects were created
	by a client.

  Development Team: Robert Duke

  Written by Microsoft Product Support Services, Languages Developer Support
  Copyright (c) 1993 Microsoft Corporation. All rights reserved.
\****************************************************************************/

#include "stdafx.h"
#include "Generat.h"

#include "mainfrm.h"
#include "ClntDisp.h"

#include "Generdoc.h"
#include "Genervw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/************************************************************************
  COleVisibleTemplateServer::OnCreateObject

  Purpose:

    Override of the base class creates the document as visible and
    does not mark the document as dirty.

  Parameters: None

  Returns:

    A pointer to the created object. It can throw a memory exception if 
    it fails. 

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

CCmdTarget* COleVisibleTemplateServer::OnCreateObject()
{
	ASSERT_VALID(this);
	ASSERT_VALID(m_pDocTemplate);

	// save application user control status
	BOOL bUserCtrl = AfxOleGetUserCtrl();

//	// create invisible doc/view/frame set
//	CDocument* pDoc = m_pDocTemplate->OpenDocumentFile(NULL, FALSE);

// we are going to make the doc/view/frame set visible
	CDocument* pDoc = m_pDocTemplate->OpenDocumentFile(NULL, TRUE);

	// restore application's user control status
	AfxOleSetUserCtrl(bUserCtrl);

	if (pDoc != NULL)
	{
		ASSERT_VALID(pDoc);
		ASSERT(pDoc->IsKindOf(RUNTIME_CLASS(CDocument)));

// we are not supporting persistent objects

		// all new documents created by OLE start out modified		
		// pDoc->SetModifiedFlag();		
	}
	return pDoc;
}

/////////////////////////////////////////////////////////////////////////////
// CGeneratorApp

BEGIN_MESSAGE_MAP(CGeneratorApp, CWinApp)
	//{{AFX_MSG_MAP(CGeneratorApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGeneratorApp construction

CGeneratorApp::CGeneratorApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CGeneratorApp object

CGeneratorApp theApp;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.
static const CLSID BASED_CODE clsid =
{ 0x773b3320, 0xc078, 0x11ce, { 0xbd, 0x4e, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

/************************************************************************
  CGeneratorApp::InitInstance

  Purpose:

    Standard initilization for an Ole Automation Server with the  
    exception that the ShowWindow and UpdateWindow functions are called
    from the (RunEmbedded() || RunAutomated()) check.  This results in 
    the server being visible.

  Parameters: None

  Returns:

    BOOL - TRUE if initialization was successful, FALSE if it was not. 

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGeneratorApp::InitInstance()
{
#ifdef _DEBUG
	afxMemDF |= checkAlwaysMemDF;
#endif

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	Enable3dControls();

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_GENERATYPE,
		RUNTIME_CLASS(CGeneratorDoc),
		RUNTIME_CLASS(CMDIChildWnd),          // standard MDI child frame
		RUNTIME_CLASS(CGeneratorView));
	AddDocTemplate(pDocTemplate);

	// Connect the COleTemplateServer to the document template.
	//  The COleTemplateServer creates new documents on behalf
	//  of requesting OLE containers by using information
	//  specified in the document template.
	m_server.ConnectTemplate(clsid, pDocTemplate, FALSE);

	// Register all OLE server factories as running.  This enables the
	//  OLE libraries to create objects from other applications.
	COleTemplateServer::RegisterAll();
		// Note: MDI applications register all server objects without regard
		//  to the /Embedding or /Automation on the command line.

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse the command line to see if launched as OLE server
	if (RunEmbedded() || RunAutomated())
	{
		// We are going to show this server so that it's data can be 
		// manipulated via the user interface of the sever or via 
		// automation
		pMainFrame->ShowWindow(m_nCmdShow);     
		pMainFrame->UpdateWindow();

		return TRUE;
	}

	// When a server application is launched stand-alone, it is a good idea
	//  to update the system registry in case it has been damaged.
	m_server.UpdateRegistry(OAT_DISPATCH_OBJECT);
	COleObjectFactory::UpdateRegistryAll();

	// create a new (empty) document
	OnFileNew();

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CGeneratorApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CGeneratorApp commands


/************************************************************************
  CGeneratorApp::CanCloseApp

  Purpose:

    Called in response to the user selecting File Exit or Close from the 
    system menu.  If it is detected that any documents were started by by 
    a client, the app will not be terminated.

  Parameters: None

  Returns:

    BOOL - TRUE if it is OK for the application to terminate otherwise
	FALSE.

  Comments:

    Called by CMainFrame::OnClose.

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGeneratorApp::CanCloseApp()
{
	// cycle through the templates
	POSITION pos = AfxGetApp()->m_templateList.GetHeadPosition();
	while (pos != NULL)
	{
		CDocTemplate* pTemplate = (CDocTemplate*)AfxGetApp()->m_templateList.GetNext(pos);
		ASSERT(pTemplate->IsKindOf(RUNTIME_CLASS(CDocTemplate)));
		
		// cycle through the docs
		POSITION pos = pTemplate->GetFirstDocPosition();
		while (pos != NULL)
		{
			// if the doc has a valid COleDispatch pointer, the doc is of a client
			CGeneratorDoc* pDoc = (CGeneratorDoc*)pTemplate->GetNextDoc(pos);		
			if(NULL != pDoc->m_ClientDisp.m_lpDispatch)
			{
				AfxGetMainWnd()->MessageBox("Application is serving a client", 
				        "Can't exit application");
				return FALSE;
			}
		}
	}

	// no documents being served - ok to close app
	return TRUE;
}

