/*****************************************************************************
  GENERDOC.CPP

  Purpose:
  
    In this application, it is the document that is automated.  The document
	implements all of the dispatch interfaces and implements various helper 
	functions.

  Functions:

    CGeneratorDoc::CGeneratorDoc
    Initializes member variables.

	CGeneratorDoc::~CGeneratorDoc
	Verifys that the client has asked the server to release it's IDispatch
	interface.

	CGeneratorDoc::OnNewDocument
	Seeds the random number generator.

	CGeneratorDoc::CanCloseFrame
	Stops the user from closing a document that is serving a client.

	CGeneratorDoc::SetAdviseDI           
	Called by the client to pass it's IDispatch interface to the server.

	CGeneratorDoc::ReleaseAdviseDI       
	Called by the client ask the server to release the clients IDispatch
	interface.

	CGeneratorDoc::AnimateColors  
	Sets or un-sets a flag that will cause WM_TIMER messages in the view
	to generate a new color.

	CGeneratorDoc::GenNewColor    
	Causes a new random color to be generated.

	CGeneratorDoc::MakeRandColor         
	Generates a random color.  The random color is a member variable of the
	CGeneratorDoc class.

	CGeneratorDoc::DoNotifyColorChange   
	Called to notify clients that a new color has been generated.

  Development Team: Robert Duke

  Written by Microsoft Product Support Services, Languages Developer Support
  Copyright (c) 1993 Microsoft Corporation. All rights reserved.
\****************************************************************************/

#include "stdafx.h"
#include "Generat.h"

#include "ClntDisp.h"

#include "Generdoc.h"
#include "Genervw.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGeneratorDoc

IMPLEMENT_DYNCREATE(CGeneratorDoc, CDocument)

BEGIN_MESSAGE_MAP(CGeneratorDoc, CDocument)
	//{{AFX_MSG_MAP(CGeneratorDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CGeneratorDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CGeneratorDoc)
	DISP_FUNCTION(CGeneratorDoc, "SetAdviseDI", SetAdviseDI, VT_BOOL, VTS_DISPATCH)
	DISP_FUNCTION(CGeneratorDoc, "ReleaseAdviseDI", ReleaseAdviseDI, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CGeneratorDoc, "AnimateColors", AnimateColors, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CGeneratorDoc, "GenNewColor", GenNewColor, VT_EMPTY, VTS_NONE)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

/************************************************************************
  CGeneratorDoc::CGeneratorDoc

  Purpose:

    CGeneratorDoc construction

  Parameters: None

  Returns: void

  Comments:

    Nothing tricy here

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

CGeneratorDoc::CGeneratorDoc()
{
	m_dwColor = RGB(255,255,255);  
	m_bCanAnimate = FALSE;
	m_bAnimate = FALSE;

	EnableAutomation();
	AfxOleLockApp();
}

/************************************************************************
  CGeneratorDoc::~CGeneratorDoc

  Purpose:

    CGeneratorDoc destruction.

  Parameters: None

  Returns: void

  Comments:

    Will warn the programmer that she is not releasing the IDispatch
	interface of the client

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

CGeneratorDoc::~CGeneratorDoc()
{	
	if(NULL != m_ClientDisp.m_lpDispatch)
		TRACE("Client not calling ReleaseAdviseDI\n");

	AfxOleUnlockApp();
}

/************************************************************************
  CGeneratorDoc::OnNewDocument

  Purpose:

    Initialize the document and seed the random nember generator.

  Parameters: None

  Returns: 
  
    TRUE if the document was successfully initialized; otherwise FALSE.

  Comments:

    Will warn the programmer if she is not releasing the IDispatch
	interface of the client.

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGeneratorDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// Seed the random-number generator with current time so that
	// the color sequence will be different every time we run.
		
	srand( (unsigned)time(NULL) );

	return TRUE;
}

/************************************************************************
  CGeneratorDoc::CanCloseFrame

  Purpose:

    Will not allow the user to close a document that is serving a
    client.

  Parameters: 

    pFrame    Points to the frame window of a view attached to the 
    document.

  Returns: 
  
    TRUE if the document can be closed; otherwise FALSE.

  Comments:

    This is an override and we have trashed the default behavior
    because it is not relevant in this situation.

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGeneratorDoc::CanCloseFrame(CFrameWnd* pFrame) 
{
	// we can't close this frame if it is serving a client
	if(NULL != m_ClientDisp.m_lpDispatch)
	{
		AfxGetMainWnd()->MessageBox("Document is serving a client", "Can't close frame");
		return FALSE;
	}

	return CDocument::CanCloseFrame(pFrame);
}


/////////////////////////////////////////////////////////////////////////////
// CGeneratorDoc serialization

void CGeneratorDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CGeneratorDoc diagnostics

#ifdef _DEBUG
void CGeneratorDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CGeneratorDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGeneratorDoc methods

/************************************************************************
  CGeneratorDoc::SetAdviseDI

  Purpose:

    Allows the client to pass it's IDispatch interface to the server.

  Parameters: 

    lpDispAdvise points to the dispatch interface of the client 
    application.

  Returns: 
  
    TRUE if successful; otherwise FALSE.

  Comments:

    It necessary to AddRef the IDispatch pointer here so that the 
	RPC proxy and STUB objects remain valid.  Reference Q133042.

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGeneratorDoc::SetAdviseDI(LPDISPATCH lpDispAdvise) 
{
	if(lpDispAdvise == NULL)
	{
		TRACE("SetAdviseDI called with NULL parameter\n");	
		return FALSE;
	}
	else
	{
		// We need to AddRef the pointer sent to us so that
		// the proxy and stub that are set up for RPC are not 
		// destroyed

		// ref article by mikecl
		
		lpDispAdvise->AddRef();

		m_ClientDisp.AttachDispatch(lpDispAdvise, TRUE);
		ASSERT(NULL != m_ClientDisp.m_lpDispatch);

		return TRUE;
	}					 
}						 

/************************************************************************
  CGeneratorDoc::ReleaseAdviseDI

  Purpose:

    Allows the client request that the server release it's IDispatch
    interface.  This is a polite way to terminate comunication from the 
	server to the client.

  Parameters:  None

  Returns: 	void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGeneratorDoc::ReleaseAdviseDI() 
{	
	m_ClientDisp.ReleaseDispatch();
	ASSERT(NULL == m_ClientDisp.m_lpDispatch);
}

/************************************************************************
  CGeneratorDoc::AnimateColors

  Purpose:

    Allows the client toggle the documents amimate flag.  The result of
    doing so will be for WM_TIMER messages in the view to case new 
    colors to be generated.

  Parameters:  None

  Returns: 	
  
    TRUE if animation is possible - FALSE if not (a timer generation 
	in the view may have failed)

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

BOOL CGeneratorDoc::AnimateColors() 
{
	if(!m_bCanAnimate)
		return FALSE;
	else
		m_bAnimate = !m_bAnimate;
	
	return TRUE;								  
}												  

/************************************************************************
  CGeneratorDoc::GenNewColor

  Purpose:

    Generates a new color, updates the servers view, and notifies the
	client that a new color has been generated.

  Parameters:  None

  Returns: 	void

  Comments:

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGeneratorDoc::GenNewColor() 
{
	MakeRandColor();

	// update the view
	UpdateAllViews(NULL);

	DoNotifyColorChange();
}

/////////////////////////////////////////////////////////////////////////////
// CGeneratorDoc helper functions

/************************************************************************
  CGeneratorDoc::GenNewColor

  Purpose:

    Generates a random color.

  Parameters:  None

  Returns: 	void

  Comments:

    I would really have liked to do something amazing like the fire
	sample but OH WELL.  May be next time.  

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGeneratorDoc::MakeRandColor()
{
	div_t div_result;							   
	int nRed, nGreen, nBlue;					   
												  
	div_result = div(rand(), 255);
	nRed = div_result.rem;

	div_result = div(rand(), 255);
	nGreen = div_result.rem;

	div_result = div(rand(), 255);					
	nBlue = div_result.rem;							
													
	m_dwColor = RGB(nRed, nGreen, nBlue);			
}

/************************************************************************
  CGeneratorDoc::DoNotifyColorChange

  Purpose:

    Notifys the client that a new color has been generated.

  Parameters:  None

  Returns: 	void

  Comments:

    A SafeArray was not really necessary here but for the sake of 
    illustration, I used one.

  History:

  Date     Comment                                           Initials
  ======== ================================================= ========
  10/10/95 Created                                             RED
\***********************************************************************/

void CGeneratorDoc::DoNotifyColorChange()
{	
	VARIANT 		vaArray;			// to hold safearray
	SAFEARRAY FAR*	pSafeArray;			// descriptor
	SAFEARRAYBOUND	rgSABound[1];		// one dimention
	LONG			lIndex;
 	short 			tempArray[3];	

	// init the safe array bound - one SAFEARRAYBOUND per dimention
	rgSABound[0].lLbound = 0;	 // zero indexed array
	rgSABound[0].cElements = 3;	 // three elements

	// create the safearray
	pSafeArray = SafeArrayCreate(VT_I2, 1, rgSABound);
	if(NULL == pSafeArray)
	{
		TRACE("SafeArrayCreate failed in CGeneratorDoc::DoNotifyColorChange\n");
		return;
	}

	// fill it 
	tempArray[0] = GetRValue(m_dwColor);
	tempArray[1] = GetGValue(m_dwColor);
	tempArray[2] = GetBValue(m_dwColor);
	
	for(lIndex = 0; lIndex < 3; lIndex++)
	{
		if(FAILED(SafeArrayPutElement(pSafeArray, &lIndex, &tempArray[lIndex])))
			TRACE("SafeArrayPutElement failed in CGeneratorDoc::DoNotifyColorChange\n");
	}

	VariantInit(&vaArray);
	V_VT(&vaArray) = VT_ARRAY | VT_I2;
	V_ARRAY(&vaArray) = pSafeArray;
	
	//call the dispatch
	m_ClientDisp.NotifyColorChange(vaArray);


	if(FAILED(SafeArrayDestroy(pSafeArray)))
	 	TRACE("SafeArrayDestroy failed in CGeneratorDoc::DoNotifyColorChange\n");
}


