/*****************************************************************************
  GENERDOC.H

  Contains the declaration of the CGeneratorDoc document class.

  Classes Declared:

    CGeneratorDoc
  
  Development Team: Robert Duke

  Written by Microsoft Product Support Services, Languages Developer Support
  Copyright (c) 1993 Microsoft Corporation. All rights reserved.
\****************************************************************************/

class CGeneratorDoc : public CDocument
{
protected: // create from serialization only
	CGeneratorDoc();
	DECLARE_DYNCREATE(CGeneratorDoc)

// Attributes
public:
	COLORREF m_dwColor;	 // we generate this either via our GenColor 
						 // method or directly via CGeneratorView::OnGenColor(); 
						   	   
	IGenCli m_ClientDisp;  // We will attach this COleDispatchDriver to the 
							  // dispatch pointer passed to us by the client.  
							  // We use this to  notify the client of changes 
							  // to our data.

	BOOL m_bAnimate;		// TRUE if we want to animate the colors
	BOOL m_bCanAnimate;		// did we get a timer?

// Operations
public:
	void MakeRandColor();
	void DoNotifyColorChange();
	
// Overrides

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGeneratorDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL CanCloseFrame(CFrameWnd* pFrame);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CGeneratorDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
private:
	//{{AFX_MSG(CGeneratorDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CGeneratorDoc)
	afx_msg BOOL SetAdviseDI(LPDISPATCH DispIToAdvise);
	afx_msg void ReleaseAdviseDI();
	afx_msg BOOL AnimateColors();
	afx_msg void GenNewColor();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
};

/////////////////////////////////////////////////////////////////////////////
