$! BUILD.COM
$!    Creates Ftnchek from source code for VMS systems
$!
$ On Control_Y Then GoTo The_Exit
$ On Warning Then GoTo The_Exit
$!
$!	First, create the right environment for compilation.
$ IF F$SEARCH("vaxc.opt") .EQS. ""
$ THEN!	Create option file for shareable image: makes executable smaller
$ COPY SYS$INPUT vaxc.opt
sys$library:vaxcrtl/share
$ ENDIF
$ DEFINE lnk$library sys$library:vaxcrtl	! simplest runtime library
$!
$!   Now compile everything and link it all.  The /DEFINE is not actually
$!   needed since VMS is a predefined symbol in VAX C.
$!   If you have xmalloc/xrealloc, remove the /DEFINE from shell_mung
$!   line and add them to the list of objs to link.
$ Set Verify
$ CC/DEFINE=(VMS,LARGE_MACHINE) ftnchek
$ CC/DEFINE=(VMS,LARGE_MACHINE) forlex
$ CC/DEFINE=(VMS,LARGE_MACHINE) fortran
$ CC/DEFINE=(VMS,LARGE_MACHINE) pgsymtab
$ CC/DEFINE=(VMS,LARGE_MACHINE) plsymtab
$ CC/DEFINE=(VMS,LARGE_MACHINE) symtab
$ CC/DEFINE=(VMS,LARGE_MACHINE) exprtype
$ CC/DEFINE=(VMS,LARGE_MACHINE) project
$ CC/DEFINE=("xmalloc=malloc","xrealloc=realloc") shell_mung
$ LINK ftnchek,forlex,fortran,pgsymtab,plsymtab,symtab,exprtype,project,-
	shell_mung,vaxc/opt
$ Set NoVerify
$ WRITE SYS$OUTPUT "Ftnchek created"
$ WRITE SYS$OUTPUT "To make it runnable as a command"
$ WRITE SYS$OUTPUT "say   $ FTNCHEK :== $diskname:[pathname]FTNCHEK"
$ On Control_Y Then GoTo Help_Exit
$ On Warning Then GoTo Help_Exit
$! Create the help library.
$ LIBR/CREATE/HELP FTNCHEK.HLB FTNCHEK.HLP
$ WRITE SYS$OUTPUT "Help library created -- to access it via HELP"
$ WRITE SYS$OUTPUT "say   $ DEFINE HLP$LIBRARY diskname:[pathname]FTNCHEK.HLB"
$ EXIT
$ Help_Exit:
$ Set NoVerify
$ WRITE SYS$OUTPUT "Error- help library not created"
$ EXIT
$ The_Exit:
$ Set NoVerify
$ WRITE SYS$OUTPUT "Error- BUILD failed."
