.TH "FTNCHEK 2.7" 1L "August 1993"
.\"======================================================================
.SH "NAME"
ftnchek \- Fortran program checker
.SH "SYNOPSIS"
.B ftnchek
[
.BI \-arguments= num
]
[
.BI \-array= num
]
[
.B \-[no]calltree
]
.if n .ti +5
[
.BI \-columns= num
]
.if t .ti +.5i
[
.BI \-common= num
]
[
.BI \-[no]crossref
]
.if n .ti +5
[
.B \-[no]declare
]
[
.B \-[no]division
]
.if t .ti +.5i
[
.B \-[no]extern
]
.if n .ti +5
[
.B \-[no]f77
]
[
.B \-[no]help
]
[
.B \-[no]hollerith
]
.if n .ti +5
[
.BI \-include= str
]
.if t .ti +.5i
[
.B \-[no]library
]
[
.B \-[no]list
]
.if n .ti +5
[
.BI \-[no]novice
]
[
.BI \-output= str
]
[
.B \-[no]portability
]
.if n .ti +5
.if t .ti +.5i
[
.B \-[no]pretty
]
[
.B \-[no]project
]
[
.B \-[no]pure
]
.if n .ti +5
[
.B \-[no]reference
]
[
.B \-[no]sixchar
]
.if t .ti +.5i
[
.B \-[no]sort
]
.if n .ti +5
[
.B \-[no]symtab
]
[
.B \-[no]truncation
]
[
.BI \-usage= num
]
.if n .ti +5
.if t .ti +.5i
[
.B \-[no]verbose
]
[
.B \-[no]volatile
]
[
.BI \-wordsize= num
]
.if n .ti +5
[
.BI \-wrap= num
]
[
.I files ...
]
.if t .ti +.5i
.SH "INTRODUCTION"
.PP
\fBftnchek\fP (short for Fortran checker)
is designed to detect certain errors in a
Fortran program that a compiler usually does not.
\fBftnchek\fP is not primarily
intended to detect syntax errors.  Its purpose is to assist the user in finding
semantic errors.  Semantic errors are legal in the Fortran language but are
wasteful or may cause incorrect operation.  For example, variables which are
never used may indicate some omission in the program; uninitialized variables
contain garbage which may cause incorrect results to be calculated; and
variables which are not declared may not have the intended type.
\fBftnchek\fP is
intended to assist users in the debugging of their Fortran program.  It is not
intended to catch all syntax errors.  This is the function of the compiler.
Prior to using \fBftnchek\fP,
the user should verify that the program compiles
correctly.
.PP
This document first summarizes how to invoke \fBftnchek\fP.
That section should be read before beginning to use \fBftnchek\fP.
Later sections describe \fBftnchek\fP's
options in more detail, give an example of its use, and explain
how to interpret the output.  The final sections mention the limitations
and known bugs in
\fBftnchek\fP.
.SH "INVOKING FTNCHEK"
\fBftnchek\fP is
invoked through a command of the form:
.sp 1
.ce 1
\fC$ ftnchek [-option -option ...] filename [filename ...]\fP
.PP
The brackets indicate something which is optional.  The brackets
themselves are not actually typed.  Here options are command-line
switches or settings, which control the operation of the program and the
amount of information that will be printed out.  If no option is
specified, the default action is to print error messages, warnings,
and informational messages, but not the program listing or symbol tables.
.PP
Each option begins with
the '\-'
character.
(On VAX/VMS or MS-DOS systems you may use either '/'
or '\-'.)
The options are described at greater length in the next section.
.PP
\fBftnchek\fP options fall into two categories: switches, which are either
true or false, and settings, which have a numeric or string value.  The
name of a switch is prefixed by 'no' to turn it off:
e.g. \fB\-nopure\fP
would turn off the warnings about impure functions. The 'no' prefix
can also be used with numeric settings, having the effect of turning
off the corresponding warnings.
Only the first 3
characters of an option name (not counting
the '\-')
need be provided.
.PP
The switches and settings which \fBftnchek\fP currently recognizes are:
.TP
.BI \-arguments= n
Set level of strictness in checking subprogram
arguments.  Min is 0 (no checking).  Max is 3 (most checking).
Default = 3.
.TP
.BI \-array= n
Set level of strictness in checking array arguments of
subprograms.  Min is 0 (least strict).  Max is 3 (most strict).
Default = 3.
.TP
.B \-calltree
Print tree of subprogram call hierarchy.  Default = no.
.TP
.BI \-columns= n
Set maximum line length to \fIn\fP columns. (Beyond
this is ignored.)  Max is 132.  Default = 72.
.TP
.BI \-common= n
Set level of strictness in checking COMMON blocks.
Min is 0 (no checking).  Max is 3 (must be identical).  Default = 3.
.TP
.B \-crossref
Print cross-reference list of subprogram calls and
COMMON block use.  Default = no.
.TP
.B \-declare
Print a list of all identifiers whose datatype is not
explicitly declared.  Default = no.
.TP
.B \-division
Warn wherever division is done (except division by a
constant).  Default = no.
.TP
.B \-extern
Warn if external subprograms which are invoked
are never defined.  Default = yes.
.TP
.B \-f77
Warn about extensions to the Fortran 77 standard.  Default = no.
.TP
.B \-help
Print command summary.  Default = no.
.TP
.B \-hollerith
Warn about Hollerith constants if \fB\-portability\fP
option is in effect.  Default = yes.
.TP
.BI \-include= path
Define a directory to search for INCLUDE files.
Cumulative.
.TP
.B \-library
Begin library mode: do not warn about subprograms
in file that are defined but never used.  Default = no.
.TP
.B \-list
Print source listing of program.  Default = no.
.TP
.B \-novice
Give output suitable for novice users.  Default = yes.
.TP
.BI \-output= filename
Send output to the given file.
Default is to send output to the screen. (Default filename extension
is \fI.\|lis\fP).
.TP
.B \-portability
Warn about non-portable usages.  Default = no.
.TP
.B \-pretty
Give warnings for possibly misleading appearance
of source code.    Default = yes.
.TP
.B \-project
Create project file (see explanation below).  Default =
no.
.TP
.B \-pure
Assume functions are pure, i.e. have no side effects.
Default = yes.
.TP
.B \-reference
Print table of subprograms referenced by each subprogram.
Default = no.
.TP
.B \-sixchar
List any variable names which clash at 6 characters length.
Default = no.
.TP
.B \-sort
Print list of subprograms sorted in prerequisite order.
Default = no.
.TP
.B \-symtab
Print symbol table for each subprogram.  Default = no.
.TP
.B \-truncation
Check for possible loss of accuracy by truncation.
Default = yes.
.TP
.BI \-usage= n
Control warnings about unused variables, etc.  Min is 0
(no checking). Max is 3 (most checking).  Default = 3.
.TP
.B \-verbose
Produce full amount of output.  Default = yes.
.TP
.B \-volatile
Assume COMMON blocks lose definition between
activations.  Default = no.
.TP
.BI \-wordsize= n
Set the default word size for numeric
quantities to \fIn\fP bytes.  Default = 4 bytes.
.TP
.BI \-wrap= n
Set output column at which to wrap long error messages and
warnings to the next line.  If set to 0, turn off wrapping.  Default = 79.
.PP
When more than one option is used, they should be separated by a blank
space, except on systems such as VMS where options begin with slash ( / ).
No blank spaces may be placed around the equals sign ( = ) in a setting.
\fCftnchek "?"\fR
will produce a command summary listing all options and settings.
.PP
When giving a name of an input file, the extension is optional.  If no
extension is given, \fBftnchek\fP will first look for a project file
with extension \fI.\|prj\fP, and will use that if it exists.  If not, then
\fBftnchek\fP will look for a Fortran source file with the
extension \fI.\|for\fP for VMS systems, \fI.\|f\fP for UNIX systems.
More than one file name can be given to \fBftnchek\fP,
and it will process the
modules in all files as if they were in a single file.
.PP
Wildcards are allowed in the specification of filenames on the command line
for the VMS and MS-DOS versions,
as also of course under UNIX and any other system that performs
wildcard expansion in the command processor.
.PP
If no filename is given, \fBftnchek\fP will read input from the
standard input.
.SH "FTNCHEK OPTIONS"
This section provides a more detailed discussion of \fBftnchek\fP
command-line options.  Options and filenames may be interspersed on a
command line.  Most options are positional: each option remains in
effect from the point it is
encountered until it is overridden by a later change.  Thus for
example, the listing may be suppressed for some files and not for
others.  Exceptions are: the \fB\-wordsize\fP setting, which cannot be
changed once processing of input files has started;
the
\fB\-arguments\fP,
\fB\-array\fP,
\fB\-calltree\fP,
\fB\-common\fP,
\fB\-crossref\fP,
\fB\-extern\fP,
\fB\-reference\fP,
\fB\-sort\fP,
and
\fB\-volatile\fP
options, where the action depends only on the value of
the option after the processing of input files is finished;
and the \fB\-include\fP setting, which is cumulative.
.PP
The option names in the following list are in alphabetical order.

.TP
.BI \-arguments= num
Controls warnings about
mismatches between actual and dummy subprogram arguments.  (An actual
argument is an argument passed to the subprogram by the caller; a
dummy argument is an argument received by the subprogram.)
.IP
The meanings of the setting values are as follows:
.RS
.TP \w'1.'u+2n
0:
turn off all such warnings.
.TP \w'1.'u+2n
1:
warn only about different number of arguments.
.TP \w'1.'u+2n
2:
warn only about mismatch of data type of arguments and of
function itself.
.TP \w'1.'u+2n
3:
all warnings.
.RE
.IP
Default = 3.
.IP
This setting is provided mainly to suppress warnings when you wish to
use \fBftnchek\fP for some other purpose than checking for errors, for
example when you only want to print the call tree.
It does not apply to checking invocations
of intrinsic functions or statement functions.
.IP
See also: \fB\-array\fP, \fB\-library\fP, \fB\-usage\fP.

.TP
.BI \-array= num
Controls the degree of strictness in checking
agreement between actual and dummy subprogram arguments that are arrays.
The warnings controlled by this setting are for constructions that might
legitimately be used by a knowledgeable programmer, but that often
indicate programming errors.
.IP
The meanings of the setting values are as follows:
.RS
.TP \w'1.'u+2n
0:
only warn about cases that are seldom intentional (see note below).
.TP \w'1.'u+2n
1:
warn if the arguments differ in their number of dimensions,
or if the actual argument is an array element while the dummy argument
is a whole array.
.TP \w'1.'u+2n
2:
warn if both arguments are arrays, but they differ in number
of elements.
.TP \w'1.'u+2n
3:
give both types of warnings.
.RE
.IP
Default = 3.
.IP
Note:
A warning is always given regardless of this setting if the actual
argument is an array while the dummy argument is a scalar variable, or
if the actual argument is a scalar variable or expression while the
dummy argument is an array.
No warning is ever given if the actual argument is an array
element while the dummy argument is a scalar variable.
Variable-dimensioned arrays and arrays dimensioned with 1 or asterisk match any
number of array elements.
.IP
See also: \fB\-arguments\fP, \fB\-library\fP, \fB\-usage\fP.

.TP
.B \-calltree
Causes \fBftnchek\fP to print out the call structure of
the complete program in the form of a tree.  The tree is printed out
starting from the main program, which is listed on the first line at
the left margin.  Then on the following lines, each routine called by
the main program is listed, indented a few spaces, followed by the
subtree starting at that routine.  Default = no.
.IP
If a routine is called by more than one other routine,
its call subtree is printed only the first time it is encountered.
Later calls give only the routine name and the notice ``(see above)''.
.IP
Note that the call tree will be incomplete if any of the input files
are project files containing more than one module
that were created in \fB\-library\fP mode.  See the
discussion of project files below.
.IP
Technical points: Each list of routines called by a given routine is
printed in alphabetical order.
If multiple main programs are found, the call tree of each is printed
separately.
If no main program is found, a report to that effect is printed out,
and the call trees of any top-level non-library routines are printed.
This flag only controls the printing of the call tree: \fBftnchek\fP
constructs the call tree in any case because it is used to determine
which library modules will be cross-checked.  See the discussion
of the \fB\-library\fP flag.
.IP
See also: \fB\-crossref\fP, \fB\-library\fP, \fB\-reference\fP,
\fB\-sort\fP, \fB\-symtab\fP.

.TP
.BI \-columns= n
Set maximum statement length to \fIn\fP columns.
(Beyond this is ignored.)
This setting is provided to allow checking of programs which may
violate the Fortran standard limit of 72 columns for the length of a
statement.  According to
the standard, all characters past column 72 are ignored.
If this setting is used when the \fB\-f77\fP option is in effect, a
warning will be given for any lines in which characters past column 72
are processed.
Max is 132.  Default = 72.

.TP
.BI \-common= n
This setting varies the strictness of
checking of COMMON blocks.
.IP
The different levels are:
.RS
.TP \w'1.'u+2n
0:
no checking.
.TP \w'1.'u+2n
1:
in each declaration of a given COMMON block,
corresponding memory locations (words or bytes) must agree in data type.
.TP \w'1.'u+2n
2:
also warn if different declarations
of the same block are not equal in total length.
.TP \w'1.'u+2n
3:
corresponding variables in each declaration of a block must
agree in data type and (if arrays) in size and number of dimensions.
.RE
.IP
Default = 3.
.IP
The Fortran 77 standard requires each named common block, but not
blank common, to be
the same length in all modules of the program.
Level 3 provides an extra degree of checking to support
a frequent programming practice.
.IP
See also: \fB\-library\fP, \fB\-usage\fP, \fB\-volatile\fP.

.TP
.B \-crossref
Specifies that a cross-reference table be printed.
This table lists each
subprogram followed by a list of the routines that call it.  Also
prints a table listing each COMMON block followed by a list of the
routines that access it.  Default = no.
.IP
The cross-reference listing omits
library modules that are not in the call tree of the main program.
The list is alphabetized.
The routines listed as using a COMMON block are those in which some
variables in the block are accessed, not simply those routines that
declare the block.  (To find out what routines declare a COMMON block
but do not use it, see the \fB\-usage\fP flag.)
.IP
See also: \fB\-calltree\fP,
\fB\-reference\fP, \fB\-sort\fP, \fB\-symtab\fP.

.TP
.B \-declare
If this flag is set, all identifiers whose datatype is
not declared in each module will be listed.  This flag is useful for
helping to find misspelled variable names, etc.  The same listing will
be given if the module contains an \fCIMPLICIT NONE\fR statement.
Default = no.
.IP
See also: \fB\-sixchar\fP, \fB\-usage\fP.

.TP
.B \-division
This switch is provided to help users spot potential
division by zero problems.  If this switch is selected, every division
except by a constant will be flagged.  (It is assumed that the user is
intelligent enough not to divide by a constant which is equal to zero!)
Default = no.
.IP
See also: \fB\-portability\fP, \fB\-truncation\fP.

.TP
.B \-extern
Causes \fBftnchek\fP to report whether any subprograms
invoked by the program are never defined, or are multiply defined.
Ordinarily, if \fBftnchek\fP is being run on a complete program, each
subprogram other than the intrinsic functions should be defined once
and only once somewhere.  Turn off this switch if you just want to
check a subset of files which form part of a larger complete program,
or to check all at once a number of unrelated files which might each
contain an unnamed main program.  Subprogram arguments will still be
checked for correctness.  Default = yes.
.IP
See also: \fB\-library\fP.

.TP
.B \-f77
Use this flag to catch language extensions which violate
the Fortran 77 standard.  Such extensions may cause your program not
to be portable.  Examples include the use of underscores in variable
names; variable names longer than six characters; statement lines
longer than 72 characters; and nonstandard statements such as the
\fCDO\fR ... \fCENDDO\fR structure.  \fBftnchek\fP does not report on
the use of lowercase letters.  Default = no.
.IP
See also: \fB\-portability\fP, \fB\-pretty\fP, \fB\-wordsize\fP.

.TP
.B \-help
Prints a list of all the command-line options with a
short description of each along with its default value.
This command is identical in function to
the \fB``?''\fP
argument, and is provided as a convenience for those systems in
which the question mark has special meaning to the command
interpreter.  Default = no.
.IP
The help listing also prints the version number and patch level of
\fBftnchek\fP and a copyright notice.
.IP
Note: the ``default'' values printed in square brackets in the help listing
are, strictly speaking, not the built-in defaults but the current
values after any environment options and any command-line
options preceding the \fB\-help\fP option have been processed.

.TP
.B \-hollerith
Hollerith constants (other than within FORMAT
specifications) are a source of possible portability problems, so when
the \fB\-portability\fP flag is set, warnings about them will be
produced.  If your program uses many Hollerith constants, these
warnings can obscure other more serious warnings.  So you can set this
flag to ``no'' to suppress the warnings about Holleriths.  This flag has
no effect unless the \fB\-portability\fP flag (which is off
by default) is turned on.
Default = yes.
.IP
See also: \fB\-portability\fP.

.TP
.BI \-include= path
Specifies a directory to be searched for files
specified by \fCINCLUDE\fR statements.  Unlike other command-line
options, this setting is cumulative; that is, if it is given more than
once on the command line, all the directories so specified are placed
on a list that will be searched in the same order as they are given.
The order in which \fBftnchek\fP searches for a file to be included is:
the current directory; the directory specified by
environment
variable \fCFTNCHEK_INCLUDE\fR
if any;
the directories specified by any \fB\-include\fP options;
the directory specified by environment variable \fCINCLUDE\fR;
and finally in
a standard systemwide directory
(\fC/usr/include\fR for UNIX, \fCSYS$LIBRARY\fR for VMS,
and \fC\\include\fR
for MSDOS).

.TP
.B \-library
This switch is used when a number of subprograms are
contained in a file, but not all of them are used by the application.
Normally, \fBftnchek\fP warns you if any subprograms are defined but
never used.  This switch will suppress these warnings.  Default = no.
.IP
This switch also controls which subprogram calls and COMMON
block declarations are checked.  If a file
is read with the \fB\-library\fP flag in effect, the subprogram calls
and COMMON declarations contained in a routine in that file will
be checked only if that routine is in the main program's call tree.
On the other hand, if the \fB\-library\fP switch is
turned off, then \fBftnchek\fP checks the calls of every routine by
every other routine, regardless of whether those routines could ever
actually be invoked at run time, and likewise all COMMON block
declarations are compared for agreement.
.IP
(If there is no main program anywhere in the set of files that
\fBftnchek\fP has read, so that there is no call tree, then
\fBftnchek\fP will look for any non-library routines that are not called
by any other routine, and use these as substitutes for the main
program in constructing the call tree and deciding what to check.
If no such top-level non-library routines are found, then
all inter-module calls and all COMMON declarations will be checked.)
.IP
See also: \fB\-arguments\fP, \fB\-calltree\fP, \fB\-common\fP, \fB\-extern\fP.


.TP
.B \-list
Specifies that a listing of the Fortran program is to be
printed out with line numbers.  If \fBftnchek\fP detects an error, the
error message follows the program line with a caret
( ^ )
specifying the location of the error.  If no source listing was
requested, \fBftnchek\fP will still print out any line containing an
error, to aid the user in determining where the error occurred.
Default = no.
.IP
See also: \fB\-symtab\fP, \fB\-verbose\fP.

.TP
.B \-novice
This flag is intended to provide more helpful
output for beginners.  It has two effects
.RS
.TP \w'1.'u+2n
(a)
provides an extra message to the effect that a function
that is used but not defined anywhere might be an array which the user
forgot to declare in a \fCDIMENSION\fR statement (since the syntax of
an array reference is the same as that of a function reference).
.TP \w'1.'u+2n
(b)
modifies the form of the error messages and warnings.  If the
flag is turned off by \fB\-nonovice\fP, these messages are printed in a
style more resembling UNIX \fBlint\fP.
.RE
.IP
Default = yes.
.IP
In versions of \fBftnchek\fP prior to 2.6, this option could take on various
numerical values, as a way of controlling various classes of warnings.
These warnings are now controlled individually by their own flags.
Novice level 1 is now handled by the \fB\-array\fP flag; level 2 has
been eliminated; level 3 is equivalent now to setting \fB\-novice\fP to
yes; level 4 is handled by the \fB\-pure\fP flag.

.TP
.BI \-output= filename
This setting is provided for convenience on
systems which do not allow easy redirection of output from programs.
When this setting is given, the output which normally appears on the
screen will be sent instead to the named file.  Note, however, that
operational errors of \fBftnchek\fP itself (e.g. out of space or cannot
open file) will still be sent to the screen.  The extension for the
filename is optional, and if no extension is given, the
extension \fI.\|lis\fP will be used.

.TP
.B \-portability
\fBftnchek\fP will give warnings for a variety of
non-portable usages.  Examples include the use of tabs except in comments
or inside strings, the use of Hollerith constants, and the
equivalencing of variables of different data types.  This option does
not produce warnings for supported extensions to the Fortran 77 standard, which
may also cause portability problems.  To catch those, use
the \fB\-f77\fP option.  Default = no.
.IP
See also: \fB\-f77\fP, \fB\-hollerith\fP, \fB\-pretty\fP, \fB\-wordsize\fP.

.TP
.B \-pretty
Controls certain messages related to the appearance of
the source code.  These warn about things that might be
deceptive to the reader.  Default = yes.
.IP
The warnings controlled by this flag include such things as
comments that are interspersed among the continuation lines of a statement,
lack of space between a keyword and a following variable name,
and
statement lines containing characters past column 72.
.IP
See also: \fB\-f77\fP, \fB\-portability\fP.

.TP
.B \-project
\fBftnchek\fP will create a project file from each
source file that is input while this flag is in effect.  The project
file will be given the same name as the input file, but with the
extension \fI.\|f\fP or \fI.\|for\fP replaced by \fI.\|prj\fP.
(If input is from standard input, the project file is named
.IR ftnchek.\|prj .)
Default = no.
.IP
A project file contains a summary of information from the source file,
for use in checking agreement
among \fCFUNCTION\fR, \fCSUBROUTINE\fR, and \fCCOMMON\fR
usages in other files.  It
allows incremental checking, which saves time whenever you have a
large set of files containing shared subroutines, most of which seldom
change.  You can run \fBftnchek\fP once on each file with the
\fB\-project\fP flag set, creating the project files.  Usually you
would also set the \fB\-library\fP and \fB\-noextern\fP flags at this
time, to suppress messages relating to consistency with other files.
Only error messages pertaining to each file by itself will be printed
at this time.  Thereafter, run \fBftnchek\fP without these flags on all
the project files together, to check consistency among the different
files.  All messages internal to the individual files will now be
omitted.  Only when a file is altered will a new project file need to
be made for it.
.IP
Naturally, when the \fB\-project\fP flag is set, \fBftnchek\fP will not
read project files as input.
.IP
Project files contain only information needed for checking
agreement between files.  This means that a project file is of no use if all
modules of the complete program are contained in a single file.
.IP
A more detailed discussion is given in the
section on Using Project Files.

.TP
.B \-pure
Assume functions are ``pure'', i.e., they will not have
side effects by modifying their arguments or variables in a COMMON
block.  When this flag is in effect, \fBftnchek\fP will base its
determination of set and used status of the actual arguments on the
assumption that arguments passed to a function are not altered.  It
will also issue a warning if a function is found to modify any of its
arguments or any COMMON variables.
Default = yes.
.IP
When this flag is turned off, actual arguments passed to functions
will be handled the same way as actual arguments passed to
subroutines.  This means that \fBftnchek\fP will assume that arguments
may be modified by the functions.  No warnings will be given if a
function is found to have side effects.  Because stricter checking is
possible if functions are assumed to be pure, you should turn this flag
off only if your program actually uses functions with side effects.

.TP
.B \-reference
Specifies that a who-calls-who table be printed.
This table lists each subprogram followed by a list of the
routines it calls.  Default = no.
.IP
The reference list omits routines
called by unused library modules.  Thus it contains the same
information as for the \fB\-calltree\fP flag, namely the hierarchy of
subprogram calls, but printed in a different format.  This prints out
a breadth-first traversal of the call tree whereas \fB\-calltree\fP prints
out a depth-first traversal.  If both \fB\-calltree\fP and
\fB\-reference\fP flags
are given, only the reference form of the table will be produced.
.IP
See also: \fB\-calltree\fP, \fB\-crossref\fP, \fB\-library\fP,
\fB\-sort\fP, \fB\-symtab\fP.

.TP
.B \-sixchar
One of the goals of the \fBftnchek\fP program is to
help users to write portable Fortran programs.  One potential source
of nonportability is the use of variable names that are longer than
six characters.  Some compilers just ignore the extra characters.
This behavior could potentially lead to two different variables being
considered as the same.  For instance, variables named \fCAVERAGECOST\fR
and \fCAVERAGEPRICE\fR are the same in the first six characters.  If
you wish to catch such possible conflicts, use this flag.  Default =
no.
.IP
Use the \fB\-f77\fP flag if you want to list \fIall\fP
variables longer than six characters, not just those pairs that are the same in
the first six.
.IP
See also: \fB\-f77\fP, \fB\-portability\fP.

.TP
.B \-sort
Specifies that a sorted list of all modules used in the
program be printed.  This list is in ``prerequisite'' order, i.e. each
module is printed only after all the modules from which it is called
have been printed.  This is also called a ``topological sort'' of the
call tree.  Each module is listed only once.  Routines that are not in
the call tree of the main program are omitted.  If there are any
cycles in the call graph (illegal in standard Fortran) they
will be detected and diagnosed.  Default = no.
.IP
See also: \fB\-calltree\fP,
\fB\-crossref\fP, \fB\-reference\fP, \fB\-symtab\fP.

.TP
.B \-symtab
A symbol table will be printed out for each module,
listing all identifiers mentioned in the module.  This table gives the
name of each variable, its datatype, and the number of dimensions for
arrays.  An asterisk (*) indicates that the variable has been
implicitly typed, rather than being named in an explicit type
declaration statement.  The table also lists all subprograms invoked
by the module, all COMMON blocks declared, etc.  Default = no.
.IP
See also: \fB\-calltree\fP, \fB\-crossref\fP, \fB\-list\fP,
\fB\-reference\fP, \fB\-sort\fP.

.TP
.B \-truncation
Warn about possible truncation (or roundoff)
errors.  Most of
these are related to integer arithmetic.  The warnings enabled when
this flag is in effect are:
.RS
.TP \w'1.'u+2n
(a)
use of the result of integer division where a real result
seems intended (namely as an exponent, or if the quotient is later
converted to real);
.TP \w'1.'u+2n
(b)
division in an integer constant expression that
yields a result of zero;
.TP \w'1.'u+2n
(c)
exponentiation of an integer by a negative
integer (which yields zero unless the base integer is 1 in magnitude);
.TP \w'1.'u+2n
(d)
use of a non-integer array subscript or DO index;
.TP \w'1.'u+2n
(e)
conversion of any real type to integer, or
conversion of a complex value to real or integer;
.TP \w'1.'u+2n
(f)
conversion of a double
precision value to single precision, or vice-versa (promotion).
This applies both to real types and to complex types.
.RE
.IP
Default = yes.
.IP
Note: warnings about truncating type conversions are given only when
the conversion is done automatically, e.g.
by an assignment statement.  If intrinsic
functions such as \fCINT\fR are used to perform the conversion, no warning
is given.
Promotions of real types from single to double precision are included
here because such conversions imply a possible loss of accuracy that
is similar to the corresponding demotions.
.IP
See also: \fB\-portability\fP, \fB\-wordsize\fP.

.TP
.BI \-usage= n
Warn about unused or possible uninitialized variables
and unused common blocks.
.IP
The meanings of the setting values are as follows:
.RS
.TP \w'1.'u+2n
0:
no warnings.
.TP \w'1.'u+2n
1:
warn if variables are (or may be) used before they are set.
.TP \w'1.'u+2n
2:
warn if variables are declared or set but never used.
.TP \w'1.'u+2n
3:
give both types of warnings.
.RE
.IP
Default = 3.
.IP
Sometimes \fBftnchek\fP makes a mistake about
these warnings.  Usually it errs on the side of giving a warning where no
problem exists, but in rare cases it may fail to warn where the
problem does exist.  See the section on Bugs for examples.  If
variables are equivalenced, the rule used by \fBftnchek\fP is that a
reference to any variable implies the same reference to all variables
it is equivalenced to.  For arrays, the rule is that a reference to
any array element is treated as a reference to all elements of the array.
.IP
This setting controls warnings not only for local variables but
also for variables in COMMON blocks.  Level 2 also controls whether a
warning is given when an entire COMMON block is unused.  When checking
for used-before-set errors involving COMMON variables, \fBftnchek\fP does
not do a thorough enough analysis of the calling sequence to know
which routines are called before others.  So warnings about this type
of error will only be given for cases in which a variable is used in
some routine but not set in any other routine.   Checking of
individual COMMON variables is done only if the \fB\-common\fP
setting is 3 (variable by variable agreement).
.IP
See also: \fB\-common\fP, \fB\-declare\fP, \fB\-volatile\fP.

.TP
.B \-verbose
This option is on by default.  Turning it off reduces
the amount of output relating to normal operation, so that error
messages are more apparent.  This option is provided for the
convenience of users who are checking large suites of files.  The
eliminated output includes the names of project files, and the message
reporting that no syntax errors were found.  (Some of this output is
turned back on by the \fB\-list\fP and \fB\-symtab\fP options.)  Default
= yes.

.TP
.B \-volatile
Assume that COMMON blocks are volatile.
Default = no.
.IP
Many Fortran programmers assume that variables, whether
local or in COMMON, are static, i.e. that
once assigned a value, they retain that value permanently until
assigned a different value by the program.  However, in fact the
Fortran 77 Standard does not require this to be the case.
Local variables may
become undefined between activations of a module in which they are
declared.  Similarly, COMMON blocks may become undefined if no module
in which they are declared is active.  (The technical term for this
behavior is ``automatic'',
but \fBftnchek\fP uses the word ``volatile'' since it
is clearer to the nonspecialist.)  Only COMMON blocks declared
in a SAVE statement, or
declared in the main program or in a block data subprogram remain
defined as long as the program is running.  Variables and COMMON
blocks that can become undefined at some point are called volatile.
.IP
If the \fB\-volatile\fP flag is turned on,
\fBftnchek\fP will warn you if it finds
a volatile COMMON block.  If, at the same time, the \fB\-usage\fP setting
is 1 or 3 (check used before set), \fBftnchek\fP will try to check whether
such a block can lose its defined status between activations of the
modules where it is declared.  \fBftnchek\fP does not do a very good job of
this: the rule used is to see whether the block is declared in two
separated subtrees of the call tree.  For instance, this would be the
case if two modules, both called from the main program, shared a
volatile COMMON block.  A block can also become undefined between two
successive calls of the same subprogram, but \fBftnchek\fP is not smart
enough to tell whether a subprogram can be called more than once, so
this case is not checked for.
.IP
The \fB\-volatile\fP flag does not affect the way \fBftnchek\fP
checks the usage of local variables.
.IP
See also: \fB\-common\fP, \fB\-usage\fP.

.TP
.BI \-wordsize= n
Specifies the default word size to be \fIn\fP bytes.  This is the size of
logical and single-precision numeric variables that are not given
explicit precisions.  Double-precision and complex variables will be twice
this value, and double complex variables four times.  Explicit precisions
for non-character variables are an extension to the Fortran 77
standard, and are given by type declarations such as \fCREAL*8 X\fR.
Default = 4 bytes.
.IP
If you want to change the built-in default value of this setting,
compile \fBftnchek\fP with the macro name
\fCBpW\fR
(Bytes per Word) set to the desired default value.  This is not
critical: the word size value does not matter for checking
standard-conforming programs that do not declare explicit precisions for
non-character variables or store Hollerith data in variables.  This
setting also does not affect the default size of character variables,
which is always 1 byte.  Hollerith constants also are assumed to
occupy 1 byte per character.
.IP
The word size is used to determine whether truncation occurs in
assignment statements, and to catch precision mismatches in subprogram
argument lists and common block lists.  The exact warnings that are
issued will depend on the status of other flags.  Under both the
\fB\-portability\fP or \fB\-nowordsize\fP flags, any mixing of
explicit with default precision objects (character
expressions not included) is warned about.  This applies to arithmetic
expressions containing both types of objects, and to
subprogram arguments and COMMON variables.
Under the \fB\-truncation\fP flag, a warning
is given for assignment of an expression to a shorter variable of the
same type, or for promotion of a lower precision value to higher
precision in an arithmetic expression or an assignment statement.
.IP
Giving a word size of 0, or equivalently, using \fB\-nowordsize\fP means that
no default value will be assumed.
Use this instead of \fB\-portability\fP if you want to check only for
those aspects of portability related to mixing default and explicit
precision, for example to flag places where \fCREAL*8\fR is treated
as equivalent to \fCDOUBLE PRECISION\fR.
.IP
See also: \fB\-portability\fP, \fB\-truncation\fP.

.TP
.BI \-wrap= col
Controls the wrapping of error messages.  Long error
messages that would run past the specified column will be broken up into
separate lines between the words of the message for better
readability.  If turned off with \fB\-nowrap\fP, each separate error
message will be printed on one line, leaving it up to the display to
wrap the message or truncate it.  Default = 79.

.SH "CHANGING THE DEFAULTS"
\fBftnchek\fP includes a mechanism for changing the
default values of all options
by defining environment variables.  When
\fBftnchek\fP  starts up,
it looks in its environment for any variables whose names are composed by
prefixing the string
\fCFTNCHEK_\fR
onto the uppercased version of the option
name.  If such a
variable is found, its value is used to specify the default for the
corresponding switch or setting.  In the case of settings (for example,
the \fB\-common\fP strictness setting)
the value of the environment variable is read as the
default setting value.  In the case of switches, the default switch will
be taken as true or yes unless the environment variable has the value
\fC0\fR or \fCNO\fR.  Of course,
command-line options will override these defaults the same way as they
override the built-in defaults.
.PP
Note that the environment variable name must be constructed with the
full-length option name, which must be in uppercase.  For example, to
make
\fBftnchek\fP print a source listing by default, set the environment
variable
\fCFTNCHEK_LIST\fR
to \fC1\fR or \fCYES\fR or anything other than \fC0\fR or \fCNO\fR.
The names
\fCFTNCHEK_LIS\fR
(not the full option name) or
\fCftnchek_list\fR
(lower case) would not be recognized.
.PP
Here are some examples of how to set environment variables on various
systems.  For simplicity, all the examples set the default \fB\-list\fP
switch to \fCYES\fR.
.PP
.fc > @
.if n .ta 30 +35
.if t .ta 2i +2i
>1. UNIX, Bourne shell:  >\fC$ FTNCHEK_LIST=YES; export FTNCHEK_LIST\fP

>2. UNIX, C shell:       >\fC% setenv FTNCHEK_LIST YES\fP

>3. VAX/VMS:             >\fC$ DEFINE FTNCHEK_LIST YES\fP

>4. MSDOS:               >\fC$ SET FTNCHEK_LIST=YES\fP
.fc

.SH "USING PROJECT FILES"
This section contains detailed information on how to use project files
most effectively, and how to avoid some pitfalls.
.PP
Ordinarily, project files should be created with the \fB\-library\fP
flag in effect.  In this mode,
the information saved in the project file consists of all subprogram
declarations, all subprogram invocations not resolved by declarations in the
same file, and one instance of each COMMON
block declaration.  This is the minimum amount of information needed
to check agreement between files.
.PP
If the file contains more than one routine, there are some
possible problems that can arise from creating the project file in
library mode, because the calling
hierarchy among routines defined within the file is lost.  Also,
if the routines in the file make use of COMMON
blocks that are shared with routines in other files, there will not be
enough information saved for the correct checking of set and used
status of COMMON blocks and COMMON variables according to the
\fB\-usage\fP setting.  Therefore if
you plan to use project files when the \fB\-usage\fP
setting is nonzero (which is the default situation), and if
multiple routines in one
project file share COMMON blocks with routines in other files,
the project files
should be created with the \fB\-library\fP flag turned off.
In this mode, \fBftnchek\fP saves, besides
the information listed above, one invocation of each subprogram by
any other subprogram in the same file, and all COMMON block
declarations.  This means that the project file will be larger than
necessary, and that when it is read in, \fBftnchek\fP may repeat some
inter-module checks that it already did when the project file was
created.  If each project file contains only one
module, there is no loss of information in creating the project
files in library mode.
.PP
Because of the possible loss of information entailed by creating a project file
with the \fB\-library\fP flag in effect, whenever that project file is read
in later, it will be treated as a library file regardless of the
current setting of the \fB\-library\fP flag.  On the other hand, a project
file created with library mode turned off can be read in later in either
mode.
.PP
Here is an example of how to use the UNIX \fBmake\fP utility to
automatically create a new project file each time the corresponding
source file is altered, and to check the set of files for consistency.
The example assumes that a macro \fCOBJS\fR has been defined which
lists all the names of object files to be linked together to form the
complete executable program.
.nf
\fC
    # tell make what a project file suffix is
    .SUFFIXES: .prj

    # tell make how to create a .prj file from a .f file
    .f.prj:
            ftnchek -project -noextern -library $<

    # set up macro PRJS containing project filenames
    PRJS= $(OBJS:.o=.prj)

    # "make check" will check everything that has been changed.
    check: $(PRJS)
            ftnchek $(PRJS)
\fP
.fi
.SH "AN EXAMPLE"
The following simple Fortran program illustrates the messages given by
\fBftnchek\fP.
The program is intended to accept an array of test scores
and then compute the average for the series.
.PP
.nf
\fC
C       AUTHORS: MIKE MYERS AND LUCIA SPAGNUOLO
C       DATE:    MAY 8, 1989

C       Variables:
C               SCORE -> an array of test scores
C               SUM ->   sum of the test scores
C               COUNT -> counter of scores read in
C               I ->     loop counter

        REAL FUNCTION COMPAV(SCORE,COUNT)
            INTEGER SUM,COUNT,J,SCORE(5)

            DO 30 I = 1,COUNT
                SUM = SUM + SCORE(I)
30          CONTINUE
            COMPAV = SUM/COUNT
        END


        PROGRAM AVENUM
C
C                       MAIN PROGRAM
C
C       AUTHOR:   LOIS BIGBIE
C       DATE:     MAY 15, 1990
C
C       Variables:
C               MAXNOS -> maximum number of input values
C               NUMS    -> an array of numbers
C               COUNT   -> exact number of input values
C               AVG     -> average returned by COMPAV
C               I       -> loop counter
C

            PARAMETER(MAXNOS=5)
            INTEGER I, COUNT
            REAL NUMS(MAXNOS), AVG
            COUNT = 0
            DO 80 I = 1,MAXNOS
                READ (5,*,END=100) NUMS(I)
                COUNT = COUNT + 1
80          CONTINUE
100         AVG = COMPAV(NUMS, COUNT)
        END
\fP
.fi
.PP
The compiler gives no error messages when this program is compiled.
Yet here is what happens when it is run:
.PP
.nf
\fC
$ run average
70
90
85
<EOF>
$
\fP
.fi
.PP
What happened?  Why didn't the program do anything?
The following is the output from
\fBftnchek\fP when it is used to debug the above
program:

.PP
.nf
\fC

$ ftnchek -list -symtab average

FTNCHEK Version 2.7 August 1993

File average.f:

      1 C       AUTHORS: MIKE MYERS AND LUCIA SPAGNUOLO
      2 C       DATE:    MAY 8, 1989
      3
      4 C       Variables:
      5 C               SCORE -> an array of test scores
      6 C               SUM ->   sum of the test scores
      7 C               COUNT -> counter of scores read in
      8 C               I ->     loop counter
      9
     10         REAL FUNCTION COMPAV(SCORE,COUNT)
     11             INTEGER SUM,COUNT,J,SCORE(5)
     12
     13             DO 30 I = 1,COUNT
     14                 SUM = SUM + SCORE(I)
     15 30          CONTINUE
     16             COMPAV = SUM/COUNT
                           ^
Warning near line 16 col 20: integer quotient expr converted to real
     17         END
     18

Module COMPAV: func: real

Variables:

      Name Type Dims     Name Type Dims     Name Type Dims     Name Type Dims
    COMPAV real         COUNT intg             I intg*            J intg
     SCORE intg  1        SUM intg

* Variable not declared. Type has been implicitly defined.


Warning: Variables declared but never referenced:
         J

Warning: Variables may be used before set:
       SUM


     19
     20         PROGRAM AVENUM
     21 C
     22 C                       MAIN PROGRAM
     23 C
     24 C       AUTHOR:   LOIS BIGBIE
     25 C       DATE:     MAY 15, 1990
     26 C
     27 C       Variables:
     28 C               MAXNOS -> maximum number of input values
     29 C               NUMS    -> an array of numbers
     30 C               COUNT   -> exact number of input values
     31 C               AVG     -> average returned by COMPAV
     32 C               I       -> loop counter
     33 C
     34
     35             PARAMETER(MAXNOS=5)
     36             INTEGER I, COUNT
     37             REAL NUMS(MAXNOS), AVG
     38             COUNT = 0
     39             DO 80 I = 1,MAXNOS
     40                 READ (5,*,END=100) NUMS(I)
     41                 COUNT = COUNT + 1
     42 80          CONTINUE
     43 100         AVG = COMPAV(NUMS, COUNT)
     44         END

Module AVENUM: prog

External subprograms referenced:

    COMPAV: real*

Variables:

      Name Type Dims     Name Type Dims     Name Type Dims     Name Type Dims
       AVG real         COUNT intg             I intg        MAXNOS intg*
      NUMS real  1

* Variable not declared. Type has been implicitly defined.


Warning: Variables set but never used:
       AVG



 0 syntax errors detected in file average.f
 6 warnings issued in file average.f

Subprogram COMPAV:  argument data type mismatch
  at position 1:
    Dummy type intg  in module COMPAV line 10 file average.f
    Actual type real  in module AVENUM line 43 file average.f
\fP
.fi
.PP
According to \fBftnchek\fP,
the program contains variables which may be
used before they are assigned an initial value, and variables which
are not needed.  \fBftnchek\fP also warns the user that an integer
quotient has been converted to a real. This may assist the user in
catching an unintended roundoff error.  Since the \fB\-symtab\fP flag
was given, \fBftnchek\fP prints out a table containing identifiers from
the local module and their corresponding datatype and number of
dimensions.  Finally, \fBftnchek\fP warns that the function
\fCCOMPAV\fR is not used
with the proper type of arguments.
.PP
With \fBftnchek\fP's
help, we can debug the program.  We can see that there
were the following errors:
.TP \w'1.'u+2n
1.
\fCSUM\fR and \fCCOUNT\fR
should have been converted to real before doing the division.
.TP \w'1.'u+2n
2.
\fCSUM\fR should have been initialized to 0 before entering the loop.
.TP \w'1.'u+2n
3.
\fCAVG\fR was never printed out after being calculated.
.TP \w'1.'u+2n
4.
\fCNUMS\fR should have been declared \fCINTEGER\fR
instead of \fCREAL\fR.
.PP
We also see that \fCI\fR, not \fCJ\fR, should have been declared
\fCINTEGER\fR in function \fCCOMPAV\fR. Also, \fCMAXNOS\fR was not
declared as \fCINTEGER\fR, nor \fCCOMPAV\fR as \fCREAL\fR, in
program \fCAVENUM\fR.  These are not errors, but they may indicate
carelessness.  As it happened, the default type of these variables
coincided with the intended type.
.PP
 Here is the corrected program, and its output when run:
.PP
.nf
\fC
C       AUTHORS: MIKE MYERS AND LUCIA SPAGNUOLO
C       DATE:    MAY 8, 1989
C
C       Variables:
C               SCORE -> an array of test scores
C               SUM ->   sum of the test scores
C               COUNT -> counter of scores read in
C               I ->     loop counter
C
       REAL FUNCTION COMPAV(SCORE,COUNT)
            INTEGER SUM,COUNT,I,SCORE(5)
C
            SUM = 0
            DO 30 I = 1,COUNT
                SUM = SUM + SCORE(I)
30          CONTINUE
            COMPAV = FLOAT(SUM)/FLOAT(COUNT)
        END
C
C
        PROGRAM AVENUM
C
C                       MAIN PROGRAM
C
C       AUTHOR:   LOIS BIGBIE
C       DATE:     MAY 15, 1990
C
C       Variables:
C               MAXNOS -> maximum number of input values
C               NUMS    -> an array of numbers
C               COUNT   -> exact number of input values
C               AVG     -> average returned by COMPAV
C               I       -> loop counter
C
C
            INTEGER MAXNOS
            PARAMETER(MAXNOS=5)
            INTEGER I, NUMS(MAXNOS), COUNT
            REAL AVG,COMPAV
            COUNT = 0
            DO 80 I = 1,MAXNOS
                READ (5,*,END=100) NUMS(I)
                COUNT = COUNT + 1
80          CONTINUE
100         AVG = COMPAV(NUMS, COUNT)
            WRITE(6,*) 'AVERAGE =',AVG
        END

$ run average
70
90
85
<EOF>
AVERAGE =   81.66666
$
\fP
.fi
.PP
With \fBftnchek\fP's
help, our program is a success!

.SH "INTERPRETING THE OUTPUT"
The messages given by
\fBftnchek\fP include not only
syntax errors but also warnings and informational messages
about things that are legal Fortran but that may indicate errors or
carelessness.
Most of these messages can be turned off by
command-line options.  Which option controls each message
depends on
the nature of the condition being warned about.  See the
descriptions of the command-line flags in the previous sections,
and of individual messages below.
Each message is prefixed with a word or phrase indicating the nature
of the condition and its severity.
.PP
``Error'' means a syntax error.  The simplest
kind of syntax errors are typographical errors, for example unbalanced
parentheses or misspelling of a keyword.  This type of error is caught
by the parser and appears with the description ``parse error'' or
``syntax error'' (depending on whether the parser was built using GNU
\fBbison\fP or UNIX \fByacc\fP respectively).
This type of error message cannot be
suppressed.  Be aware that this type of error often means
that \fBftnchek\fP has not properly interpreted the statement where the
error occurs, so that its subsequent checking operations will be
compromised.  You should eliminate all syntax errors before proceeding to
interpret the other messages \fBftnchek\fP gives.
.PP
``Warning: Nonstandard syntax'' indicates an extension to Fortran that
\fBftnchek\fP supports but that is not according to the Fortran 77 standard.
The extensions that \fBftnchek\fP accepts
are described in the section on Extensions below.
One example is the \fCDO\fR ... \fCENDDO\fR construction.
If a program uses these extensions, warnings will be
given only if the \fB\-f77\fP flag is set.  The default is to give no warnings.
.PP
``Warning'' in other cases
means a condition that is suspicious but that may or may not
be a programming error.  Frequently these conditions are legal under
the standard.  Some are illegal but do not fall under the heading
of syntax errors.
Usage errors are one example.
These refer to the possibility that a variable may be used before
it has been assigned a value (generally an error),
or that a variable is declared but never used (harmless but may
indicate carelessness).
The amount of checking for usage errors is controlled by
the \fB\-usage\fP flag, which
is set for the maximum amount of checking by default.
.PP
Truncation warnings cover situations in which accuracy may be lost
unintentionally, for example when a double precision value is assigned
to a real variable.  These warnings are controlled by the
\fB\-truncation\fP flag, which is on by default.
.PP
``Nonportable usage'' warns about some feature that may not be
accepted by some compilers even though it is not contrary
to the Fortran 77 Standard, or that may cause the program to perform
differently on different platforms.
For example, equivalencing real
and integer variables is usually a non-portable practice.
The use of extensions to the standard language is, of course, another
source of non-portability, but this is handled as a separate case.  To
check a program for true portability, both the \fB\-portability\fP and
the \fB\-f77\fP flags should be used.  They are both turned off by
default.  The \fB\-wordsize\fP setting is provided to check only those
nonportable usages that depend on a particular machine wordsize.
.PP
``Possibly misleading appearance'' is used for legal constructions that may not
mean what they appear to mean at first glance.  For example, Fortran is
insensitive to blank space, so extraneous space within variable names
or the lack of space between a keyword and a variable can convey the wrong
impression to the reader.
These messages can be suppressed by turning off the \fB\-pretty\fP
flag, which is on by default.
.PP
Other messages that are given after all the files are processed,
and having to do with agreement between modules, do not use the word
``warning'' but generally fall into that category.
Examples include type mismatches between corresponding variables in
different COMMON
block declarations, or between dummy and actual arguments of a
subprogram.
These warnings are controlled by the \fB\-common\fP and
\fB\-arguments\fP settings respectively.  By default both are set for
maximum strictness of checking.
.PP
Another group of warnings about conditions that are often harmless
refer to cases where the array properties of a variable
passed as a subprogram argument differ between the two routines.
For instance, an array element might be passed to a subroutine that
expects a whole array.  This is a commonly-used technique for
processing single rows or columns of two-dimensional arrays.
However, it could also indicate a programming error.  The
\fB\-array\fP setting allows the user to adjust the degree of
strictness to be used in checking this kind of agreement between
actual and dummy array arguments.  By default
the strictness is maximum.
.PP
``Oops'' indicates a technical
problem, meaning either a bug in \fBftnchek\fP or that its resources have
been exceeded.
.PP
The format of the error messages has been modified from previous
versions for more clarity. The syntax error messages and warnings now
have the filename included along with the line number and column
number.  \fBftnchek\fP now has two different options for the
appearance of these error messages.  If \fB\-novice\fP is in effect,
which is the default,
the messages are very similar in
style to those of the previous version.  (In default style, the filename is
not printed in messages within the body of the program if \fB\-list\fP is in
effect.)  The other style of error messages is selected by the
\fB\-nonovice\fP option.  In this
style, the appearance of the messages is similar to that of the
UNIX \fBlint\fP program.
.PP
\fBftnchek\fP is still blind to some kinds of syntax errors.
The two most important ones are detailed checking of \fCFORMAT\fR statements,
and almost anything to do with control of execution
flow by means of \fCIF\fR, \fCDO\fR,
and \fCGOTO\fR statements: namely correct nesting of control structures,
matching of opening statements such as \fCIF\fR ... \fCTHEN\fR with
closing statements such as \fCENDIF\fR, and the proper use of
statement labels (numbers).  Most compilers will catch these errors.
See the section on Limitations for a more detailed discussion.
.PP
If \fBftnchek\fP gives you a syntax error message when the compiler does
not, it may be because your program contains an extension to
standard Fortran which is accepted by the compiler but not by
\fBftnchek\fP.  (See the section on Extensions.)
On a VAX/VMS system, you can use the compiler option \fC/STANDARD\fR
to cause the compiler to accept only standard Fortran.
On most UNIX or UNIX-like systems, this can be accomplished by
setting the flag \fB\-ansi.\fP
Also, consult the \fCREADME\fR file included in the \fBftnchek\fP
distribution for information on how to control which extensions
\fBftnchek\fP accepts.
.PP

Many of the messages given by \fBftnchek\fP are self-explanatory.
Those that need some additional explanation are listed below in
alphabetical order.

.TP
.I "Common block NAME: data type mismatch at position n"
The \fIn\fP-th variable in the COMMON block differs in data type
in two different declarations of the COMMON block.  By default
(\fB\-common\fP strictness level 3), \fBftnchek\fP is very picky about
COMMON blocks: the variables listed in them must match exactly
by data type and array dimensions.  That is, the legal pair of
declarations in different modules:
.nf
\fC
     COMMON /COM1/ A,B
\fP
.fi
.IP
and
.nf
\fC
    COMMON /COM1/ A(2)
\fP
.fi
.IP
will cause \fBftnchek\fP to give warnings at strictness level 3.  These
two declarations are legal in Fortran since they both declare two real
variables.  At strictness level 1 or 2, no warning would be given in
this example, but the warning would
be given if there were a data type mismatch, for instance, if \fCB\fR
were declared \fCINTEGER\fR.
Controlled by \fB\-common\fP setting.

.TP
.I "Common block NAME has long data type following short data type"
Some compilers require alignment of multi-byte items so that each item
begins at an address that is a multiple of the item size.  Thus if a
short (e.g. single-precision real) item is followed by a long (e.g.
double precision real) item, the latter may not be aligned correctly.
Controlled by \fB\-portability\fP option.

.TP
.I "Common block NAME has mixed character and non-character variables"
The ANSI standard requires that if any variable in a COMMON
block is of type \fCCHARACTER\fR, then all other variables in the
same COMMON block must also be of type \fCCHARACTER\fR.
Controlled by \fB\-f77\fP option.

.TP
.I "Common block NAME: varying length"
For \fB\-common\fP setting level 2, this message means that
a COMMON block is declared to have different numbers of words in two
different subprograms.  A word is the amount of storage occupied by
one integer or real variable.
For \fB\-common\fP setting level 3, it means that the two declarations
have different numbers of variables, where an array of any size is
considered one variable.
This is not
necessarily an error, but it may indicate that a variable is missing
from one of the lists.  Note that according to the Fortran 77 standard,
it is an error for named COMMON blocks (but not blank COMMON) to differ
in number of words in declarations in different modules.
Given for \fB\-common\fP setting 2 or 3.

.TP
.I "Error: Badly formed logical/relational operator or constant"
.TP
.I "Error: Badly formed real constant"
The syntax analyzer has found the start of
one of the special words that begin and
end with a period (e.g. \fC.EQ.\fR), or the start of a numeric constant,
but did not succeed in finding a complete item of that kind.

.TP
.I "Error: cannot be adjustable size in module NAME"
A character variable cannot be declared with a size that is an
asterisk in parentheses unless it is a dummy argument, a parameter, or
the name of the function defined in the module.

.TP
.I "Error: cannot be declared in SAVE statement in module NAME"
Only local variables and common blocks can be declared in a
\fCSAVE\fR statement.

.TP
.I "Error: No path to this statement"
\fBftnchek\fP will detect statements which are ignored or by-passed because
there is no foreseeable route to the statement.  For example, an
unnumbered statement (a statement without a statement label), occurring
immediately after a \fCGOTO\fR
statement, cannot possibly be executed.

.TP
.I "Error: Parse error"
This means that the parser, which analyzes the Fortran
program into expressions,
statements, etc., has been unable to find a valid interpretation for some
portion of a statement in the program.  If your compiler does not report a
syntax error at the same place, the most common explanations are: (1) use of an
extension to ANSI standard Fortran that is not recognized by
\fBftnchek\fP, or (2) the statement requires more lookahead than
\fBftnchek\fP uses (see section on Bugs).
.IP
NOTE: This message means that the affected statement is not interpreted.
Therefore, it is possible that \fBftnchek\fP's
subsequent processing will be in error, if it depends on any matters
affected by this statement (type declarations, etc.).

.TP
.I "Error: Statement out of order."
\fBftnchek\fP will detect statements that are out of the
sequence specified for ANSI standard Fortran 77.  Table 1 illustrates the
allowed sequence of statements in the Fortran language.  Statements which are
out of order are nonetheless interpreted by
\fBftnchek\fP,
to prevent ``cascades'' of error messages.

.IP
.nf
.if n .ne 11
.if t .ne 1.75i
\fC
--------------------------------------------------------
                  |               | implicit
                  |  parameter    |---------------------
                  |               | other specification
        format    |---------------|---------------------
         and      |               | statement-function
        entry     |  data         |---------------------
                  |               | executable
--------------------------------------------------------

                      \fRTable 1\fP
\fP
.fi

.TP
.I "Error: Syntax error"
This is the same as ``Error: Parse error'' (see above).  It is generated
if your version of \fBftnchek\fP was built using the UNIX \fByacc\fP
parser generator rather than GNU \fBbison\fP.

.TP
.I "Identifiers which are not unique in first six chars"
Warns that two identifiers which are longer than 6 characters do not
differ in the first 6 characters.  This is for portability: they may not
be considered distinct by some compilers.
Controlled by \fB\-sixchar\fP option.

.TP
.I "Nonportable usage: argument precision may not be correct for intrinsic function"
The precision of an argument passed to an intrinsic function may be
incorrect on some computers.  Issued when a numeric variable declared
with explicit precision (e.g.  \fCREAL*8 X\fR) is passed to a
specific intrinsic function (e.g. \fCDSQRT(X)\fR).
Controlled by \fB\-portability\fP and \fB\-wordsize\fP.

.TP
.I "Nonportable usage: character constant/variable length exceeds 255"
Some compilers do not support character strings more than 255
characters in length.
Controlled by \fB\-portability\fP.

.TP
.I "Nonportable usage: File contains tabs"
\fBftnchek\fP expands tabs to be equivalent to spaces up to the next column
which is a multiple of 8.  Some compilers treat tabs differently, and
also it is possible that files sent by electronic mail will have the tabs
converted to blanks in some way.  Therefore files containing tabs may not
be compiled correctly after being transferred.  \fBftnchek\fP  does not give
this message if tabs only occur within comments or character constants.
Controlled by \fB\-portability\fP.

.TP
.I "Nonportable usage: non-integer DO loop bounds"
This warning is only given when the \fCDO\fR index and bounds are
non-integer.
Use of non-integer quantities in a \fCDO\fR statement may cause
unexpected errors, or different results on different machines, due to
roundoff effects.
Controlled by \fB\-portability\fP.

.TP
.I "Possibly it is an array which was not declared"
This message is appended to warnings related to
a function invocation or to an argument type
mismatch, for which the possibility exists that what appears to be a
function is actually meant to be an array.  If the programmer forgot to
dimension an array, references to the array will be interpreted as
function invocations.  This message will be suppressed if the name in
question appears in an \fCEXTERNAL\fR or \fCINTRINSIC\fR statement.
Controlled by the \fB\-novice\fP option.

.TP
.I "Possibly misleading appearance: characters past 72 columns"
The program is being processed with the statement field width at its
standard value of 72, and some nonblank characters have been found
past column 72.  In this case,
\fBftnchek\fP is not processing the characters past column 72, and is
notifying the user that the statement may not have the meaning that it
appears to have.  These characters might be intended by the programmer to be
significant, but they will be ignored by the compiler.  (A similar warning
is alternatively given under the \fB\-f77\fP flag if the
\fB\-columns\fP setting is used to increase the statement field width.)
Controlled by \fB\-pretty\fP.

.TP
.I "Possibly misleading appearance: Common block declared in more than one statement"
Such multiple declarations are legal and have the same effect as
a continuation of the original declaration of the block.
This warning is only given if the two declarations are separated by
one or more intervening statements.
Controlled by \fB\-pretty\fP.

.TP
.I "Possibly misleading appearance: Continuation follows comment or blank line"
\fBftnchek\fP  issues this warning message to alert the user that a
continuation of a statement is interspersed with comments, making it easy
to overlook.
Controlled by \fB\-pretty\fP.

.TP
.I "Possibly misleading appearance: Extraneous parentheses"
Warns about parentheses surrounding a variable by itself in an
expression.  When a parenthesized variable is passed as an argument to
a subprogram, it is treated as an expression, not as a variable whose
value can be modified by the called routine.
Controlled by \fB\-pretty\fP.

.TP
.I "Subprogram NAME: argument data type mismatch at position n"
The subprogram's
\fIn\fP-th actual argument (in the \fCCALL\fR or the
usage of a function) differs in datatype or precision from the \fIn\fP-th dummy
argument (in the \fCSUBROUTINE\fR or \fCFUNCTION\fR
declaration).  For instance, if the user defines a
subprogram by
.nf
\fC
     SUBROUTINE SUBA(X)
     REAL X
\fP
.fi
.IP
and elsewhere invokes \fCSUBA\fR by
.nf
\fC
     CALL SUBA(2)
\fP
.fi
.IP
\fBftnchek\fP will detect the error.  The reason here
is that the number 2 is integer, not real.  The user should have said
.nf
\fC
     CALL SUBA(2.0)
\fP
.fi
.IP
When checking an argument which is a subprogram, \fBftnchek\fP must be
able to determine whether it is a function or a subroutine.  The rules
used by \fBftnchek\fP to do this are as follows: If the subprogram,
besides being passed as an actual argument, is also invoked directly
elsewhere in the same module, then its type is determined by that
usage.  If not, then if the name of the subprogram does not appear in
an explicit type declaration, it is assumed to be a subroutine; if it
is explicitly typed it is taken as a function.  Therefore, subroutines
passed as actual arguments need only be declared by an \fCEXTERNAL\fR
statement in the calling module, whereas functions must also be
explicitly typed in order to avoid generating this error message.

Controlled by \fB\-arguments\fP.

.TP
.I "Subprogram NAME: argument arrayness mismatch at position n"
Similar to the preceding situation, but
the subprogram dummy argument differs from the corresponding actual
argument in its number of dimensions or number of elements.
Controlled by \fB\-array\fP together with \fB\-arguments\fP.

.TP
.I "Subprogram NAME: argument mismatch at position n"
A character dummy argument is larger than the corresponding actual
argument, or a Hollerith dummy argument is larger than the
corresponding actual argument.  Controlled by \fB\-arguments\fP.

.TP
.I "Subprogram NAME: argument usage mismatch"
\fBftnchek\fP  detects a possible conflict between the way a subprogram uses
an argument and the way in which the argument is supplied to the
subprogram.  The conflict can be one of two types, as outlined below.

.TP
.if n .ti +3
.if t .ti +.3i
.I "Dummy arg is modified, Actual arg is const or expr"
A dummy argument is an argument as named in a \fCSUBROUTINE\fR or
\fCFUNCTION\fR statement and used within the subprogram.  An actual
argument is an argument as passed to a subroutine or function by the
caller.  \fBftnchek\fP is saying that a dummy argument is modified by
the subprogram, implying that its value is changed in the calling module.
The corresponding actual argument should not be a constant or
expression, but rather a variable or array element which can be
legitimately assigned to.
Given for \fB\-usage\fP setting 1 or 3.

.TP
.if n .ti +3
.if t .ti +.3i
.I "Dummy arg used before set, Actual arg not set"
Here a dummy argument may be used in the subprogram
before having a value assigned to it by the subprogram.  The
corresponding actual argument should have a value assigned to it by the
caller prior to invoking the subprogram.
Given for \fB\-usage\fP setting 1 or 3.
.IP
These warnings are not affected by the \fB\-arguments\fP setting.

.TP
.I "Subprogram NAME invoked inconsistently"
Here the mismatch is between the datatype of the subprogram itself as
used and as defined. For instance, if the user declares
.nf
\fC
     INTEGER FUNCTION COUNT(A)
\fP
.fi
.IP
and invokes \fCCOUNT\fR in another module as
.nf
\fC
     N = COUNT(A)
\fP
.fi
.IP
without declaring its datatype, it will default to real type, based on
the first letter of its name.  The calling module should have included
the declaration
.nf
\fC
     INTEGER COUNT
\fP
.fi
.IP
Given for \fB\-arguments\fP setting 2 or 3.

.TP
.I "Subprogram NAME:  varying length argument lists:"
An inconsistency has been found between the number of dummy arguments
(parameters) a subprogram has and the number of actual arguments given it
in an invocation.
\fBftnchek\fP keeps track of all invocations of subprograms
(\fCCALL\fR
statements and expressions using functions) and compares them with
the definitions of the subprograms elsewhere in the source code.  The
Fortran compiler normally does not catch this type of error.
Given for \fB\-arguments\fP setting 1 or 3.

.TP
.I "Variable not declared.  Type has been implicitly defined"
When printing the symbol table for a module,
\fBftnchek\fP will flag with an asterisk
all identifiers that are not explicitly typed
and will show the datatype that was assigned through implicit typing.
This provides support for users who wish to declare all variables as
is required in Pascal or some other languages.
This message appears only when the \fB\-symtab\fP option is in effect.
Alternatively, use the \fB\-declare\fP flag if you want to get a list of all
undeclared variables.

.TP
.I "Variables declared but never referenced"
Detects any identifiers that were declared in your program but were
never used, either to be assigned a value or to have their value
accessed.  Variables in COMMON are excluded.
Given for \fB\-usage\fP setting 2 or 3.

.TP
.I "Variables set but never used"
\fBftnchek\fP will notify the user when a variable has been assigned a
value, but the variable is not otherwise used in the program.  Usually
this results from an oversight.
Given for \fB\-usage\fP setting 2 or 3.

.TP
.I "Variables used before set"
This message indicates that an identifier is used to compute a value
prior to its initialization.  Such usage may lead to an incorrect value
being computed, since its initial value is not controlled.
Given for \fB\-usage\fP setting 1 or 3.

.TP
.I "Variables may be used before set"
Similar to used before set except that \fBftnchek\fP is not able to
determine its status with certainty.  \fBftnchek\fP assumes a variable
may be used before set if the first usage of the variable occurs prior
in the program text to its assignment.
Given for \fB\-usage\fP setting 1 or 3.

.TP
.I "Warning: DO index is not integer"
This warning is only given when the \fCDO\fR bounds are integer, but
the \fCDO\fR index is not.  It may indicate a failure to declare the
index to be an integer.
Controlled by \fB\-truncation\fP option.

.TP
.I "Warning: integer quotient expr converted to real"
The quotient of two integers results in an integer type result, in
which the fractional part is dropped.  If such an integer expression
involving division is later converted to a real datatype, it may be that
a real type division had been intended.
Controlled by \fB\-truncation\fP option.

.TP
.I "Warning: Integer quotient expr used in exponent"
The quotient of two integers results in an integer type result, in
which the fractional part is dropped.  If such an integer expression
is used as an exponent, it is quite likely that a real type division was
intended.
Controlled by \fB\-truncation\fP option.

.TP
.I "Warning: NAME not set when RETURN encountered"
The way that functions in Fortran return a value is by assigning the
value to the name of the function.  This message indicates that the
function was not assigned a value before the point where a
\fCRETURN\fR statement was found.  Therefore it is possible that the
function could return an undefined value.

.TP
.I "Warning: Nonstandard syntax: adjustable size cannot be concatenated here"
The Fortran 77 Standard forbids concatenating character variables
whose size is an asterisk in parentheses, except in an assignment
statement.   Controlled by \fB\-f77\fP.

.TP
.I "Warning: Nonstandard syntax: characters past 72 columns"
A statement has been read which has nonblank characters past column
72, with the statement field extended
beyond the standard value of 72 columns by the \fB\-col\fP setting.
Standard Fortran ignores all text in those columns, but some compilers do
not.  Thus the program may be treated differently by different compilers.
Controlled by \fB\-f77\fP option and \fB\-columns\fP setting.

.TP
.I "Warning: Possible division by zero"
This message is printed out wherever division is done (except division
by a constant).  Use it to
help locate a runtime division by zero problem.
Controlled by \fB\-division\fP option.

.TP
.I "Warning: real truncated to intg"
\fBftnchek\fP has detected an assignment statement which has a real
expression on the right, but an integer variable on the left.  The
fractional part of the real value will be lost.  If you explicitly
convert the real expression to integer using the \fCINT\fR or
\fCNINT\fR intrinsic function, no warning will be printed.  A similar
message is printed if a double precision expression is assigned to a
single precision variable, etc.
Controlled by \fB\-truncation\fP option.

.TP
.I "Warning: subscript is not integer"
Since array subscripts are normally integer quantities, the use of a
non-integer expression here may signal an error.
Controlled by \fB\-truncation\fP option.

.TP
.I "Warning: Unknown intrinsic function"
This message warns the user that a name declared in an
\fCINTRINSIC\fR statement is unknown to \fBftnchek\fP.  Probably it is
a nonstandard intrinsic function, and so the program will not be
portable.  The function will be treated by \fBftnchek\fP as a
user-defined function.  This warning is not controlled by any
option, since it affects \fBftnchek\fP's analysis of
the program.

.SH "LIMITATIONS AND EXTENSIONS"

\fBftnchek\fP accepts ANSI standard Fortran-77 programs with some minor
limitations and numerous common extensions.
.TP
.B Limitations:
.IP
\fBftnchek\fP uses only one line of lookahead when
analyzing a program into its basic syntactic elements.  If a
particular statement is difficult to identify, it may be handled
improperly if the ambiguity is not resolved on a single line.  This
limitation applies to complex constants except in \fCDATA\fR
statements, and to situations in which a variable name might be
confused with a keyword.  For example, if the variable name
\fCWRITE\fR is used for an array, then a very long
statement assigning a value
to some element of this array could be mistaken as a \fCWRITE\fR
statement if the equals sign is not on the same line as the word
\fCWRITE\fR.
.IP
The dummy arguments in statement functions are treated like ordinary
variables of the program.  That is, their scope is the entire module, not
just the statement function definition.
.IP
The checking of FORMAT statements is lax, tolerating missing separators
(comma, etc.) between format descriptors in places where the Standard
requires them, and allowing \fI.d\fP fields on descriptors that should
not have them.  It does warn under \fB\-f77\fP
about nonstandard descriptor types (like
\fCO\fR), and supported extensions.
.IP
The only checking related to control of execution
flow is a warning about statements that cannot be reached because they
do not have a label and they follow an unconditional transfer.
There is no checking for correct nesting of \fCDO\fR loops or
matching of opening statements such as \fCIF\fR ... \fCTHEN\fR with
closing statements such as \fCENDIF\fR, nor the proper definition and use of
statement labels.  Fortunately, most compilers will catch these errors.
.IP
If a user-supplied subprogram has the same name as one of the
nonstandard intrinsic functions, it must be declared in an
\fCEXTERNAL\fR statement in any routine that invokes it.  Otherwise
it will be subject to the checking normally given to the intrinsic
function.  Since the nonstandard intrinsics are not standard, this
\fCEXTERNAL\fR statement is not required by the Fortran 77 Standard.
See the lists of supported nonstandard intrinsic functions under
Extensions below.
.TP
.B Extensions:
Tabs are permitted, and translated into equivalent blanks which correspond
to tab stops every 8 columns.  The standard does not recognize tabs.
Note that some compilers allow tabs, but treat them differently.
.IP
The VMS version treats a line with an initial tab followed by a nonzero
digit as a continuation line.
.IP
Lower case characters are permitted, and are converted internally to
uppercase except in character strings.  The standard specifies upper case only,
except in comments and strings.
.IP
Hollerith constants are permitted, in accordance with the Fortran 77
Standard, appendix C.  They should not be used in expressions, or confused
with datatype CHARACTER.
.IP
Statements may be longer than 72 columns provided that the setting
\fB\-column\fP
was used to increase the limit.  According to the standard, all
text from columns 73 through 80 is ignored, and no line may be longer
than 80 columns.
.IP
Variable names may be longer than six characters.  The standard specifies
six as the maximum.
.IP
Variable names may contain underscores and dollar signs,
which are treated the same as alphabetic letters.  The default type
for variables beginning with these characters is REAL.
In IMPLICIT type statements specifying a range of characters,
the dollar sign follows Z and is followed by underscore.
.IP
The \fCDO\fR ...  \fCENDDO\fR control structure is permitted.  The
syntax which is recognized is according to either of the following two
forms:
.in +5
\fCDO\fP [\fIlabel\fP [\fC,\fP]] \fIvar\fP \fC=\fP
\fIexpr\fP \fC,\fP \fIexpr\fP [\fC,\fP \fIexpr\fP]
.br
 ...
.br
\fCEND DO\fP
.in -5
or
.in +5
\fCDO\fP [\fIlabel\fP [\fC,\fP]] \fCWHILE (\fP \fIexpr\fP \fC)\fP
.br
 ...
.br
\fCEND DO\fP
.in -5
where square brackets indicate optional elements.
.IP
The \fCACCEPT\fR and \fCTYPE\fR statements (for terminal I/O) are
permitted, with the same syntax as \fCPRINT\fR.
.IP
Statements may have any number of continuation lines.  The standard
allows a maximum of 19.
.IP
Inline comments, beginning with an exclamation mark, are
permitted.
.IP
NAMELIST I/O is supported.  The syntax is the same as in VAX/VMS
or IBM Fortran.
.IP
FORMAT statements can contain a dollar sign to indicate suppression of
carriage-return.
An integer expression enclosed in angle brackets can be used anywhere in a
FORMAT statement where
the Standard allows an integer constant (except for the length of a
Hollerith constant),
to provide a run-time value for a repeat specification or field width.
.IP
The \fCIMPLICIT NONE\fR statement is supported.  The meaning of this
statement is that all variables must have their data types explicitly
declared.  Rather than flag the occurrences of such variables with
syntax error messages, \fBftnchek\fP waits till the end of the module,
and then prints out a list of all undeclared variables,
as it does for the \fB\-declare\fP option.
.IP
Data types \fCINTEGER\fR, \fCREAL\fR, \fCCOMPLEX\fR, and
\fCLOGICAL\fR are allowed to have an optional precision specification in
type declarations.  For instance, \fCREAL*8\fR means an 8-byte
floating point data type.  The \fCREAL*8\fR datatype is not
necessarily considered equivalent to \fCDOUBLE PRECISION\fR,
depending on the \fB\-wordsize\fP setting.
The Fortran 77 standard allows
a length specification only for \fCCHARACTER\fR data.
.IP
\fBftnchek\fP supports the \fCDOUBLE\fR \fCCOMPLEX\fR type
specification for a complex quantity whose real and imaginary parts
are double precision.  Mixed-mode arithmetic involving
single-precision complex with double-precision real data,
prohibited under the Standard, yields a double complex result.
The double complex counterparts of all the standard intrinsic
functions for complex data are included:
.nf
\fC
    DCMPLX    DCONJG    DIMAG     DREAL
    CDABS     CDSQRT    CDEXP     CDLOG     CDSIN     CDCOS
    ZABS      ZSQRT     ZEXP      ZLOG      ZSIN      ZCOS
\fP
.fi
.IP
The following other commonly found nonstandard intrinsic functions are
provided.  All except \fCEXIT\fR are defined in MIL-STD 1753.
.nf
\fC
    BTEST     IAND      IOR       IBSET     IBCLR
    IBITS     IEOR      ISHFT     ISHFTC    NOT
    EXIT
\fP
.fi
.IP
For the UNIX version of \fBftnchek\fP, the following common UNIX
intrinsic functions are provided:
.nf
\fC
    ABORT     AND       GETARG    GETENV    GMTIME
    IARGC     LSHIFT    LTIME     OR        IRAND
    RAND      RSHIFT    SRAND     SYSTEM    TIME
    XOR
\fP
.fi
.IP
Note: there are two common calling sequences for \fCRAND\fR and
\fCIRAND\fR: with
zero arguments or with 1 argument.  By default, \fBftnchek\fP accepts
either form.  If you wish to enforce strict adherence to one form or the other,
you should compile \fBftnchek\fP with one of the
two macros
\fCRAND_NO_ARG\fR or \fCRAND_ONE_ARG\fR
set.
.IP
For the VAX/VMS version of \fBftnchek\fP, the following common VMS
intrinsic functions are provided:
.nf
\fC
    DATE      ERRSNS    IDATE     RAN       SECNDS
    SIZEOF    TIME
\fP
.fi
.IP
Argument checking is not tight for those nonstandard intrinsics
that take arrays or mixed argument types.
.IP
\fBftnchek\fP permits the \fCINCLUDE\fR statement, which causes
inclusion of the text of the given file.  The syntax is
.in +5
\fCINCLUDE '\fP\fIfilename\fP\fC'\fP
.in -5
.IP
When compiled for VMS, \fBftnchek\fP will assume a default
extension of \fI.\|for\fP if no filename extension is given.
Also for compatibility with VMS, the VMS version allows the qualifier
\fC/[NO]LIST\fR
following the filename, to control the listing of the included file.
There is no support for including VMS text modules.
.IP
At this time, in diagnostic output relating to items contained in include
files, the only information about the location of the error
is its location in the include file.
There is no traceback giving the parent file(s).
.IP
\fBftnchek\fP accepts \fCPARAMETER\fR definitions that involve
intrinsic functions
and exponentiation by a non-integer exponent.  Both of these cases are
prohibited by the standard, and will be warned about if the \fB\-f77\fP flag
is set.  If an intrinsic function is a compile-time integer constant,
\fBftnchek\fP will evaluate it.  This allows better checking if the
parameter is used in declaring array sizes.
.IP
The intrinsic functions that are evaluated are:
.nf
\fC
    ABS       IABS      DIM       IDIM      MAX
    MAX0      MIN       MIN0      MOD       SIGN
    ISIGN     LEN       ICHAR     INDEX
\fP
.fi
.IP
The functions of integer arguments are evaluated only if the arguments
are integer constant expressions.  (These may involve integer
constants, parameters, and evaluated intrinsic functions.)  The
function \fCLEN\fR is evaluated if its argument is an expression
involving only character constants and variables whose length is not
adjustable.  The functions \fCICHAR\fR and \fCINDEX\fR are evaluated
only if the arguments are character constants.  \fBftnchek\fP gives a
warning if it needs the value of some intrinsic function that is not
evaluated.
.SH "NEW FEATURES"
Here are the changes from Version 2.6 to Version 2.7:
.TP \w'1.'u+2n
1.
Fixed bugs: to allow statement functions with no arguments; to catch
extra comma in subprogram argument lists; argument of \fCLEN\fR does
not need to have a defined value.
.TP \w'1.'u+2n
2.
Insensitive to blanks as per the Standard.
.TP \w'1.'u+2n
3.
Changed behavior of options:
\fB\-f77\fP controls warnings about
statement out of order
and
COMMON block with mixed character and non-character data;
\fB\-help\fP option now lists patch level and copyright;
\fB\-novice\fP controls appearance of warning messages.
.TP \w'1.'u+2n
4.
Added handling of explicit precision and double complex data type.
\fCREAL*8\fR is no longer synonymous with \fCDOUBLE PRECISION\fR,
depending on the machine wordsize.
Checking length agreement for character data also done properly now.
.TP \w'1.'u+2n
5.
Checking usage status of COMMON blocks and COMMON variables.
.TP \w'1.'u+2n
6.
Improved format of messages.
.TP \w'1.'u+2n
7.
Support for common nonstandard intrinsic functions.
.TP \w'1.'u+2n
8.
New options: \fB\-arguments\fP,
\fB\-crossref\fP, \fB\-reference\fP, \fB\-sort\fP,
\fB\-volatile\fP, \fB\-wordsize\fP,
and \fB\-wrap\fP.
.TP \w'1.'u+2n
9.
Behavior when no top-level non-library modules found, changed
from no cross-checking to complete cross-checking.
.TP \w'1.'u+2n
10.
Added expansion of wildcards for filenames on the command line
to the VMS and MS-DOS versions.
.TP \w'1.'u+2n
11.
Parser is generated by \fBbison\fP.  Formerly \fByacc\fP was used.
.TP \w'1.'u+2n
12.
Made changes to allow the IBM PC version handle larger files.
.PP
Here are the changes from Version 2.5 to Version 2.6:
.TP \w'1.'u+2n
1.
The following bugs in Version 2.5 were fixed:
Overflow of large integer parameter values.
Inline comment character mistaken in difficult contexts.
Unnamed \fCBLOCK DATA\fR modules treated as main programs.
\fCDATA\fR implied-do statements sometimes parsed incorrectly.
Size of variable-dimensioned arrays sometimes calculated incorrectly.
Documented bug number 1 in the previous documentation, which
caused a used-before-set warning if a function modifies an argument, has
been fixed.  The warning is now controlled by the \fB\-pure\fP option.
.TP \w'1.'u+2n
2.
New features:
Support for NAMELIST I/O.
Directories to be searched for include files can be specified.
All keyword pairs are now accepted in both split or single-word form.
\fCPARAMETER\fR definitions may contain intrinsic functions.
Cross-module checking within library files is now limited to modules
in the call tree.
\fCBYTE\fR data type is accepted (treated as INTEGER).
VMS and MS-DOS versions no longer require command-line flags having the ``/''
prefix to be separated by space.
.TP \w'1.'u+2n
3.
New command-line flags added and existing flags modified
for better control of error and warning reporting.  Affected flags are:
.BR \-array ,
.BR \-calltree ,
.BR \-help ,
.BR \-hollerith ,
.BR \-novice ,
.BR \-pretty ,
.BR \-pure ,
.BR \-trunc ,
.BR \-usage ,
and the
.B \-no
prefix to turn functions off.  See documentation sections for full
explanation of these flags.
.TP \w'1.'u+2n
4.
New warnings: if array subscript or DO index is non-integer;
if constant value of 0 results from integer division or exponentiation;
and if data type of expression in logical or arithmetic \fCIF\fR
statement is improper.
The warning of ``variable declared but not used'' is now suppressed when the
declaration is in an include file.
A warning is now given under the \fB\-f77\fP option if the standard
limit of 19 continuation lines is exceeded.
.SH "BUGS"
\fBftnchek\fP  still has much room for improvement.
Your feedback is appreciated.  We want to know about any bugs you notice.
Bugs include not only cases in which \fBftnchek\fP  issues an error message
where no error exists, but also if \fBftnchek\fP fails to issue a warning when
it ought to.  Note, however, that \fBftnchek\fP  is not intended to catch all
syntax errors (see section on Limitations).
Also, it is not considered a bug for a variable to be
reported as used before set, if the reason is that the usage of the
variable occurs prior in the text to where the variable is set.  For
instance, this could occur when a \fCGOTO\fR causes execution to loop backward
to some previously skipped statements.  \fBftnchek\fP  does not analyze the
program flow, but assumes that statements occurring earlier in the text
are executed before the following ones.
.PP
We especially want to know if \fBftnchek\fP  crashes for any reason.  It is
not supposed to crash, even on programs with syntax errors.  Suggestions
are welcomed for additional features which you would find useful.  Tell
us if any of \fBftnchek\fP's
messages are incomprehensible.  Comments on the
readability and accuracy of this document are also welcome.
.PP
You may also suggest support for additional extensions to the
Fortran language.  These will be included only if it is felt that the
extensions are sufficiently widely accepted by compilers.
.PP
If you find a bug in \fBftnchek\fP,
first consult the list of known bugs
below to see if it has already been reported.  Also check the section
entitled ``Limitations and Extensions'' above for restrictions
that could be causing the problem.  If you do not find the problem
documented in either place, then send a report including
.TP \w'1.'u+2n
1.
The operating system and CPU type on which \fBftnchek\fP  is running.
.TP \w'1.'u+2n
2.
The version of \fBftnchek\fP.
.TP \w'1.'u+2n
3.
A brief description of the bug.
.TP \w'1.'u+2n
4.
If possible, a small sample program showing the bug.
.PP
.br
The report should be sent to either of the following addresses:
.PP
.nf
\fC
      MONIOT@FORDMULC.BITNET
      moniot@mary.fordham.edu
\fP
.fi
.IP
.PP
Highest priority will be given to bugs which cause \fBftnchek\fP  to crash.
Bugs involving incorrect warnings or error messages may take longer to fix.
.PP
Certain problems that arise when checking large programs can be fixed
by increasing the sizes of the data areas in \fBftnchek\fP.  (These
problems are generally signaled by error messages beginning with ``Oops''.)
The simplest way to increase the table sizes is by
recompiling \fBftnchek\fP with the \fCLARGE_MACHINE\fR macro name
defined.  Consult the \fCmakefile\fR and \fCREADME\fR file for the
method of doing this.
.PP
 The following is a list of known bugs.
.TP \w'1.'u+2n
1.
Bug: Used-before-set message is suppressed for any variable which
is used as the loop index in an implied-do loop, even if it was in
fact used before being set in some earlier statement.
For example, consider \fCJ\fR in the statement
.IP
.nf
\fC
      WRITE(5,*) (A(J), J=1,10)
\fP
.fi
.IP
.IP
Here \fBftnchek\fP parses the I/O expression,
\fCA(J)\fR, where \fCJ\fR is used, before it parses the implied loop
where \fCJ\fR is set.  Normally this would cause
\fBftnchek\fP to report a spurious used-before-set warning for \fCJ\fR.
Since this report is usually in error and occurs fairly commonly,
\fBftnchek\fP  suppresses the warning for \fCJ\fR altogether.
.IP
Prognosis: A future version of  \fBftnchek\fP  is planned which will handle
implied-do loops correctly.
.TP \w'1.'u+2n
2.
Bug: Variables used (not as arguments) in statement-function
subprograms do not have their usage status updated when the statement
function is invoked.
.IP
Prognosis: To be fixed in a future version of \fBftnchek\fP.
.TP \w'1.'u+2n
3.
Bug: VAX version does not expand wildcards in filenames on the
command line if they are followed without space by an option, e.g.
\fCftnchek *.f/calltree\fR would not expand the \fC*.f\fR.
This is because VMS-style options without intervening
space are not supported by the GNU \fCshell_mung\fR routine that is used
to expand wildcards.
.IP
Prognosis: unlikely to be fixed.

.SH "ACKNOWLEDGEMENTS"
\fBftnchek\fP is a public-domain program.  It
was designed by Dr. Robert Moniot, professor at Fordham
University, College at Lincoln Center.  During the academic year of
1988-1989, Michael Myers and Lucia Spagnuolo developed the program to
perform the variable usage checks.  During the following year it was
augmented by Lois Bigbie to check subprogram arguments and
COMMON block
declarations.  Brian Downing assisted with the implementation of the
\fCINCLUDE\fR statement.  John Quinn wrote the common block usage checks.
Additional features will be added as time permits.
With Version 2.5, the name was changed from \fBforchek\fP to \fBftnchek\fP,
to avoid confusion with a
similar program named \fBforcheck\fP,
developed earlier at Leiden University.
.PP
We would like to thank
John Amor of the University of British Columbia,
Reg Clemens of the Air Force Phillips Lab in Albuquerque,
Markus Draxler of the University of Stuttgart,
Victor Eijkhout of the University of Tennessee at Knoxville,
Greg Flint of Purdue University,
Daniel P. Giesy of NASA Langley Research Center,
Fritz Keinert of Iowa State University,
Judah Milgram of the University of Maryland College Park,
Hugh Nicholas of the Pittsburgh Supercomputing Center,
Dan Severance of Yale University,
Phil Sterne of Lawrence Livermore National Laboratory,
Larry Weissman of the University of Washington,
Warren J. Wiscombe of NASA Goddard,
and especially
Nelson H. F. Beebe of the University of Utah,
for pointing out bugs and suggesting some improvements.
We also thank Jack Dongarra for putting
\fBftnchek\fP  into the \fCnetlib\fR
library of publicly available software,
and Lee Rimar of Absoft Corporation for providing an executable
version for Macintosh.
The \fB\-reference\fP feature was
contributed by Gerome Emmanuel, Ecole des mines, U. Nancy
(slightly modified).
.SH "INSTALLATION AND SUPPORT"
The
\fBftnchek\fP  program can be obtained
by anonymous ftp from many software servers, including host
\fCresearch.att.com\fR
(192.20.225.2) where it is located in directory
\fC/netlib/fortran\fR.
It can also be obtained via electronic mail
by sending the message:
``\fCsend ftnchek from fortran\fR''
to the Internet address: \fCnetlib@ornl.gov\fR.

Installation requires a C compiler for your computer.
Executable binary in ZIP format
for IBM PC computers under MS-DOS is available by
anonymous ftp from \fCwuarchive.wustl.edu\fR
(128.252.135.4) where it is located in directory
\fC/mirrors/msdos/fortran\fR, filename \fCftnchk27.zip\fR.
Executable binary in stuffit format for Macintosh computers is also
available from the same archive, in directory
\fC/mirrors/macintosh/lang\fR, filename \fCftnchk27.sit\fR.
.PP
\fBftnchek\fP has a number of fixed internal parameters that affect its
operation, such as the symbol table sizes and support for various
extensions and particular operating systems.  They are
implemented as C language macro names.  If you wish to change a
parameter defined by one of these macros, it is necessary to recompile
\fBftnchek\fP with the macro definition changed to the desired value.  See
the \fCREADME\fR file for a list of these macro names and instructions for
defining them according to your preferences.
.PP
This document is named
.IR ftnchek.man .
On UNIX systems,
you can print it using the command \fCnroff -man ftnchek.man | lpr\fR.
The distribution also includes a PostScript version of this document named
.I ftnchek.ps
which can be printed directly on any PostScript printer.
.PP
.PP
For further information and to report bugs, you may contact Dr. Robert Moniot
at either of the following network addresses:
.PP
.nf
\fC
      MONIOT@FORDMULC.BITNET
      moniot@mary.fordham.edu
\fP
.fi
.IP
.PP
.\"==============================[The End]==============================


