
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "magic.h"

 void
 main (int argc, char **argv) {

   int    bToDOS, ch, i;

   FILE  *hIn,
         *hOut;


   if (argc < 3  ||  argc > 4) {
     print_help (argv[0]);
     exit(1);
     }

   bToDOS = 1;
   i = 1;

   if (strcmp(argv[1], "/x") == 0  ||
       strcmp(argv[1], "/X") == 0) {
     bToDOS = 0;
     i = 2;
     }

   hIn = fopen(argv[i], "rb");
   if ( !hIn ) {
     printf("\n can't open %s\n", argv[i]);
     exit(1);
     }

   hOut = fopen(argv[i+1], "wb");
   if ( !hOut ) {
     printf("\n can't open %s\n", argv[i+1]);
     exit(1);
     }

   if ( bToDOS ) {
     for ( ; ; ) {
       ch = fgetc(hIn);
       if (ch == -1)
         break;
       if (ch == '\n')
         fputc('\r', hOut);
       fputc(ch, hOut);
       }
     }

   else {
     for ( ; ; ) {
       ch = fgetc(hIn);
       if (ch == -1)
         break;
       if (ch == '\r') {
         ch = fgetc(hIn);
         if (ch != '\n')
           fputc('\r', hOut);
         }
       fputc(ch, hOut);
       }
     }

   fclose(hIn);
   fclose(hOut);
  
   exit(1);
   }

static void print_help (char *program) {
     printf("\n usage:  %s  [/x] infile outfile\n\n", program);
     printf("  Converts between UNIX- and DOS-style EOL's.\n");
     printf("  By default, <infile> is assumed to be a UNIX file;\n");
     printf("  as it is copied to <outfile>, each \\n character\n");
     printf("  is replaced by a \\r\\n character pair.\n");
     printf("  \n");
     printf("  If the  /x  (\"eXport\") switch is used, <infile> is\n");
     printf("  assumed to be a DOS file; as it is copied to <outfile>,\n");
     printf("  each  \\r\\n sequence is replaced by a \\n character.\n");
     printf("  \n");
     printf("  *** If used, /x MUST be the first argument ***\n");
     printf("  \n");
     printf("  \n");
 }
 