'
' Compiler Statements 
'
$COMPILE  MEMORY           ' { EXE "?.EXE" | CHAIN "?.PBC" | UNIT "?.PBU" }
$CPU       80386           ' { 8086 | 80286 | 80386}
$COM           0           ' { 0 -> 32767 }
$SOUND       128           ' { 1 -> 4096 }
$STACK     32766           ' { 1536 -> 32766 }
$STRING       32           ' { 1 | 2 | 4 | 8 | 16 | 32 }
$OPTIMIZE SIZE             ' { SIZE | SPEED }
$DIM      ARRAY            ' { ALL | ARRAY | NONE }
$DYNAMIC                   ' { $STATIC | $DYNAMIC | $HUGE }
$ERROR    BOUNDS     OFF   ' { ON | + | OFF | - }
$ERROR    NUMERIC    OFF   ' { ON | + | OFF | - }
$ERROR    OVERFLOW   OFF   ' { ON | + | OFF | - }
$ERROR    PARAM      OFF   ' { ON | + | OFF | - }
$ERROR    STACK      OFF   ' { ON | + | OFF | - }
$EVENT               OFF   ' { ON | + | OFF | - }
$DEBUG    MAP        OFF   ' { ON | + | OFF | - }
$DEBUG    PBDEBUG    OFF   ' { ON | + | OFF | - }
$DEBUG    PATH       OFF   ' { ON | + | OFF | - }
$DEBUG    UNIT       OFF   ' { ON | + | OFF | - }
$OPTION   CNTLBREAK  OFF   ' { ON | + | OFF | - }
$OPTION   GOSUB      OFF   ' { ON | + | OFF | - }
$LIB      COM        OFF   ' { ON | + | OFF | - }
$LIB      LPT        OFF   ' { ON | + | OFF | - }
$LIB      GRAPH      OFF   ' { ON | + | OFF | - }
$LIB      CGA        OFF   ' { ON | + | OFF | - }
$LIB      EGA        OFF   ' { ON | + | OFF | - }
$LIB      VGA        OFF   ' { ON | + | OFF | - }
$LIB      HERC       OFF   ' { ON | + | OFF | - }
$LIB      FULLFLOAT  OFF   ' { ON | + | OFF | - }
$LIB      IPRINT     OFF   ' { ON | + | OFF | - }
$LIB      ALL        OFF   ' { ON | + | OFF | - }
$FLOAT    EMULATE          ' { EMULATE | NPX | PROCEDURE }

%UseMouse =  0             ' change this to -1 for mouse support

'
' Include Statements 
'
$INCLUDE "PUBLICS .INC"    ' all public statements               <Ŀ
$INCLUDE "DAS-NB01.INC"    ' nutz 'n boltz #1                       matched
$INCLUDE "DAS-NB02.INC"    ' nutz 'n boltz #2                       pair
$INCLUDE "DAS-NB03.INC"    ' math package, sound & tunes         <
''
$if %UseMouse              '
  $INCLUDE "DAS-NBT0.INC"  ' general purpose printing WITH MOUSE <Ŀ either
$else                      '                                        
  $INCLUDE "DAS-NBT1.INC"  ' general purpose printing NO MOUSE   < or
$endif                     '
$INCLUDE "DAS-NBT2.INC"    ' Tinput and family
$INCLUDE "DAS-NBT3.INC"    ' menu routines
$INCLUDE "DAS-NBT4.INC"    ' screen clearing & copiing
'
' Set-up Functions 
'
PUBLIC pProgPath$          ' program's home path
PUBLIC pCollate$           ' CountryCode's collate string for ARRAY SORT

IF pbvCPU < 3 THEN
  CLS
  PRINT "CAN'T RUN THIS PROGRAM ON LESS THAN A 386"
  END
END IF

pProgPath$ = fProgPath$

DIM tCC AS CountryCodeType
LSET tCC = fGetCountry$( 0 )
IF tCC.CountryCode > 0 THEN
  SetDateFormat tCC.DateFormat, tCC.DateSep
  SetTimeFormat tCC.TimeFormat, tCC.TimeSep
  CHR2MID pbvUSINGchrs, 3, tCC.ThousandSep
  CHR2MID pbvUSINGchrs, 4, tCC.DecimalSep
  SetMoneyMask tCC.MoneySymbol, tCC.MoneyFormat, tCC.MoneyDecs
  pCollate$ = fGetCollate$
END IF

HelpLineSetup 25, 14, 67, 47

SetINSERTmsg  " INSERT ON  ", " INSERT OFF ", 25, 1

DIM tYesNo AS SHARED YesNoTYPE
  tYesNo.YesKey   = "Y"                 ' fUCASEdos$ is used here
  tYesNo.YesText  = "<Y>es"             ' <YES> answer (17 chars max)
  tYesNo.YesAttr  =  47                 ' color attribute for <YES>
  tYesNo.NoKey    = "N"                 ' fUCASEdos$ is used here too
  tYesNo.NoText   = "<N>o"              ' <NO> answer (17 chars max)
  tYesNo.NoAttr   =  79                 ' color attribute for <NO>
  tYesNo.OffAttr  = 120                 ' "OFF" attribute
  tYesNo.ShdoFore =   0                 ' shadow foreground color if < 16

$if %UseMouse
  Buttons? = fMouseSETUP?( 2 )              ' left & right buttons only
  EventSetup 10, 200                        ' we'll use events

  FUNCTION fGetKey% () LOCAL PUBLIC

    DO
      IF INSTAT THEN
        FUNCTION = CVI( INKEY$ + CHR$(0) )
        EXIT FUNCTION
      END IF
    LOOP UNTIL fMouseBUTTON% <> 0

  END FUNCTION
$else
  FUNCTION fGetKey% () LOCAL PUBLIC

    WHILE NOT INSTAT : WEND
    FUNCTION = CVI( INKEY$ + CHR$(0) )

  END FUNCTION
$endif

'
' Program Code 
'


'
' End Program 
'

ByeBye:
  SCREEN 0,,0,0         ' back to text mode
  WIDTH  80,25          ' 80x25 screen
  COLOR  7,0,0          ' normal DOS colors
  LOCATE ,,1            ' cursor on
  CLS                   '
  END                   '


