1 REM POKER SQUARES
2 REM Version 1.0
3 REM Copyright David M. Gottlieb, 1988
100 DIM SHARED DECK%(52),TEMP%(52),A$(15),PLAYER$(10),SCORE(10),BOARD%(5,5,2)
110 DIM SHARED STABLE%(10,2),HAND%(5,2),ACROSS%(5),DOWN%(5),NSPOT%(14),LASTSCORE(10)
120 DIM SHARED STEMP(10,2)
200 DATA 1,2,4,6,8,10,12,15,20,30,1,2,4,10,6,8,12,18,20,30
210 FOR I=1 TO 2
220   FOR J=1 TO 10
230     READ STABLE%(J,I)
240   NEXT J
250 NEXT I
990 REM END
10000 REM <DRIVER> Driver for poker squares
10010 RANDOMIZE TIMER
10020 GOSUB 21000
10030 CLS
10040 GOSUB 19000
10050 IF IFEND=1 THEN 10980
10060 IF NEWGAME=0 THEN 10110
10070 GOSUB 18000
10080 IF IFQUIT=1 OR NPLAYER=0 THEN 10980
10090 IF TYPEGAME=1 OR TYPEGAME=5 THEN
10092   GOSUB 17000
10094 ELSE
10096   GOSUB 13000
10098 END IF
10100 GOSUB 17200
10110 GOSUB 11000
10120 IF IFFINISHED=1 THEN
10130   A$(1)="Play another game like this one"
10140   A$(2)="Change the game and play again"
10150   A$(3)="Quit"
10160   NA=3:TX$="What do you want to do now?"
10170   CSTART=1
10180   CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(1!))
10190   IF CHOICE=3 THEN 10980
10200   IF CHOICE=2 THEN 10030
10210   FOR I=1 TO 10:SCORE(I)=0:LASTSCORE(I)=0:NEXT I
10220   PLAYERUP=1:ROUND=1
10230   FOR I=1 TO 5
10240     FOR J=1 TO 5
10250       BOARD%(I,J,1)=0:BOARD%(I,J,2)=0
10260     NEXT J
10270   NEXT I
10275   IF TYPEGAME>1 AND TYPEGAME<5 THEN GOSUB 13000
10280   CLS
10290   CALL SHUFFLE(DECK%(),TEMP%())
10300   DECKPTR=1
10302   SCORESOFAR=0:BONUSSOFAR=0
10304   FOR I=1 TO 5:ACROSS%(I)=0:DOWN%(I)=0:NEXT I
10310   GOTO 10110
10320 ELSE
10330   A$(1)="Yes":A$(2)="No":TX$="Do you want to save this game?":CSTART=1:NA=2
10340   CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(2!))
10350   IF CHOICE=2 THEN 10130
10360   COLOR 1,3,1:CLS
10362   IF NEWGAME=0 THEN
10363     SAVENAME$=OLDNAME$
10364     LOCATE 8,30:PRINT "Saving to "+SAVENAME$
10365     GOTO 10530
10366   END IF
10370   LOCATE 3,3:PRINT "Input the name you want to save this under."
10380   LOCATE 4,3:PRINT "The name can be no longer than eight characters, and can
10390   LOCATE 5,3:PRINT "  contain only letters and numbers"
10400   LOCATE 7,3:INPUT SAVENAME$
10410   LENSV=LEN(SAVENAME$)
10420   IF LENSV=0 THEN 10330
10430   IF SAVENAME$=SPACE$(LENSV) THEN 10330
10440   FOR I=1 TO LENSV
10450     IF MID$(SAVENAME$,I,1)<>" " THEN 10470
10460   NEXT I
10470   SAVENAME$=MID$(SAVENAME$,I,LENSV-I+1)
10480   LENSV=LEN(SAVENAME$)
10490   FOR I=LENSV TO 1 STEP -1
10500     IF MID$(SAVENAME$,I,1)<>" " THEN 10520
10510   NEXT I
10520   SAVENAME$=LEFT$(SAVENAME$,I)+".GDF"
10530   OPEN SAVENAME$ FOR APPEND AS #1
10540   IF LOF(1)>0 THEN
10550     TX$="This name is already used.  Do you want to re-use it?"
10560     CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(3!))
10570     IF CHOICE=2 THEN 10330
10580   END IF
10590   CLOSE #1
10600   OPEN SAVENAME$ FOR OUTPUT AS #1
10610   BUF$=SPACE$(15)
10620   MID$(BUF$,1,1)=CHR$(TYPEGAME+48)
10630   MID$(BUF$,2,2)=RIGHT$(STR$(NPLAYER),2)
10640   MID$(BUF$,4,6)=CHR$(DEUCES+48)+CHR$(EXTRA+48)+CHR$(PEEKABOO+48)+CHR$(IFBONUS+48)+CHR$(SCORETABLE+48)+CHR$(PLAYERUP+48)
10650   MID$(BUF$,10,2)=RIGHT$(STR$(DECKPTR),2)
10655   MID$(BUF$,12,2)=CHR$(ROUND+48)+CHR$(48+TAKEOVER)
10656   MID$(BUF$,14,2)=CHR$(LASTPLACEX+48)+CHR$(LASTPLACEY+48)
10660   PRINT#1,BUF$
10670   BUF$=SPACE$(80)+"."
10680   FOR I=1 TO NPLAYER
10690     MID$(BUF$,I*8-7,8)=PLAYER$(I)
10700   NEXT I
10710   PRINT#1,BUF$
10720   BUF$=SPACE$(100)
10730   FOR I=1 TO NPLAYER
10740     MID$(BUF$,I*5-4,5)=RIGHT$("     "+STR$(SCORE(I)),5)
10745     MID$(BUF$,I*5+46,5)=RIGHT$("     "+STR$(LASTSCORE(I)),5)
10750   NEXT I
10760   PRINT#1,BUF$
10770   BUF$=SPACE$(75)
10780   FOR I=1 TO 5
10782     FOR J=1 TO 5
10784       MID$(BUF$,I*15+J*3-17,1)=CHR$(BOARD%(I,J,1)+48)
10786       MID$(BUF$,I*15+J*3-16,2)=RIGHT$(STR$(BOARD%(I,J,2)),2)
10788     NEXT J
10790   NEXT I
10800   PRINT#1,BUF$
10810   BUF$=SPACE$(156)
10820   FOR I=1 TO 52
10830     MID$(BUF$,I*3-2,3)=RIGHT$("  "+STR$(DECK%(I)),3)
10840   NEXT I
10850   PRINT#1,BUF$
10860   CLOSE#1
10870   GOTO 10130
10880 END IF
10980 GOSUB 12500
10982 COLOR 1,3,1:CLS
10985 SYSTEM
10990 END
11000 REM <GAMEDRIVER> Driver for play of game
11001 REM Output IFFINISHED (0..no,1..yes)
11010 IFFINISHED=1
11011 PEEKON=0
11012 BACKCOLOR1%=4:BACKCOLOR2%=7
11014 IF NEWGAME=1 THEN LASTPLACEX=0
11015 IF NEWGAME=1 THEN CALL SHUFFLE(DECK%(),TEMP%())
11020 GOSUB 16500
11030 IF NEWGAME=0 THEN GOSUB 16200
11040 COLOR 1,3,1
11055 MUSTEMPTY=1
11060 GOSUB 16000
11070 IF DEUCES=1 THEN
11090   CALL DECODECARD(VHERE,SUIT,SPOT)
11100   IF SPOT=2 THEN
11110     GOSUB 15500
11115     IF IFTAKEOVER=1 THEN GOSUB 24000:GOTO 11160
11120     VHERE=100*SUIT+SPOT
11130   END IF
11140 END IF
11150 GOSUB 15000
11160 IF IFINT=1 AND DECKPTR<26+EXTRA THEN
11170   COLOR 1,3,1:CLS
11180   DECKPTR=DECKPTR-1
11190   IFFINISHED=0:GOTO 11990
11200 END IF
11210 GOSUB 14000
11220 IF DECKPTR<26+EXTRA THEN
11230   IF DECKPTR>25 THEN MUSTEMPTY=0
11232   IF DECKPTR=26 THEN
11233     COLOR 1,3:LOCATE 12,61:PRINT SPACE$(18)
11234     GOSUB 12300
11235   END IF
11240   GOTO 11060
11250 END IF
11252 LOCATE 22,41:COLOR 12,3:PRINT "               GAME OVER              "
11253 LOCATE 23,41:COLOR 15,3:PRINT "      Press any key to continue.      "
11254 LOCATE 24,41:COLOR 15,3:PRINT "                                      ";
11255 YY$=INKEY$:IF LEN(YY$)<>0 THEN 11255
11256 YY$=INKEY$:IF LEN(YY$)=0 THEN 11256
11260 LASTSCORE(PLAYERUP)=(SCORESOFAR+BONUSSOFAR)*TIMESSCORE
11270 SCORE(PLAYERUP)=SCORE(PLAYERUP)+LASTSCORE(PLAYERUP)
11280 GOSUB 13500
11290 IF IFFINISHED=0 THEN 11990
11300 GOSUB 12000
11310 IF IFNOMORE=1 THEN 11990
11320 GOTO 11020
11990 RETURN
12000 REM <NEXTGAME> Prepares for next game
12010 COLOR 1,3,1:CLS:IFNOMORE=0
12020 IF TYPEGAME<>5 THEN
12022   CALL SHUFFLE(DECK%(),TEMP%())
12024 END IF
12026 DECKPTR=1
12030 IF BACKCOLOR1%=4 THEN BACKCOLOR1%=7:BACKCOLOR2%=1:GOTO 12040
12035 BACKCOLOR1%=4:BACKCOLOR2%=7
12040 NEWGAME=1
12050 IF PLAYERUP=NPLAYER THEN
12060   IF TYPEGAME=1 OR TYPEGAME=5 THEN IFNOMORE=1:GOTO 12290
12070   LASTROUND=2*TYPEGAME-1
12080   IF ROUND=LASTROUND THEN IFNOMORE=1:GOTO 12290
12090   PLAYERUP=1
12100   ROUND=ROUND+1
12110   FOR I=1 TO NPLAYER:LASTSCORE(I)=0:NEXT I
12120 ELSE
12130   PLAYERUP=PLAYERUP+1
12140 END IF
12145 IF TYPEGAME>1 AND TYPEGAME<5 THEN GOSUB 13000
12150 FOR I=1 TO 5
12160   FOR J=1 TO 5
12170     BOARD%(I,J,1)=0:BOARD%(I,J,2)=0
12180   NEXT J
12190 NEXT I
12200 SCORESOFAR=0:BONUSSOFAR=0
12210 FOR I=1 TO 5:ACROSS%(I)=0:DOWN%(I)=0:NEXT I
12290 RETURN
12300 REM <BLINK> Blinks extra card line
12370 FOR I=1 TO 3
12380   COLOR 12,1:LOCATE 11,14:PRINT " EXTRA CARDS "
12390   CALL WAITE((1!))
12400   COLOR 1,3:LOCATE 11,14:PRINT "             "
12410   CALL WAITE((1!))
12420 NEXT I
12490 RETURN
12500 REM <FINALSCREEN> Puts up final screen
12502 GOSUB 12800
12503 COLOR 12,1
12504 LOCATE 25,60:PRINT "Press any old key.";
12510 YY$=INKEY$:IF LEN(YY$)<>0 THEN 12510
12512 FCL=15
12520 COLOR FCL,1
12530 LOCATE 3,3:PRINT "We hope you"
12540 LOCATE 5,3:PRINT "enjoyed ----->"
12550 LOCATE 19,3:PRINT "For a catalog of other games and useful programs (all cheap, or even"
12560 LOCATE 20,3:PRINT "free), write to us or phone 602-945-6833."
12570 FCL=FCL+1:IF FCL>15 THEN FCL=10
12575 IF FCL=11 THEN FCL=12
12576 COLOR FCL,1
12577 CALL WAITE((2!))
12580 LOCATE 22,25:PRINT "INNOVATIONS IN COMPUTING, INC."
12590 LOCATE 23,28:PRINT "4841 N. Scottsdale Road"
12600 LOCATE 24,29:PRINT "Scottsdale, AZ  85251";
12610 FCL=FCL+1:IF FCL>15 THEN FCL=10
12620 IF FCL=11 THEN FCL=12
12625 COLOR FCL,1
12630 CALL WAITE((1!))
12645 TIMECHK=TIMER+3
12650 YY$=INKEY$
12655 IF LEN(YY$)=0 THEN
12660   IF TIMER<TIMECHK THEN 12650
12670   GOTO 12520
12680 END IF
12790 RETURN
12800 REM <POKERSQUARES> Puts up POKER SQUARES
12810 CLS
12815 OPEN "FIRSTSCR.DAT" FOR INPUT AS #1
12820 COLOR 3,1,1
12825 CLS
12830 FOR I=1 TO 12
12835   LINE INPUT#1,BUF$
12840   XSTART=VAL(MID$(BUF$,1,3))
12845   YSTART=VAL(MID$(BUF$,4,3))
12850   KOLOR=INT(RND*5)+11
12855   IF KOLOR<12 THEN KOLOR=10
12860   IF KOLOR>15 THEN KOLOR=15
12865   COLOR KOLOR,1
12870   FOR J=1 TO 5
12875     PBUF$=""
12880     FOR K=0 TO 5
12885       IF MID$(BUF$,J*6+K+1,1)="1" THEN
12890         PBUF$=PBUF$+CHR$(219)
12895       ELSE
12900         PBUF$=PBUF$+" "
12905       END IF
12910     NEXT K
12915     LOCATE YSTART+J-1,XSTART
12920     PRINT PBUF$
12925   NEXT J
12930 NEXT I
12935 CLOSE #1
12940 COLOR 3,1
12990 RETURN
13000 REM <COMPUTEFEATURES> Computes features for a round
13010 TIMESSCORE=1
13020 IF TYPEGAME=2 AND ROUND=3 THEN TIMESSCORE=2
13030 IF TYPEGAME=3 AND (ROUND=3 OR ROUND=5) THEN TIMESSCORE=2
13040 IF TYPEGAME=4 AND (ROUND=4 OR ROUND=7) THEN TIMESSCORE=2
13050 DEUCES=0
13060 IF TYPEGAME=2 AND ROUND>1 THEN DEUCES=1
13070 IF TYPEGAME=3 AND (ROUND=2 OR ROUND=4 OR ROUND=5) THEN DEUCES=1
13080 IF TYPEGAME=4 AND (ROUND=2 OR ROUND=3 OR ROUND>5) THEN DEUCES=1
13090 PEEKABOO=0
13100 IF TYPEGAME=3 AND ROUND=3 THEN PEEKABOO=3
13110 IF TYPEGAME=4 AND (ROUND=2 OR ROUND=5) THEN PEEKABOO=3
13120 EXTRA=0
13130 IF ROUND=1 THEN EXTRA=2
13140 IF TYPEGAME=2 AND ROUND=3 THEN EXTRA=3
13150 IF TYPEGAME=3 AND ROUND=4 THEN EXTRA=3
13160 IF TYPEGAME=3 AND ROUND=5 THEN EXTRA=3
13170 IF TYPEGAME=4 AND ROUND=3 THEN EXTRA=2
13180 IF TYPEGAME=4 AND ROUND=6 THEN EXTRA=3
13190 IF TYPEGAME=4 AND ROUND=7 THEN EXTRA=3
13200 IFBONUS=1
13490 RETURN
13500 REM <SCORESCREEN> Puts up score screen
13510 COLOR 1,1,1:CLS
13520 COLOR 15,1
13530 LOCATE 1,1:PRINT CHR$(201)+STRING$(35,CHR$(205))+CHR$(181)+"      "+CHR$(198)+STRING$(35,CHR$(205))+CHR$(187)
13532 FOR I=2 TO 23
13534   LOCATE I,1:PRINT CHR$(186):LOCATE I,80:PRINT CHR$(186)
13536 NEXT I
13540 LOCATE 24,1:PRINT CHR$(200)+STRING$(78,CHR$(205))+CHR$(188);
13550 COLOR 11,1:LOCATE 1,38:PRINT "SCORES"
13560 IF TYPEGAME=1 THEN CHK$="SINGLE ROUND PLAY"
13562 IF TYPEGAME=5 THEN CHK$="DUPLICATE PLAY"
13564 IF TYPEGAME=2 OR TYPEGAME=3 OR TYPEGAME=4 THEN
13566   CHK$="ROUND    IN  -ROUND TOURNAMENT"
13568   MID$(CHK$,7,1)=CHR$(ROUND+48)
13570   MID$(CHK$,13,1)=CHR$(2*TYPEGAME+47)
13572 END IF
13574 LCHK=LEN(CHK$)
13580 COLOR 3,1
13585 TOSKIP=41-INT(LCHK/2)
13590 LOCATE 3,TOSKIP:PRINT CHK$
13600 COLOR 15,1:LOCATE 5,3:PRINT "PLAYER    SCORE"
13605 IF TYPEGAME>1 AND TYPEGAME<5 THEN LOCATE 5,22:PRINT "TOTAL SO FAR"
13610 IF NPLAYER>1 THEN
13620   FOR I=1 TO NPLAYER:STEMP(I,1)=SCORE(I):STEMP(I,2)=I:NEXT I
13630   FOR I=1 TO NPLAYER-1
13640     FOR J=I+1 TO NPLAYER
13650       IF STEMP(I,1)<STEMP(J,1) THEN
13660         SWAP STEMP(I,1),STEMP(J,1)
13670         SWAP STEMP(I,2),STEMP(J,2)
13680       END IF
13682     NEXT J
13684   NEXT I
13686 ELSE
13688   STEMP(1,2)=1
13690 END IF
13700 FOR I=1 TO NPLAYER
13705   J=STEMP(I,2)
13710   COLOR 11,1:LOCATE I+5,3:PRINT PLAYER$(J)
13720   COLOR 10,1:LOCATE I+5,14:PRINT RIGHT$("   "+STR$(LASTSCORE(J)),3)
13730   IF TYPEGAME>1 AND TYPEGAME<5 THEN
13740     COLOR 14,1:LOCATE I+5,26:PRINT RIGHT$("    "+STR$(SCORE(J)),4)
13745   END IF
13750 NEXT I
13760 COLOR 3,1
13770 LOCATE 18,3:PRINT "Press  Enter  to continue."
13780 LOCATE 19,3:PRINT "Press  Esc  to stop this game."
13785 LOCATE 20,3:PRINT "Press  R  to remove a player."
13790 YY$=INKEY$:IF LEN(YY$)<>0 THEN 13790
13800 YY$=INKEY$:IF LEN(YY$)<>1 THEN 13800
13802 IF YY$="R" OR YY$="r" THEN GOSUB 23000:GOTO 13510
13810 IF ASC(YY$)=13 THEN 13990
13820 IF ASC(YY$)=27 THEN IFFINISHED=0:GOTO 13990
13830 SOUND 500,.5:GOTO 13800
13990 RETURN
14000 REM <UPSCORES> Updates scores
14001 REM Input VHERE,XCURS,YCURS
14010 SCORESOFAR=0
14020 ACROSS%(YCURS)=0
14030 FOR J=1 TO 5
14040   IF BOARD%(J,YCURS,1)=0 THEN 14110
14050   HAND%(J,1)=BOARD%(J,YCURS,1):HAND%(J,2)=BOARD%(J,YCURS,2)
14060 NEXT J
14070 CALL EVAL(HAND%(),NSPOT%(),EVALUATION)
14080 IF EVALUATION=0 THEN PTS=0:GOTO 14100
14090 PTS=STABLE%(EVALUATION,SCORETABLE)
14100 CALL DISPLAYS(PTS,YCURS,(1))
14105 ACROSS%(YCURS)=PTS
14106 DOWN%(XCURS)=0
14110 FOR I=1 TO 5
14120   IF BOARD%(XCURS,I,1)=0 THEN 14200
14130   HAND%(I,1)=BOARD%(XCURS,I,1):HAND%(I,2)=BOARD%(XCURS,I,2)
14140 NEXT I
14150 CALL EVAL(HAND%(),NSPOT%(),EVALUATION)
14160 IF EVALUATION=0 THEN PTS=0:GOTO 14180
14170 PTS=STABLE%(EVALUATION,SCORETABLE)
14180 CALL DISPLAYS(PTS,XCURS,(2))
14190 DOWN%(XCURS)=PTS
14200 FOR I=1 TO 5:SCORESOFAR=SCORESOFAR+ACROSS%(I)+DOWN%(I):NEXT I
14210 LOCATE 19,55:COLOR 13,1:PRINT RIGHT$("  "+STR$(SCORESOFAR),3)
14220 BONUSSOFAR=0
14230 IF IFBONUS=1 THEN
14240   SC=INT(SCORESOFAR/10)-2
14250   IF SC>0 THEN
14260     BONUSSOFAR=SC*10
14270     IF SC>2 THEN BONUSSOFAR=15*SC-10
14280     IF SC>4 THEN BONUSSOFAR=20*SC-30
14290   END IF
14300   CALL DISPLAYB(BONUSSOFAR)
14310 END IF
14320 IF IFBONUS=1 THEN
14330   LOCATE 20,41:COLOR 1,3:PRINT "Next bonus is at         (   points)"
14340   NEXTBONUS=30
14350   REM
14360   IF SCORESOFAR>=NEXTBONUS THEN NEXTBONUS=NEXTBONUS+10:GOTO 14350
14370   AMTBONUS=10:IF NEXTBONUS>40 THEN AMTBONUS=15
14380   IF NEXTBONUS>60 THEN AMTBONUS=20
14390   LOCATE 20,59:COLOR 13,1:PRINT RIGHT$("  "+STR$(NEXTBONUS),3)
14400   LOCATE 20,67:COLOR 10,1:PRINT RIGHT$(" "+STR$(AMTBONUS),2)
14410 END IF
14490 RETURN
14900 REM <CURSOR> Puts up a cursor
14902 Q$=CHR$(219)
14910 COLOR 9,3:IF ONOFF=0 THEN COLOR 3,3
14920 LOCATE 4*YCURS-1,6*XCURS:PRINT STRING$(6,Q$)
14930 FOR ICURS=0 TO 3
14940   LOCATE 4*YCURS+ICURS,6*XCURS:PRINT Q$:LOCATE 4*YCURS+ICURS,6*XCURS+5:PRINT Q$
14950 NEXT ICURS
14960 LOCATE 4*YCURS+3,6*XCURS:PRINT STRING$(6,Q$)
14990 RETURN
15000 REM <PLACECARD> Places card on table
15005 IFINT=0
15010 YCURS=3:XCURS=3:ONOFF=1
15020 GOSUB 14900
15022 IF BOARD%(XCURS,YCURS,1)=0 THEN GOSUB 22000
15030 YY$=INKEY$:IF LEN(YY$)=0 THEN 15030
15035 XCURSNEW=XCURS:YCURSNEW=YCURS
15040 IF LEN(YY$)=2 THEN
15050   YY=ASC(MID$(YY$,2,1))
15060   IF YY=72 THEN
15070     IF YCURS=1 THEN SOUND 500,.5:GOTO 15030
15080     YCURSNEW=YCURS-1
15090     GOTO 15300
15100   ELSEIF YY=75 THEN
15110     IF XCURS=1 THEN SOUND 500,.5:GOTO 15030
15120     XCURSNEW=XCURS-1
15130     GOTO 15300
15140   ELSEIF YY=77 THEN
15150     IF XCURS=5 THEN SOUND 500,.5:GOTO 15030
15160     XCURSNEW=XCURS+1
15170     GOTO 15300
15180   ELSEIF YY=80 THEN
15190     IF YCURS=5 THEN SOUND 500,.5:GOTO 15030
15200     YCURSNEW=YCURS+1
15210     GOTO 15300
15220   ELSE
15230     SOUND 500,.5:GOTO 15030
15235   END IF
15240 ELSE
15241   IF TAKEOVER=1 AND DECKPTR>2 AND (YY$="U" OR YY$="u") AND LASTPLACEX>0 AND DECKPTR<26 THEN GOSUB 24000:GOTO 15490
15242   IF ASC(YY$)=27 THEN IFINT=1:GOTO 15490
15243   IF (YY$="P" OR YY$="p") AND PEEKABOO>0 THEN GOSUB 25000
15245   IF ASC(YY$)<>13 THEN SOUND 500,.5:GOTO 15030
15246   IF PEEKON=1 THEN
15247     COLOR 1,3:LOCATE 7,73:PRINT "      ":LOCATE 8,73:PRINT "      ":LOCATE 9,73:PRINT "      ":PEEKON=0
15248   END IF
15250   IF MUSTEMPTY=1 THEN
15255     IF BOARD%(XCURS,YCURS,1)<>0 THEN SOUND 500,.5:GOTO 15030
15260   END IF
15265   CALL DECODECARD(VHERE,SUIT,SPOT)
15270   BOARD%(XCURS,YCURS,1)=SUIT:BOARD%(XCURS,YCURS,2)=SPOT
15275   XLOC%=XCURS*6+1:YLOC%=YCURS*4
15280   CALL DISPLAYCARD(VHERE,XLOC%,YLOC%,(176),BACKCOLOR1%,BACKCOLOR2%)
15285   ONOFF=0:GOSUB 14900
15287   LASTPLACEX=XCURS:LASTPLACEY=YCURS
15290   GOTO 15490
15295 END IF
15300 ONOFF=0:GOSUB 14900
15302 IF BOARD%(XCURS,YCURS,1)=0 THEN
15303   XLOC%=XCURS*6+1:YLOC%=YCURS*4
15304   CALL DISPLAYCARD((0!),XLOC%,YLOC%,(176),BACKCOLOR1%,BACKCOLOR2%)
15305 END IF
15310 XCURS=XCURSNEW:YCURS=YCURSNEW:ONOFF=1:GOSUB 14900
15312 IF BOARD%(XCURS,YCURS,1)=0 THEN GOSUB 22000
15320 SOUND 1000,.1
15330 GOTO 15030
15490 RETURN
15500 REM <CHANGEDEUCE> Changes a deuce
15505 IFTAKEOVER=0
15510 COLOR 15,3:LOCATE 22,47:PRINT"WILD CARD!  Press 2-9, or T(en),"
15520 LOCATE 23,47:PRINT "J(ack), Q(ueen), K(king) or     "
15530 LOCATE 24,47:PRINT "A(ce).                          ";
15540 CALL DISPLAYCARD((999!),(41),(22),(176),BACKCOLOR1%,BACKCOLOR2%)
15550 YY$=INKEY$:IF LEN(YY$)<>0 THEN 15550
15560 YY$=INKEY$:IF LEN(YY$)<>1 THEN 15560
15570 YY=ASC(YY$)
15575 IF TAKEOVER=1 AND DECKPTR>2 AND (YY$="U" OR YY$="u") AND LASTPLACEX>0 AND DECKPTR<26 THEN IFTAKEOVER=1:GOTO 15790
15580 IF YY>49 AND YY<58 THEN
15582   SPOT=YY-48:SPOT$=YY$
15584 ELSEIF YY$="T" OR YY$="t" THEN
15586   SPOT=10:SPOT$="10"
15588 ELSEIF YY$="J" OR YY$="j" THEN
15590   SPOT=11:SPOT$="Jack"
15592 ELSEIF YY$="Q" OR YY$="q" THEN
15594   SPOT=12:SPOT$="Queen"
15596 ELSEIF YY$="K" OR YY$="k" THEN
15598   SPOT=13:SPOT$="King"
15600 ELSEIF YY$="A" OR YY$="a" THEN
15602   SPOT=14:SPOT$="Ace"
15604 ELSE
15606   SOUND 500,.5:GOTO 15550
15608 END IF
15610 COLOR 15,3:LOCATE 22,47:PRINT SPACE$(32):LOCATE 22,47:PRINT SPOT$+" of what?"
15620 LOCATE 23,47:PRINT "C(lubs), D(iamonds), H(earts),  "
15630 LOCATE 24,47:PRINT "S(pades).  Esc = change spot.  ";
15640 YY$=INKEY$:IF LEN(YY$)<>0 THEN 15640
15650 YY$=INKEY$:IF LEN(YY$)<>1 THEN 15650
15660 IF ASC(YY$)=27 THEN 15510
15665 IF TAKEOVER=1 AND DECKPTR>2 AND (YY$="U" OR YY$="u") AND LASTPLACEX>0 AND DECKPTR<26 THEN IFTAKEOVER=1:GOTO 15790
15670 IF YY$="C" OR YY$="c" THEN SUIT=1:GOTO 15720
15680 IF YY$="D" OR YY$="d" THEN SUIT=2:GOTO 15720
15690 IF YY$="H" OR YY$="h" THEN SUIT=3:GOTO 15720
15700 IF YY$="S" OR YY$="s" THEN SUIT=4:GOTO 15720
15710 SOUND 500,.5:GOTO 15640
15720 V=100*SUIT+SPOT:VWILD=V
15730 CALL DISPLAYCARD(V,(41),(22),(176),BACKCOLOR1%,BACKCOLOR2%)
15740 COLOR 15,3:LOCATE 22,47:PRINT"Use arrow keys to place this    "
15750 LOCATE 23,47:PRINT "card.  Press  Enter  when you   "
15760 LOCATE 24,47:PRINT "are satisfied.  Esc to quit.    ";
15790 RETURN
16000 REM <PLACENEXT> Places the next card
16010 VHERE=DECK%(DECKPTR)
16015 VHEREUSE=VHERE
16016 IF DEUCES=1 THEN
16017   CALL DECODECARD(VHEREUSE,SUIT,SPOT):IF SPOT=2 THEN VHEREUSE=999
16018 END IF
16020 CALL DISPLAYCARD(VHEREUSE,(41),(22),(176),BACKCOLOR1%,BACKCOLOR2%)
16030 DECKPTR=DECKPTR+1
16090 RETURN
16200 REM <FILLSCREEN> Fills in initial screen
16201 REM Compute bonus so far, put up cards, put up line scores
16210 SCORESOFAR=0
16240 FOR I=1 TO 5
16242   YLOC%=4*I
16244   FOR J=1 TO 5
16246     XLOC%=6*J+1
16248     V=BOARD%(J,I,1)*100+BOARD%(J,I,2)
16250     CALL DISPLAYCARD(V,XLOC%,YLOC%,(176),BACKCOLOR1%,BACKCOLOR2%)
16252   NEXT J
16254 NEXT I
16260 FOR I=1 TO 5
16265   ACROSS%(I)=0
16270   FOR J=1 TO 5
16272     IF BOARD%(J,I,1)=0 THEN 16300
16274     HAND%(J,1)=BOARD%(J,I,1):HAND%(J,2)=BOARD%(J,I,2)
16276   NEXT J
16280   CALL EVAL(HAND%(),NSPOT%(),EVALUATION)
16281   IF EVALUATION=0 THEN PTS=0:GOTO 16285
16282   PTS=STABLE%(EVALUATION,SCORETABLE)
16285   CALL DISPLAYS(PTS,I,(1))
16290   SCORESOFAR=SCORESOFAR+PTS
16292   ACROSS%(I)=PTS
16300 NEXT I
16310 FOR J=1 TO 5
16315   DOWN%(J)=0
16320   FOR I=1 TO 5
16322     IF BOARD%(J,I,1)=0 THEN 16350
16324     HAND%(I,1)=BOARD%(J,I,1):HAND%(I,2)=BOARD%(J,I,2)
16326   NEXT I
16330   CALL EVAL(HAND%(),NSPOT%(),EVALUATION)
16331   IF EVALUATION=0 THEN PTS=0:GOTO 16335
16332   PTS=STABLE%(EVALUATION,SCORETABLE)
16335   CALL DISPLAYS(PTS,J,(2))
16340   SCORESOFAR=SCORESOFAR+PTS
16342   DOWN%(J)=PTS
16350 NEXT J
16360 BONUSSOFAR=0
16370 IF IFBONUS=1 THEN
16372   SC=INT(SCORESOFAR/10)-2
16374   IF SC>0 THEN
16376     BONUSSOFAR=SC*10
16378     IF SC>2 THEN BONUSSOFAR=15*SC-10
16380     IF SC>4 THEN BONUSSOFAR=20*SC-30
16382   END IF
16384   CALL DISPLAYB(BONUSSOFAR)
16386 END IF
16390 IF IFBONUS=1 THEN
16400   LOCATE 20,41:COLOR 1,3:PRINT "Next bonus is at         (   points)"
16405   NEXTBONUS=30
16410   REM
16415   IF SCORESOFAR>=NEXTBONUS THEN NEXTBONUS=NEXTBONUS+10:GOTO 16410
16420   AMTBONUS=10:IF NEXTBONUS>40 THEN AMTBONUS=15
16425   IF NEXTBONUS>60 THEN AMTBONUS=20
16430   LOCATE 20,59:COLOR 13,1:PRINT RIGHT$("  "+STR$(NEXTBONUS),3)
16435   LOCATE 20,67:COLOR 10,1:PRINT RIGHT$(" "+STR$(AMTBONUS),2)
16440 END IF
16490 RETURN
16500 REM <INITSCREEN> Puts up initial screen
16510 COLOR 1,3,1:CLS
16515 SS$=CHR$(205)+CHR$(205)+CHR$(181)+"  "+CHR$(198)
16520 LOCATE 2,4:PRINT CHR$(201)+SS$+SS$+SS$+SS$+SS$+CHR$(205)+CHR$(205)+CHR$(187)
16530 FOR I=1 TO 5
16540   FOR J=0 TO 3
16550     LOCATE I*4+J-1,4
16560     IF J=0 THEN PRINT CHR$(186)
16562     IF J=1 THEN PRINT CHR$(208)
16564     IF J=3 THEN PRINT CHR$(210)
16570     LOCATE I*4+J-1,37:PRINT CHR$(186)
16580   NEXT J
16590 NEXT I
16600 LOCATE 23,4:PRINT CHR$(186):LOCATE 23,37:PRINT CHR$(186)
16610 LOCATE 24,4:PRINT CHR$(200)+STRING$(32,CHR$(205))+CHR$(188);
16630 FOR I=1 TO 5
16640   YLOC%=4*I
16650   FOR J=1 TO 5
16660     XLOC%=6*J+1
16670     CALL DISPLAYCARD((0!),XLOC%,YLOC%,(176),BACKCOLOR1%,BACKCOLOR2%)
16680   NEXT J
16690 NEXT I
16700 IF IFBONUS=1 THEN
16702   COLOR 1,3:LOCATE 24,24:PRINT CHR$(181)+"         "+CHR$(198);
16704   COLOR 10,1:LOCATE 24,25:PRINT "BONUS";
16710 END IF
16720 COLOR 15,1:LOCATE 2,41:PRINT " SCORING TABLE  "
16725 COLOR 12,3:LOCATE 2,61:PRINT "FEATURES"
16730 COLOR 3,1
16732 LOCATE 3,41:PRINT " royal flush ":LOCATE 4,41:PRINT " 5 of a kind "
16734 LOCATE 5,41:PRINT " strt. flush ":LOCATE 6,41:PRINT " 4 of a kind "
16736 LOCATE 7,41:PRINT " full house  ":LOCATE 8,41:PRINT " flush       "
16738 LOCATE 9,41:PRINT " straight    ":LOCATE 10,41:PRINT " 3 of a kind "
16740 LOCATE 11,41:PRINT " two pair    ":LOCATE 12,41:PRINT " one pair    "
16750 COLOR 13,1
16760 FOR I=1 TO 10
16762   LOCATE I+2,54
16764   IF I=2 AND DEUCES=0 THEN
16766     PRINT "-- "
16768   ELSE
16770     PRINT RIGHT$(STR$(STABLE%(11-I,SCORETABLE)),2)+" "
16775   END IF
16778 NEXT I
16780 COLOR 1,3
16782 IF DEUCES=1 THEN LOCATE 3,61:PRINT "Deuces wild"
16784 IF TIMESSCORE=2 THEN LOCATE 4,61:PRINT "Double score"
16786 IF EXTRA>0 THEN LOCATE 5,61:PRINT "Extra cards:"+STR$(EXTRA)
16788 IF PEEKABOO>0 THEN
16790   LOCATE 7,61:PRINT "Press P":LOCATE 8,61:PRINT"to peek":LOCATE 9,61:PRINT "("+CHR$(48+PEEKABOO)+" left)"
16792   CALL DISPLAYCARD((0!),(73),(7),(176),BACKCOLOR1%,BACKCOLOR2%)
16794 END IF
16795 IF TAKEOVER=1 AND DECKPTR<26 THEN
16796   COLOR 1,3:LOCATE 12,61:PRINT "Hit U to undo last"
16797 END IF
16800 IF TYPEGAME>1 AND TYPEGAME<5 THEN
16802   COLOR 1,3:LOCATE 15,40:PRINT STR$(TYPEGAME*2-1)+"-GAME TOURNAMENT   ROUND"
16804   LOCATE 15,67:COLOR 15,1:PRINT ROUND
16806 END IF
16810 LOCATE 17,41:COLOR 1,3:PRINT "Player now up:"
16820 LOCATE 17,57:COLOR 14,1:PRINT PLAYER$(PLAYERUP)
16822 COLOR 1,3:LOCATE 19,41:PRINT "Total so far:"
16824 COLOR 13,1:LOCATE 19,55:PRINT RIGHT$("  "+STR$(SCORESOFAR),3)
16830 IF IFBONUS=1 AND NEWGAME=1 THEN
16840   LOCATE 20,41:COLOR 1,3:PRINT "Next bonus is at         (   points)"
16850   NEXTBONUS=30
16862   AMTBONUS=10
16870   LOCATE 20,59:COLOR 13,1:PRINT RIGHT$("  "+STR$(NEXTBONUS),3)
16880   LOCATE 20,67:COLOR 10,1:PRINT RIGHT$(" "+STR$(AMTBONUS),2)
16890 END IF
16900 COLOR 15,3:LOCATE 22,47:PRINT"Use arrow keys to place this     "
16910 LOCATE 23,47:PRINT "card.  Press  Enter  when you    "
16920 LOCATE 24,47:PRINT "are satisfied.  Esc to quit.     ";
16930 CALL DISPLAYCARD((0!),(41),(22),(176),BACKCOLOR1%,BACKCOLOR2%)
16990 RETURN
17000 REM <GETOPTIONS> Gets options
17010 A$(1)="Yes":A$(2)="No"
17020 NA=2:TX$="Do you want deuces to be wild?":CSTART=1
17030 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(4!))
17040 DEUCES=0:IF CHOICE=1 THEN DEUCES=1
17050 TX$="Do you want bonuses to be awarded?"
17060 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(5!))
17070 IFBONUS=0:IF CHOICE=1 THEN IFBONUS=1
17080 TX$="Do you want to get 3 peeks ahead at the next card?"
17090 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(6!))
17100 PEEKABOO=0:IF CHOICE=1 THEN PEEKABOO=3
17110 A$(1)="None"
17120 A$(2)="1"
17130 A$(3)="2"
17140 A$(4)="3"
17150 NA=4:TX$="How many extra (replacement) cards do you want dealt at the end?":CSTART=1
17160 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(7!))
17170 EXTRA=CHOICE-1
17190 RETURN
17200 REM <GETSCORETABLE> Gets scoring table and takeover flag
17210 A$(1)="Regular table"
17220 A$(2)="Table with enhanced scoring for straights"
17230 NA=2:TX$="Which scoring table do you want?":CSTART=1
17240 CALL MENU(TX$,A$(),NA,CSTART,SCORETABLE,(8!))
17245 A$(1)="Yes":A$(2)="No"
17250 NA=2:TX$="Do you want to be allowed to undo the last card placed?":CSTART=1
17255 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(9!))
17260 TAKEOVER=0:IF CHOICE=1 THEN TAKEOVER=1
17270 COLOR 1,3:CLS
17290 RETURN
18000 REM <GETTYPE> Gets type of game and players
18005 TIMESSCORE=1:ROUND=1:SCORESOFAR=0
18006 FOR I=1 TO 5:ACROSS%(I)=0:DOWN%(I)=0:NEXT I
18010 A$(1)="Single rounds"
18020 A$(2)="3-round tournament"
18030 A$(3)="5-round tournament"
18040 A$(4)="7-round tournament"
18050 A$(5)="Duplicate play"
18060 A$(6)="Quit"
18070 NA=6:TX$="What type of game do you want to play?":CSTART=1
18080 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(10!))
18090 IFQUIT=0:IF CHOICE=6 THEN IFQUIT=1:GOTO 18890
18100 TYPEGAME=CHOICE
18120 COLOR 1,3,1:CLS
18130 LOCATE 3,3:PRINT "Fill in the player names below.  Press  Esc  when done."
18140 LOCATE 4,3:PRINT "Use arrow keys to go from field to field."
18160 FOR I=1 TO 10
18170   COLOR 0,0:LOCATE I+5,3:PRINT "        ":PLAYER$(I)="        "
18180 NEXT I
18190 XCURS=3:YCURS=6:CURSON=0:TIMECHK=TIMER
18200 YY$=INKEY$
18210 IF LEN(YY$)=0 THEN
18220   IF TIMER-TIMECHK>0.3 THEN
18230     CURSON=CURSON+1:IF CURSON=2 THEN CURSON=0
18240     COLOR 15,0:IF CURSON=0 THEN COLOR 0,15
18250     GOSUB 18900
18260     TIMECHK=TIMER
18270   END IF
18280   GOTO 18200
18290 ELSEIF LEN(YY$)=1 THEN
18300   IF ASC(YY$)=27 THEN 18610
18301   YY=ASC(YY$):IF YY=32 THEN 18310
18302   IF YY>64 AND YY<91 THEN 18310
18303   IF YY>96 AND YY<123 THEN YY$=CHR$(YY-32):GOTO 18310
18304   IF YY>47 AND Y<58 THEN 18310
18305   IF YY=13 THEN 18331
18306   IF YY=8 THEN 18334
18307   SOUND 500,.5:GOTO 18200
18310   MID$(PLAYER$(YCURS-5),XCURS-2,1)=YY$
18320   LOCATE YCURS,XCURS:COLOR 15,0:PRINT YY$
18330   GOTO 18450
18331   COLOR 15,0:GOSUB 18900
18332   YCURS=YCURS+1:IF YCURS=16 THEN YCURS=6
18333   XCURS=3:CURSON=0:COLOR 15,0:GOSUB 18900:TIMECHK=TIMER:GOTO 18200
18334   IF XCURS=3 THEN SOUND 500,.5:GOTO 18200
18335   COLOR 15,0:GOSUB 18900
18336   XCURS=XCURS-1
18337   CURSON=0:COLOR 15,0:GOSUB 18900:TIMECHK=TIMER:GOTO 18200
18340 ELSE
18342   YY=ASC(MID$(YY$,2,1))
18350   IF YY=72 THEN
18360     COLOR 15,0:GOSUB 18900
18370     YCURS=YCURS-1:XCURS=3:IF YCURS=5 THEN YCURS=15
18380     CURSON=0:COLOR 15,0:GOSUB 18900:TIMECHK=TIMER:GOTO 18200
18390   ELSEIF YY=75 THEN
18400     IF XCURS=3 THEN SOUND 500,.5:GOTO 18200
18410     COLOR 15,0:GOSUB 18900
18420     XCURS=XCURS-1
18430     GOTO 18380
18440   ELSEIF YY=77 THEN
18450     COLOR 15,0:GOSUB 18900
18460     IF XCURS=10 THEN
18470       YCURS=YCURS+1:IF YCURS=16 THEN YCURS=6
18480       XCURS=3
18490     ELSE
18500       XCURS=XCURS+1
18510     END IF
18520     GOTO 18380
18530   ELSEIF YY=80 THEN
18540     COLOR 15,0:GOSUB 18900
18550     YCURS=YCURS+1:IF YCURS=16 THEN YCURS=6
18560     XCURS=3:GOTO 18380
18570   ELSE
18580     SOUND 500,.5:GOTO 18200
18590   END IF
18600 END IF
18610 NPLAYER=0
18620 FOR I=1 TO 10
18630   FOR J=1 TO 8
18640     IF MID$(PLAYER$(I),J,1)<>" " THEN 18670
18650   NEXT J
18660   GOTO 18690
18670   NPLAYER=NPLAYER+1
18680   PLAYER$(NPLAYER)=LEFT$(MID$(PLAYER$(I),J,8-J+1)+"        ",8)
18690 NEXT I
18890 RETURN
18900 REM <DISPONE> Displays one character
18910 LOCATE YCURS,XCURS:PRINT MID$(PLAYER$(YCURS-5),XCURS-2,1)
18990 RETURN
19000 REM <GETSTART> Gets new game start data
19010 A$(1)="Start a new game"
19020 A$(2)="Restart a saved game"
19022 A$(3)="Look at the rules"
19025 A$(4)="Quit"
19030 NA=4:TX$="What do you want to do?":CSTART=1
19040 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(11!))
19042 IFEND=0:IF CHOICE=4 THEN IFEND=1:GOTO 19190
19045 IF CHOICE=3 THEN
19046   CALL RULES(("PSQUARES.RUL"))
19047   GOTO 19010
19048 END IF
19050 NEWGAME=1:IF CHOICE=2 THEN NEWGAME=0
19060 IF NEWGAME=0 THEN
19070   GOSUB 19200
19080   IF IFOK=0 THEN 19010 ELSE 19190
19090 ELSE
19100   FOR I=1 TO 10:SCORE(I)=0:LASTSCORE(I)=0:NEXT I
19110   PLAYERUP=1
19120   FOR I=1 TO 5
19122     FOR J=1 TO 5
19124       BOARD%(I,J,1)=0:BOARD%(I,J,2)=0
19126     NEXT J
19128   NEXT I
19130   CLS
19140   CALL SHUFFLE(DECK%(),TEMP%())
19150   DECKPTR=1
19160 END IF
19190 RETURN
19200 REM <READOLD> Reads an old game into memory
19201 REM Output IFOK (0..no selection,1..ok)
19202 REM Includes selection of file
19210 COLOR 1,3,1:CLS:IFOK=1
19220 SHELL "DIR >TEMPX.DAT"
19230 OPEN "TEMPX.DAT" FOR INPUT AS #1
19240 NA=1:A$(1)="None of these"
19250 WHILE EOF(1)=0
19260   LINE INPUT#1,BUF$
19270   IF LEFT$(BUF$,1)<>" " AND LEFT$(BUF$,1)<>"." THEN
19280     IF MID$(BUF$,10,3)="GDF" THEN
19290       NA=NA+1
19300       A$(NA)=MID$(BUF$,1,8)
19310       IF NA=15 THEN 19350
19320     END IF
19330   END IF
19340 WEND
19350 CLOSE #1
19360 KILL "TEMPX.DAT"
19370 IF NA=1 THEN
19372   LOCATE 3,3:PRINT "No games are saved."
19374   LOCATE 6,3:PRINT "Press any key to continue."
19376   YY$=INKEY$:IF LEN(YY$)=0 THEN 19376
19400   IFOK=0:GOTO 19990
19410 END IF
19420 CSTART=1:TX$="Which game do you want?"
19430 CALL MENU(TX$,A$(),NA,CSTART,CHOICE,(12!))
19440 IF CHOICE=1 THEN IFOK=0:GOTO 19990
19450 OLDNAME$=LEFT$(A$(CHOICE)+" ",8)
19460 Y=INSTR(OLDNAME$," "):IF Y>0 THEN OLDNAME$=LEFT$(OLDNAME$,Y-1)
19470 OLDNAME$=OLDNAME$+".GDF"
19480 OPEN OLDNAME$ FOR INPUT AS #1
19490 LINE INPUT#1,BUF$:BUF$=LEFT$(BUF$+SPACE$(15),15)
19500 TYPEGAME=VAL(MID$(BUF$,1,1))
19510 NPLAYER=VAL(MID$(BUF$,2,2))
19512 DEUCES=VAL(MID$(BUF$,4,1))
19513 EXTRA=VAL(MID$(BUF$,5,1))
19514 PEEKABOO=VAL(MID$(BUF$,6,1))
19515 IFBONUS=VAL(MID$(BUF$,7,1))
19516 SCORETABLE=VAL(MID$(BUF$,8,1))
19517 PLAYERUP=VAL(MID$(BUF$,9,1))
19530 DECKPTR=VAL(MID$(BUF$,10,2))
19531 ROUND=VAL(MID$(BUF$,12,1)):TAKEOVER=VAL(MID$(BUF$,13,1))
19532 LASTPLACEX=VAL(MID$(BUF$,14,1)):LASTPLACEY=VAL(MID$(BUF$,15,1))
19533 IF TYPEGAME>1 AND TYPEGAME<5 THEN GOSUB 13000
19540 LINE INPUT#1,BUF$
19550 FOR I=1 TO NPLAYER
19560   PLAYER$(I)=MID$(BUF$,I*8-7,8)
19570 NEXT I
19580 LINE INPUT#1,BUF$:BUF$=LEFT$(BUF$+SPACE$(100),100)
19590 FOR I=1 TO NPLAYER
19600   SCORE(I)=VAL(MID$(BUF$,I*5-4,5))
19605   LASTSCORE(I)=VAL(MID$(BUF$,I*5+46,5))
19610 NEXT I
19620 LINE INPUT#1,BUF$:BUF$=LEFT$(BUF$+SPACE$(75),75)
19630 FOR I=1 TO 5
19640  FOR J=1 TO 5
19650    BOARD%(I,J,1)=VAL(MID$(BUF$,I*15+J*3-17,1))
19660    BOARD%(I,J,2)=VAL(MID$(BUF$,I*15+J*3-16,2))
19670  NEXT J
19680 NEXT I
19690 LINE INPUT#1,BUF$:BUF$=LEFT$(BUF$+SPACE$(156),156)
19700 FOR I=1 TO 52
19710   DECK%(I)=VAL(MID$(BUF$,I*3-2,3))
19720 NEXT I
19730 CLOSE#1
19740 KILL OLDNAME$
19990 RETURN
20000 REM <DISPLAYHAND> Displays a sample hand
20001 REM Input FIRSTTIME (if 1..wait is short)
20010 WAITTIME=1:IF FIRSTTIME=1 THEN WAITTIME=0.2
20020 FOR K=0 TO 4
20030   XLOC%=8+3*K:YLOC%=6-K:IF K=4 THEN YLOC%=4
20040   CALL DISPLAYCARD((0!),XLOC%,YLOC%,(176),(4),(1))
20050 NEXT K
20055 CALL WAITE((WAITTIME))
20060 FOR K=0 TO 4
20070   XLOC%=8+3*K:YLOC%=6-K:IF K=4 THEN YLOC%=4
20080   V=DECK%(VSTART+K)
20090   CALL DISPLAYCARD(V,XLOC%,YLOC%,(0),(0),(0))
20100   CALL WAITE((WAITTIME))
20110 NEXT K
20190 RETURN
21000 REM <FIRSTSCREEN> Puts up the first screen
21010 FIRSTTIME=1
21020 CALL SHUFFLE(DECK%(),TEMP%())
21030 GOSUB 12800
21280 LOCATE 20,5:PRINT "Copyright 1988"
21290 LOCATE 21,5:PRINT "Innovations in Computing, Inc."
21300 LOCATE 22,5:PRINT "Runtime library copyright by"
21310 LOCATE 23,5:PRINT "Microsoft, Inc."
21340 VSTART=1
21350 GOSUB 20000
21352 FIRSTTIME=0
21355 COLOR 12,1:LOCATE 21,48:PRINT "Press any key to start"
21360 FOR I=1 TO 5000
21370   YY$=INKEY$
21380   IF LEN(YY$)>0 THEN 21490
21390 NEXT I
21392 COLOR 3,1:LOCATE 21,48:PRINT SPACE$(30)
21400 VSTART=VSTART+5
21410 IF VSTART>48 THEN VSTART=VSTART-47
21420 GOTO 21350
21490 RETURN
22000 REM <GREENCARD> Puts up green card
22010 XLOC%=XCURS*6+1:YLOC%=YCURS*4
22020 VTODO=DECK%(DECKPTR-1)+1000
22025 IF DEUCES=1 THEN
22026   CALL DECODECARD(VTODO,SUITTODO,SPOTTODO)
22027   IF SPOTTODO=2 THEN VTODO=VWILD+1000
22028 END IF
22030 CALL DISPLAYCARD(VTODO,XLOC%,YLOC%,(176),BACKCOLOR1%,BACKCOLOR2%)
22090 RETURN
23000 REM <REMOVE> Removes a player
23010 IF NPLAYER=1 THEN SOUND 500,.5:GOTO 23990
23020 FOR I=1 TO NPLAYER
23030   TOPRT$=PLAYER$(I)
23040   Y=INSTR(TOPRT$," ")
23050   IF Y>0 THEN TOPRT$=LEFT$(TOPRT$,Y-1)
23060   COLOR 4,1:LOCATE 23,3:PRINT "Do you want to remove "+TOPRT$+"?      (Press  Y  for yes or  N  for no)."
23070   YY$=INKEY$:IF LEN(YY$)<>0 THEN 23070
23080   YY$=INKEY$:IF LEN(YY$)<>1 THEN 23080
23090   IF YY$="N" OR YY$="n" THEN 23190
23100   IF YY$<>"Y" AND YY$<>"y" THEN SOUND 500,.5:GOTO 23070
23110   IF I<NPLAYER THEN
23120     FOR J=I TO NPLAYER-1
23130       PLAYER$(J)=PLAYER$(J+1)
23140       LASTSCORE(J)=LASTSCORE(J+1)
23150       SCORE(J)=SCORE(J+1)
23160     NEXT J
23170   END IF
23180   IF PLAYERUP>I THEN PLAYERUP=PLAYERUP-1
23185   NPLAYER=NPLAYER-1
23188   GOTO 23990
23190 NEXT I
23990 RETURN
24000 REM <UNDO> Undoes the last move
24010 ONOFF=0:GOSUB 14900
24020 IF BOARD%(XCURS,YCURS,1)=0 THEN
24030   XLOC%=XCURS*6+1:YLOC%=YCURS*4
24040   CALL DISPLAYCARD((0!),XLOC%,YLOC%,(176),BACKCOLOR1%,BACKCOLOR2%)
24050 END IF
24060 XLOC%=LASTPLACEX*6+1:YLOC%=LASTPLACEY*4
24070 CALL DISPLAYCARD((0!),XLOC%,YLOC%,(176),BACKCOLOR1%,BACKCOLOR2%)
24080 BOARD%(LASTPLACEX,LASTPLACEY,1)=0
24090 BOARD%(LASTPLACEX,LASTPLACEY,2)=0
24092 COLOR 1,3
24093 LOCATE LASTPLACEY*4+1,3:PRINT "  "
24094 LOCATE 2,6*LASTPLACEX+2:PRINT "  "
24100 LASTPLACEX=0
24110 DECKPTR=DECKPTR-2
24190 RETURN
25000 REM <PEEKABOO> Processes peek
25020 IF DECKPTR>25+EXTRA THEN SOUND 500,.5:GOTO 25990
25030 V=DECK%(DECKPTR)
25040 CALL DECODECARD(V,SUIT,SPOT)
25050 IF DEUCES=1 AND SPOT=2 THEN V=999
25060 CALL DISPLAYCARD(V,(73),(7),(176),BACKCOLOR1%,BACKCOLOR2%)
25070 PEEKABOO=PEEKABOO-1
25075 PEEKON=1
25080 IF PEEKABOO>0 THEN
25090   COLOR 1,3
25100   LOCATE 9,62:PRINT CHR$(48+PEEKABOO)
25110 ELSE
25112   COLOR 1,3
25120   LOCATE 7,61:PRINT "         ":LOCATE 8,61:PRINT "         ":LOCATE 9,61:PRINT "         "
25130 END IF
25990 RETURN
40000 SUB SHUFFLE(DECK%(1),TEMP%(1)) STATIC
40001 REM Returns a shuffled deck
40002 REM Output .. DECK%(52), where DECK%(i) is the i-th card in the
40003 REM           deck.  Coding is 100*suit+card, with suit=1..clubs,
40004 REM           2..diamonds,3..hearts,4..spaces, and with cards
40005 REM           being 2,3,...10,11(jack),12(queen),13(king),14(ace)
40010 FOR I=1 TO 52
40020   TEMP%(I)=INT(RND*30000)
40030 NEXT I
40040 FOR I=1 TO 52
40050   SUIT=INT((I-1)/13)+1
40060   SPOT=I-13*SUIT+14
40070   DECK%(I)=SUIT*100+SPOT
40080 NEXT I
40090 FOR I=1 TO 51
40100   FOR J=I+1 TO 52
40110     IF TEMP%(I)>TEMP%(J) THEN
40120       SWAP TEMP%(I),TEMP%(J)
40130       SWAP DECK%(I),DECK%(J)
40140     END IF
40150   NEXT J
40160 NEXT I
40190 END SUB
40200 SUB DECODECARD(V,SUIT,SPOT) STATIC
40210 SUIT=INT(V/100)
40220 SPOT=V-100*SUIT
40290 END SUB
40300 SUB DISPLAYCARD(V,XLOC%,YLOC%,BACKSYMBOL%,BACKCOLOR1%,BACKCOLOR2%) STATIC
40301 REM Displays one card
40302 REM Input V .. value of card (= 0 .. back)
40303 REM       XLOC%,YLOC% .. upper left corner of card
40304 REM       BACKSYMBOL% .. symbol for back of card
40305 REM       BACKCOLOR1%, BACKCOLOR2% .. colors for back of card
40306 IFGREEN=0:IF V>1000 THEN V=V-1000:IFGREEN=1
40310 IF V=0 THEN
40320   LOCATE YLOC%,XLOC%
40330   COLOR BACKCOLOR1%,BACKCOLOR2%
40340   PRINT STRING$(4,BACKSYMBOL%);
40350   LOCATE YLOC%+1,XLOC%
40360   PRINT STRING$(4,BACKSYMBOL%);
40370   LOCATE YLOC%+2,XLOC%
40380   PRINT STRING$(4,BACKSYMBOL%);
40382 ELSEIF V=999 THEN
40384   LOCATE YLOC%,XLOC%:COLOR 2,7
40385   PRINT CHR$(218)+CHR$(196)+CHR$(196)+CHR$(191);
40386   LOCATE YLOC%+1,XLOC%
40387   PRINT CHR$(179)+"WC"+CHR$(179);
40390   LOCATE YLOC%+2,XLOC%
40391   PRINT CHR$(192)+CHR$(196)+CHR$(196)+CHR$(217);
40398 ELSE
40400   CALL DECODECARD(V,SUIT,SPOT)
40410   ON SUIT GOTO 40420,40430,40440,40450
40420   COLOR 0,7:SCHAR=5:GOTO 40460
40430   COLOR 4,7:SCHAR=4:GOTO 40460
40440   COLOR 4,7:SCHAR=3:GOTO 40460
40450   COLOR 0,7:SCHAR=6
40460   IF IFGREEN=1 THEN
40461     COLOR 7,0
40462     IF SUIT=2 OR SUIT=3 THEN COLOR 7,4
40463   END IF
40464   IF SPOT<10 THEN SPOT=SPOT+48:GOTO 40510
40465   IF SPOT=10 THEN SPOT=84:GOTO 40510
40470   IF SPOT=11 THEN SPOT=74:GOTO 40510
40480   IF SPOT=12 THEN SPOT=81:GOTO 40510
40490   IF SPOT=13 THEN SPOT=75:GOTO 40510
40500   IF SPOT=14 THEN SPOT=65
40510   LOCATE YLOC%,XLOC%
40520   PRINT CHR$(218)+CHR$(196)+CHR$(196)+CHR$(191);
40530   LOCATE YLOC%+1,XLOC%
40540   PRINT CHR$(179)+CHR$(SPOT)+CHR$(SCHAR)+CHR$(179);
40550   LOCATE YLOC%+2,XLOC%
40560   PRINT CHR$(192)+CHR$(196)+CHR$(196)+CHR$(217);
40570 END IF
40590 END SUB
40600 SUB WAITE(DELAY) STATIC
40610 TIMECHK=TIMER+DELAY
40620 IF TIMER>TIMECHK THEN 40690
40630 GOTO 40620
40690 END SUB
40700 SUB MENU (TX$,A$(1),NA,CSTART,CHOICE,HELPNUM) STATIC
40701 REM Input A$ .. choices, NA .. number of choices, CSTART .. start point
40702 REM Output CHOICE .. selection
40710 COLOR 1,3,1:CLS
40720 LOCATE 3,3:PRINT TX$
40730 FOR I=1 TO NA
40740  LOCATE I+4,3:PRINT A$(I)
40750 NEXT I
40760 COLOR 12,3
40770 LOCATE CSTART+4,3:PRINT A$(CSTART)
40780 CHOICE=CSTART
40790 COLOR 1,3
40800 LOCATE 20,3:PRINT "Use arrow keys or space bar to move cursor."
40810 LOCATE 21,3:PRINT "Press  Enter  to make selection."
40815 IF HELPNUM>0 THEN LOCATE 23,3:PRINT "Press  H  for help."
40820 CALL GETKEY(YY$,YY)
40830 IF YY=0 THEN
40840   IF YY$=" " THEN 40910
40841   IF ASC(YY$)=13 THEN 40990
40842   IF HELPNUM>0 AND (YY$="H" OR YY$="h") THEN CALL MENUHELP(HELPNUM):GOTO 40710
40843   YY=ASC(YY$):IF YY>96 AND YY<123 THEN YY=YY-32
40844   FOR IA=1 TO NA
40845     YYCHK=ASC(MID$(A$(IA),1,1)):IF YYCHK>96 AND YYCHK<123 THEN YYCHK=YYCHK-32
40846     IF YY=YYCHK THEN CHOICE=IA:GOTO 40990
40847   NEXT IA
40850   SOUND 500,.5:GOTO 40820
40860 ELSE
40870   IF YY=72 THEN 40950
40880   IF YY=80 THEN 40910
40890   SOUND 500,.5:GOTO 40820
40900 END IF
40910 LOCATE CHOICE+4,3:COLOR 1,3:PRINT A$(CHOICE)
40920 CHOICE=CHOICE+1
40930 IF CHOICE>NA THEN CHOICE=1
40940 GOTO 40970
40950 LOCATE CHOICE+4,3:COLOR 1,3:PRINT A$(CHOICE)
40960 CHOICE=CHOICE-1:IF CHOICE=0 THEN CHOICE=NA
40970 LOCATE CHOICE+4,3:COLOR 12,3:PRINT A$(CHOICE)
40980 GOTO 40820
40990 END SUB
41000 SUB GETKEY(YY$,YY) STATIC
41001 REM Output YY$ .. user input byte if length=1
41002 REM        YY .. 0 if length=1, or value of second byte
41010 YY$=INKEY$:IF LEN(YY$)<>0 THEN 41010
41020 YY$=INKEY$:IF LEN(YY$)=0 THEN 41020
41030 IF LEN(YY$)=1 THEN
41040   YY=0
41050 ELSE
41060   YY=ASC(MID$(YY$,2,1))
41070 END IF
41090 END SUB
41100 SUB DISPLAYB(BONUSSOFAR) STATIC
41110 COLOR 13,1:LOCATE 24,31:PRINT RIGHT$("   "+STR$(BONUSSOFAR),3);
41190 END SUB
41200 SUB DISPLAYS(PTS,I,ITYPE%) STATIC
41210 IF ITYPE%=1 THEN
41220   XLOC%=3
41230   YLOC%=I*4+1
41240 ELSE
41250   XLOC%=6*I+2
41260   YLOC%=2
41270 END IF
41280 COLOR 13,1
41290 LOCATE YLOC%,XLOC%
41300 PRINT RIGHT$("  "+STR$(PTS),2)
41390 END SUB
41400 SUB EVAL(HAND%(2),NSPOT%(1),EVALUATION) STATIC
41410 IFFLUSH=1:EVALUATION=0
41420 SUITCHK=HAND%(1,1)
41430 FOR I=2 TO 5
41440   IF SUITCHK<>HAND%(I,1) THEN IFFLUSH=0:GOTO 41460
41450 NEXT I
41460 FOR I=2 TO 14:NSPOT%(I)=0:NEXT I
41470 FOR I=1 TO 5
41480   SP=HAND%(I,2)
41490   NSPOT%(SP)=NSPOT%(SP)+1
41500 NEXT I
41510 MAXKIND=0:MAX2KIND=0
41520 FOR I=2 TO 14
41530   IF NSPOT%(I)>1 THEN
41540     IF NSPOT%(I)>MAXKIND THEN
41550       MAX2KIND=MAXKIND:MAXKIND=NSPOT%(I)
41560     ELSEIF NSPOT%(I)>MAX2KIND THEN
41570       MAX2KIND=NSPOT%(I)
41580     END IF
41590   END IF
41600 NEXT I
41605 IFSTRAIGHT=0
41610 IF MAXKIND=5 THEN EVALUATION=9:GOTO 41990
41620 IF MAXKIND=4 THEN EVALUATION=7:GOTO 41990
41630 IF MAXKIND=3 THEN
41640   IF MAX2KIND=2 THEN EVALUATION=6:GOTO 41990
41650   EVALUATION=3:GOTO 41750
41660 END IF
41670 IF MAXKIND=2 THEN
41680   IF MAX2KIND=2 THEN EVALUATION=2:GOTO 41750
41690   EVALUATION=1:GOTO 41750
41700 END IF
41710 IFSTRAIGHT=0
41720 FOR I=1 TO 14
41721   II=I:IF II=1 THEN II=14
41722   IF NSPOT%(II)>0 THEN
41724     STARTST=I:IF II=14 THEN II=1
41726     FOR J=1 TO 4
41727       IF II+J>14 THEN
41728         IF I=1 THEN 41745 ELSE 41750
41729       END IF
41730       JJ=II+J
41731       IF NSPOT%(JJ)=0 THEN
41732         IF I=1 THEN 41745 ELSE 41750
41733       END IF
41734     NEXT J
41736     IFSTRAIGHT=1:GOTO 41750
41740   END IF
41745 NEXT I
41750 IF IFFLUSH=1 THEN
41760   IF IFSTRAIGHT=1 THEN
41770     IF STARTST=10 THEN EVALUATION=10:GOTO 41990
41780     EVALUATION=8:GOTO 41990
41782   ELSE
41783     EVALUATION=5:GOTO 41990
41790   END IF
41800 END IF
41810 IF IFSTRAIGHT=1 THEN EVALUATION=4:GOTO 41990
41990 END SUB
42000 SUB MENUHELP(HELPNUM) STATIC
42010 OPEN "R",5,"HELP.DAT",78
42020 FIELD 5,78 AS HBUF$
42030 COLOR 1,3:CLS
42032 LOCATE 1,1:COLOR 15,3:PRINT CHR$(218)+STRING$(78,CHR$(196))+CHR$(191)
42040 FOR I=1 TO 20
42042   COLOR 15,3:LOCATE I+1,1:PRINT CHR$(179):LOCATE I+1,80:PRINT CHR$(179)
42050   GET 5,HELPNUM*20+I
42060   COLOR 1,3:LOCATE I+1,2:PRINT HBUF$
42070 NEXT I
42072 COLOR 15,3:LOCATE 22,1:PRINT CHR$(179):LOCATE 22,80:PRINT CHR$(179)
42080 LOCATE 22,24:COLOR 12,3:PRINT "Press any key to return to menu."
42085 COLOR 15,3:LOCATE 23,1:PRINT CHR$(192)+STRING$(78,CHR$(196))+CHR$(217)
42090 YY$=INKEY$:IF LEN(YY$)<>0 THEN 42090
42100 YY$=INKEY$:IF LEN(YY$)=0 THEN 42100
42110 CLS
42120 CLOSE#5
42190 END SUB
42200 SUB RULES(RULEFILE$) STATIC
42210 OPEN RULEFILE$ FOR INPUT AS #1
42230 COLOR 1,3,1:CLS
42240 COLOR 15,1
42250 LOCATE 1,1:PRINT CHR$(218)+STRING$(78,CHR$(196))+CHR$(191)
42260 FOR I=2 TO 21
42270   LOCATE I,1:PRINT CHR$(179):LOCATE I,80:PRINT CHR$(179)
42280 NEXT I
42290 LOCATE 22,1:PRINT CHR$(192)+STRING$(78,CHR$(196))+CHR$(217)
42300 COLOR 4,3
42310 LOCATE 24,5:PRINT "ENTER .. next page        ESC .. quit        S .. start over";
42315 LASTBLANK=1:COLOR 1,3
42320 FOR I=2 TO 21
42330   IF EOF(1)<>0 THEN 42400
42340   LINE INPUT#1,BUF$
42350   BUF$=LEFT$(BUF$+SPACE$(72),72)
42360   IF BUF$=SPACE$(72) THEN
42362     IF I>14 THEN 42400
42363     IF LASTBLANK=0 THEN LASTBLANK=1:GOTO 42370
42364     GOTO 42330
42366   END IF
42368   LASTBLANK=0
42370   LOCATE I,5:PRINT BUF$
42390 NEXT I
42395 GOTO 42430
42400 FOR J=I TO 21
42410   LOCATE J,5:PRINT SPACE$(72)
42420 NEXT J
42430 YY$=INKEY$:IF LEN(YY$)<>0 THEN 42430
42440 YY$=INKEY$:IF LEN(YY$)<>1 THEN 42440
42450 IF YY$="S" OR YY$="s" THEN
42460   CLOSE#1
42470   GOTO 42210
42480 ELSEIF ASC(YY$)=27 THEN
42490   GOTO 42580
42500 ELSEIF ASC(YY$)<>13 THEN
42510   SOUND 500,.5:GOTO 42440
42520 ELSE
42530   IF EOF(1)<>0 THEN 42580
42540   GOTO 42315
42550 END IF
42580 CLOSE #1
42590 END SUB
