{ Create a friendlier, TStringList-like string collection.}
unit StrList;
interface
uses Objects;

type
  PStrListCollection = ^TStrListCollection;
  TStrListCollection = object(TStringCollection)
    function StrAt(Index: Integer): string;
    procedure Add(const S: string);
  end;

implementation

{ Translate a pointer into a string, handling the NIL case. }
function PtrToStr(P: Pointer): string;
begin
  if P = nil then PtrToStr := '' else PtrToStr := PString(P)^;
end;

{ Safely return a string from the string collection. }
function TStrListCollection.StrAt(Index: Integer): string;
begin
  StrAt := PtrToStr(At(Index));
end;

{ Add a string to the end of the string collection. }
procedure TStrListCollection.Add(const S: string);
begin
  AtInsert(Count, NewStr(S));
end;

end.

