#include <windows.h>
#include "tbtray.h"

HINSTANCE hInstance;
BOOL fAnimation;
HICON hAnimOnIcon, hAnimOffIcon;

void TaskbarTray_SendMessage(HWND hwnd, UINT message)
{
  NOTIFYICONDATA nid;

  nid.cbSize = sizeof(NOTIFYICONDATA);
  nid.hWnd = hwnd;
  nid.uID = ID_ANIMATION_CTL;
  nid.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
  nid.uCallbackMessage = TASKBAR_TRAY_MSG;
  nid.hIcon = fAnimation ? hAnimOnIcon : hAnimOffIcon;

  lstrcpy(nid.szTip, "Window animation is ");
  lstrcat(nid.szTip, fAnimation ? "on" : "off");

  Shell_NotifyIcon(message, &nid);
}

/*
uID is never used in this function, but it has been kept
for future expansion.
*/
void TaskbarTray_HandleMessage(HWND hwnd,
                               UINT uID,
                               UINT message)
{
  switch (message)
  {
    case WM_LBUTTONDBLCLK:
      PostMessage(hwnd, WM_COMMAND, IDM_ANIMATION, 0);
      break;

    case WM_RBUTTONUP:
      {
        HMENU hMenu;
        POINT pt;

        /*
        It's not necessary to create a pop-up menu at
        run-time using CreatePopupMenu(). You can also
        store the menu as a resource. Simply attach the
        pop-up to a standard resource menu bar, then
        call LoadMenu() to load the menu resource and
        use GetSubMenu() to access the pop-up menu.
        */

        hMenu = CreatePopupMenu();

        AppendMenu(hMenu, MF_ENABLED,
                   IDM_ANIMATION, "Window Animation");
                   AppendMenu(hMenu, MF_ENABLED,
                   IDM_QUIT, "Quit");

        /*
        SetMenuDefaultItem() is a new Shell API function
        that causes the given menu item to display itself
        in bold text. The bold text indicates that the
        item is the default action as a result of double-
        clicking. In this case, double-clicking toggles
        the window animation state; therefore, the
        Window Animation item is displayed in bold.
        */

        SetMenuDefaultItem(hMenu, IDM_ANIMATION, FALSE);

        if (fAnimation)
          CheckMenuItem(hMenu, IDM_ANIMATION,
                        MF_BYCOMMAND | MF_CHECKED);

        GetCursorPos(&pt);

        SetForegroundWindow(hwnd);
        TrackPopupMenu(hMenu, TPM_RIGHTBUTTON,
                       pt.x, pt.y, 0, hwnd, NULL);

        PostMessage(hwnd, WM_USER, 0, 0);

        DestroyMenu(hMenu);
      }
      break;
  }
}

void UpdateAnimationSetting(HWND hwnd)
{
  HKEY hKey;

  if (RegOpenKeyEx(HKEY_CURRENT_USER,
                   "Control Panel\\" \
                   "Desktop\\" \
                   "WindowMetrics",
                   0,
                   KEY_QUERY_VALUE,
                   &hKey) == ERROR_SUCCESS)
  {
    RegSetValueEx(hKey, "MinAnimate", 0, REG_SZ,
                  (BYTE*) (fAnimation ? "1" : "0"), 2);
    RegCloseKey(hKey);

    if ( MessageBox(hwnd,
                   "You must restart your computer " \
                   "before the new setting will take " \
                   "effect.\n\nDo you want to restart " \
                   "your computer now?",
                   "Window Animation Control",
                   MB_ICONQUESTION | MB_SETFOREGROUND |
                   MB_YESNO) == IDYES )
    {
      ExitWindowsEx(EWX_REBOOT, 0);
    }
  }
}

BOOL GetAnimationSetting(void)
{
  HKEY hKey;
  char szData[2];

  if (RegOpenKeyEx(HKEY_CURRENT_USER,
                   "Control Panel\\" \
                   "Desktop\\" \
                   "WindowMetrics",
                   0,
                   KEY_QUERY_VALUE,
                   &hKey) == ERROR_SUCCESS)
  {
    DWORD cbData;

    cbData = 2;
    RegQueryValueEx(hKey, "MinAnimate", 0, NULL,
                    (BYTE*) szData, &cbData);
    RegCloseKey(hKey);
  }

  return szData[0] == '1';
}

LRESULT APIENTRY MainWndProc(HWND hwnd, UINT message,
                            WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
    case TASKBAR_TRAY_MSG:
      TaskbarTray_HandleMessage(hwnd,
                                (UINT)wParam,
                                (UINT)lParam);
      break;

    case WM_COMMAND:
      switch( LOWORD(wParam) )
      {
        case IDM_ANIMATION:
          fAnimation = !fAnimation;
          TaskbarTray_SendMessage(hwnd, NIM_MODIFY);
          UpdateAnimationSetting(hwnd);
          break;

        case IDM_QUIT:
          SendMessage(hwnd, WM_DESTROY, 0, 0);
          break;

        default:
          return DefWindowProc(hwnd, message,
                               wParam, lParam);
      }
      break;

    case WM_CREATE:
      fAnimation = GetAnimationSetting();
      hAnimOnIcon = LoadIcon(hInstance,
                      MAKEINTRESOURCE(IDI_ANIMATION_ON));
      hAnimOffIcon = LoadIcon(hInstance,
                      MAKEINTRESOURCE(IDI_ANIMATION_OFF));
      TaskbarTray_SendMessage(hwnd, NIM_ADD);
      break;

    case WM_DESTROY:
      TaskbarTray_SendMessage(hwnd, NIM_DELETE);
      DestroyIcon(hAnimOnIcon);
      DestroyIcon(hAnimOffIcon);
      PostQuitMessage(0);
      break;

    default:
      return DefWindowProc(hwnd, message,
                           wParam, lParam);
  }

  return 0;
}

int APIENTRY WinMain(HINSTANCE hInst,
                     HINSTANCE hPrevInstance,
                     LPSTR lpCmdLine, int nCmdShow)
{
  MSG msg;
  WNDCLASS wcTaskbarTray;
  HWND hwnd;

  if (hPrevInstance != NULL) return 0;

  hInstance = hInst;

  wcTaskbarTray.style         = 0;
  wcTaskbarTray.lpfnWndProc   = (WNDPROC) MainWndProc;
  wcTaskbarTray.cbClsExtra    = 0;
  wcTaskbarTray.cbWndExtra    = 0;
  wcTaskbarTray.hInstance     = hInstance;
  wcTaskbarTray.hIcon         = NULL;
  wcTaskbarTray.hCursor       = NULL;
  wcTaskbarTray.hbrBackground = NULL;
  wcTaskbarTray.lpszMenuName  = NULL;
  wcTaskbarTray.lpszClassName = "TaskbarTrayClass";

  RegisterClass(&wcTaskbarTray);

  hwnd = CreateWindow("TaskbarTrayClass", "", 0,
                      0, 0, 0, 0,
                      NULL, NULL, hInstance, NULL);

  if (hwnd == NULL) return 0;

  ShowWindow(hwnd, SW_HIDE);
  UpdateWindow(hwnd);

  while ( GetMessage(&msg, NULL, 0, 0) )
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  return (msg.wParam);
}

