unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TfrmMain = class(TForm)
    imgCycle: TImage;
    timCycle: TTimer;
    pntCycle: TPaintBox;
    procedure timCycleTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure pntCyclePaint(Sender: TObject);
  private
    { Private declarations }
    currentBitmap: integer;

  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
   currentBitmap := 1;
end;

procedure TfrmMain.timCycleTimer(Sender: TObject);
begin
   imgCycle.Picture.LoadFromFile(Format('bmp%d.bmp', [currentBitmap]));
   currentBitmap := currentBitmap + 1;
   if currentBitmap > 4 then begin
      currentBitmap := 1;
   end;
   pntCycle.Canvas.CopyRect(pntCycle.ClientRect, imgCycle.Canvas,
      imgCycle.ClientRect);
end;

procedure TfrmMain.pntCyclePaint(Sender: TObject);
begin
   pntCycle.Canvas.CopyRect(pntCycle.ClientRect, imgCycle.Canvas,
      imgCycle.ClientRect);
end;

end.
 