unit Config;

interface

uses
  Forms, SvrUtils, StdCtrls, RzColCbx, RzTrkBar, Controls, Classes;

type
  TFrmConfig = class( TForm )
    GrpLaserSpeed: TGroupBox;
    TrkSpeed: TRzTrackBar;
    BtnOK: TButton;
    BtnCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    ChkRandomColors: TCheckBox;
    TrkPause: TRzTrackBar;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    GrpLaserOrigin: TGroupBox;
    OptUL: TRadioButton;
    OptUC: TRadioButton;
    OptUR: TRadioButton;
    OptML: TRadioButton;
    OptMC: TRadioButton;
    OptMR: TRadioButton;
    OptLL: TRadioButton;
    OptLC: TRadioButton;
    OptLR: TRadioButton;
    ChkRandomOrigin: TCheckBox;
    ChkPassword: TCheckBox;
    BtnSetPassword: TButton;
    CbxColor: TRzColorComboBox;
    procedure BtnSetPasswordClick( Sender : TObject );
    procedure ChkPasswordClick( Sender : TObject );
    procedure BtnOKClick( Sender : TObject );
    procedure BtnCancelClick( Sender : TObject );
    procedure FormCreate( Sender : TObject );
    procedure ChkRandomColorsClick( Sender : TObject );
    procedure ChkRandomOriginClick( Sender : TObject );
  private
    function GetLaserOrigin : TLaserOrigin;
    procedure SetLaserOrigin;
    procedure UpdateOpts;
  end;

var
  FrmConfig: TFrmConfig;

implementation

{$R *.DFM}

uses
  SetPWFrm;


procedure TFrmConfig.FormCreate( Sender : TObject );
begin
  LoadSettings;                          { Initialize Settings }
  CbxColor.SelectedColor := LaserColor;
  TrkSpeed.Position := TrkSpeed.Max - LaserSpeed;
  TrkPause.Position := TrkPause.Max - PauseDelay;
  ChkPassword.Checked := PWProtected;
  ChkRandomColors.Checked := RandomColors;
  ChkRandomOrigin.Checked := RandomOrigin;
  SetLaserOrigin;
  UpdateOpts;
end;


procedure TFrmConfig.SetLaserOrigin;
begin
  case LaserOrigin of
    loUpperLeft:
      OptUL.Checked := True;
    loUpperCenter:
      OptUC.Checked := True;
    loUpperRight:
      OptUR.Checked := True;
    loMidLeft:
      OptML.Checked := True;
    loMidCenter:
      OptMC.Checked := True;
    loMidRight:
      OptMR.Checked := True;
    loLowerLeft:
      OptLL.Checked := True;
    loLowerCenter:
      OptLC.Checked := True;
    loLowerRight:
      OptLR.Checked := True;
  end;
end; {= TFrmConfig.SetLaserOrigin =}


function TFrmConfig.GetLaserOrigin : TLaserOrigin;
begin
  if OptUL.Checked then
    Result := loUpperLeft
  else if OptUC.Checked then
    Result := loUpperCenter
  else if OptUR.Checked then
    Result := loUpperRight
  else if OptML.Checked then
    Result := loMidLeft
  else if OptMC.Checked then
    Result := loMidCenter
  else if OptMR.Checked then
    Result := loMidRight
  else if OptLL.Checked then
    Result := loLowerLeft
  else if OptLC.Checked then
    Result := loLowerCenter
  else
    Result := loLowerRight;
end; {= TFrmConfig.GetLaserOrigin =}


procedure TFrmConfig.BtnSetPasswordClick(Sender: TObject);
begin
  FrmSetPassword := TFrmSetPassword.Create( Application );
  try
    FrmSetPassword.ShowModal;
  finally
    FrmSetPassword.Free;
  end;
end;


procedure TFrmConfig.ChkPasswordClick( Sender : TObject );
begin
  BtnSetPassword.Enabled := ChkPassword.Checked;
end;


procedure TFrmConfig.BtnOKClick( Sender : TObject );
begin
  LaserColor := CbxColor.SelectedColor;
  LaserSpeed := TrkSpeed.Max - TrkSpeed.Position;
  PauseDelay := TrkPause.Max - TrkPause.Position;
  LaserOrigin := GetLaserOrigin;
  PWProtected := ChkPassword.Checked;
  RandomColors := ChkRandomColors.Checked;
  RandomOrigin := ChkRandomOrigin.Checked;
  SaveSettings;
  Close;
end;


procedure TFrmConfig.BtnCancelClick( Sender : TObject );
begin
  Close;
end;


procedure TFrmConfig.ChkRandomColorsClick( Sender : TObject );
begin
  CbxColor.Enabled := not ChkRandomColors.Checked;
end;


procedure TFrmConfig.ChkRandomOriginClick( Sender : TObject );
begin
  UpdateOpts;
end;


procedure TFrmConfig.UpdateOpts;
begin
  OptUL.Enabled := not ChkRandomOrigin.Checked;
  OptUC.Enabled := not ChkRandomOrigin.Checked;
  OptUR.Enabled := not ChkRandomOrigin.Checked;
  OptML.Enabled := not ChkRandomOrigin.Checked;
  OptMC.Enabled := not ChkRandomOrigin.Checked;
  OptMR.Enabled := not ChkRandomOrigin.Checked;
  OptLL.Enabled := not ChkRandomOrigin.Checked;
  OptLC.Enabled := not ChkRandomOrigin.Checked;
  OptLR.Enabled := not ChkRandomOrigin.Checked;
end;

end.
