unit Getpwfrm;

interface

uses
  WinTypes, WinProcs, Messages, Forms, StdCtrls, Controls,
  ExtCtrls, Classes;

type
  TFrmGetPassword = class( TForm )
    Label1: TLabel;
    EdtPassword: TEdit;
    BtnOK: TButton;
    BtnCancel: TButton;
    Image2: TImage;
    procedure BtnOKClick( Sender : TObject );
    procedure FormShow( Sender : TObject );
    procedure FormCreate( Sender : TObject );
    procedure FormDestroy( Sender : TObject );
  private
    FOldWnd : HWnd;
  public
  end;

var
  FrmGetPassword: TFrmGetPassword;

implementation

{$R *.DFM}

uses
  SvrUtils;


procedure TFrmGetPassword.FormCreate(Sender: TObject);
begin
  FOldWnd := SetSysModalWindow( Handle );
end;


procedure TFrmGetPassword.FormDestroy(Sender: TObject);
begin
  SetSysModalWindow( FOldWnd );
end;


procedure TFrmGetPassword.BtnOKClick(Sender: TObject);
begin
  if EncryptString( EdtPassword.Text ) <> Password then
  begin
    Application.MessageBox( 'The password that you typed is not ' +
                            'correct.'#13'Try typing it again.',
                            'Passwords', mb_OK or
                            mb_IconExclamation or mb_SystemModal );
    EdtPassword.Clear;
    { Simulate Mouse click b/c SetFocus is not sufficient to }
    { return focus to the edit field when system modal. }
    SendMessage( EdtPassword.Handle, wm_LButtonDown, 0, 0 );
    SendMessage( EdtPassword.Handle, wm_LButtonUp, 0, 0 );
    Exit;
  end;
  ModalResult := mrOK;
end;


procedure TFrmGetPassword.FormShow(Sender: TObject);
begin
  EdtPassword.SetFocus;
end;

end.
