unit RzColCbx;
interface
uses
  Messages, WinTypes, WinProcs, Classes, Forms, Graphics, Controls,
  StdCtrls, Menus;

type
  TRzColorComboBox = class( TCustomComboBox )
  private
    FIncludeColor : Boolean;
    FShowSysColors : Boolean;
    procedure SetShowSysColors( Value : Boolean );
    function GetSelectedColor : TColor;
    procedure SetSelectedColor( Value : TColor );
    procedure DrawItem( Index : Integer; Rect : TRect;
                        State : TOwnerDrawState ); override;
  protected
    procedure CreateWnd; override;
    procedure AddColor( const S : string ); virtual;
  public
    constructor Create( AOwner : TComponent ); override;
  published
    property SelectedColor : TColor
      read GetSelectedColor
      write SetSelectedColor
      default clBlack;

    property ShowSysColors : Boolean
      read FShowSysColors
      write SetShowSysColors
      default True;

    { Inherited Properties & Events }
    property Color;
    property Ctl3D;
    property DragMode;
    property DragCursor;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Sorted;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDropDown;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
  end;

procedure Register;

implementation

constructor TRzColorComboBox.Create( AOwner : TComponent );
begin
  inherited Create( AOwner );
  Style := csOwnerDrawFixed;   { Notice Style is not published }
  FShowSysColors := True;
end;

procedure TRzColorComboBox.CreateWnd;
begin
  inherited CreateWnd;
  Clear;                               { Clear items from list }
  FIncludeColor := True;
  GetColorValues( AddColor );   { Call AddColor for all Colors }
  SelectedColor := clBlack;
end;

procedure TRzColorComboBox.AddColor( const S : string );
var
  C : Longint;
begin
  { GetColorValues calls AddColor for all colors, including }
  { system colors.  Flag is cleared to skip system colors.  }
  if ( S = 'clScrollBar' ) and not FShowSysColors then
    FIncludeColor := False;

  if FIncludeColor then
  begin
    IdentToColor( S, C );      { Coverts string to color value }
    { Rather than a pointer to an object, the Objects property }
    { is populated with the Longint value of the Color }
    Items.AddObject( Copy( S, 3, 20 ), TObject( C ) );
  end;
end;

procedure TRzColorComboBox.SetShowSysColors( Value : Boolean );
begin
  if Value <> FShowSysColors then
  begin
    FShowSysColors := Value;
    RecreateWnd;
  end;
end;

function TRzColorComboBox.GetSelectedColor : TColor;
begin
  if ItemIndex = -1 then
    Result := clBlack
  else
    Result := TColor( Items.Objects[ ItemIndex ] );
end;

procedure TRzColorComboBox.SetSelectedColor( Value : TColor );

  function IndexFromColor( C : TColor ) : Integer;
  var
    I : Integer;
  begin
    I := 0;
    while (I < Items.Count) and (C <> TColor(Items.Objects[I])) do
      Inc( I );

    if I = Items.Count then
      Result := -1
    else
      Result := I;
  end;

begin
  ItemIndex := IndexFromColor( Value );
end;

procedure TRzColorComboBox.DrawItem( Index : Integer; Rect : TRect;
                                     State : TOwnerDrawState );
var
  R : TRect;
  C : Longint;
begin
  with Canvas do
  begin
    R := Rect;
    InflateRect( R, -2, -2 );
    R.Right := 20;          { R represents size of color block }
    FillRect( Rect );

    { Color value (i.e. TColor) is stored in Objects prooperty }
    Brush.Color := TColor( Items.Objects[ Index ] );
    Rectangle( R.Left, R.Top, R.Right, R.Bottom );
    if odSelected in State then
      Brush.Color := clHighlight
    else
      Brush.Color := Color;               { Display Color Name }
    TextOut( Rect.Left + 24, Rect.Top + 2, Items[ Index ] );
  end;
end;

procedure Register;
begin
  RegisterComponents( 'Raize', [ TRzColorComboBox ] );
end;

end.
