{==============================================================================}
{= RzCommon Unit                                                              =}
{=                                                                            =}
{= This unit defines constants, types, and miscellaneous procedures and       =}
{= functions used by multiple component classes. Also declares the            =}
{= TRzAboutInfo class which is used by the TRzAboutBoxProperty editor.        =}
{=                                                                            =}
{= Building Custom Delphi Components - Ray Konopka                            =}
{= Copyright  1995 by Raize Software Solutions, Inc.                         =}
{==============================================================================}

{$I RAIZE.INC}

unit RzCommon;

interface

uses
  WinTypes, Classes, Graphics, ExtCtrls;

type
  TFrameStyle = ( fsNone, fsFlat, fsGroove, fsBump, fsRecessed, fsRaised );

const                                                           { Color Arrays }
  ULBevelColor : array[ TPanelBevel ] of TColor = ( clWindow,
                                                    clBtnShadow,
                                                    clBtnHighlight);

  LRBevelColor : array[ TPanelBevel ] of TColor = ( clWindow,
                                                    clBtnHighlight,
                                                    clBtnShadow );

  { Frame Style Color constant arrays }

  ULFrameColor : array[ TFrameStyle ] of TColor = ( clWindow,
                                                    clWindowFrame,
                                                    clBtnShadow,
                                                    clBtnHighlight,
                                                    clBtnShadow,
                                                    clBtnHighlight );


  LRFrameColor : array[ TFrameStyle ] of TColor = ( clWindow,
                                                    clWindowFrame,
                                                    clBtnHighlight,
                                                    clBtnShadow,
                                                    clBtnHighlight,
                                                    clBtnShadow );


  TextAlignments : array[ TAlignment ] of Word = ( dt_Left,
                                                   dt_Right,
                                                   dt_Center );

const                                                 { Palette Page Constants }
  RaizePage : string[ 5 ] = 'Raize';
  RaizeStatusPage : string[ 12 ] = 'RzStatus';


type
  { TRzAboutInfo must be persistent so it can appear as a property }

  TRzAboutInfo = class( TPersistent )
  private
    FCopyrightDate : string;
    FCompany       : string;
    FDescription   : string;
  public
    property CopyrightDate : string
      read FCopyrightDate
      write FCopyrightDate;

    property Company : string
      read FCompany
      write FCompany;

    property Description : string
      read FDescription
      write FDescription;
  end;

procedure DrawCtl3DBorder( Canvas : TCanvas; Bounds : TRect );
procedure DrawBorder( Canvas : TCanvas; Bounds : TRect;
                      ULColor, LRColor : TColor );

implementation


{=======================================}
{== Generic DrawCtl3DBorder Procedure ==}
{=======================================}

procedure DrawCtl3DBorder( Canvas : TCanvas; Bounds : TRect );
begin
  with Bounds, Canvas do
  begin
    Pen.Color := clBtnShadow;
    MoveTo( Left, Bottom - 1 );
    LineTo( Left, Top );
    LineTo( Right, Top );

    Pen.Color := clBtnHighlight;
    MoveTo( Right - 1, Top + 1 );
    LineTo( Right - 1, Bottom - 1 );
    LineTo( Left, Bottom - 1 );

    Pen.Color := clBtnText;
    MoveTo( Left + 1, Bottom - 2 );
    LineTo( Left + 1, Top + 1 );
    LineTo( Right - 1, Top + 1 );

    Pen.Color := clBtnFace;
    MoveTo( Right - 2, Top + 2 );
    LineTo( Right - 2, Bottom - 2 );
    LineTo( Left + 1, Bottom - 2 );
  end;
end;


{==================================}
{== Generic DrawBorder Procedure ==}
{==================================}

procedure DrawBorder( Canvas : TCanvas; Bounds : TRect;
                      ULColor, LRColor : TColor );
begin
  with Bounds, Canvas do
  begin
    Pen.Color := ULColor;
    MoveTo( Left, Bottom - 1 );
    LineTo( Left, Top );
    LineTo( Right - 1, Top );

    Pen.Color := LRColor;
    LineTo( Right - 1, Bottom - 1 );
    LineTo( Left, Bottom - 1 );
  end;
end;


end.
