unit Setpwfrm;

interface

uses
  Forms, WinTypes, StdCtrls, Controls, Classes, ExtCtrls;

type
  TFrmSetPassword = class( TForm )
    EdtCurrentPassword: TEdit;
    EdtNewPassword: TEdit;
    EdtConfirmPassword: TEdit;
    LblCurrentPassword: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    BtnOK: TButton;
    BtnCancel: TButton;
    Bevel1: TBevel;
    procedure BtnOKClick( Sender : TObject );
    procedure FormCreate( Sender : TObject );
    procedure FormShow( Sender : TObject );
  private
  public
  end;

var
  FrmSetPassword: TFrmSetPassword;

implementation

{$R *.DFM}

uses
  SvrUtils;


procedure TFrmSetPassword.FormCreate( Sender : TObject );
begin
  EdtCurrentPassword.Clear;
  EdtNewPassword.Clear;
  EdtConfirmPassword.Clear;

  { Disable Edit field and Label if there is no current PW }
  EdtCurrentPassword.Enabled := Password <> '';
  LblCurrentPassword.Enabled := Password <> '';
end;


procedure TFrmSetPassword.BtnOKClick(Sender: TObject);
var
  S : string;
begin
  if EdtCurrentPassword.Enabled then
  begin
    if EncryptString( EdtCurrentPassword.Text ) <> Password then
    begin
      Application.MessageBox( 'The Current password that you ' +
                              'typed is not correct.'#13'Try ' +
                              'typing it again.', 'Passwords',
                              mb_OK or mb_IconExclamation );

      EdtCurrentPassword.Clear;
      EdtNewPassword.Clear;
      EdtConfirmPassword.Clear;
      EdtCurrentPassword.SetFocus;
      Exit;
    end;
  end;

  if EdtNewPassword.Text <> EdtConfirmPassword.Text then
  begin
      Application.MessageBox( 'The new and confirmed passwords ' +
                              'do not match.'#13'Please type ' +
                              'them again.', 'Passwords',
                              mb_OK or mb_IconStop );

    EdtNewPassword.Clear;
    EdtConfirmPassword.Clear;
    EdtNewPassword.SetFocus;
    Exit;
  end;

  SetPassword( EdtNewPassword.Text );
  Application.MessageBox( 'The password has been successfully ' +
                          'changed.', 'Passwords',
                          mb_OK or mb_IconInformation );

  Close;
end; {= TFrmSetPassword.BtnOKClick =}


procedure TFrmSetPassword.FormShow( Sender : TObject );
begin
  if EdtCurrentPassword.Enabled then
    EdtCurrentPassword.SetFocus
  else
    EdtNewPassword.SetFocus;
end;

end.
