unit SvrUtils;

interface

uses
  Graphics;

const
  Colors : array[ 0..15 ] of TColor =
    ( clBlack, clMaroon, clGreen, clOlive, clNavy, clPurple,
      clTeal, clGray, clSilver, clRed, clLime, clYellow, clBlue,
      clFuchsia, clAqua, clWhite );

type
  TLaserOrigin = ( loUpperLeft, loUpperCenter, loUpperRight,
                   loMidLeft, loMidCenter, loMidRight,
                   loLowerLeft, loLowerCenter, loLowerRight );

var
  LaserSpeed : Longint;
  PauseDelay : Longint;
  LaserColor : TColor;
  LaserOrigin : TLaserOrigin;
  Password : string;
  PWProtected : Boolean;
  RandomColors : Boolean;
  RandomOrigin : Boolean;

procedure LoadSettings;
procedure SaveSettings;
function EncryptString( const S : string ) : string;
procedure SetPassword( const S : string );
procedure WinDelay( Duration : Longint );

implementation

uses
  IniFiles, SysUtils, WinProcs, Forms, MMSystem;

const
  Section = 'Screen Saver.DLLaser';

procedure LoadSettings;
var
  IniFile : TIniFile;
  TempInt : Integer;
begin
  IniFile := TIniFile.Create( 'CONTROL.INI' );
  Password := IniFile.ReadString( 'ScreenSaver', 'Password', '' );
  LaserSpeed := IniFile.ReadInteger( Section, 'LaserSpeed', 10 );
  PauseDelay := IniFile.ReadInteger( Section, 'PauseDelay', 10 );
  LaserColor := IniFile.ReadInteger( Section,'LaserColor',clGreen);
  TempInt := IniFile.ReadInteger( Section, 'LaserOrigin',
                                  Ord(loLowerCenter) );
  LaserOrigin := TLaserOrigin( TempInt );
  PWProtected := IniFile.ReadBool( Section, 'PWProtected', False );
  RandomColors := IniFile.ReadBool(Section, 'RandomColors', False);
  RandomOrigin := IniFile.ReadBool(Section, 'RandomOrigin', False);
  IniFile.Free;
end; {= LoadSettings =}


procedure SaveSettings;
var
  IniFile : TIniFile;
begin
  IniFile := TIniFile.Create( 'CONTROL.INI' );
  IniFile.WriteInteger( Section, 'LaserSpeed', LaserSpeed );
  IniFile.WriteInteger( Section, 'PauseDelay', PauseDelay );
  IniFile.WriteInteger( Section, 'LaserColor', LaserColor );
  IniFile.WriteInteger( Section, 'LaserOrigin',Ord(loLowerCenter));
  IniFile.WriteBool( Section, 'PWProtected', PWProtected );
  IniFile.WriteBool( Section, 'RandomColors', RandomColors );
  IniFile.WriteBool( Section, 'RandomOrigin', RandomOrigin );
  IniFile.Free;
end;


function EncryptString( const S : string ) : string;
var
  I, Len : Integer;
  B : Byte;
  Stz : array[ 0..255 ] of Char;

  procedure EXor( X : Byte; var Y : Byte );
  const                { '[]=' - not allowed in profile string }
    NotAllowed = [ 0..$20, $7f..$90, $93..$9F, $3D, $5B, $5D ];
  begin
   if not ( ( Y xor X ) in NotAllowed ) then
     Y := Y xor X;
  end;

begin {= EncryptString =}
  { Encryption method works for Null-Terminated strings }
  { Therefore, first copy S to a null-terminated string }
  StrPCopy( Stz, UpperCase( S ) );
  Len := StrLen( Stz );
  if Len = 0 then
  begin
    Result := '';
    Exit;
  end;

  for I := 0 to Len - 1 do                        { First Pass }
  begin
    B := Byte( Stz[ I ] );
    Exor( Len, B );
    if I = 0 then
      Exor( $2A, B )
    else
    begin
      Exor( I, B );
      Exor( Byte( Stz[ I - 1 ] ), B );
    end;
    Stz[ I ] := Char( B );              { Store Encrypted Byte }
  end;

  if Len > 1 then                                { Second Pass }
  begin
    for I := Len - 1 downto 0 do
    begin
      B := Byte( Stz[ I ] );
      Exor( Len, B );
      if I = Len - 1 then
        Exor( $2A, B )
      else
      begin
        Exor( I, B );
        Exor( Byte( Stz[ I + 1 ] ), B );
      end;
      Stz[ I ] := Char( B );            { Store Encrypted Byte }
    end;
  end;

  Result := StrPas( Stz );            { Return a Pascal string }
end; {= EncryptString =}


procedure SetPassword( const S : string );
var
  IniFile : TIniFile;
begin
  IniFile := TIniFile.Create( 'CONTROL.INI' );
  if S = '' then
    Password := ''
  else
    Password := EncryptString( S );
  IniFile.WriteString( 'ScreenSaver', 'Password', Password );
  IniFile.Free;
end; {= SetPassword =}


procedure WinDelay( Duration : Longint );
var
  Start : Longint;
begin
  if Duration = 0 then
    Exit;
  Start := TimeGetTime;       { TimeGetTime from MMSystem Unit }
  repeat
    Application.ProcessMessages;
  until TimeGetTime - Start >= Duration;
end;

end.
