program Squirmy_Dots;

{$N-,E-,Q+,S+,R-,I+,O-,F+,P+,T-,X-,V-,B+,A+,G+,D-,L-,Y-}
{$M 1024,0,3905}
{$L Bgi256}

(* Compiled in Borland Turbo Pascal 7.0 for DOS. Bgi256.Obj is a non-Borland
   aftermarket add-on file. It is "registered", meaning the Bgi256.Obj file
   itself isn't needed to run Squirmy Dots. *)

uses crt,drivers,graph;

var
Gd, Gm, Error, X, Y, Timer : integer;
Adjuster, Adjuster2 : char;

label Top, Start;

(* Gm := 0 is 320x200x256, 1 is 640x400x256, 2 is 640x480x256,
         3 is 800x600x256, 4 is 1024x768x256, 5 is 1280x1024x256 *)

procedure Bgi256proc; external;

procedure InitBGI256;
begin
Gd := installuserdriver('Bgi256',nil);
Error := registerbgidriver(@Bgi256proc);
if Adjuster = '1' then Gm := 0;  (* Run in 320x200x256 mode *)
if Adjuster = '2' then Gm := 2;  (* Run in 640x480x256 mode *)
if Adjuster = '3' then Gm := 3;  (* Run in 800x600x256 mode *)
if Adjuster = '4' then Gm := 4;  (* Run in 1024x768x256 mode *)
initgraph(Gd,Gm,'');
Error := graphresult;
if Error <> 0 then
begin
closegraph;
writeln('                                                         ');
writeln(' Sorry, your display and/or video card is incompatible   ');
writeln(' with this screen saver program. Oh, well; No harm done. ');
writeln('                                                         ');
halt(1);
end;
end;

procedure InitBgi256_2;
begin
if Adjuster = '1' then Gm := 0;  (* Run in 320x200x256 mode *)
if Adjuster = '2' then Gm := 2;  (* Run in 640x480x256 mode *)
if Adjuster = '3' then Gm := 3;  (* Run in 800x600x256 mode *)
if Adjuster = '4' then Gm := 4;  (* Run in 1024x768x256 mode *)
initgraph(Gd,Gm,'');
Error := graphresult;
if Error <> 0 then
begin
closegraph;
writeln('                                                         ');
writeln(' Sorry, your display and/or video card is incompatible   ');
writeln(' with this screen saver program. Oh, well; No harm done. ');
writeln('                                                         ');
halt(1);
end;
end;

procedure Exit_Program;
begin
closegraph;
textcolor(7);
textbackground(0);
clrscr;
textcolor(11);
textbackground(1);
gotoxy(1,4);
write(' I''m glad you tried Squirmy Dots');
textcolor(139);
writeln('! ');
writeln;
donesyserror;   (* Turns off initsyserror for program exit. *)
halt;
end;

begin
initsyserror;   (* Turns off ctrl-break, in drivers unit. *)
Adjuster2 := 'A';
textcolor(14);
textbackground(5);
Top:
clrscr;
gotoxy(1,3);
writeln(' Welcome to "Squirmy Dots"! While it''s running, if you press N (for "new") you');
writeln(' you blank the screen and start all over again. If you press any key besides B');
writeln(' or N, you exit to DOS. If you have enough video ram as shown below, you will');
writeln(' see up to 262,144 colors over a period of time. Even though this program shows');
writeln(' only up to 256 colors at any one instant in time, the palette is "rotated" or');
writeln(' "cycled", if you will, through 18 bits or 256k true color! (Over time though).');
writeln(' Squirmy Dots is designed around a Christmas lights theme, in terms of a set of');
writeln(' decoration lights. The video modes are in the menu below. This is version 5.5');
writeln(' of the program. Also, you will see an occasional short flicker at the screen,');
writeln(' this is intended. It''s in one of 262,144 shades also. This is all meant to be');
writeln(' very relaxing like soft music. If you press the B key (for Back to this menu),');
writeln(' you can return to this menu to choose another video mode, or exit the program.');
writeln(' Choose a mode; 1 through 5 now to begin.....');
writeln;
writeln(' 1) Run Squirmy Dots at  320x200 (needs 256 k ram on the video card)');
writeln(' 2) Run Squirmy Dots at  640x480 (needs 512 k ram on the video card)');
writeln(' 3) Run Squirmy Dots at  800x600 (needs 1 meg ram on the video card)');
writeln(' 4) Run Squirmy Dots at 1024x768 (needs 1 meg ram on the video card)');
writeln(' 5) Exit this program');
writeln(' Remember, press B or N during the show if you like, any other key exits');
gotoxy(46,15);
Adjuster := readkey;

case Adjuster of
'1' : begin  X:= 320; Y:=200; Timer:=145;  end;
'2' : begin  X:= 640; Y:=480; Timer:= 31;  end;
'3' : begin  X:= 800; Y:=600; Timer:= 21;  end;
'4' : begin  X:=1024; Y:=768; Timer:= 13;  end;
'5' : Exit_Program;
else goto Top;
end;

if (Adjuster2 = 'b') or (Adjuster2 = 'B') then
InitBgi256_2
else InitBgi256;

Start:
repeat
putpixel(random(X), random(Y), random(256));
delay(random(Timer));
delay(1);
setrgbpalette(random(256),random(64),random(64),random(64));
delay(random(Timer));
delay(1);
setrgbpalette(0,0,0,0);
until keypressed;

Adjuster2 := readkey;

case Adjuster2 of
'n','N' : begin clearviewport; goto Start; end;
'b','B' : begin closegraph; goto Top; end;
else Exit_Program;
end;

end.