
; CapaPlay II Unit for Assembler
;
; Syntax: call commandname C,parameters
; Value returned is either in dx:ax,ax or al depending on size

;****************************** GUS Settings **********************************

extrn _CP_GetIRQ:far				;byte
extrn _CP_SetIRQ:far				;(byte NewIRQ)
extrn _CP_GetDMA:far				;byte
extrn _CP_SetDMA:far				;(byte NewDMA)
extrn _CP_GetBasePort:far			;word
extrn _CP_SetBasePort:far			;(word NewBasePort)
extrn _CP_SetLineIn:far				;(byte LineInState)
extrn _CP_SetMicIn:far				;(byte MicInState)

;******************************* Load/Unload **********************************

extrn _CP_LoadModule:far			;byte (dword ptr ModName,dword StartOffset,byte TransferMode)
extrn _CP_LoadOnlyPatterns:far			;byte (dword ptr ModName,dword StartOffset,byte TransferMode)
extrn _CP_FreeModule:far

;***************************** Start/Stop/Pause *******************************

extrn _CP_StartModule:far			;(byte Amplification,byte DefaultPanning,byte TimerMode)
extrn _CP_StopModule:far	
extrn _CP_PauseModule:far

;********************** Set General Module Information ************************

extrn _CP_SetSpeedZeroMode:far			;(byte SpeedZeroMode)
extrn _CP_SetPanEffectMode:far			;(byte PanEffectMode)
extrn _CP_SetVBlankMode:far			;(byte VBlankMode)
extrn _CP_SetAmigaLimitsMode:far		;(byte AmigaLimitsMode)

;********************** Get General Module Information ************************

extrn _CP_GetModuleName:far			;dword poworder
extrn _CP_GetModuleType:far			;byte  
extrn _CP_GetModuleLength:far			;byte
extrn _CP_GetNumOfPatterns:far			;word
extrn _CP_GetNumOfInstruments:far		;byte
extrn _CP_GetNumOfChannels:far			;byte
extrn _CP_GetNumOfUsedChannels:far		;byte
extrn _CP_GetRestartPosition:far		;byte
extrn _CP_GetUsedPatternMemory:far		;dword
extrn _CP_GetUsedInstrumentInfoMemory:far	;dword
extrn _CP_GetUsedGUSMemory:far			;dword
extrn _CP_GetFileSize:far			;dword

;********************** Set General Playing Information ***********************

extrn _CP_SetPosition:far			;(word NewPosition)
extrn _CP_SetGlobalVolume:far			;(word NewVolume)
extrn _CP_SetMainVolume:far			;(word NewVolume)
extrn _CP_RestoreInitialVolume:far
extrn _CP_SetSpeed:far				;(word NewSpeed)
extrn _CP_SetTempo:far				;(word NewTempo)
extrn _CP_RestoreSpeedAndTempo:far
extrn _CP_SetDefaultPanning:far			;(signed byte DefaultPanning)

;********************** Get General Playing Information ***********************

extrn _CP_GetRow:far				;byte
extrn _CP_GetNumOfRows:far			;word (word PositionNum)
extrn _CP_GetPosition:far			;byte
extrn _CP_GetPattern:far			;byte
extrn _CP_GetGlobalVolume:far			;byte
extrn _CP_GetMainVolume:far			;byte
extrn _CP_GetSpeed:far				;byte
extrn _CP_GetTempo:far				;byte
extrn _CP_GetPlayingTime:far			;word
extrn _CP_GetTimer:far				;dword
extrn _CP_GetLoopCounter:far			;byte

;************************* Set Channel Information ****************************

extrn _CP_SetChannelMute:far			;(word ChannelNum,byte MuteState)
extrn _CP_SetChannelPanning:far			;(word ChannelNum,byte NewPanning)
extrn _CP_PlaySample:far			;(word ChannelNum,word InstrumentNum,word SampleNum,byte Note,byte Octave)
extrn _CP_StopSample:far			;(word ChannelNum)

;************************* Get Channel Information ****************************

extrn _CP_GetChannelNote:far			;byte (word ChannelNum)
extrn _CP_GetChannelOctave:far			;byte (word ChannelNum)
extrn _CP_GetChannelVolume:far			;byte (word ChannelNum)
extrn _CP_GetChannelEffect:far			;byte (word ChannelNum)
extrn _CP_GetChannelEffectParams:far		;byte (word ChannelNum)
extrn _CP_GetChannelInstrument:far		;byte (word ChannelNum)
extrn _CP_GetChannelSample:far			;byte (word ChannelNum)
extrn _CP_GetChannelBar:far			;byte (word ChannelNum)
extrn _CP_GetChannelNoteTrigger:far		;byte (word ChannelNum)
extrn _CP_GetChannelPanning:far			;byte (word ChannelNum)
extrn _CP_GetChannelMute:far			;byte (word ChannelNum)

;******************** Set Instrument;Sample Information ***********************

extrn _CP_SetSampleMute				;byte (word InstrumentNum,word SampleNum,byte MuteState)

;******************** Get Instrument;Sample Information ***********************

extrn _CP_GetInstrumentName:far			;dword ptr (word InstrumentNum)
extrn _CP_GetNumOfSamples:far			;byte (word InstrumentNum)
extrn _CP_GetSampleName:far			;dword ptr (word InstrumentNum,word SampleNum)
extrn _CP_GetSampleSize:far			;dword (word InstrumentNum,word SampleNum)
extrn _CP_GetSampleC4Spd:far			;word (word InstrumentNum,word SampleNum)
extrn _CP_GetSampleVolume:far			;byte (word InstrumentNum,word SampleNum)
extrn _CP_GetSamplePanning:far			;byte (word InstrumentNum,word SampleNum)
extrn _CP_GetSampleLoopType:far			;byte (word InstrumentNum,word SampleNum)
extrn _CP_GetSampleLoopBegin:far		;dword (word InstrumentNum,word SampleNum)
extrn _CP_GetSampleLength:far			;dword (word InstrumentNum,word SampleNum)
extrn _CP_GetSample16Bit:far			;byte (word InstrumentNum,word SampleNum)
extrn _CP_GetSampleMute:far			;byte (word InstrumentNum,word SampleNum)

