/*
 * 
 * blt2cx02.c - 17-Oct-1995 Cornel Huth 
 * This module is called by blt2demo.c
 * External data (non-BULLET data file) key store
 *
 */

#include "platform.h"

#ifdef ON_OS2
   #include <os2.h>
#endif
#ifdef ON_W95
   #define WIN32_LEAN_AND_MEAN
   #include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#ifdef ON_OS2
   #include "bullet2.h"
#endif
#ifdef ON_W95
   #include "bullet95.h"
#endif
#ifdef ON_DOSX
   #include "bulletx.h"
#endif


extern CHAR *collateTable;


int cx02() {

#pragma pack(1)

ACCESSPACK AP;
DOSFILEPACK DFP;
CREATEINDEXPACK CIP;
HANDLEPACK HP;
OPENPACK OP;

#pragma pack()

time_t startTime, endTime;

int display = 0;                // display results or not flag
int sameSequence = 1;           // use same sequence for keys or new flag
int binaryKey = 0;              // store key as binary 32-bit flag

LONG rndSeqVar = 0;             // used to construct on-the-fly key

CHAR nameIX3[] = "$CX02.IX3";   // name of index file created
ULONG indexID=0;                // handle of index file
CHAR keyExpression[128];        // key expression string buffer (159 max)
CHAR keyBuffer[68];             // buffer used to store/receive key values

ULONG keys2add;                 // keys to store
LONG i;                         // counter
CHAR tmpStr[64];                // misc stuff, non-Bullet related
LONG rez;                       // return value from Bullet
LONG dupHits = 0;               // duplicate keys generated from rand()


// Delete previous files from any previous run (disregard any error return)

DFP.func = DELETE_FILE_DOS;
DFP.filenamePtr = nameIX3;
rez = BULLET(&DFP);

strcpy(keyExpression,"EXTERNAL DATA SO NOT PARSED BUT IS STORED");

CIP.func = CREATE_INDEX_XB;
CIP.filenamePtr = nameIX3;
CIP.keyExpPtr = keyExpression;
CIP.xbLink = -1;                // must be -1 to use external data
                                // sort by ASCII (or any valid sort-cmp func)
CIP.sortFunction = (8 << 8) | ASCII_SORT;  // the 8 is the key size

CIP.codePage = 0;               // use OS-default code page
CIP.countryCode = 0;            // use OS-default country code
CIP.collatePtr = NULL;          // since ASCII_SORT, no collate table is used
CIP.nodeSize = 512;             // 512-byte node size (or 1024, 2048 bytes)
rez = BULLET(&CIP);
if (rez) {
   printf("Failed index file create.  Err: %li\n",rez);
   goto Abend;
}

OP.func = OPEN_INDEX_XB;
OP.filenamePtr = nameIX3;
OP.asMode = READWRITE | DENYNONE; // must always specify a sharing mode
OP.xbLink = -1;                   // must be -1 to use external data
rez = BULLET(&OP);
if (rez) {
   printf("Failed index file open.  Err: %li\n",rez);
   goto Abend;
}
indexID = OP.handle;


printf("Display keys and key data (slower results)? (y/N) ");
gets(tmpStr);
if (*tmpStr=='y') display = 1;

printf("           Repeat same random key sequence? (Y/n) ");
gets(tmpStr);
if (*tmpStr=='n') sameSequence = 0;

printf("\n Since storing keys one at a time, it's recommended that you\n");
printf(" limit the keys for this test to less than 100,000 or so.  You could\n");
printf(" add until your disk fills...use Ctrl-C if you can't wait.\n\n");
printf("    How many keys to store (100k takes 1-4 min.)? ");
gets(tmpStr);
keys2add = atol(tmpStr);
if (keys2add < 1) keys2add = 1;       // would you rather end the test?
if (keys2add > 9999999) keys2add = 1; // why wait around for so many?

if (sameSequence)
   srand(1);
else
   srand((unsigned)time(0));

printf("  Storing %ld keys... ",keys2add);
if (display) printf("\n");

time(&startTime);

AP.func = STORE_KEY_XB;
AP.handle = indexID;
AP.keyPtr = keyBuffer;
AP.recNo = 1;           // 32-bit data attached, start at 1 (why not)

if (binaryKey) {
   printf("binaryKey version is not coded\n");
}
else {
   for (i = 1; i <= keys2add; i++) {
      rndSeqVar = (rand() >> 3) * (rand() >> 3);   // 4095*4095=16769025 max
      sprintf(tmpStr,"%8.8i",rndSeqVar);
      strncpy(keyBuffer,tmpStr,8);

      rez = BULLET(&AP);
      if (rez) {

         // tried to insert a 'random' key that was already in the index; since
         // this is not INSERT_XB, dups are not automatically handled -- here
         // they're just skipped and another store is done to cover the total

         if (rez==EXB_KEY_EXISTS) {
            dupHits++;
            i--;                // do another key store (reuse AP.recNo)
         }
         else {
            printf("Failed storing key %s  %ld.  Err: %li\n",keyBuffer,i,rez);
            goto Abend;
         }
      }
      else {
          if (display) printf("%8.8s  %9.9lu\r", keyBuffer, AP.recNo);
         AP.recNo++;
      }
   }

}
time(&endTime);
if (display) printf("\n...");

printf("took %lu secs.",(endTime - startTime));

if (dupHits) 
   printf(" (had %ld duplicates--ignored)\n",dupHits);
else
   printf("\n");

memset(keyBuffer,0,sizeof(keyBuffer)); // gives the \0 to the returned key

printf("Accessing %ld keys in order... ",keys2add);
if (display) printf("\n");
time(&startTime);
AP.func = FIRST_KEY_XB;
AP.handle = indexID;
AP.keyPtr = keyBuffer;
rez = BULLET(&AP);
i=0;
while (rez==0) {
   i++;
   if (display) printf("%8.8s  %9.9lu\r", keyBuffer, AP.recNo);
   AP.func = NEXT_KEY_XB;
   rez = BULLET(&AP);
};
if (display) printf("\n...");

// expected rez is EXB_END_OF_FILE

if (rez!=EXB_END_OF_FILE)  {
   printf("Failed KEY access.  Err: %li\n",rez);
   goto Abend;
}
time(&endTime);
printf("took %lu secs. for %ld keys\n",(endTime - startTime),i);


// Fatal errors above come straight to here
Abend:

// Close file

if (indexID) {
   HP.func = CLOSE_INDEX_XB;
   HP.handle = indexID;
   rez = BULLET(&HP);
   if (rez)
      printf("Failed index file close.  Err: %li\n",rez);
}
return rez; 
}
