/******************************************************************************
Module name: NoDigits.c
Written by: Jeffrey Richter
Notices: Copyright (c) 1995 Jeffrey Richter
Purpose: Demonstrates how to subclass a window
******************************************************************************/


#include "..\Win95ADG.h"          /* See Appendix A for details */
#include <Windows.h>
#include <WindowsX.h>
#pragma warning(disable: 4001)    /* Single-line comment */
#include "resource.h"


///////////////////////////////////////////////////////////////////////////////


// Function that converts an edit window to a NoDigitsClass window
// by subclassing the edit window
BOOL WINAPI NoDigitsClass_ConvertEdit (HWND hwnd, BOOL fSubclass);


///////////////////////////////////////////////////////////////////////////////


BOOL NoDigits_OnInitDialog (HWND hwnd, HWND hwndFocus, LPARAM lParam) {

   adgSETDLGICONS(hwnd, IDI_SUBCLASS, IDI_SUBCLASS);

   // Turn the regular edit windows into NoDigits windows by subclassing them.
   NoDigitsClass_ConvertEdit(GetDlgItem(hwnd, IDC_NODIGITS1), TRUE);
   NoDigitsClass_ConvertEdit(GetDlgItem(hwnd, IDC_NODIGITS2), TRUE);

   return(TRUE);  // Accepts default focus window.
}


///////////////////////////////////////////////////////////////////////////////


void NoDigits_OnCommand (HWND hwnd, int id, HWND hwndCtl, UINT codeNotify) {

   switch (id) {
      case IDCANCEL:              // Allows dialog box to close.

         // Turn the NoDigits windows back into regular Edit windows.
         NoDigitsClass_ConvertEdit(GetDlgItem(hwnd, IDC_NODIGITS1), FALSE);
         NoDigitsClass_ConvertEdit(GetDlgItem(hwnd, IDC_NODIGITS2), FALSE);
         EndDialog(hwnd, id);
         break;
   }   
}


///////////////////////////////////////////////////////////////////////////////


BOOL WINAPI NoDigits_DlgProc (HWND hwnd, UINT uMsg, 
   WPARAM wParam, LPARAM lParam) {

   switch (uMsg) {

      // Standard Window's messages
      adgHANDLE_DLGMSG(hwnd, WM_INITDIALOG, NoDigits_OnInitDialog);
      adgHANDLE_DLGMSG(hwnd, WM_COMMAND,    NoDigits_OnCommand);
   }
   return(FALSE);                 // We didn't process the message.
}


///////////////////////////////////////////////////////////////////////////////


int WINAPI WinMain (HINSTANCE hinstExe, HINSTANCE hinstPrev, 
   LPSTR lpszCmdLine, int nCmdShow) {

   adgWARNIFUNICODEUNDERWIN95();
   adgVERIFY(-1 != DialogBox(hinstExe, MAKEINTRESOURCE(IDD_NODIGITS),
      NULL, NoDigits_DlgProc));

   return(0);
}


//////////////////////////////// End of File //////////////////////////////////
