{ Drag and Drop Control Unit -- Williams }
unit Dragctrl;

interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls;

{ Stand in for Form (or parent) OnDragOver }
procedure FormDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
{ Stand in for Parent's OnDragDrop }
procedure FormDragDrop(Sender, Source: TObject; X, Y: Integer);
{ Stand in for Control's OnDragOver }
procedure CtrlDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
{ Set Edit and label OnDragOver events }
procedure SetCallbacks(aForm : TForm; cb : TDragOverEvent);

implementation
procedure FormDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
{ Don't accept over non-client area }
Accept:= (X>=0) and (Y>=0);
end;

procedure FormDragDrop(Sender, Source: TObject; X, Y: Integer);
var
ctl, own:TControl;
begin
{ don't drop in title bar, etc.}
if (X < 0) or (Y < 0) then exit;
ctl:=Source as TControl;
own:=Sender as TControl;
{ If not over parent, then reparent control }
  if ctl.Parent <> own then
    ctl.Parent:=own as TWinControl;
  ctl.Left:=X;
  ctl.Top:=Y;
end;

procedure CtrlDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
var
  obj : TControl;
  pt : TPoint;
  aForm : TWinControl;
begin
if (Sender = Source) and (State = dsDragEnter) then
  begin
{ Drag into self, so adjust hot spot }
  obj:=Source as TControl;
  aForm:=obj.Parent;
  pt.x:=obj.Left;
  pt.y:=obj.Top;
  pt:=aForm.ClientToScreen(pt);
  SetCursorPos(pt.x,pt.y);
  end;
{ Don't allow control to accept another control }
Accept:=False;
end;

procedure SetCallbacks(aForm : TForm; cb : TDragOverEvent);
var
i : integer;
eobj : TEdit;
lobj : TLabel;
begin
{ Walk component list }
for i:=0 to aForm.ComponentCount-1 do
  begin
  eobj:=nil;
  lobj:=nil;
{ Set eobj for edits and lobj for labels }
  if (aForm.Components[i] is TEdit) then
    eobj:=aForm.Components[i] as TEdit;
  if (aForm.Components[i] is TLabel) then
    lobj:=aForm.Components[i] as TLabel;
{ Set event as appropriate }
  if (eobj <> nil) then
     eobj.OnDragOver:=cb;
  if (lobj <> nil) then
     lobj.OnDragOver:=cb;
  end;
end;



end.
