{ WININFO Main Unit }
unit Mainwin;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, IniFiles,
  DragCtrl,EditDlg,DispList,About, ExtCtrls;

type
  TForm1 = class(TForm)
    CXScreen: TEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Customize1: TMenuItem;
    Move1: TMenuItem;
    Show1: TMenuItem;
    BackgroundColor1: TMenuItem;
    About1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    CYScreen: TEdit;
    ChangeLabels: TMenuItem;
    N2: TMenuItem;
    ColorDialog: TColorDialog;
    SMMouse: TEdit;
    FieldColor1: TMenuItem;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Move1Click(Sender: TObject);
    procedure FormDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure FormDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure CtrlDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure LabelDblClick(Sender: TObject);
    procedure ChangeLabelsClick(Sender: TObject);
    procedure BackgroundColor1Click(Sender: TObject);
    procedure Show1Click(Sender: TObject);
    procedure FieldColor1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    private
    { Private declarations }
    Moving, chglbl : Boolean; { Change label text? }
    inifile : TIniFile;       { Our INI file }
    fieldColor : TColor;      { Field color (-1=default)}
    procedure SetMoving(flag : Boolean); { Moving?}
    procedure Load;
    procedure Save;
    procedure SetFieldColor(aColor : TColor);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Exit1Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
s : String;
begin
{ Reset modes and set defaults }
   Moving:=False;
   chglbl:=False;
   fieldColor:=-1;
{ Set INI file }
   inifile:=TIniFile.Create('WININFO.INI');
{ Set up info fields }
   Str(GetSystemMetrics(SM_CXSCREEN),s);
   CXScreen.Text:=s;
   Str(GetSystemMetrics(SM_CYSCREEN),s);
   CYScreen.Text:=s;
   if GetSystemMetrics(SM_MOUSEPRESENT)=0 then
     SMMouse.Text:='No'
   else
     SMMouse.Text:='Yes';
{ Set up callbacks }
   DragCtrl.SetCallbacks(self,CtrlDragOver);
   Load;  { Load custom config }
end;

{ Helper to set moving status on }
procedure TForm1.SetMoving(flag : Boolean);
var
eobj : TEdit;
lobj : TLabel;
i : Integer;
begin
{ Walk component list }
for i:=0 to ComponentCount-1 do
  begin
  eobj:=nil;
  lobj:=nil;
  if (Components[i] is TEdit) or
     (Components[i] is TLabel) then
    begin
    if Components[i] is TEdit then
      eobj:=Components[i] as TEdit
    else
      lobj:=Components[i] as TLabel;

{ Set drag mode and hint flag }
    if not flag then
      if eobj <> nil then
        begin
        eobj.DragMode:=dmManual;
        eobj.ShowHint:=False;
        end
      else
        begin
        lobj.DragMode:=dmManual;
        lobj.ShowHint:=False;
        end
    else
      if eobj <> nil then
        begin
        eobj.DragMode:=dmAutomatic;
        eobj.ShowHint:=True;
        end
      else
        begin
        lobj.DragMode:=dmAutomatic;
        lobj.ShowHint:=True;
        end;
    end;
  end;
end;

{Move menu }
procedure TForm1.Move1Click(Sender: TObject);
var
menu : TMenuItem;
begin
menu := Sender as TMenuItem;
 if menu.Checked then
   menu.Checked:=False
 else
   menu.Checked:=True;
 SetMoving(menu.Checked);
 Moving:=menu.Checked;
 if (Moving) then {uncheck label change flag }
   begin
   chglbl:=False;
   MainMenu1.Items[0][0][1].Checked:=False;
   end;
end;

{ Pass DragOver to CtrlDrag }
procedure TForm1.FormDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
 DragCtrl.FormDragOver(Sender,Source,X,Y,State,Accept);
end;

{ Pass DragDrop to CtrlDrag }
procedure TForm1.FormDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  DragCtrl.FormDragDrop(Sender,Source,X,Y);
end;

{ Pass DragOver to CtrlDrag }
procedure TForm1.CtrlDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  DragCtrl.CtrlDragOver(Sender,Source,X,Y,State,Accept);
end;


{Double click label to edit }
procedure TForm1.LabelDblClick(Sender: TObject);
var
  lbl : TLabel;
begin
  if not chglbl then exit;   { ignore if wrong mode }
  lbl:=Sender as TLabel;
  LblEditor.text:=lbl.Caption;
  LblEditor.ShowModal;
  if LblEditor.ModalResult=mrOK then
    lbl.Caption:=LblEditor.text;
end;

{ Toggle label change mode }
procedure TForm1.ChangeLabelsClick(Sender: TObject);
begin
chglbl:=not MainMenu1.Items[0][0][1].Checked;
MainMenu1.Items[0][0][1].Checked:=chglbl;
{need to turn off moving }
Moving:=False;
SetMoving(False);
MainMenu1.Items[0][0][0].Checked:=False;
end;

{ Change form's background color }
procedure TForm1.BackgroundColor1Click(Sender: TObject);
begin
ColorDialog.Color:=Color;
if ColorDialog.Execute then
  Color:=ColorDialog.Color;
end;

{ Show which fields? }
procedure TForm1.Show1Click(Sender: TObject);
var
 i,n: integer;
 obj : TControl;
begin
 DisplayList.SrcList.Clear;
 DisplayList.DstList.Clear;
{ Put all hidden fields in SrcList and
  all visible fields in DstList }
 for i:=0 to ComponentCount-1 do
  begin
  if (Components[i] is TEdit) or (Components[i] is TLabel) then
    obj := Components[i] as TControl
  else
    continue;
  if obj.Visible then
    begin
    n:=DisplayList.DstList.Items.Add(obj.hint);
{ Store object too }
    DisplayList.DstList.Items.Objects[n]:=obj;
    end
  else
    begin
    n:=DisplayList.SrcList.Items.Add(obj.hint);
{ Store object too }
    DisplayList.SrcList.Items.Objects[n]:=obj;
    end;
  end;

{GO!}
DisplayList.SetButtons;
DisplayList.ShowModal;
if DisplayList.ModalResult=mrOk then
  begin
{ Show/hide based on which list control is in }
  for i:=0 to DisplayList.SrcList.Items.Count-1 do
    (DisplayList.SrcList.Items.Objects[i] as TControl).Visible:=False;
  for i:=0 to DisplayList.DstList.Items.Count-1 do
    (DisplayList.DstList.Items.Objects[i] as TControl).Visible:=True;
  end;
end;

{ Change field colors }
procedure TForm1.FieldColor1Click(Sender: TObject);
begin
ColorDialog.Color:=fieldColor;
if ColorDialog.Execute then
  SetFieldColor(ColorDialog.Color);
end;

{ Set field color }
procedure TForm1.SetFieldColor(aColor : TColor);
var
  i : Integer;
begin
  fieldColor:=aColor;
  for i:=0 to ComponentCount-1 do
    if Components[i] is TEdit then
      (Components[i] as TEdit).Color:=aColor;

end;


procedure TForm1.About1Click(Sender: TObject);
begin
AboutBox.ShowModal;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Save;  { Write custom config to INI file }
end;

procedure TForm1.Save;
var
 tfstring : String;
 i : Integer;
 eobj : TEdit;
 lobj : TLabel;
begin
{ Save colors }
  inifile.WriteInteger('Colors','Form',ColorToRGB(Color));
  if fieldColor <> -1 then
    inifile.WriteInteger('Colors','Field',ColorToRGB(fieldColor));
{ Save components }
  for i:=0 to ComponentCount-1 do
  begin
  if Components[i] is TEdit then
      begin
      eobj:=Components[i] as TEdit;
      if eobj.Visible then
        tfstring:='T'
      else
        tfstring:='F';
      inifile.WriteString('TEdit',eobj.Name,Format('%d,%d,%s',
       [eobj.Left,eobj.Top,tfstring]));
      end;

  if Components[i] is TLabel then
      begin
      lobj:=Components[i] as TLabel;
      if lobj.Visible then
        tfstring:='T'
      else
        tfstring:='F';
      inifile.WriteString('TLabel',lobj.Name,Format('%d,%d,%s,%s',
       [lobj.Left,lobj.Top,tfstring,lobj.Caption]));
      end;
  end;

end;


procedure TForm1.Load;
var
  tmpint : LongInt;
  str : String;
  i,n : Integer;
  eobj : TEdit;
  lobj : TLabel;
begin
{ Read colors }
  tmpint:=inifile.ReadInteger('Colors','Form',-1);
  if tmpint <> -1 then
    Color:=TColor(tmpint);
  tmpint:=inifile.ReadInteger('Colors','Field',-1);
  if tmpint <> -1 then
    SetFieldColor(TColor(tmpint));

{ Read config for each Edit control/label }
 for i:=0 to ComponentCount-1 do
  begin
  if Components[i] is TEdit then
      begin
      eobj:=Components[i] as TEdit;
      str:=inifile.ReadString('TEdit',eobj.Name,'');
      n:=pos(',',str);
      if n<>0 then
        eobj.Left:=StrToInt(Copy(str,1,n-1));
      str:=Copy(str,n+1,255);
      n:=pos(',',str);
      if n<>0 then
        eobj.Top:=StrToInt(Copy(str,1,n-1));
      n:=pos(',',str);
      if (n<>0) and (str[n+1]='F') then
        eobj.Visible:=False
      else
        eobj.Visible:=True;
      end;

  if Components[i] is TLabel then
      begin
      lobj:=Components[i] as TLabel;
      str:=inifile.ReadString('TLabel',lobj.Name,'');
      n:=pos(',',str);
      if n<>0 then
        lobj.Left:=StrToInt(Copy(str,1,n-1));
      str:=Copy(str,n+1,255);
      n:=pos(',',str);
      if n<>0 then
        lobj.Top:=StrToInt(Copy(str,1,n-1));
      n:=pos(',',str);
      if (n<>0) and (str[n+1]='F') then
        lobj.Visible:=False
      else
        lobj.Visible:=True;
      if n <> 0 then
        lobj.Caption:=Copy(str,n+3,255);
      end;
  end;


end;


end.
