/******************************************************************************
Module name: AniBtn.c
Written by: Jeffrey Richter
Notices: Copyright (c) 1995 Jeffrey Richter
Purpose: AniBtn superclass child control implementation file
******************************************************************************/


#include "..\Win95ADG.h"          /* See Appendix A for details */
#include <windows.h>
#include <windowsx.h>
#pragma warning(disable: 4001)    /* Single-line comment */
#include <commctrl.h>
#include "SuperCls.h"
#include "AniBtn.h"


///////////////////////////////////////////////////////////////////////////////


// The imagelist code requires the ComCtl32.lib library.  Because 
// VC++ 2.x doesn't link with ComCtl32.lib by default, I must force it.
#pragma comment(lib, "ComCtl32.lib")


///////////////////////////////////////////////////////////////////////////////


typedef struct {
   HIMAGELIST himl;               // Handle of imagelist containing images
   int iImage;                    // Index of image in himl to show next
   int nTimeout;                  // Image change interval
} ANIBTN_WNDEXTRABYTES;


///////////////////////////////////////////////////////////////////////////////


void WINAPI AniBtn_OnSetTimer (HWND hwnd, int nTimeout) {

   SuperCls_SetWindowLong(hwnd,  
      adgMEMBEROFFSET(ANIBTN_WNDEXTRABYTES, nTimeout), nTimeout);
   SetTimer(hwnd, 1, nTimeout, NULL);
}


///////////////////////////////////////////////////////////////////////////////


int WINAPI AniBtn_OnGetTimer (HWND hwnd) {

   return(SuperCls_GetWindowLong(hwnd, 
      adgMEMBEROFFSET(ANIBTN_WNDEXTRABYTES, nTimeout)));
}



///////////////////////////////////////////////////////////////////////////////


void WINAPI AniBtn_OnSetImageList (HWND hwnd, HIMAGELIST himl) {

   SuperCls_SetWindowLong(hwnd, 
      adgMEMBEROFFSET(ANIBTN_WNDEXTRABYTES, himl), (LONG) himl);
   SuperCls_SetWindowLong(hwnd, 
      adgMEMBEROFFSET(ANIBTN_WNDEXTRABYTES, iImage), 0);
}


///////////////////////////////////////////////////////////////////////////////


HIMAGELIST WINAPI AniBtn_OnGetImageList (HWND hwnd) {

   return((HIMAGELIST) SuperCls_GetWindowLong(hwnd, 
      adgMEMBEROFFSET(ANIBTN_WNDEXTRABYTES, himl)));
}


///////////////////////////////////////////////////////////////////////////////


LRESULT AniBtn_CallBaseClass (HWND hwnd, UINT uMsg, 
   WPARAM wParam, LPARAM lParam) {

   return(CallWindowProc(SuperCls_GetWndProcBaseCls(hwnd), 
      hwnd, uMsg, wParam, lParam));
}


///////////////////////////////////////////////////////////////////////////////


BOOL AniBtn_OnCreate (HWND hwnd, LPCREATESTRUCT lpCreateStruct) {

   AniBtn_SetTimer(hwnd, 250);    // Default to .25 seconds.

   // Make sure that the button base class is given the opportunity to
   // perform any initialization that it needs to.
   // NOTE: The return value for WM_CREATE is -1 if the window should not be 
   // created and 0 if it should be created.  However, the OnCreate message 
   // cracker expects TRUE to be returned if the window should be created and
   // FALSE if the window should not be created.
   return(-1 != FORWARD_WM_CREATE(hwnd, lpCreateStruct, AniBtn_CallBaseClass));
}


///////////////////////////////////////////////////////////////////////////////


void AniBtn_OnDestroy (HWND hwnd) {

   // If there is an imagelist associated with the button, destroy it.
   HIMAGELIST himl = AniBtn_GetImageList(hwnd);
   if (himl != NULL) 
      ImageList_Destroy(himl);

   // Kill the timer associated with the button.
   KillTimer(hwnd, 1);

   // Make sure that the button base class is given the opportunity to
   // perform any needed clean up.
   FORWARD_WM_DESTROY(hwnd, AniBtn_CallBaseClass);
}


///////////////////////////////////////////////////////////////////////////////


void AniBtn_OnTimer (HWND hwnd, UINT id) {

   HIMAGELIST himl = AniBtn_GetImageList(hwnd);

   if (himl != NULL) {

      // Get the AniBtn's image index.
      int iImage = SuperCls_GetWindowLong(hwnd, 
         adgMEMBEROFFSET(ANIBTN_WNDEXTRABYTES, iImage));

      // Change the AniBtn's icon.
      HICON hiconOld = (HICON) SendMessage(hwnd, BM_SETIMAGE, IMAGE_ICON, 
         (LONG) ImageList_GetIcon(himl, iImage, ILD_NORMAL));

      // Destroy any old icon that is displayed.
      if (hiconOld != NULL) 
         DestroyIcon(hiconOld);

      iImage = ++iImage % ImageList_GetImageCount(himl);
      SuperCls_SetWindowLong(hwnd, 
         adgMEMBEROFFSET(ANIBTN_WNDEXTRABYTES, iImage), iImage);
   }
}


///////////////////////////////////////////////////////////////////////////////


LRESULT WINAPI AniBtn_WndProc (HWND hwnd, UINT uMsg, 
   WPARAM wParam, LPARAM lParam) {

   switch (uMsg) {

      // Standard window messages
      HANDLE_MSG(hwnd, WM_CREATE,        AniBtn_OnCreate);
      HANDLE_MSG(hwnd, WM_DESTROY,       AniBtn_OnDestroy);
      HANDLE_MSG(hwnd, WM_TIMER,         AniBtn_OnTimer);

      // Control-specific messages
      HANDLE_MSG(hwnd, ABM_SETTIMER,     AniBtn_OnSetTimer);
      HANDLE_MSG(hwnd, ABM_GETTIMER,     AniBtn_OnGetTimer);
      HANDLE_MSG(hwnd, ABM_SETIMAGELIST, AniBtn_OnSetImageList);
      HANDLE_MSG(hwnd, ABM_GETIMAGELIST, AniBtn_OnGetImageList);
   }

   return(AniBtn_CallBaseClass(hwnd, uMsg, wParam, lParam));
}


///////////////////////////////////////////////////////////////////////////////


ATOM WINAPI AniBtn_RegisterClass (HINSTANCE hinst, BOOL fGlobalClass) {

   WNDCLASSEX wc;
   adgINITSTRUCT(wc, TRUE);
   if (!GetClassInfoEx(NULL, __TEXT("BUTTON"), &wc)) 
      return(INVALID_ATOM);

   // Calling InitCommonControls isn't strictly necessary because ImageLists
   // are not actually registered window classes, but for "correctness" we
   // call this function here anyway.
   InitCommonControls();

   // Give our new class a new name.
   wc.lpszClassName = WC_ANIBTN;

   // Our module is registering the class.
   wc.hInstance = hinst;

   // Make the new class a global class if the user desires.
   if (fGlobalClass)
      wc.style |= CS_GLOBALCLASS;

   // The following WNDCLASSEX members are not changed for AniBtn:
   //      hIcon, hIconSm, hCursor, hbrBackground, lpszMenuName.

   // Register the new window superclass.
   return(SuperCls_RegisterClassEx(&wc, AniBtn_WndProc, 
      0, sizeof(ANIBTN_WNDEXTRABYTES)));
}


///////////////////////////////////////////////////////////////////////////////


BOOL WINAPI AniBtn_UnregisterClass (HINSTANCE hinst) {

   return(UnregisterClass(WC_ANIBTN, hinst));
}


//////////////////////////////// End of File //////////////////////////////////
