%----------------------------------------------------------------------
%
%     This is the default configuration file for XFLC
%
%     Call XFLC [d:\path\filename.ext] to start XFLC with different
%     controlfiles. 
%    
%     Blank lines or lines with leading space(s) or the "%"-
%     character are treated as comments.
%
%     Refer the XFLC documentations for a more detailed description
%     of the controlfile.
%
%-----------------------------------------------------------------------

% Path where your systemfiles resides. This statement overwrites the
% path specified with the environment variable.
%SysPath C:\RA

% If you have'nt specify a systempath via the environment variable, you
% tell XFLC with this statement to work with a RA or SBBS installation
%BBS RA

% Let's make the filelist
AllFiles

% New files on the board 
NewFiles

% Let's put our LOGO in front of the Public List.
Header

% And some additional information in the buttom of the list..
Footer

% First file area no. to list
First 1

% Last file area no. to list
% These statements takes highest priority
Last 200

% List only areas with the specified level or below.
% Skip areas that are not available for normal users.
Level 50

% XFLC list defaults to mark last months file with a '*' in the Opus way.
% You may change the number of days using MarkLast.
MarkLast 10

% Areas to leave out (up to 200 statements possible)
% This parameter will overwrite the "Level" and the "Show" statements.
%Skip 150

% Add an extra area to the list (up to 200 statements possible).
% This parameter will overwrite the "Level" statement.
%Show 151

% All areas marked with this statement are processed only in
% maintenance mode but are not shown in the filelist
%Silent 160

% This statement will comment out a non-existing file in the filelist
% Never use "Missing" together with "RemMiss"
Missing --- Offline ---

% Delete missing files from FILES.BBS
% FILES.BBS will be completely removed if no more files are in the area!
%RemMiss

% Create a status report. If you set the reserved keyword "ALLFILES"
% the status report will be placed at the end of your AllFiles list.
Stats AllFiles

% With this option you can specify how to archive your filelist
% You can choose between PackA for AllFiles and PackN for NewFiles
PackA ARJ m -jm -s -zLISTHEAD.TXT ALLFILES ALLFILES.TXT >NUL:
%PackA PKZIP -mexo -z ALLFILES ALLFILES.TXT <LISTHEAD.TXT
%PackN ARJ m -jm -s NEWFILES NEWFILES.TXT

% Adopt files: Insert orphans in FILES.BBS.
Adopt

% Make an orphan report of all adopted files (works only with "Adopt")
Orphan

% Enable wrapping of filedescriptions.
Wrap

% The second and following lines of filedescriptions start at the
% column, specified by this statement
Indent 37

% Replace the own errorhandler by QB's error handling. Use this only
% for debugging reasons, since the system will stop and wait for a
% keystroke. 
%FullError

% Place self definable headerfiles at the top of each filearea
AreaHead 

% Let's add the estimated transfer time to the filedescription
XFerTime

% Maximal number of files each filearea
MaxFiles 2000

% If the first character of a line in FILES.BBS matches with one of the
% character(s) specified with this statement, this line will be treated
% as a comment.
Comment -*

% Remove all files matching the filespecification
Crap *.bak
Crap *.@*
Crap DSZ.LOG

DIZFile FILE_ID.DIZ
DIZFile DESC.SDI

% The following statement keeps a backup copy of the modified FILES.BBS
BkUp

% This statement set the date of FILES.BBS to the date of the latest upload
Stamp

% This statement set the first letter of the filename and -extension to the
% upper case and the remaining characters to the lower case
Capitalize

% Retrieves any filedescription of all archives; run this *not daily* 
%FileInfo

% Move files to the given path, if the filedate is older than the amount
% of days
%OldStuff F:\OLDSTUFF 1095
