/* Convert the DATE in a DIR TEXT file to OFF-LINE                           */
/* Written by Cam DeBuck Software                                            */
/* Donated to the PUBLIC DOMAIN                                              */
/* Originally written using the TopSpeed C Compiler (JPI)                    */
/* Programmer:  Cam N. DeBuck                                                */

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <fcntl.h>
#include <io.h>
#include <mem.h>
#include <share.h>
#include <stat.h>
#include <string.h>

/**************************************************************
*
*    Function:  MemErrorMessage(char *Str)
*
*  Parameters:  Takes a pointer to a string
*
*      Return:  void
*
*     Purpose:  Notifies users that a memory error occured
*
***************************************************************/
void pascal MemErrorMessage(char *Str) {
  char CrLf[] = "\r\n";

  printf("%s",CrLf);
  printf("Not enough memory for %s Buffer%s.",Str,CrLf);
  printf("\r\nProgram will run a little slower, but it will work just fine.%s",CrLf);
  printf("%s",CrLf);
}

/**************************************************************
*
*    Function:  main(int argc, char *argv[])
*
*  Parameters:  Dos Command Line (Path and FileName of DIR TEXT)
*
*      Return:  Error Level to DOS
*
*     Purpose:  Startup of code
*
***************************************************************/
int main(int argc, char *argv[]) {

  char NewFileName[256];  /* Misc. Text String to hold various string(s) */

  FILE *FileIn  = NULL;   /* FileIn  Handler */
  FILE *FileOut = NULL;   /* FileOut Handler */

  char *BufferIn  = NULL; /* Our BUFFER for the Input  File */
  char *BufferOut = NULL; /* Our BUFFER for the Output File */

  if(argc != 2) {
    printf("\r\nUsage is OFFLINE.EXE DirTextName\r\n");
    return(1);
  }

  /* Allocate Memory for the Input BUFFER */
  if((BufferIn  = (char *) malloc(4097))==NULL) {
    MemErrorMessage("Input");
  }

  /* Allocate Memory for the Output BUFFER */
  if((BufferOut = (char *) malloc(4097))==NULL) {
    MemErrorMessage("Output");
  }

  /* Clear the BUFFER(s) with NULLs */
  if(BufferIn != NULL) {
    memset(BufferOut,0,4097);
  }

  if(BufferOut != NULL) {
    memset(BufferIn,0,4097);
  }


  if( (FileIn = fdopen(sopen(argv[1],O_BINARY|O_RDWR,SH_DENYNO,S_IWRITE|S_IREAD),"r+b"))==NULL ) {
    /* Clean up our allocated memory */
    if(BufferOut!=NULL) {
      free(BufferOut);
    }
    if(BufferIn!=NULL) {
      free(BufferIn);
    }
    printf("Cannot Open %s",argv[1]);
    return(1);
  }

  /* Open up the DOS BUFFERS for the InputFile (If it was allocated) */
  if(BufferIn!=NULL) {
    setvbuf(FileIn,BufferIn,_IOFBF,4096);
  }

  /* Create the Output FileName */
  sprintf(NewFileName,"%s.NEW",argv[1]);

  if( (FileOut = fdopen(sopen(NewFileName,O_CREAT|O_BINARY|O_RDWR,SH_DENYNO,S_IWRITE|S_IREAD),"r+b"))==NULL ) {
    /* Close the Input File */
    fclose(FileIn);

    /* Clean up our allocated memory */
    if(BufferOut!=NULL) {
      free(BufferOut);
    }
    if(BufferIn!=NULL) {
      free(BufferIn);
    }
    printf("Cannot Open %s",argv[1]);
    return(1);
  }

  /* Open up the DOS BUFFERS for the Output File (If it was allocated) */
  if(BufferOut!=NULL) {
    setvbuf(FileOut,BufferOut,_IOFBF,4096);
  }

  while((fgets(NewFileName,255,FileIn))!=NULL) {

    /* the isdigit functions returns non zero if it's a characger '0'-'9' */
    /* we also added checking for the "-" in the date just to make sure   */

    if( (isdigit(NewFileName[23])) && (NewFileName[25]=='-') ) {

      /* if the above statement is TRUE, then let's change it to OFF-LINE */
      NewFileName[23] = 'O';
      NewFileName[24] = 'F';
      NewFileName[25] = 'F';
      NewFileName[26] = '-';
      NewFileName[27] = 'L';
      NewFileName[28] = 'I';
      NewFileName[29] = 'N';
      NewFileName[30] = 'E';

    }
    fputs(NewFileName,FileOut);
  }

  fclose(FileOut);
  fclose(FileIn);

  /* RENAME the DIR file to DIR.BAK (DIR will be substituted by ARGV[1] */
  sprintf(NewFileName,"%s.BAK",argv[1]);
  rename(argv[1],NewFileName);

  /* RENAME the NEW DIR file to the appropriate name (as defined in ARGV[1]) */
  sprintf(NewFileName,"%s.NEW",argv[1]);
  rename(NewFileName,argv[1]);

  /* Free Buffers */
  if(BufferOut != NULL) {
    free(BufferOut);
  }
  if(BufferIn != NULL) {
    free(BufferIn);
  }
}
