{ Cheezy Siren - An external page bell for Pocket Pager }
{ The controls are the same as those used by PPage.     }

{$X+}


Uses Crt, Modem;


Const
     _LeftShift  = $02;
     _RightShift = $01;


Var
   A, B : Word;


{ Checks status of both Shift keys     }
{ Alt-C is pressed by the Sysop.       }

Function KeyOn(Mask : Byte) : Boolean;
Var
   KeyboardStatus : ^Byte;
Begin
     KeyboardStatus := Ptr($0000,$0417);
     KeyOn := (KeyboardStatus^ AND Mask) = Mask;
End;


{ Does a complete check of the key-    }
{ board to see who pressed what.       }

Procedure CheckKeys;
Var
   Ch : Char;
Begin
     NoSound;
     If ReadKey = #0 Then
     { A "special" key, either remote or local. }
     Begin
          If NOT(SLData^.LastKey) Then
          { The last keypressed was remote. }
          Begin
               ReadKey;
               Halt(1);
          End
          Else
          { The last keypress was local. }
          Begin
               If ReadKey = #46 {Alt-C} Then If KeyOn(_LeftShift) OR
               KeyOn(_RightShift) Then Halt(4) Else Halt(3);
          End;
     End
     Else
     { Any "normal" key, #1-255, local or remote. }
     Begin
          If NOT(SLData^.LastKey) Then Halt(1) Else Halt(2);
     End;
End;


Begin
     ComToggle;  { Turn Comm. Off }
     TextColor(7); TextBackground(0);
     WriteLn(' Cheezy Siren, by David Shafer');
     WriteLn(' Alt-C/Shift-Alt-C to Chat, any other key to Abort');
     ComToggle;  { Turn Comm. Back On }

     { Make 10 complete cycles }
     For B := 1 To 10 Do
     Begin
          { Sound travels up }
          For A := 1000 To 1500 Do
          Begin
               If Keypressed Then CheckKeys;
               Sound(A);
               Delay(1);
          End;
          { Sound travels down }
          For A := 1500 DownTo 1000 Do
          Begin
               If Keypressed Then CheckKeys;
               Sound(A);
               Delay(1);
          End;
     End;
     NoSound;
     Halt(0);  { Not necessary, but a reminder. }
End.
