{ TurBoard v1.12 File Formats                         March , 1993 }

{ (c) Copyright Shawn Rhoads 1993, ALL RIGHTS RESERVED }
{ (c) Copyright Software @ Work 1993, ALL RIGHTS RESERVED }

{ This change may be somewhat painful, but we've add RESERVED space for
  just about every file format available, so hopefully, this will take care
  of most of the file format upgrades for some time to come. }


{ We haven't taken the time to convert all of the record types over to C
  for those of you who requested C file formats as well.  Here is some
  information that you will find useful in doing the conversion yourself:

  Pascal Type  C Type        Actual Space Used
  -----------  ------------  -----------------------------------------
  byte         char          one byte
  char         char          one byte
  boolean      char          one byte (0 = FALSE, 255 (!FALSE) = TRUE)
  word         int           two bytes (integer type)
  longint      double        four bytes (long integer type)

  TurBoard does not generally use floating point variables, so in most
  cases the conversion is easy.  }


{ Security type, used throughout TurBoard for security.
  GE = Greater Than or Equal Security requirement
  E1 = Security Group 1    (0 = No Group)
  E2 = Security Group 2    (0 = No Group)
  E3 = Security Group 3    (0 = No Group)
  E4 = Security Group 4    (0 = No Group)
  K1 = Key requirement #1  (#0 = No key)
  K2 = Key requirement #2  (#0 = No key)
  K3 = Key requirement #3  (#0 = No key)
}

  sectype = record
    GE, E1, E2, E3, E4: byte;
    K1, K2, K3: char;
  end;

{ Record type for FORUMS.DAT file.}

  forumtype = record
    name: string[8];
    qwknumb: word;           { used internally by TurBoard for QWK;
                               this is the QWK forum number }
    rsl: sectype;            { sl to read messages in this forum. }
    esl: sectype;            { sl to enter messages in this forum. }
    desc: string[60];        { description of this forum }
    chairman: string[36];    { Actual name of chairman from USERS.DAT }
    path: string[80];        { DOS path of this forum's data files }
    basepw: string[10];      { Reserved }
    alias: boolean;          { TRUE (255) = Alias names turned on
                               FALSE (0) = Real names used }
    anonymous: boolean;      { TRUE allows anonymous names }
    private: boolean;        { TRUE allows private messages }
    mailtype: char;          { N = Normal; F = Fidonet; E = Echo }
    maxdaysold: longint;
    maxmsgs: longint;
    area: string[60];        { Fidonet AREA name }
    origin: string[100];     { Individual origin line}
    seenby: boolean;         { Reserved }
    intromsg: char;          { Reserved }
    reserved: array[1..150] of byte; { Reserved for future expansion NULLS }
  end;

{ Record type for ECHO.DAT file in the forum path it is for.}

  echotype = record
    zone: word;              { Fido-style address }
    net: word;
    node: word;
    point: word;
    network: word;           { record number in NETWORKS.DAT }
    reserved: array[1..50] of byte;  {Reserved for future expansion NULLS }
  end;

{ Record type for NETWORKS.DAT }

  networktype = record
    name: string[8];         { name of the network }
    zone: word;              { Our address in that network }
    net: word;
    node: word;
    point: word;
    ext: string[60];
    archive: word;           { Archiver for network from SYSTEM.DAT }
    dir: string[8];
    rtzone: word;
    rtnet: word;
    rtnode: word;
    rtpoint: word;
    reserved: array[1..60] of byte; {Reserved for future expansion NULLS}
  end;

{ Record type for HEADERS.DAT }

  headertype = record
    number: longint;
    fromhere: boolean;
    MSGID: string[30];
    REPLY: string[30];
    replyto: longint;
    fromname: string[36];
    fromloc: string[30];
    toname: string[36];
    toloc: string[30];
    subject: string[36];
    datetime: longint;
    private: boolean;
    fidotype: char;
    deleted: boolean;
    misc: string[8];
    readdatetime: longint;
    index: longint;
    reserved: array[1..60] of byte;
  end;

{ Record type for MSGS.DAT }

{ First part of message is pointed to by "index" from headertype.
  Last record is identified by next = -1 }

  msgtype = record
    data: string[128];
    next: longint;
  end;

{ Record type for BBS List}

  BBSTyp   = Record
          Name: string[36];
          Sysop: string[36];
          baud: string[8];
          theme: string[20];
          phone: string[12];
          protocol: string[12];
          network: string[30];
          city: string[30];
          software: string[20];
          computer: string[20];
          diskspace: longint;
          NoLines: longint;
          modemtype: string[20];
          index: longint;
          review: byte;
          enteredby: longint;
          local: boolean;
          reserved: array[1..50] of byte;  { Reserved for future expansion }
        end;

{ Record type for User Indexes  A.NDX, B.NDX ...}

  IndexTyp = Record
           phonetic: string[8];
           number: longint;
        end;

{ Record type for MODEMS.DAT }

  ModemTyp = Record
           name: string[90];
           init: string[90];
           terminit: string[90];
           maxbaud: word;
           offhook: string[20];
           hangup: string[20];
           ConnectString: String[20];
           answer: string[10];
           followbaud: byte;
           ring: string[20];
           ringing: string[20];
           nocarrier: string[20];
           timeout: byte;
           lowerdtrpause: byte;
         end;

{ Record type for NODExxxx.DAT file for each node. }

  NodeType = Record
          port: byte;
          modemtype: byte;
          syspath: string[90];
          snoop: boolean;
          minbaud, maxbaud: word;
          reserved: array[1..40] of byte;
        end;

{ A YAK information file, internally used by TurBoard }

  Notifytype = array[0..100] of boolean;

{ The internal representation of the marked file list }

  Filestacktype = array[1..10] of string[12];

{ Record type for NODES.DAT file used for dropping to doors, etc. }

  NodesType = Record
          Name: String[36];
          Location: String[20];
          Desc: String[32];
          Action: Byte;
          pbaud: longint;
          cbaud: longint;
          ANSIs: Boolean;
          naplps: boolean;
          menu: word;
          instamp: LongInt;
          instampsecs: LongInt;
          ChatTime: Integer;
          Maxtime: Integer;
          SLName: String[20];
          after: char;
          modem: boolean;
          cdpath: string[8];
          cdname: string[30];
          forum: string[8];
          notify: notifytype;
          filestack: filestacktype;
          reserved: array[1..70] of byte; { Reserved for future expansion NULL}
        end;

{ Record type for USERS.DAT }

   UserType = Record
           Name: String[36];
           Pw: String[10];
           SL: byte;
           keys: string[20];
           alias: string[36];
           Street: String[30];
           City: String[30];
           HPhone: String[14];
           WName: String[30];
           WTitle: String[20];
           WPhone: String[14];
           Account: LongInt;
           PointNumber: word;
           FilePoints: longint;
           TimeOn: Integer;
           LastOn: LongInt;
           LastDir: LongInt;
           Width: Byte;
           ScrnLength: Byte;
           transfer1: Char;
           archive: byte;
           birthday: LongInt;
           birthyear: word;
           timeson: word;
           downloads: word;
           downloadk: longint;
           uploads: word;
           uploadk: longint;
           msgentered: word;
           msgread: longint;
           Pause: Boolean;
           FullScreen: Boolean;
           Mail: byte;
           Hack: byte;
           clr: Boolean;
           spellcheck: boolean;
           expert: boolean;
           forumintro: char;
           menurotation: byte;
           expiredate: longint;
           expiresl: byte;
           timebank: longint;
           prompt: string[50];
           reserved: array[1..60] of byte;
         end;


{ Record type for SYSTEM.DAT }

  SystemType = Record
           Name: String[80];
           Password: String[10];
           SysopPassword: String[10];
           SysopHere: Boolean;
           Sound: Boolean;
           CallerNum: LongInt;
           open1: Boolean;
           quickpw: boolean;
           aliasok: boolean;
           TPath: String[80];
           BBSPath: String[80];
           bookpath: string[80];
           APath: String[80];
           UPath: String[80];
           MPath: String[80];
           FPath: String[80];
           DPath: String[80];
           YakPath: String[80];
           BPath: String[80];
           AdPath: String[80];
           CBPath: String[80];
           QUPath: String[80];
           LogPath: String[80];
           FDataPath: String[80];
           FInPath: String[80];
           FOutPath: String[80];
           logupdate: byte;
           TimeZone: String[30];
           UPFileSL, uppvtsl, uppubsl: sectype;
           uploaddir: string[8];
           NewSL: Byte;
           newkeys: string[20];
           doscom: string[40];
           secdad, secadcata, secdbbs, secbbstext,
           secaddbookchap, secedchap, secaddnewbook, secaddbulletin,
           secdelbul, seceditbul, secadddoor, seceditdoor, secedit,
           sectype, seceditdirext, seceditdir, secdeldir, secaddfiledir,
           secffext, secdeldirlist, secreadall, secaddforum, secentfido,
           seceditforum, secmmsg, secdelforum, secdetaillog, secedituser,
           secyak, secsetup, secenterresumes, seclngadd, seclngedit,
           secreadresumes, secads, secbbslist, secdoor, seccb,
           seceditcb, secqwk, secbook, secbul, secquest, secquestmod,
           seclog, secart, secartedit, secdl: sectype;
           fidopassthrough: boolean;
           lastevent: longint;
           InitPoints: Word;
           credperk: Word;
           regname, regserial: string[60];
           credperdl: word;
           dlkperpoint: word;
           limitdltime: boolean;
           asciiok, ansiok, naplpsok, future1ok, future2ok: boolean;
           ultimebonus: byte;
           fdtype: byte;
           QWKname: string[8];
           arcname: array[1..8] of string[10];
           arcid: array[1..8] of char;
           arccmd: array[1..8,1..2] of string[50];
           arcprm: array[1..8,1..2] of string[50];
           arcext: array[1..8] of string[3];
           cddrive: array[1..8] of char;
           cdname: array[0..8] of string[50];
           cdavail: array[1..8] of boolean;
           cdsl: array[1..8] of sectype;
           viruspgm: string[60];
           askfiledetail: boolean;
           reserved: array[1..1000] of byte;
         end;

{ Record type for SECURITY.DAT }

  SecurityType = Record
           Name: String[20];
           Time: Integer;
           reserved: array[1..50] of byte;
          end;

{ Record type for the language file. }

  langtype = string[100];

{ Record type for YAK.DAT }

  YakType = Record
           name: string[80];
           description: string[60];
           onceonly: boolean;
           check: array[1..4] of word;
           checkval: array[1..4] of longint;
           blankresponce: string[80];
           hotkey: boolean;
           reserved: array[1..100] of byte; {Reserved for future expansion}
         end;

{ Record type for *.HOT }

  hottype = record
           ch: char;
           cmd: string[20];
           gxt, gxb, gyt, gyb: real;  {graphics mouse activate box}
           sl: sectype;
           action: string[80];
           reserved: array[1..20] of byte;
         end;

{ Record type for BULLETINS }

  BulletinType = Record
           AutoRead: Boolean;
           DateTime: LongInt;
           SL: sectype;
           Desc: String[60];
           reserved: array[1..20] of byte;
  end;

{ Record type for *.NMA (located in the USERS directory)}

  NewMailType = Record
    Number: LongInt;
    Forum: String[8];
    read: boolean;
    reserved: array[1..10] of byte;
  end;

{ Record type for *.LOG }

  LogType = Record
          Node: Byte;
          DateTime: LongInt;
          Action: Byte;
          A: String[13];
         end;

  othertyp = string[80];

{ Record type for file directory }

  filedirtype = record
    name: string[8];
    usl: sectype;
    dsl: sectype;
    desc: string[34];
    sort: byte;
    newestfiledate: longint;
    dirpath: string[80];
    reserved: array[1..200] of byte;
  end;

{ Record type for file listings }

  filelisttype = record
    name: string[12];
    path: string[80];
    deleted: boolean;
    fdate: longint;
    fsize: longint;
    dsl: sectype;
    postdate: longint;
    detailed: longint;
    desc: string[46];
    dirname: string[8];
    numbdownloads: word;
    keywords: string[80];
    uploadby: longint;
    review: byte;
    filetype: char;
    reserved: array[1..100] of byte;
  end;

{ Record type for file listing indexes }

  indextype = record
    name:string[12];
    date:longint;
    number:longint;
  end;

{ Record type for file listing reviews }

  reviewtype = record
    usernumb: longint;
    review: byte;
  end;
