#include<io.h>
#include<stdio.h>
#include<conio.h>
#include<stdarg.h>
#include<stdlib.h>
#include<alloc.h>
#include<time.h>
#include<string.h>
#include<process.h>

#define byte unsigned char
#define word unsigned int
#define flag unsigned char
#define TRUE	1
#define FALSE   !TRUE

/*******************************************************************
 These are structures for reading the RBBS records in binary format.
 All RBBS records are set up in 128 byte blocks.
 *******************************************************************/
/*****************************************************************
 This is the checkpoint Record. It is the first block of any
 RBBS message file, ie; MAINM.DEF and contains vital pointer info.
 *****************************************************************/
struct checkpoint_record
	{
	char last_msg_num[8];    	        // ascii, leading space
	word sec_lev_for_auto_add;              // integer value
	char caller_number[10];                 // ascii, leading space
	flag public_flag;                       // '/' = no PUB MSG's (17.4)
	flag private_flag;                      // '/' = no PRV MGS's (17.4)
	flag password_flag;                     // '/' = no PWD MSG's (17.4)
	byte reserved1[33];                     // Zeroed
	char user_count[5];                     // ascii, leading space
	byte reserved2[6];                      // Zeroed
	char msg_start_blk[7];                  // ascii, leading space
	char next_msg_blk[7];       		// ascii, leading space
/************************************************************************
 This is the number of the last block in the file when using fixed length
 message base (does not grow). RBBS figures a message as 5 blocks, so you
 will not be able to enter any from this block -4 if using fixed
 ************************************************************************/
	char last_msg_blk[7];                   // ascii, leading space
/*****************************************************************
 This is the maximum number of ACTIVE messages allowed, max is 999
 *****************************************************************/
	char msg_max[7];                        // ascii, leading space
	byte reserved3[31];		        // Zeroed
	char node_max[2];     		        // ascii, 1-36
	};

/*************************************************************************
 This is the BBS Node Record, it is stored in the second block of every
 RBBS message file. For each additional RBBS node using this message base,
 there will be a consecutive Node Record, up to 36.
 *************************************************************************/
struct node_record
	{
	char last_caller[31];
	char sysop_avail_tog[2];  		//  ASCII ("-1"=true, "0"=false)
	char sysop_annoy_tog[2];                // 
	char sysop_on_next_flag[2];             // 
	char line_printer_avail_flag[2];        // 
	char doors_avail_flag[2];               // 
	char eight_bit_flag[2];                 // 
	char callers_baud[2];                   // -1=300bps...-8=38400bps
	char upper_case_only_flag[2];           // 
	byte bytes_transferred[4];              // Long?
	byte batch_transfer_flag;               // Non zero=TRUE
	char graphics_setting[2];               // " 0"=none, " 1"=IBM, " 2"=ANSI
	char sysop_flag[2];                     //  "-1" = sysop
	char activity_flag;                     // 'A'=active, 'I'=inactive
	char snoop_flag[2];                     // 
	char rbbs_to_modem_baud[5];             // Ascii
	byte caller_logon_time[3];              // Hour,Minute,Second
	byte reserved1[4];
	byte private_door_flag[2];              // 
	byte type_of_shell;                     // 0=none,1=download,2=upload,3=ext regist pgm
	char protocol_type;                     // First letter of protocol
	byte reserved2;
	byte last_dos_exit_date[2];             // Month, day, year (packed)
	byte reserved3[7];
	byte last_dos_exit_time[5];             // ascii HR:MN
	char reliable_mode_flag[2];             // 
/*****************************************************************
 The following block usually contains the caller's city and state,
 but is filled in whenever RBBS temporarily exits to dos.
 *****************************************************************/
	char pui_filename[8];
	byte local_user_flag[2]; 		// (0x0D,0x0D)=Local
	char local_user_mode[2];                // True=Com0
	char current_conf_name[8];
	word time_credits[2];			// Integer?
	byte reserved4[2];
/*****************************************************************/
	byte last_subsystem[2];                 // Subsystem index where user was
	char last_external_protocol_date[6];    // MMDDYY exited
	char lasr_external_protocol_time[4];    // HHMM exited
	};

/********************************************************************
 Next we have the Message Header record. Each message starts with one
 of these (17.4 allows multiple headers for 'carbon copy' to others).
 RBBS does not remove old messages, only tags them, until you pack
 the message base.
 ********************************************************************/
struct message_header
	{
	flag private_flag;      		    // '*'=private, ' '=public
	char msg_number[4];                     // In ascii, left justify
	char from[31];                          // Uppercase
	char to[22];                            // Uppercase
	char time_sent[8];                      // HR:MN:SE
	byte header_number;	                // Number of headers on this MSG,
							    //     1-225 (17.4)
	char date_sent[8];                      // MN-DY-YR
	char subject[25];                       // Uppercase
	char password[15];                      // ^READ^ / ^KILL^
	byte active;     		        	    // 225=active, 226=killed
	char msg_blk_size[4];                   // ascii, leading space
	word read_sec_lev;                      // integer value
	byte month,day,year;    	          // Last Read, spaces if not
	byte hour,minute,second;                // Last Read, spaces if not
	};

/*************************************************************************
 The last record used in the message base is simply a block of 128 bytes
 that contains the actual message text. Instead of a CR/LF, each line is
 terminated with an ascii 227 (''). Interestingly, this is the exact same
 format used in a QWK mail packet. Multiple lines can be in one block and
 lines can wrap over to the next. Number of block is stored in the Header.
 *************************************************************************/

/******************************************************************
 This is the format of the QWK message for either the QWK packet or
 the REP. The only difference is the value of qwk.number
 ******************************************************************/
struct QWK
	{
	byte status_flag;       // ' ' in my findings
/********************************************************************
 If this is from the QWK packet this is the message number,
 if its the REP, the conference number is here as well as in conf_num
 ********************************************************************/
	char number[7];         // in ascii, left justified
	char date[8];           // mm-dd-yy (ascii)
	char time[5];           // 24 hour hh:mm
	char to[25];		// Uppercase, left justified
	char from[25];		// ""
	char subject[25];		// mixed case
	char password[12];	// ^KILL^, ^READ^
	char ref_msg_num[8];    // ascii, left j, blank filled
	char msg_blk_size[6];   // in ascii + header (2 min), left J
	byte active_flag;		// 225=active, 226=killed
	word conf_num;		// integer value
	byte reserved1[2];	// unused.
	char network_flag; 	// *=network tagline is present, ' ' otherwise
	};

/*******************************************************************
 From this point on are my proprietary structures to hold temp info
 while accessing the message base and retrieving/building messages.
 These ARE NOT rbbs formats, just intended to make life easier since
 RBBS holds lot's of numbers in ASCII format (???).
 *******************************************************************/

/******************************************
 Check Point Record handy data structure
 All these number are offset 1 in Real Life
 ******************************************/
typedef struct
	{
	long	last_msg_num;     // Last message Number            (offset 1)
	long 	first_msg_blk;    // Block # of first message       (offset 0)
	long	last_msg_blk;     // Block # of last message        (offset 0)
	long  next_msg_blk;     // Block where next message goes  (offset 0)
	long	msg_max;          // Max Number of messages allowed (offset 1)
	}CPR;

/****************************************************************
 Here's my message format. Generic to convert from/to rbbs or qwk
 ****************************************************************/
typedef struct
	{
	byte hour;
	byte minute;
	byte second;
	byte month;
	byte day;
	byte year;
	}DTG;

typedef struct
	{
	word number;		  // message number
	char from[32];
	char to[26];
	char subject[26];
	char password[16];
	DTG sent;              	  // When msg was sent
	DTG read; 	       	  // When msg was read
	int  conf;		  // Conference Number
	int  level;               // Sec Lev to read
	flag active;              // True or False
	flag priv;                // True or false
	char *text_buffer;	  // pointer to the msg text
	long size;		  // number of text blocks+header
	}MSG;

/*****************************************
 Here are structures for linked lists used
 when reading the host configuration file
 *****************************************/
struct ll_conf
	{
	int number;
	int processed;
	int last_read;
	char path[81];
	struct ll_conf *next;
	};

struct ll_who
	{
	char user[32];
	struct ll_who *next;
	};

struct ll_swap
	{
	char from[32],to[32];
	struct ll_swap *next;
	};

/***************************************
 This is the structure holding all the
 data from  the host configuration file.
 ***************************************/
typedef struct
	{
	flag append;
	flag killqwk;
	flag pass_private;
	char qwkname[81];
	char repname[81];
	char tagline[81];
	char logfile[81];
	char workdir[81];
	char zip[81];
	char unzip[81];
	char hostname[9];
	char lmrname[13];
	struct ll_swap *import;
	struct ll_swap *export;
	struct ll_conf *conf;
	struct ll_who *loser;
	struct ll_who *exempt;
	int conf_count;
	int loser_count;
	int exempt_count;
	int msg_count;
	}CONFIG;

/***************************
 Last Message Read Structure
 ***************************/
struct LMR
	{
	int number;
	int last_read;
	};

/****************************
 Simple text window structure
 for direct screen writes
 ****************************/
typedef struct
	{
	int far *screen;
	unsigned char x1;
	unsigned char y1;
	unsigned char x2;
	unsigned char y2;
	int border;
	int text;
	int header;
	unsigned char cx;
	unsigned char cy;
	char title[80];
	}WIN;

/*******************
 Function Prototypes
 *******************/
void pos_qwk(FILE *infile);
void pos_rbbs(FILE *infile);
void read_rbbs_header(CPR *cpr, FILE *infile);
void write_rbbs_header(CPR *cpr,FILE *outfile);
int read_rbbs(MSG *msg,FILE *infile);
int write_rbbs(MSG *msg,char *file);   //Notice this uses name vice handle
int read_qwk(MSG *msg,FILE *infile);
void write_qwk(MSG *msg,FILE *outfile);
void failure(char *,...);
void *e_malloc(size_t size);
void show_msg(MSG *msg);
void show_header(MSG *msg);
void getblock(void *buff,long block,FILE *infile);
void putblock(void *buff,long block,FILE *outfile);
void addblock(void *buff,FILE *outfile);
void addtag(MSG *msg);
void padcpy(char *to, char *from,int length);
void lpadcpy(char *to, char *from,int length);
void termcpy(char *to, char *from,int length);
void get_dtg(DTG *dtg);
void padzcpy(char *to, char *from,int length);
void remls(char *);
void read_config(CONFIG *config, char *cfgfile);
void openwin(WIN *win);
void wallpaper(WIN *win);
void scrollwin(WIN *win);
void printwin(WIN *win, char *str);
void printfwin(WIN *win, char *str,...);
void make_lmr(void);
void export(char *host);
void import(char *host);
int deny(MSG *msg);
int exempt(MSG *msg);
void checkworkdir(char *dir);
void unzip(void);
void zip(void);