@ECHO OFF
REM
REM      This batch file is OPTIONAL and its use is not required for 
REM      WR-BBS operation.  If this file exists in the WR-BBS home path,
REM      it will be executed each time the computer's date changes. This
REM      is usually once a day, at midnight.  If there is a caller on line
REM      or some other WR-BBS activity occuring when the date changes,
REM      then WR-BBS runs MIDNIGHT.BAT as soon as WR-BBS becomes idle after
REM      the date changes.     
REM
REM      You can modify this batch file to suit you needs.  You do NOT have
REM      to use any of the routines or lines contained in this file.
REM
REM      If you wish to design your own MIDNIGHT.BAT, please keep the
REM      following in mind:
REM
REM      1. WR-BBS passes a six character string to MIDNIGHT.BAT when it
REM         calls the batch file.  This string is the date, in the format
REM         MMDDYY.  You can capture that information by using the DOS
REM         replaceable paramater symbol %1 in MIDNIGHT.BAT.
REM
REM      2. WR-BBS is "shelled" when it calls MIDNIGHT.BAT.  Do not restart
REM         WR-BBS with WR or WRBBS, or you will have two copies of WR-BBS
REM         fighting each other.  Just let the batch file end normally, and
REM         WR-BBS will "unshell" and resume operation.  Since WR-BBS is
REM         still loaded (although swapped out) when MIDNIGHT.BAT executes,
REM         don't load any TSR's, and don't activate any TSR's (such as 
REM         flushing a cache) inside MIDNIGHT.BAT.
REM
REM      3. Never modify or delete any WR-BBS files that end with .DAT or
REM         .IDX inside MIDNIGHT.BAT.  If you want to run a utility that
REM         modifies the data files, you should do it in a "terminate"
REM         event.
REM
REM      4. It is not necessary to reboot the system on a regular basis,
REM         which is a convention that some SysOps are used to following.
REM         If you want to reboot automatically (not necessary), you should
REM         do this in a "terminate" event.
REM
REM
ECHO.
ECHO.
ECHO 
ECHO  Ŀ 
ECHO    MIDNIGHT.BAT    A utility batch file for WR-BBS   
ECHO  Ĵ 
ECHO    Database files are being automatically backed up   
ECHO   
ECHO 
ECHO.
ECHO.
REM      The following line checks for the existance of the WR-BBS environment
REM      variable.  If that DOS environment variable does not exist,  no other
REM      processing can occur.
REM
IF W%WR-BBS%W==WW GOTO ERROR01
REM
REM      Since the home directory for WR-BBS is known (from the environment
REM      variable), the batch file assures that the correct working directory
REM      is current by changing to the home path directory.
REM
CHDIR %WR-BBS%
REM
REM      Since the home path is the current directory, and the database files 
REM      are closed, the batch file copies the database files to new files
REM      ending in *.DBK.  This creates an identical copy of the database
REM      which can be later copied by this batch file, and other utility,
REM      or manually by the SysOp.  Since open files cannot be copied, this
REM      is one of the only opportunities to create a backup of the database
REM      for later use.
REM
COPY *.DAT *.DBK /V > NUL
REM
REM      The next line looks for a directory named WRBACKUP, which is a 
REM      subdirectory off the home path directory. It tests for the existence
REM      of NUL in that directory.  NUL will exist in any sub-directory
REM      (at least with PC-DOS or MS-DOS), indicating that the directory
REM      already exists. If the directory does not exist, it is created.
REM
IF NOT EXIST %WR-BBS%\WRBACKUP\NUL MKDIR %WR-BBS%\WRBACKUP
REM
REM      The current log file (WRBBSLOG.TXT) is now copied to the backup
REM      directory.  It is renamed during the copy process to a filename 
REM      that reflects the date, for example AL063094.LOG.  This is done by
REM      using the value passed by WR-BBS for the %1 replacable parameter.
REM      WR-BBS passes the date as a six-character string - MMDDYY.
REM
COPY %WR-BBS%\WRBBSLOG.TXT %WR-BBS%\WRBACKUP\AL%1.LOG /V > NUL
REM
REM      The next line checks for the existence of the newly copied and
REM      renamed log file in the WRBACKUP directory.  If the file exists
REM      (which it should), then the copy operation was successful, and 
REM      the original log file can be deleted from its original location
REM      in the home path directory.  WR-BBS will automatically create a
REM      new log file when it discovers the old one is erased.
REM
IF EXIST %WR-BBS%\WRBACKUP\AL%1.LOG DEL %WR-BBS%\WRBBSLOG.TXT
REM
REM      End of processing.  You can add your own routines here, etc.
REM
GOTO FINISHED
:ERROR01
REM
REM      Control is passed to this label if the environment variable
REM      "WR-BBS" is not found.
REM
ECHO ERROR:  Environment variable "WR-BBS" not defined.
:FINISHED
ECHO.
