@ECHO OFF
REM
REM          ** REMOVE COMMENTS FOR FASTER OPERATION **
REM
REM
REM          This is the batch file that controls all file transfers when
REM          a caller requests a download from  (or an upload to) WR-BBS.
REM
REM          You can use this file without modification,    or edit it to 
REM          suit the needs of your WR-BBS installation. This is the same
REM          copy of WFILEXFR.BAT that is presently being used by the WR-
REM          BBS Headquarters BBS as of January 18, 1993.
REM
REM
REM          If you wish to use this file without changes,  the following
REM          requirements must be met:
REM
REM          1.  You must have a copy of  DSZ.COM, in the home directory.
REM              See the WR-BBS documentation for information on what the
REM              home directory is, as it relates to WR-BBS.
REM
REM          2.  The copy of DSZ.COM you have should be a registered copy
REM              for full functionality.  Some of DSZ's extended features 
REM              are only available in the registered version.   The cost
REM              to register DSZ is nominal,  and I personally think that
REM              it is an excellent value.  See the documentation for the
REM              number of Omen Technology's BBS,  where you can obtain a
REM              copy of DSZ and register your copy. The author of WR-BBS
REM              has no connection with Omen Technology.
REM
REM          3.  This batch file, WFILEXFR.BAT must also be in the WR-BBS
REM              home directory.
REM
REM          If all of the three above requirements are met,  you can use
REM          WFILEXFR.BAT as a "plug 'n play" ready-to-use file.  If your
REM          copy of DSZ is not registered, you will at least have use of 
REM          the Xmodem protocol until you get your registration from the
REM          author of DSZ.
REM
REM
REM          You are by no means limited to using DSZ for your protocols.
REM          Any file transfer protocol can be used,  but this batch file
REM          will control its operation.
REM
REM          When WR-BBS invokes a file transfer, it passes the following
REM          parameters to WFILEXFR.BAT:
REM
REM
REM          %1  -  Single character describing the communications port that
REM                 was in use on WR-BBS when this batch file was called. It
REM                 will be one of the folllowing:  1, 2, 3, 4, or N.    The
REM                 numbers represent COM ports, while "N" means the session
REM                 is local and the communications port is not in use.
REM
REM          %2  -  A numeric string, representing the baud rate that was in
REM                 effect when this batch file was called.   If the session
REM                 is local, then the string "LOCAL" will be passed as this
REM                 parameter.  Examples include:  300, 1200, 2400, etc.
REM
REM          %3  -  This parameter indicates whether the file transfer is an
REM                 upload to this BBS ("RECEIVE"),  or a download from this
REM                 BBS ("SEND").  These are the only values possible.
REM
REM          %4  -  The protocol keyword.
REM
REM          %5  -  The name of the file to be transferred, or the file name
REM                 of a list file which contains several filenames that are
REM                 to be transferred.   A list file will be created only if 
REM                 the protocol is configured for batch transmission.  This
REM                 means that all upload (RECEIVE) protocols and all single
REM                 action download (SEND) protocols will have a single file
REM                 name here. If a batch protocol is used but only one file
REM                 is selected for download,   then a single file name will 
REM                 appear here as well.  The next parameter (%6) designates  
REM                 whether the transmission is "batch" or "single".  A list
REM                 file, if needed, will be created in the home path, using
REM                 the name DL.LST.
REM
REM          %6  -  A numeric string, representing the number of files to be
REM                 transferred.  This string will always be "1" for uploads
REM                 (RECEIVE), non-batch downloads, and batch downloads when
REM                 a single file is requested.  If a multiple file download
REM                 (batch) is requested, then this string will be a numeric
REM                 value between 2 and 65355.
REM
REM
REM          (The comments from here on relate to specific operations)
REM
REM          Verify that all expected parameters were passed.
REM
IF W%1==WW GOTO ERROR01
IF W%2==WW GOTO ERROR02
IF W%3==WW GOTO ERROR02
IF W%4==WW GOTO ERROR02
IF W%5==WW GOTO ERROR02
IF W%6==WW GOTO ERROR02
REM
REM          Echo the parameters to the local screen.
REM
ECHO Parameters passed to %0:
ECHO.
ECHO 1  -  %1
ECHO 2  -  %2
ECHO 3  -  %3
ECHO 4  -  %4
ECHO 5  -  %5
ECHO 6  -  %6
ECHO 7  -  %7
ECHO 8  -  %8
ECHO.
REM
REM          Check for LOCAL session, and warn user accordingly.
REM
IF EXIST $FAILURE DEL $FAILURE
IF %1==N GOTO LOCAL
IF %2==LOCAL GOTO LOCAL
REM
REM          Branch processing based on the protocol keyword.
REM
IF %4==KERMIT GOTO KERMIT
IF %4==XMODEM_CS GOTO XMODEMCRC
IF %4==XMODEM1K GOTO XMODEM1K
IF %4==XMODEMCRC GOTO XMODEMCRC
IF %4==YMODEM GOTO YMODEM
IF %4==YMODEM1K GOTO YMOD1K
IF %4==YMODEMG GOTO YMODEMG
IF %4==ZMODEM GOTO ZMODEM
GOTO ERROR04
REM -------------------------------------------------------------------------
:KERMIT
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$  KERMIT PROCESSING  $$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM
REM          Parameter %3 determines if this is a SEND or RECEIVE.
REM
IF %3==RECEIVE GOTO KERMRECV
IF %3==SEND GOTO KERMSEND
REM
REM
REM          If match for %3 was not found, there is something wrong.
GOTO ERROR03
:KERMRECV
%WR-BBS%\PCKERMIT -b %2 -l COM%1 -r -a %5 -c
GOTO FINISHED
:KERMSEND
%WR-BBS%\PCKERMIT -l COM%1 -b %2 -s %5 -c
GOTO FINISHED
REM -------------------------------------------------------------------------
:XMODEM1K
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$  XMODEM-1K PROCESSING $$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM
REM          Parameter %3 determines if this is a SEND or RECEIVE.
REM
IF %3==RECEIVE GOTO XM1_RECV
IF %3==SEND GOTO XM1_SEND
REM
REM          If match for %3 was not found, there is something wrong.
GOTO ERROR03
:XM1_RECV
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 rx %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
:XM1_SEND
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 sx -k %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05 
GOTO FINISHED
REM ------------------------------------------------------------------------
:XMODEMCRC
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$  XMODEM-CRC PROCESSING $$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM
REM          Parameter %3 determines if this is a SEND or RECEIVE.
REM
IF %3==RECEIVE GOTO XMC_RECV
IF %3==SEND GOTO XMC_SEND
REM
REM          If match for %3 was not found, there is something wrong.
GOTO ERROR03
:XMC_RECV
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 rc %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
:XMC_SEND
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 sx %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
REM ------------------------------------------------------------------------
:YMODEM
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$ YMODEM PROCESSING $$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM
REM          Parameter %3 determines if this is a SEND or RECEIVE.
REM
IF %3==RECEIVE GOTO YM_RECV
IF %3==SEND GOTO YM_SEND
REM
REM          If match for %3 was not found, there is something wrong.
GOTO ERROR03
:YM_RECV
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 restrict rb %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
:YM_SEND
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 sb %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED


:YMOD1K
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$ YMODEM-1K PROCESSING $$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM
REM          Parameter %3 determines if this is a SEND or RECEIVE.
REM
IF %3==RECEIVE GOTO YM1RECV
IF %3==SEND GOTO YM1SEND
REM
REM          If match for %3 was not found, there is something wrong.
GOTO ERROR03
:YM1RECV
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 restrict rb %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
:YM1SEND
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 sb -k %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED






:YMODEMG
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$ YMODEM-G PROCESSING $$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM
REM          Parameter %3 determines if this is a SEND or RECEIVE.
REM
IF %3==RECEIVE GOTO YMGRECV
IF %3==SEND GOTO YMGSEND
REM
REM          If match for %3 was not found, there is something wrong.
GOTO ERROR03
:YMGRECV
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 restrict rb -g %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
:YMGSEND
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 sb -k %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
REM ------------------------------------------------------------------------
:ZMODEM
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$ ZMODEM PROCESSING $$$$$$$$$$$$$$$$$$$$$$$$
REM          $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
REM
REM          Parameter %3 determines if this is a SEND or RECEIVE.
REM
IF %3==RECEIVE GOTO ZM_RECV
IF %3==SEND GOTO ZM_SEND
REM
REM          If match for %3 was not found, there is something wrong.
GOTO ERROR03
:ZM_RECV
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 restrict handshake slow rz %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
:ZM_SEND
REM
REM          Invoke DSZ for the file transfer.    See DSZ documentation for
REM          details on command line arguments.  Notice lower case letters,
REM          which are required for correct  DSZ operation except where the
REM          DSZ documentation explicitly indicates otherwise.  Remember to
REM          register your copy of DSZ with DSZ's author!
REM
dsz port %1 sz %5
REM
REM          DSZ, like most file transfer protocols, will set the DOS
REM          ERRORLEVEL to something other than zero  if any problems
REM          were encountered. If a non-zero errorlevel was detected,
REM          the following line simply puts  a  breif message  on the 
REM          screen for the SysOp.
REM
IF ERRORLEVEL 1 GOTO ERROR05
GOTO FINISHED
REM ------------------------------------------------------------------------
:LOCAL
REM          (Local session in progress - can't use protocols)
ECHO File transfer protocols cannot be used during local logon!
GOTO FINISHED
:ERROR01
REM          (No parameters at all)
ECHO ERROR:  No parameters!
GOTO FINISHED
:ERROR02
REM          (An incorrect number of parameters was passed to this batch)
ECHO ERROR:  Invalid number of parameters!
ECHO.
IF NOT W%1W==WW ECHO PARAMETER 1 = %1
IF NOT W%2W==WW ECHO PARAMETER 2 = %1
IF NOT W%3W==WW ECHO PARAMETER 3 = %1
IF NOT W%4W==WW ECHO PARAMETER 4 = %1
IF NOT W%5W==WW ECHO PARAMETER 5 = %1
IF NOT W%6W==WW ECHO PARAMETER 6 = %1
IF NOT W%7W==WW ECHO PARAMETER 7 = %1
GOTO FINISHED
:ERROR03
REM         (Parameter # 3 is invalid)
ECHO ERROR: Invalid keyword (%3)
GOTO FINISHED
:ERROR04
REM         (Protocol keyword not found)
ECHO  ERROR: Undefined protocol (%4)
GOTO FINISHED
:ERROR05
REM         (Transfer failure detected: non-zero errorlevel )
REM
REM         To signal to WR-BBS that an error has occurred,  a "flag" file
REM         is created by redirecting a string into a file named $FAILURE,
REM         which will be created in the current directory. 
REM
ECHO Error detected during %3 of %5. > $FAILURE
ECHO.
ECHO ERROR OCCUURED DURING %4 %3 OF %5!
ECHO.
:FINISHED
REM   (this used to be a pause)
