@ECHO OFF
REM
REM  Ŀ
REM   This is the batch file which controls the WR-BBS program.  Although 
REM   WR-BBS can be run from the command line,  without  a file like this 
REM   one, the use of WR.BAT is STRONGLY urged. There are several reasons 
REM   why WR-BBS can terminate:                                           
REM                                                                       
REM       - Scheduled termination to run an event.                        
REM                                                                       
REM       - Normal termination due to shutdown request from keyboard.     
REM                                                                       
REM       - Unexpected termination due to an error.                       
REM                                                                       
REM   For each of the possible termination reasons,   WR-BBS sets the DOS 
REM   ERRORLEVEL to a specific value before it actually terminates.  This 
REM   batch file uses that  information to branch to an appropriate label 
REM   and invoke another program (for an event or door),   restart WR-BBS 
REM   (if termination was due to an error),  or  return  to the operating 
REM   system prompt (in case of normal shutdown).                         
REM                                                                       
REM   Please see the WR-DOS documentation for a detail description of the 
REM   ERRORLEVEL values that WR-BBS sets for each type of termination.    
REM  
REM
REM
REM      If the batch file has just been started, or if an error has caused   
REM      WR-BBS to terminate, control will be branched to the label STARTBBS
REM      which appears below.  When control is passed to that label, WR.BAT
REM      does the following:
REM
REM          It runs the utility program WDELAY, which gives the local SysOp
REM          a chance to abort the startup (or restart) if desired.  If the 
REM          startup (or restart) is happpening "unattended", such as after
REM          a power failure, or system error, when nobody is at the local
REM          console, then after 15 seconds, WDELAY starts the program by
REM          terminating with an ERRORLEVEL of 0. 
REM
REM          WR.BAT is designed so that an ERRORLEVEL of zero at this point
REM          will continue with the start (or restart) of WR-BBS.  If the
REM          SysOp presses ESC at the local keyboard while WDELAY is running,
REM          then WDELAY terminates, setting the ERRORLEVEL to 1.  WR.BAT 
REM          will then react by branching to to the FINISHED label, without
REM          starting WR-BBS.
REM
REM          If the local SysOp presses ENTER while WDELAY is running, then
REM          WDELAY terminates immediately, setting the ERRORLEVEL to zero.
REM          WR.BAT reacts by starting WR-BBS, just as if a default timeout
REM          had occurred in WDELAY.
REM
REM          For more detailed information on WDELAY, please read WDELAY.DOC.
REM
REM
:STARTBBS
ECHO.
ECHO.
ECHO ͻ
ECHO   WR-BBS will start in 15 seconds  
ECHO ͼ
ECHO.
ECHO.
WDELAY 15
IF ERRORLEVEL 1 GOTO FINISHED
REM
REM      Start (or restart) WR-BBS
REM
WRBBS.EXE
REM
REM      WR-BBS has been started.  When WR-BBS terminates, the following 
REM      lines will examine the ERRORLEVEL and branch control to the 
REM      appropriate label in WR.BAT.
REM
IF ERRORLEVEL 100 GOTO STARTBBS
IF ERRORLEVEL 84 GOTO RUNEVENT
IF ERRORLEVEL 1 GOTO STARTBBS
REM
REM      An ERRORLEVEL of zero means that WR-BBS terminated normally, in
REM      repsonse to an ALT-Q (quit) request from the keyboard.
REM
IF ERRORLEVEL 0 GOTO FINISHED
REM
REM      If the ERRORLEVEL is less than zero (highly unusual), then WR-BBS
REM      terminated for an unknown reason, so it should be restarted.
REM
GOTO STARTBBS
:RUNEVENT
REM
REM      If control branches to the RUNEVENT label, this means that WR-BBS 
REM      terminated with an ERRORLEVEL between 84 and 99.  In WRCONFIG.SYS,
REM      you can optionally schedule up to 16 events that WR-BBS executes
REM      after a configured time each day or on certain days.  Each event
REM      can be set as a "shell" event or a "terminate" event.  When a shell
REM      event runs, WR.BAT plays no part in the control of that event, since
REM      WR-BBS stays loaded in memory and simply shells to the operating
REM      system to run the event program.  When the event program finishes,
REM      WR-BBS resumes normal operation.
REM
REM      A "terminate" event, however, is executed much differently.  When a
REM      terminate event occurs, WR-BBS completely terminates, and sets the
REM      ERRORLEVEL to a value between 86 and 99.  The actual value that is
REM      set, depends on what you have configured in WRCONFIG.SYS.  Please
REM      read the WR-BBS documentation for detailed information on setting
REM      up terminate events.
REM
REM      IMPORTANT:  If the terminate event runs another batch file (outside
REM                  of WR.BBS), you must do one of the following, so that
REM                  WR-BBS will automatically restart when the event is 
REM                  finished:
REM
REM                  1.  Use the DOS CALL keyword to call the other batch 
REM                      file from WR.BAT.  Using CALL allows control to 
REM                      return to WR.BAT after the other batch file has
REM                      completed.  Without the CALL command, the parent
REM                      batch file (this one, WR.BAT) no longer has control
REM                      and the system will sit idle after the event.
REM
REM                  2.  At the end of the other batch file (the one that
REM                      runs the event), restart WR.BAT by changing back to
REM                      the WR-BBS home directory and then running (without
REM                      a CALL) the batch file WR.BAT.
REM
REM                  Attention is necessary to ensure that you do not CALL
REM                  or run WR.BAT while WR.BAT still has control.  This will
REM                  cause various unexpected problems.
REM
REM      (Put your event's command lines in place of the dummy names below)
REM
IF ERRORLEVEL 98 CALL DUMMY1.BAT
IF ERRORLEVEL 95 SAMPLE2.EXE
IF ERRORLEVEL 87 DUMMY3.BAT
REM
REM      Do not remove the line below.  It will restart WR-BBS after an event
REM      is called on one the above lines, or if there is (erroneously) no
REM      definition for the particular ERRORLEVEL.
REM
GOTO STARTBBS
:FINISHED
ECHO.
ECHO WR.BAT has terminated.
ECHO.

