********************************************************************
* for those of us new to Clipper 5, I thought you might enjoy
* seeing Grumpfish's utility-generated code for Tbrowsing
* a .DBF
* Structure of the .DBF is at bottom of this file
* The Grumpfish utility VTBROW is available FREE with a
* subscription the the Aquarium monthly disk-based newsletter
* $ 159.00 per year
********************************************************************
/*
   Program: LPBROW5.PRG
   Date:    01/30/93
   Time:    12:03:29
   Dialect: Clipper 5.01
   Compile with: clipper LPBROW5 /n /w /a
   Generated by THE VISIBLE TBROWSE
   Copyright (c) 1991 Greg Lief
      Grumpfish, Inc.
      P. O. Box 17761
      Salem, OR 97305
      Tel 503.588.1815
      Fax 503.588.1980
*/

#include "inkey.ch"
#include "setcurs.ch"

function LPBROW5
local b, c, oldcolor := setcolor(), key := 0
local oldcurs := setcursor(0), oldscore := set(_SET_SCOREBOARD, .f.)
local oldscrn := savescreen(0, 0, maxrow(), maxcol())
local nrow, ncol     // for showing more arrows
cls
use louphone new
b := TBrowseDB(2, 0, 21, 79)
b:colorSpec := 'W/N,W+/R,GR+/B,GR+/R,N/W,R+/B,+W/N,+W/N,N/W,N/BG'
b:headSep := ''
b:colSep  := '  '
b:footSep := ''
c := TBColumnNew('Last Name', fieldblock('LNAME'))
c:defColor := {9, 2}      /* default colors changed */
c:colorBlock := { | x | {3, 2} }
c:footing := 'Apellido'
c:width := 25
b:AddColumn( c )
c := TBColumnNew('First Name', fieldblock('FNAME'))
c:footing := 'Nombre'
c:width := 25
b:AddColumn( c )
c := TBColumnNew('Title', fieldblock('TITLE'))
c:footing := 'Cortesa'
b:AddColumn( c )
c := TBColumnNew('Company/Address 1', fieldblock('CO'))
c:footing := 'Compaa/Direccin 1'
b:AddColumn( c )
c := TBColumnNew('Street/Address 2', fieldblock('STREET'))
c:footing := 'Calle/Direccin 1'
b:AddColumn( c )
c := TBColumnNew('City', fieldblock('CITY'))
c:footing := 'Ciudad'
b:AddColumn( c )
c := TBColumnNew('State', fieldblock('STATE'))
c:footing := 'Estado'
b:AddColumn( c )
c := TBColumnNew('Zip Code', fieldblock('ZIP'))
c:footing := 'Zona Postl'
b:AddColumn( c )
c := TBColumnNew('Telephone 1', fieldblock('TEL'))
c:footing := 'Telefno 1'
b:AddColumn( c )
c := TBColumnNew('Telephone 2', fieldblock('WORK'))
c:footing := 'Telefno 2'
b:AddColumn( c )
c := TBColumnNew('Note 1', fieldblock('MEMO'))
c:footing := 'Nota 1'
b:AddColumn( c )
c := TBColumnNew('Note 2', fieldblock('MEMO2'))
c:footing := 'Nota 2'
b:AddColumn( c )
c := TBColumnNew('Xmas;Card?', fieldblock('XMAS'))
c:footing := 'Carta de;Navidad?'
b:AddColumn( c )
c := TBColumnNew('Post;Card?', fieldblock('POSTCARD'))
c:footing := 'Tarjeta;Postl?'
b:AddColumn( c )
c := TBColumnNew('Birth;Date', fieldblock('BDAY'))
c:footing := 'Fecha de;Nacimiento'
b:AddColumn( c )
c := TBColumnNew('Last;Updated', fieldblock('UPDATE'))
c:footing := 'Ultima;Fecha'
b:AddColumn( c )
c := TBColumnNew('Memo Field;1 of 1', { | | '<memo>' } )
c:footing := 'Descripcin; 1 de 1'
b:AddColumn( c )
b:autoLite := .f.
do while key != K_ESC
   do while ! b:stabilize() .and. ( key := inkey() ) == 0
   enddo
   if b:stable
      // save cursor location
      nrow := row()
      ncol := col()
      // draw arrows if data off to left or right
      // must take frozen columns into account
      // note: dependent upon Clipper 5.01!
      if b:leftvisible > b:freeze + 1
         @ 22, 0 say chr(17) + chr(196) color 'N/BG'
      else
         @ 22, 0 say space(2)
      endif
      if b:rightvisible < b:colCount
         @ 22, 78 say chr(196) + chr(16) color 'N/BG'
      else
         @ 22, 78 say space(2)
      endif
      setpos(nrow, ncol)
      // highlight current row
      b:colorRect( {b:rowPos, 1, b:rowPos, b:colCount}, { 9, 10 })
      b:hiLite()         // highlight current cell
      key := inkey(0)
   endif
   do case
      case key == K_UP
         b:refreshCurrent()   // remove highlight from current row
         b:up()
      case key == K_DOWN
         b:refreshCurrent()   // remove highlight from current row
         b:down()
      case key == K_LEFT
         b:left()
      case key == K_RIGHT
         b:right()
      case key == K_PGDN
         b:refreshCurrent()   // remove highlight from current row
         b:pageDown()
      case key == K_PGUP
         b:refreshCurrent()   // remove highlight from current row
         b:pageUp()
      case key == K_CTRL_PGDN
         b:refreshCurrent()   // remove highlight from current row
         b:goBottom()
      case key == K_CTRL_PGUP
         b:refreshCurrent()   // remove highlight from current row
         b:goTop()
      case key == K_HOME
         b:home()
      case key == K_END
         b:end()
      case key == K_CTRL_HOME
         b:panHome()
      case key == K_CTRL_END
         b:panEnd()
      case key == K_CTRL_LEFT
         b:panLeft()
      case key == K_CTRL_RIGHT
         b:panRight()
      case key == K_ENTER   // edit current cell directly
         editcell(b)
         // force redisplay of current row
         b:refreshCurrent()
   endcase
enddo
setcursor(oldcurs)              // restore previous cursor
set(_SET_SCOREBOARD, oldscore)  // restore previous SCOREBOARD
setcolor(oldcolor)              // restore previous color
restscreen(0, 0, maxrow(), maxcol(), oldscrn)
use
return nil

static function editcell(b)
local c := b:getColumn(b:colPos)
// set insert key to toggle both insert mode & cursor
local oldins := setkey( K_INS, {|| setcursor( ;
         if(readinsert(! readInsert()), SC_NORMAL, SC_INSERT))} )

// initial cursor setting based on current mode
setcursor( if(readInsert(), SC_INSERT, SC_NORMAL) )

// create corresponding GET with GETNEW() and read it now
readmodal( { getnew(Row(), Col(), c:block, c:heading,, b:colorSpec) } )
setcursor(0)              // turn cursor back off
setkey(K_INS, oldins)     // reset INS key
return NIL

* eof: LPBROW5.PRG
** here is the structure of LOUPHONE.DBF **
** Louis Hemmi, CPA
** 309 Avondale
** Houston, Tx. 77006-3113

*  Structure for database : LOUPHONE.DBF
*  Number of data records : 286
*  Date of last update    : 1/24/93
*  Field  Field Name  Type       Width    Dec
*      1  LNAME       Character     30
*      2  FNAME       Character     30
*      3  TITLE       Character      8
*      4  CO          Character     30
*      5  STREET      Character     30
*      6  CITY        Character     20
*      7  STATE       Character      2
*      8  ZIP         Character     10
*      9  TEL         Character     21
*     10  WORK        Character     21
*     11  MEMO        Character     30
*     12  MEMO2       Character     30
*     13  XMAS        Logical        1
*     14  POSTCARD    Logical        1
*     15  BDAY        Date           8
*     16  UPDATE      Date           8
*     17  TEST        Memo          10
*  ** Total **                     291
*
* enjoy *
