;**************************************************************************
;*                                                                        *
;*   UNAME.ASP  (C) 1992 DATASTORM TECHNOLOGIES, INC.                     *
;*                                                                        *
;* An ASPECT script file that shows how to create unique file names       *
;* based on system date and time.  Upto 10 unique file names can be       *
;* created at any given second.                                           *
;*                                                                        *
;* Note: Months 10-12 are represented with A-C                            *
;*                                                                        *
;**************************************************************************

proc main
   string path = "C:\"             ; Directory for Files (Must have trailing \)
   string fname                             ; File Name
   string ext = "."                         ; File Extension
   string temp                              ; Temporary Variable
   string dte
   integer indx                             ; Counter Variable

   indx = 1                                 ; Set Counter to 1
   date dte                                 ; Get Date
   substr s0 dte 0 2                        ; Pull out Month
   substr s1 dte 3 2                        ; Pull out day

   atoi s0 n1                               ; Convert Month string to int
   if n1<10                                 ; If Month Int < 10
     itoa n1 s0                             ; Convert back to string
   else
     switch n1                              ; Switch on Month int
       case 10                              ; If 10
         s0 = "A"                           ;    set to A
         endcase
       case 11                              ; If 11
         s0 = "B"                           ;    set to B
         endcase
       case 12                              ; If 12
         s0 = "C"                           ;    set to C
         endcase
       endswitch
     endif

   strcat ext s0                            ; Add month to ext
   strcat ext s1                            ; Add day to ext
new:
   assign fname $null                       ; Fill Fname With Nulls
   assign temp  $null                       ; Fill Temp  With Nulls

   time s0 1                                ; Get time
   n2 = 0
   for n0 = 0 upto 7                        ; Strip ":" & store in temp
     strpeek s0 n2 n1
     strpoke temp n0 n1
     inc n2
     if (n0 == 1) || (n0 == 3)
       inc n2
       endif
      endfor

   fname = temp                             ; Set Fname to Temp (Counter Var)
   itoa indx temp                           ; Put index value in temp

   strcat fname "-"                         ; Add hyphen
   strcat fname temp                        ; Add Value to temp
   strcat fname ext                         ; Add Ext to End of Fname
   temp=path
   strcat temp fname                        ; Add Fname to End of Path
   fname = temp                             ; Set Fname = to Path

   isfile fname                             ; If file exists
   if success                               ;   Inc indx, loop & rebuild
     inc indx                               ;   filename
     goto new
     endif

  log open  fname                  ;*
endproc
