@echo off
:----------------------------------------------------------------------------:
: 				Sample.bat                                   :
: 		Demonstration for Y_OR_N.COM By Joe Ellis.                   :
:									     :
: Hint:  to display a blank line in batch files, type "echo [255]" that's    :
: the word "echo", a blank space, and the ASCII character 255 (hold down     :
: [Alt] and enter 255 on the numeric keypad).  This will cause the batch     :
: file to display a blank line.  This allows you to make a more pleasing     :
: screen display.  In this batch file, all of the capital ECHO's have the    :
: hidden blank character after them.					     :
:----------------------------------------------------------------------------:

cls
echo 	This is an example of how to use the Y_OR_N utility in a batch file.
echo You can create your own interactive batch files by asking the user a
echo 'yes' or 'no' question.  By using the proper command line switches, you
echo can enable or disable the beep prompts, specify the amount of time to 
echo wait before selecting a "default" answer, or specify no timeout at all.
ECHO 
echo	To give you an idea of how to use Y_OR_N, you can run this batch file
echo in "debug" mode.  With debug on, we will display the actual command that
echo is used each time Y_OR_N is called.  The command will appear on one line,
echo with the actual screen output appearing on the following line.  To avoid
echo confusion, run this batch file with debug turned off the first time through.
echo Then, run it again with debug on to view the commands.
ECHO 
y_or_n /a"Do you want to turn on \"debug\" mode?"

if errorlevel 3 goto debug
if errorlevel 2 goto no_debug
if errorlevel 1 goto debug

:debug
set DEBUG="ON"
goto after_debug

:no_debug
set DEBUG="OFF"

:after_debug
cls
echo 	NEW in Version 1.2!:
echo	Users may now press [Enter] for the "default" answer (whatever you
echo specify for errorlevel 3) or, they may press [Esc] to answer "No".
ECHO 
echo	Y_OR_N.COM now has several new command-line options that you will see 
echo in use in the next few examples.  Read Y_OR_N.DOC for more information
echo about these new options.
ECHO 
echo 	The following questions are intended to demonstrate some possible uses
echo of Y_OR_N.  They will not actually do anything, like load your mouse 
echo driver, etc.
ECHO 
if %DEBUG%=="ON" echo Y_OR_N /A"Press [Enter] to continue, [Esc] to exit." /Q
Y_OR_N /A"Press [Enter] to continue, [Esc] to exit." /Q

if errorlevel 3 goto quest1
if errorlevel 2 goto end
if errorlevel 1 goto quest1

:----------------------------------------------------------------------------:
:	    Ask question & wait 5 seconds before timing out:                 :
:----------------------------------------------------------------------------:

:quest1
cls
if %DEBUG%=="ON" echo Y_OR_N /A"Do you want to load your mouse driver?" /W5
Y_OR_N /A"Do you want to load your mouse driver?" /W5

:----------------------------------------------------------------------------:
: 	Make sure you test for the highest errorlevel 1st!                   :
:----------------------------------------------------------------------------:

	if errorlevel 3 goto timeout1
	if errorlevel 2 goto no1
	if errorlevel 1 goto yes1

:timeout1
cls
echo Error level was 3!  Either you pressed [Enter], or, Y_or_N waited 5 seconds
echo and then came to this batch file location.  You can make your batch file
echo load (or not load) the application in your question...this is very useful if
echo you run a BBS or a network that automatically reboots your PC when something
echo goes wrong! Y_OR_N allows you create interactive batch files that won't hang
echo up your system if it reboots and you're not there to press a key!
ECHO 
ECHO 
ECHO 

if %DEBUG%=="ON" echo Y_OR_N /A"Press [Enter] to continue, [Esc] to exit." /Q
Y_OR_N /A"Press [Enter] to continue, [Esc] to exit." /Q

if errorlevel 3 goto quest2
if errorlevel 2 goto end
if errorlevel 1 goto quest2

:no1
cls
echo Error level was 2... You must have pressed 'N' or [Esc]!  
goto common

:yes1
cls
echo Error level was 1... You must have pressed 'Y'!

:common
echo This allows your batch file to branch to a label and custom configure your
echo system each time you reboot.  With the timeout feature, you can have a
echo "default" configuration that your system loads when you don't press a key!
ECHO 
ECHO 
ECHO 

if %DEBUG%=="ON" echo Y_OR_N /A"Press [Enter] to continue, [Esc] to exit." /Q
Y_OR_N /A"Press [Enter] to continue, [Esc] to exit." /Q

if errorlevel 3 goto quest2
if errorlevel 2 goto end
if errorlevel 1 goto quest2

:quest2
cls
echo Now, go back and try giving a different answer (or let it time out)!
ECHO 
ECHO 
ECHO 

if %DEBUG%=="ON" echo Y_OR_N /A"Press [Enter] to continue." /Q
Y_OR_N /A"Press [Enter] to continue." /Q

cls
if %DEBUG%=="OFF" goto skip
echo Y_OR_N /A"Want to try it again? (notice, this question didn't beep)" /W5 /Q
:skip
Y_OR_N /A"Want to try it again? (notice, this question didn't beep)" /W5 /Q

	if errorlevel 3 goto quest1
	if errorlevel 2 goto end
	if errorlevel 1 goto quest1

:end
