#include "Getexit.ch"
#include "InKey.ch"

#define K_SPACE 32
#define RADIO_BUTTON Chr(4)

#command @ <row>, <col> GET <var>                                ;
                        RADIO <radios,...>                       ;
                                                                 ;
      =>                                                         ;
         SetPos(<row>, <col>)                                    ;
         ; RadioGets({|x| iif(x == NIL, <var>, <var> := x) },    ;
                     <(var)>, {<radios>}, GetList)               ;
         ; DrawRadios(GetList, Atail(GetList))

MEMVAR GetList

FUNCTION RadioTest

LOCAL cPayType := ""
LOCAL cSex := ""

  CLEAR SCREEN

  // Radio buttons group 1
  // Start with Amex selected
  cPayType = "Amex"
  @ 5, 10 SAY "Payment Type"
  @ 6, Col() GET cPayType RADIO "Amex", "M/C", "Visa", "Diners"

  // Radio buttons group 2
  @ 15, 10 SAY "Sex"
  @ 16, Col() GET cSex RADIO "Male", "Female", "Not tonight dear"
  READ

RETURN NIL


// Issue radio button gets for array of character strings contained in
// aChoices. bVar is a get/set block for the get variable, cVar is the
// variable name.
FUNCTION RadioGets(bVar, cVar, aChoices, aGetList)

LOCAL oGet
LOCAL nRow := Row(), nCol := Col()
LOCAL nGets := Len(aChoices)
LOCAL nGet
LOCAL nStartGet := Len(aGetList) + 1
LOCAL nSaveRow, nSaveCol

  // For each element in aChoices
  FOR nGet := 1 To nGets

    // Display ( ) before the get
    DevPos(nRow, nCol)
    DevOut("( ) ")

    // Create an empty get object and add it to the list
    oGet := GetNew()
    Aadd(aGetList, oGet)

    // Its position is 4 spaces to the right of the cursor
    // (just past ( ) )
    oGet:col   := nCol + 4

    // We increment the row number so the
    oGet:row   := nRow++

    // Set get:name for hot keys
    oGet:name  := cVar

    // Here's where it gets a bit tricky. The get object's get/set
    // block must just return the character string describing the
    // radio button ("Amex", e.g. ). We cannot, however, set it as:
    //    {|| aChoices[nGet] }
    // as this code block is reevaluated at READ time when nGet is
    // invalid. We solve the problem with a detached local.
    oGet:block := t(aChoices[nGet])

    // Cargo is an arry of two elements. The first element contains
    // the get/set block for the real variable, the second element
    // is an array of offsets inside getlist of the other gets that
    // comprise the radio buttons
    oGet:cargo := {bVar, Array(nGets)}

    // Fill cargo[2] with element numbers of other gets in radio
    // button list. nStartGet is the element number of the first one.
    Aeval(oGet:cargo[2], {|x, n| oGet:cargo[2, n] := nStartGet + n - 1})

    // Radio gets have their own reader, of course
    oGet:reader := {|o| RadioReader(o, aGetList) }
    oGet:display()
  NEXT

RETURN oGet


// Just return a code block, which, when evaluated, will return c.
// As the returned code block references a local variable that variable
// becomes "detached" from the activation stack.
FUNCTION t(c)

RETURN {|x| c }


// The reader for radio buttons
Proc RadioReader( oGet, aGetList )

  // read the GET if the WHEN condition is satisfied
  IF ( GetPreValidate(oGet) )
    // activate the GET for reading
    oGet:SetFocus()

    DO WHILE ( oGet:exitState == GE_NOEXIT )
      // check for initial typeout (no editable positions)
      IF ( oGet:typeOut )
        oGet:exitState := GE_ENTER
      ENDIF

      // apply keystrokes until exit
      DO WHILE ( oGet:exitState == GE_NOEXIT )
        RadioApplyKey(oGet, InKey(0), aGetList)
      ENDDO

      // disallow exit if the VALID condition is not satisfied
      IF ( !GetPostValidate(oGet) )
        oGet:exitState := GE_NOEXIT
      ENDIF
    ENDDO

    // de-activate the GET
    oGet:KillFocus()
  ENDIF

RETURN


PROC RadioApplyKey(oGet, nKey, aGetList)

LOCAL cKey
LOCAL bKeyBlock
LOCAL nSaveRow, nSaveCol

  // check for SET KEY first
  IF ( (bKeyBlock := SetKey(nKey)) <> NIL )
    GetDoSetKey(bKeyBlock, oGet)
    RETURN  // NOTE
  ENDIF

  DO CASE
    CASE ( nKey == K_UP )
      oGet:exitState := GE_UP

    CASE ( nKey == K_SH_TAB )
      oGet:exitState := GE_UP

    CASE ( nKey == K_DOWN )
      oGet:exitState := GE_DOWN

    CASE ( nKey == K_TAB )
      oGet:exitState := GE_DOWN

    CASE ( nKey == K_ENTER )
      oGet:exitState := GE_ENTER

    CASE nKey == K_SPACE
      // Toggle state of this radio button. If the get
      // currently contains this radio button, clear it.
      // If it does not, set it to that value
      IF Eval(oGet:cargo[1]) == Eval(oGet:block)
        Eval(oGet:cargo[1], "")
      ELSE
        Eval(oGet:cargo[1], Eval(oGet:block))
      ENDIF

      // And redraw the getlist
      DrawRadios(aGetlist, oGet)

    CASE ( nKey == K_ESC )
      IF ( Set(_SET_ESCAPE) )
        oGet:undo()
        oGet:exitState := GE_ESCAPE
      ENDIF

    CASE (nKey == K_PGUP )
      oGet:exitState := GE_WRITE

    CASE (nKey == K_PGDN )
      oGet:exitState := GE_WRITE

    CASE ( nKey == K_CTRL_HOME )
      oGet:exitState := GE_TOP

    // both ^W and ^End terminate the READ (the default)
    CASE (nKey == K_CTRL_W)
      oGet:exitState := GE_WRITE

    CASE (nKey == K_INS)
      Set( _SET_INSERT, !Set(_SET_INSERT) )

  ENDCASE

RETURN


// Draw all radio buttons in aGetList to which the get object in
// oGet is attached
PROC DrawRadios(aGetList, oGet)

LOCAL cSelected := Eval(oGet:cargo[1])
LOCAL nRadios   := Len(oGet:cargo[2])
LOCAL oGet1
LOCAL nSaveRow := Row()
LOCAL nSaveCol := Col()
LOCAL nGet

  FOR nGet := 1 TO nRadios
    oGet1 := aGetList[oGet:cargo[2, nGet]]
    DevPos(oGet1:row, oGet1:col - 3)
    IF Eval(oGet1:cargo[1]) == Eval(oGet1:block)
      DevOut(RADIO_BUTTON)
    ELSE
      DevOut(" ")
    ENDIF
  NEXT

  DevPos(nSaveRow, nSaveCol)

RETURN
