'                      SCHWBFEE (for $TOKTRAX, release 4)
'        ͻ
'                   Charles Schwab Commission Calculator           
'        Ķ
'          Charles Schwab and Company, Inc. can in no way be held  
'          responisble for the content or accuracy of this program.
'        ͼ
'---------------------------------------------------------------------------
' The following sample program estimates SCHWAB commissions for common
' stock purchases based on their 5/20/1991 schedule of charges.  Any
' modifications will require the QuickBASIC or BASIC PDS compiler.
'---------------------------------------------------------------------------
' SCHWBFEE can be used standalone, although it was designed for use by
' the $TOKTRAX (v4) Stock Tracking System to estimate transaction fees.
' The result of the calculation is saved to a file called CALC.FEE if
' the /FILE parameter is used, otherwise results are sent to the screen.
' $TOKTRAX issues the /FILE command and reads CALC.FEE for its estimates.
'---------------------------------------------------------------------------
'Syntax:
' SCHWBFEE shares price [symbol] [/FUND] [/FILE]
'where:
' shares = number of shares transacted
' price  = price per share
'    The command line MUST specify both of these, in order. For example,
'    the line  SCHWBFEE 200 15.25  instructs the program to calculate
'    the commission on 200 shares of stock purchased at $15.25 per share.
' symbol = optional stock symbol
' /FUND is optional parameter for estimating fees for mutual funds.
' /FILE option sends output to file CALC.FEE instead of screen.
'---------------------------------------------------------------------------
DECLARE FUNCTION min (i, j)

errcode% = 0                                    'set error code to 0

fund% = 0                                       'set mutual fund calc false

type$ = "Estimated Schwab Common Stock Commission = $###,###.##"

text$ = COMMAND$                                'copy command line to text$

fund% = INSTR(text$, "/FUND")                   'test if FUND calc
IF fund% > 0 THEN
	MID$(text$, fund%, 5) = "     "             'remove /FUND from command line
	type$ = " Estimated Schwab Mutual Fund Commission  = $###,###.##"
	END IF

file% = INSTR(text$, "/FILE")                   'test if output to file
IF file% > 0 THEN
	MID$(text$, file%, 5) = "     "             'remove /FILE from command line
	END IF

text$ = LTRIM$(RTRIM$(text$))                   'remove leading and trailing
												'spaces from the command line
												'and assign to text$ variable

space% = INSTR(text$, " ")                      'locate position of the space
IF space% = 0 THEN errcode% = 1: GOTO errexit   'branch to ERREXIT if no space
												'  (less than 2 parameters)

shares = ABS(VAL(LEFT$(text$, space%)))         'get number of shares
												'doesn't allow 0 or negative #

text$ = LTRIM$(RIGHT$(text$, LEN(text$) - space%))
												'remove shares from command line

space% = INSTR(text$, " ")                      'locate position of the space to
												'  determine if a symbol was passed

IF space% THEN
	price = ABS(VAL(LEFT$(text$, space%)))      'get price
	sym$ = RIGHT$(text$, LEN(text$) - space%)
	ELSE
	price = ABS(VAL(RIGHT$(text$, LEN(text$) - space%)))
	sym$ = "shares"
	END IF                                      'doesn't allow 0 or negative #

amount = shares * price                         'total cost of stock

IF fund% GOTO fundcalc                          'if calc is for mutual fund,
												'  branch to that routine

SELECT CASE amount                              'calculate the fee
	CASE 0 TO 2500:
			fee = 30 + amount * .017
	CASE 2500 TO 6250:
			fee = 56 + amount * .0066
	CASE 6250 TO 20000:
			fee = 76 + amount * .0034
	CASE 20000 TO 50000:
			fee = 100 + amount * .0022
	CASE 50000 TO 500000:
			fee = 155 + amount * .0011
	CASE ELSE:
			fee = 255 + amount * .0009
	END SELECT
minimum = 39                                    'overriding minimum of $39
IF fee < minimum THEN fee = minimum

mincharge = shares * .09                        'get total minimum charge
IF shares > 1000 AND price < 5 THEN
	mincharge = mincharge + .04 * (shares - 1000)
	END IF
IF shares > 1000 AND price >= 5 THEN
	mincharge = mincharge + .05 * (shares - 1000)
	END IF
IF fee < mincharge THEN fee = mincharge

maxcharge = 55                                  'calc total maximum charge
IF shares > 100 THEN maxcharge = maxcharge + .55 * (shares - 100)
IF fee > maxcharge THEN fee = maxcharge

IF price < 1 THEN fee = 39 + amount * .04       'fee for "penny stocks"

GOTO finis

'---------------------------------------------------------------------------
fundcalc:

fee = min(amount, 15000) * .006                      'calculate mutual fund fee
SELECT CASE amount
	CASE 0 TO 15000:
	CASE 15000 TO 100000:
			fee = fee + .002 * (amount - 15000)
	CASE IS > 100000:
			fee = fee + .002 * (85000) + .0008 * (amount - 100000)
	END SELECT
IF fee < 29 THEN fee = 29                           'overriding minimum

'---------------------------------------------------------------------------
finis:
IF file% THEN                                       'If /FILE specified
	f% = FREEFILE                                   '  save result to file
	OPEN "CALC.FEE" FOR OUTPUT AS #f%               '  for $tokTraX to read
	PRINT #f%, fee
	CLOSE #f%
  ELSE
	PRINT
	PRINT "                     SCHWBFEE (for $TOKTRAX, release 4)"
	PRINT "        ͻ"
	PRINT "                   Charles Schwab Commission Calculator           "
	PRINT "        Ķ"
	PRINT "         Charles Schwab and Co. can in no way be held responsible "
	PRINT "               for the content or accuracy of this program.       "
	PRINT "        ͼ"
	COLOR 15
	PRINT TAB(4); USING type$; fee; : PRINT "  (for"; shares; sym$; ")"
													'else print to screen
  END IF

'---------------------------------------------------------------------------
errexit:
IF errcode% AND NOT file% THEN
	CLS : SOUND 500, 2: SOUND 100, 2
	LOCATE 5, 1
	PRINT "        ͻ"
	PRINT "                    SCHWBFEE (for $TOKTRAX, release 4)            "
	PRINT "        Ķ"
	PRINT "         SCHWBFEE estimates Schwab broker commissions for stocks  "
	PRINT "         and mutual funds, based on schedule dated May 20, 1991.  "
	PRINT "         Charles Schwab and Co. can in no way be held responsible "
	PRINT "         for the content or accuracy of this program.             "
	PRINT "        Ķ"
	PRINT "          Syntax: SCHWBFEE SHARES PRICE [SYMBOL] [/FUND] [/FILE]  "
	PRINT "            where SHARES is the number of shares transacted       "
	PRINT "                  PRICE is the stock price per share              "
	PRINT "                  SYMBOL optionally displays stock symbol         "
	PRINT "                  /FUND optionally calculates mutual fund fee     "
	PRINT "                  /FILE optionally prevents output to screen,     "
	PRINT "                    instead saving output to file CALC.FEE.       "
	PRINT "        ͼ"
	END IF

END

FUNCTION min (i, j)
'============================================================
' Given two REAL numbers, min returns the smaller of the two.
		IF i > j THEN min = j ELSE min = i
END FUNCTION

