{
   This script contains the "Achelis Binary Wave(tm)" calculation
   shown in the Metastock(*) 2.0 distribution system. It has been
   modified to include the following indicators as well:
                                    BUY         SELL
      Chaikin's Oscillator          > 0         < 0
      Parabolic SAR                 < C         > C
      Commodity Channel Index      > 100       < -100
   It is here to give an example of the kind of analysis
   available with the TAS Script language.
   The Metastock manual discusses this binary wave system on
   page 187 of the User's Manual.
   The script will put out a message if the value of the binary
   wave changes from yesterday to today (the terms 'today' and
   'yesterday' are used loosely, but meant to be the 'latest day'
   and the 'day before', respectively).
   Two variables are defined and updated as each of the four
   individual binary wave formulas are checked.
   They are:
   "t_bwave" which is today's binary wave value (-7 to +7)
            and
   "y_bwave" which is yesterday's binary wave value (-7 to +7)
   What we are looking for is a TRANSITION from yesterday to
   today. If the stock moved to +7 today and it was lower yesterday,
   perhaps this is a buying opportunity. If the stock moved to -7
   perhaps it is a short sell.
}

{ This subroutine takes a variable PERIOD as the number of days to 
  look back in computing "y_bwave" }

:BinaryWave
lb = -period;            { Compute "look back" index }
y_total : number;        { yesterday's total bwave }
t_total : number;        { today's total bwave value }
c_total : number;        { total changed bwave values}
tick_total : number;     { ticker count }
sell_count : number;     { total SELL's given }
buy_count : number;      { total BUY's given }
MACD_ARRAY : ARRAY;    { Place to put values for TODAY }
MACDTRIG_ARRAY : ARRAY;
MA20 : ARRAY;
ROC12 : ARRAY;           { PLACE TO PUT RATE OF CHANGE }
STOCH53 : ARRAY;                { PLACE TO PUT STOCH(5,3) VALUES }
CO_ARRAY : ARRAY;
CCI14 : ARRAY;          { PLACE TO PUT CCI(14) VALUES }
SAR_A : ARRAY;          { PARABOLIC SAR ARRAY}
y_bwave := 0;     { this is our 'score' yesterday}
t_bwave := 0;     { this is our 'score' today}
alert   := '         ';
if FIRST_TICKER then
begin
    y_total = 0;        { yesterday's total bwave }
    t_total = 0;        { today's total bwave value }
    c_total = 0;        { total changed bwave values}
    tick_total = 0;     { ticker count }
    sell_count = 0;     { SELL count }
    buy_count = 0;      { BUY count }
end;
BEGIN
	{
	   First compute MACD Binary Wave for yesterday and today
	   Note that MACD() computes the 12 day EMA - 26 day EMA and places
	   the result in the array MACD_ARRAY. The 9 day EMA is computed
	   and placed in the result array MACDTRIG_ARRAY
	}
	MACD_ARRAY = MACD();
	MACDTRIG_ARRAY = MACDTRIGGER();
	{
	   Now compute 20-MA B-Wave
	}
	MA20 := mov(c,20,'E');   { Compute 20 unit EMA of close }
	{
	   Now compute 12-ROC B-Wave
	}
	ROC12 := roc(c,12,'%');
	{
	   Now compute 5-3 stochastic B-wave
	}
	STOCH53 := stoch(5,3);          { compute stoch(%K period, %K slow) }
	{
	    check if Chaikin's AD oscillator is above or below 0
	}
	CO_ARRAY := CO();       { PLACE CHAIKIN'S OSCILLATOR IN CO_ARRAY}
	{
	    check if CCI(14)  above +100 or below -100
	}
	CCI14 := cci(14);
	{
	   check if Wilder's Parabolic is greater or less than close
	}
	SAR_A := SAR(.02,.20);

   { All arrays are calculated. Now do the checking of change }
	IF MACD_ARRAY[0] > MACDTRIG_ARRAY[0] THEN
       t_bwave := t_bwave + 1    { macd greater than trigger }
	else
       t_bwave := t_bwave - 1;   { macd less than trigger    }
	if MACD_ARRAY[lb] > MACDTRIG_ARRAY[lb] then
       y_bwave := y_bwave + 1    { macd greater than trigger }
	else
       y_bwave := y_bwave - 1;   { macd less than trigger    }
	if c[0] > MA20 then    { compare today's close to today's ema}
       t_bwave := t_bwave + 1    { ema greater than close }
	else
       t_bwave := t_bwave - 1;   { ema less than close    }
   { compare yesterday's close to today's ema}
	if c[lb] > MA20[lb] then 
       y_bwave := y_bwave + 1    { ema greater than close }
	else
       y_bwave := y_bwave - 1;   { ema less than close    }
	if ROC12 > 0 then
       t_bwave := t_bwave + 1    { roc greater than 0 }
	else
       t_bwave := t_bwave - 1;   { roc less than 0    }
	if ROC12[lb] > 0 then
       y_bwave := y_bwave + 1    { roc greater than 0 }
	else
       y_bwave := y_bwave - 1;   { roc less than 0    }
	if STOCH53[0] > 50 then
       t_bwave := t_bwave + 1    { stoch greater than 50 }
	else
       t_bwave := t_bwave - 1;   { stoch less than 50    }
	if STOCH53[lb] > 50 then
       y_bwave := y_bwave + 1    { stoch greater than 50 }
	else
	       y_bwave := y_bwave - 1;   { stoch less than 50    }
	IF CO_ARRAY[0] > 0 THEN
        t_bwave := t_bwave + 1
	else
        t_bwave := t_bwave - 1;
	IF CO_ARRAY[lb] > 0 THEN
        y_bwave := y_bwave + 1
	else
        y_bwave := y_bwave - 1;
	if CCI14[0] < -100 then
	   t_bwave := t_bwave - 1
	else
	if CCI14[0] > 100 then
	   t_bwave := t_bwave + 1;
	if CCI14[lb] < -100 then
	   y_bwave := y_bwave - 1
	else
	if CCI14[lb] > 100 then
	   y_bwave := y_bwave + 1;
	if SAR_A[0] > C then    { if SAR above close, position is SHORT}
	   t_bwave := t_bwave-1
	else
	   t_bwave := t_bwave+1;
	if SAR_A[lb] > C[lb] then    { if SAR above close, position is SHORT}
	   y_bwave := y_bwave-1
	else
	   y_bwave := y_bwave+1;
	{
	   Okay, here we are at the end of the script. We have boiled
	   the formulas down to two values:
	   "t_bwave" which is today's binary wave value (-7 to +7)
	            and
	   "y_bwave" which is yesterday's binary wave value (-7 to +7)
	}
	{
	   First, let's check if the wave moved to +7..if so, let's print
	   out it's value then and now
	}
	tick_total = tick_total + 1;    { add to count of tickers }
	y_total = y_total + y_bwave;    { add yesterday's bwave to total}
	t_total = t_total + t_bwave;    { add today's bwave to total}
	c_total = c_total + diff;    { add diff in bwave to total}
	buy_flag = 0;
	sell_flag = 0;
	alert = '         ';
	if ((y_bwave < 7) and (t_bwave = 7)) then
	begin
	    buy_flag = 1;
	    alert = '   BUY   ';
	    buy_count = buy_count + 1;
	end
	{
	   Now, let's check if the wave moved to -7..if so, let's print
	   out it's value then and now
	}
	else
	if ((y_bwave > -7) and (t_bwave = -7)) then
	begin
	    sell_flag =  1;
	    alert = '   SELL  ';
	    sell_count = sell_count + 1;
	end;
END; 	{ of if good_date = date }
RETURN;
if last_ticker then
begin
   writeln('\t\t\n\n------------- SUMMARY--------------------');
   writeln('\tTickers Processed             ',INT(tick_total));
   writeln('\tYesterday Binary Wave Average ',y_total/tick_total);
   writeln('\tToday Binary Wave Average     ',t_total/tick_total);
   writeln('\tAverage Change in Binary Wave ',c_total/tick_total);
   writeln('\t',INT(buy_count),' BUY Signals');
   writeln('\t',INT(sell_count),' SELL Signals');
end;
