/* Fontools header file (C) 1993 Jeremy Lilley

 Use this file to interface various SFF and SFS files with the C language.
 Depending on your memory model, you may have to use FONTS_N.OBJ (near) or 
 FONTS_F.OBJ (far). Both are designed for 32-bit far pointers, and if you 
 wish to use 16 bit pointers (tiny or small memory model), you must modify
 the FONTS_N.ASM file as directed in the file and reassemble it with MASM.
 
 You can interface files either of the following ways:
 
 	1) Create an OBJ file with either BINOBJ (from Borland) and link it
 	   to your file as data, and call the necessary procedures.
 	   
 	2) Use LANGUAGE.EXE to make a C header file with the data from 
 	   a SFF or SFS file and use the INCLUDE directive to make it
 	   data.
 	   
 	3) Store the images in disk files are retrieve them using file IO.
 	   Allocate pointers, etc. This is not very efficient and can leave
 	   a bunch of small stupid 1 to 4 k font and screen files lying around
 	   uncompressed. These files also have a tendency to get "lost."
 	    	   
 Here is an example (using #2, but #1 is similar) :
 
 #include <stdio.h>
 #include "fontools.h"
 #include "mydata_s.h"
 #include "mydata_f.h"
 
 / *   mydata_s contains the screen, mydata_f contains the font. The
   indentifiers are mydatascreen and mydatafont. * /
   
 main () {
 readfont ( mydatafont );
 readscreen ( mydatascreen );
 }

*/

/* The following are the declarations and comments about them. Depending on
 the memory model, you may have to change them. */

extern void readfont( char far *fontptr );
/* This function reads a font file that has been stored in memory by any
 method. It check for font file validity before attempting to display it. */

extern void readscreen( char far *screenptr );
/* This function reads a screen file or block from memory stored by any 
  method. It uses the dimensions given when it was saved. */

extern void sequencefonts (void);
/* BE CAREFUL WITH THIS! If you can help it, don't call it yourself.
 It sets up the EGA card so that you can move fonts into the 0xA000 segment.
 Each character occupies 32 bytes regardless of the number of points per
 character needed. Thus, character 0 would be at 0xA000:0, character 1 would
 be at 0xA000:0x20, etc. DON'T LEAVE THIS ON WHEN YOU DON'T HAVE TO BECAUSE
 IT SCREWS UP THE WAY THE SCREEN LOOKS WHEN IT IS ON (to say the least!). */

extern void desequencefonts (void);
/* Use this to turn off sequencefonts and normalize the display. */

extern void resetfonts (void);
/* This preforms a mode set and sets th lines to 400 on VGA.  */

extern void savefonts( char far *savebufferpointer );
/* Saves fonts to a 8192-byte buffer */

extern void restorefonts( char far *restorebufferpointer );
/* Restores fonts from a 8192-byte buffer */

extern void setscanlines( char scanlines );
/* Sets the scan lines on VGA to:
     0=200 lines, 1=350 lines, 2=400 lines */
