/* Directory Manager 2.0 install routine                        */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
say center(' Welcome to the Directory Manager 2.0 install procedure ', 79, '*');
say center(' QB Software,  P.O. Box 8019, Rochester,  Minnesota  55903 ', 79, '*');
say ''
do forever
   rc=CharOut(,"Enter source drive letter (example A): ");
   input = '';
   Do While (Pos('0A'x, input)=0);
      input=input||CharIn(,,1);
   End;
   input = c2x(input)
   input = delstr(input, (length(input)-3))
   input = x2c(input)
   source_drive = input
   if source_drive \= '' then leave
end
source_drive = source_drive || ':'
drive_info = SysDriveInfo(source_drive)
parse var drive_info . . . label
if label \= 'DIRMANPM' then
    do
       stream_name = stream(source_drive||'\DIRMAN20.EXE', 'c', 'query exists')
       if stream_name = '' then
       do
          say 'Error, incorrect installation diskette';
          exit
        end
    end
say ''
do forever
   rc=CharOut(,"Enter fully quailified target directory (example C:\DIRMAN ): ");
   input = '';
   Do While (Pos('0A'x, input)=0);
      input=input||CharIn(,,1);
   End;
   input = c2x(input)
   input = delstr(input, (length(input)-3))
   input = x2c(input)
   target_directory = input
   if target_directory \= '' then leave
end
new_directory = directory(target_directory);
if new_directory \= target_directory then
    do
       say ''
       say 'Creating directory' target_directory
       rc = SysMkDir(target_directory);
       if rc \= 0 then
          do
              say 'Error creating directory' target_directory
              exit
           end
       say 'Directory' target_directory 'created';
       new_directory = directory(target_directory);
       new_directory = translate(new_directory);
       target_directory = translate(target_directory);
    end
if new_directory = target_directory then
   do
       say ''
       say 'Copying files to' target_directory '...';
       '@ECHO OFF'
       'COPY A:*.* ' target_directory '1>NUL 2>&1'
       '@ECHO ON'
       say 'Copy complete';
   end
   else do
           say 'Error copying files to' target_directory
           exit
    end
say ''
say 'Creating Directory Manager object'
location = '<WP_DESKTOP>'
title    = 'Directory Manager 2.0'
class    = 'WPProgram'
progtype = 'PROGTYPE=PM;'
exename  = 'EXENAME='||target_directory||'\DIRMAN20.EXE;'
workdir  = 'WORKDIR='||target_directory||';'
objectid = '<DIRMAN_2_0>;'
open     = 'OPEN=DEFAULT;'
setup    = progtype||exename||workdir||objectid||open
rc = SysCreateObject(class, title, location, setup, 'F')
if rc \= 1 then
    do
       say 'Error creating Directory Manager object';
       exit
    end
say 'Directory Manager object created';
