/* ctype.h (emx+gcc) */

#if !defined (_CTYPE_H)
#define _CTYPE_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_CTYPE_C)
extern unsigned char _ctype[];
#endif

#define _UPPER  0x01
#define _LOWER  0x02
#define _DIGIT  0x04
#define _XDIGIT 0x08
#define _CNTRL  0x10
#define _SPACE  0x20
#define _PUNCT  0x40
#define _PRINT  0x80

#define CTYPE_ISALNUM(c)  ((_ctype+1)[c] & (_UPPER|_LOWER|_DIGIT))
#define CTYPE_ISALPHA(c)  ((_ctype+1)[c] & (_UPPER|_LOWER))
#define CTYPE_ISCNTRL(c)  ((_ctype+1)[c] & (_CNTRL))
#define CTYPE_ISDIGIT(c)  ((_ctype+1)[c] & (_DIGIT))
#define CTYPE_ISGRAPH(c)  ((_ctype+1)[c] & (_PUNCT|_UPPER|_LOWER|_DIGIT))
#define CTYPE_ISLOWER(c)  ((_ctype+1)[c] & (_LOWER))
#define CTYPE_ISPRINT(c)  ((_ctype+1)[c] & (_PRINT))
#define CTYPE_ISPUNCT(c)  ((_ctype+1)[c] & (_PUNCT))
#define CTYPE_ISSPACE(c)  ((_ctype+1)[c] & (_SPACE))
#define CTYPE_ISUPPER(c)  ((_ctype+1)[c] & (_UPPER))
#define CTYPE_ISXDIGIT(c) ((_ctype+1)[c] & (_XDIGIT))

#define CTYPE_ISASCII(c) ((unsigned)(c) <= 0x7f)
#define CTYPE_TOASCII(c) ((c) & 0x7f)

#if !defined (_CTYPE_FUN)
#define isalnum(c)  CTYPE_ISALNUM (c)
#define isalpha(c)  CTYPE_ISALPHA (c)
#define iscntrl(c)  CTYPE_ISCNTRL (c)
#define isdigit(c)  CTYPE_ISDIGIT (c)
#define isgraph(c)  CTYPE_ISGRAPH (c)
#define islower(c)  CTYPE_ISLOWER (c)
#define isprint(c)  CTYPE_ISPRINT (c)
#define ispunct(c)  CTYPE_ISPUNCT (c)
#define isspace(c)  CTYPE_ISSPACE (c)
#define isupper(c)  CTYPE_ISUPPER (c)
#define isxdigit(c) CTYPE_ISXDIGIT (c)
#define isascii(c)  CTYPE_ISASCII (c)
#define toascii(c)  CTYPE_TOASCII (c)
#endif

#if !defined (_CTYPE_C) && !defined (_CTYPE_FUN)
static __inline__ int _toupper (int c) { return (c-'a'+'A'); }
static __inline__ int _tolower (int c) { return (c-'A'+'a'); }
static __inline__ int toupper(int c) {return (islower(c) ? _toupper(c) : c);}
static __inline__ int tolower(int c) {return (isupper(c) ? _tolower(c) : c);}
#endif

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_CTYPE_H) */
