/* time.h (emx+gcc) */

#if !defined (_TIME_H)
#define _TIME_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (_TIME_T)
#define _TIME_T
typedef unsigned long time_t;
#endif

#if !defined (_CLOCK_T)
#define _CLOCK_T
typedef long clock_t;
#endif

#if !defined (_TM)
#define _TM
struct tm         /* cf. sys/emx.h */
{
  int tm_sec;     /* 0..59 */
  int tm_min;     /* 0..59 */
  int tm_hour;    /* 0..23 */
  int tm_mday;    /* 1..31 */
  int tm_mon;     /* 0..11 */
  int tm_year;    /* 0(:=1900).. */
  int tm_wday;    /* 0..6 */
  int tm_yday;    /* 0..365 */
  int tm_isdst;   /* 0 */
};
#endif

#if !defined (CLOCKS_PER_SEC)
#define CLOCKS_PER_SEC 100
#endif

#if !defined (CLK_TCK)
#define CLK_TCK 100
#endif

#if !defined (_TZSET_C)
extern int daylight;
extern long timezone;
extern char *tzname[2];
#endif

double difftime (time_t t1, time_t t0);
char *asctime (__const__ struct tm *t);
char *ctime (__const__ time_t *t);
clock_t clock (void);
struct tm *gmtime (__const__ time_t *t);
struct tm *localtime (__const__ time_t *t);
time_t mktime (struct tm *t);
size_t strftime (char *string, size_t size, __const__ char *format,
    __const__ struct tm *t);
time_t time (time_t *t);
void tzset (void);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_TIME_H) */
