/***********************************************************************\
 *                                 PC2.c                               *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed.                                                            *
 *                                                                     *
 * Install.cmd  Installation batch file.                               *
 *                                                                     *
 *              INSTALL <InstallationPathDirectory>                    *
 *              F.e. INSTALL C:\PMAPPS\PC2                             *
 *                                                                     *
 *              The PC/2 Package is installed in the Path pointed      *
 *              by <InstallationPathDirectory> from the current path.  *
 *                                                                     *
\***********************************************************************/

/* static char RCSID[]="@(#) $Header: Install.cmd Version 1.30 04,1993 $ (LBL)" */

                                        /* Register REXX APIs */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Parse Arg InstallationPathDirectory     /* Command line parameter */
Signal On Halt Name SignalHandler       /* Exception handler */
Call DisplayLogo                        /* Display logo panel */
                                        /* Query the current path and directory */
CurrentPathDirectory=SysSearchPath("Path", "Install.cmd")
                                        /* Installation path must be given */
Do While InstallationPathDirectory=" "
    Call DisplayLogo                    /* Display logo panel */
    Say "                       PC/2 Installation Instruction:"
    Say
    Say " To install PC/2, you must provide a target path to install PC/2 into."
    Say
    Say " Syntax:       INSTALL <InstallationPathDirectory>"
    Say
    Say " Example:      INSTALL C:\PMAPPS\PC2"
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please input: "
    Col=Col+15
    Call SysCurPos Row, Col
    Pull InstallationPathDirectory
End
Call DisplayLogo                        /* Display logo panel */

                                        /* Test for installation directory */
Call SysFileTree InstallationPathDirectory, FileDirectory, 'D'
If FileDirectory.0='0' Then Do
                                        /* Make the installation directory */
    rc=SysMkDir(InstallationPathDirectory)
    If rc\=0 Then Do
        Say " Sorry, the desired directory couldn't be created - exiting..."
        Exit
    End
End

                                        /* Now copy files */
Say
Say " Now copying files..."
Call FileCopy 'PC2.exe', InstallationPathDirectory
Call FileCopy 'PC2.hlp', InstallationPathDirectory
Call FileCopy 'PC2*.cfg', InstallationPathDirectory
Call FileCopy 'PC2Hook.dll', InstallationPathDirectory
Call FileCopy 'PC2.doc', InstallationPathDirectory
Call FileCopy 'PC2.faq', InstallationPathDirectory
Call FileCopy 'Makefile', InstallationPathDirectory
Call FileCopy 'Install.cmd', InstallationPathDirectory
Call FileCopy 'Source.zip', InstallationPathDirectory
Call DisplayLogo                        /* Display logo panel */

                                        /* Ask the user if he wants to display the Popup-
                                           Menu after a single-click instead of a double-
                                           click with mouse button 1 */
Say " Do you want the Popup-Menu displayed after a single-click with mouse button 1"
Parse Value SysCurPos() with Row Col
Say " instead of the default double click? [Y/y/N/n]: "
Col=Col+49
Call SysCurPos Row, Col
Pull SingleClickFlag
Say
If SingleClickFlag='Y' | SingleClickFlag='y' Then Do
                                        /* Add -SingleClick to the parameters field */
    SetupString="EXENAME="InstallationPathDirectory"\PC2.EXE;STARTUPDIR="InstallationPathDirectory";PARAMETERS=-SingleClick"
End
else Do
                                        /* Add -DoubleClick to the parameters field */
    SetupString="EXENAME="InstallationPathDirectory"\PC2.EXE;STARTUPDIR="InstallationPathDirectory";PARAMETERS=-DoubleClick"
End
                                        /* Now create the PC/2 object on the Desktop */
rc=SysCreateObject("WPProgram",,
                   "PC/2",,
                   "<WP_DESKTOP>",,
                   SetupString)
If rc=0 Then Do
    Say " Sorry, PC/2 couldn't be created as a WPS object - exiting..."
    Exit
End

If Substr(InstallationPathDirectory, 2, 1)=":" Then Do
                                        /* Change to the drive where we copied files to */
    Command="@"Filespec("Drive", InstallationPathDirectory)" >NUL"
    Command
End
                                        /* Change in the directory */
Command="@CD "InstallationPathDirectory" >NUL"
Command
                                        /* Now we start PC/2 with help, but check for
                                           the clicking method */
If SingleClickFlag='Y' | SingleClickFlag='y' Then Do
    Command="@Start PC2.exe -SingleClick -INSTALL >NUL"
End
else Do
    Command="@Start PC2.exe -DoubleClick -INSTALL >NUL"
End
Command
If rc\=0 Then Do
    Say " Sorry, I couldn't start PC/2 for you..."
End
Else Do
    Say " After you have finished reading all help panels exit PC/2 and restart it by"
    Say " clicking on the Desktop with mouse button 1. You will notice that the back-"
    Say " ground behind the icon changed its color and shape if PC/2 is started."
End
Say
                                        /* Now search for CONFIG.SYS and the statement
                                           SET RESTARTOBJECTS=STARTUPFOLDERSONLY */
FoundConfig=FALSE
SearchConfig="C:\CONFIG.SYS D:\CONFIG.SYS E:\CONFIG.SYS F:\CONFIG.SYS G:\CONFIG.SYS"
Do Temp=1 to Words(SearchConfig)
    Call SysFileSearch "STARTUPFOLDERSONLY", Word(SearchConfig, 1), LinesCount
    If LinesCount.0\=0 Then FoundConfig=TRUE
End
                                        /* Inform the user about CONFIG.SYS */
If FoundConfig=TRUE Then Do
    Say " You have the statement SET RESTARTOBJECTS=STARTUPFOLDERSONLY in your"
    Say " Config.Sys. To enable OS/2 to start PC/2 during boot, you have to create"
    Say " a shadow of PC/2 and move it into your startup folder."
End
Else Do
    Say " You don't have the statement SET RESTARTOBJECTS=STARTUPFOLDERSONLY in ypur"
    Say " Config.Sys. OS/2 will start automatically PC/2 during next boot, if PC/2 is"
    Say " active before you Shutdown your System."
End
Say
Say " Press Enter to continue!..."
Pull Ignore
Call DisplayLogo                        /* Display logo panel */
                                        /* Now search for CONFIG.SYS and the statement
                                           SET RUNWORKPLACE=C:\OS2\PMSHELL.EXE */
FoundConfig=FALSE
SearchConfig="C:\CONFIG.SYS D:\CONFIG.SYS E:\CONFIG.SYS F:\CONFIG.SYS G:\CONFIG.SYS"
Do Temp=1 to Words(SearchConfig)
    Call SysFileSearch "SET RUNWORKPLACE=C:\OS2\PMSHELL.EXE", Word(SearchConfig, 1), LinesCount
    If LinesCount.0\=0 Then FoundConfig=TRUE
End
                                        /* Inform the user about CONFIG.SYS */
If FoundConfig=TRUE Then Do
    Say " You have the statement SET RUNWORKPLACE=C:\OS2\PMSHELL.EXE in your"
    Say " Config.Sys. You may replace the WPS by PC/2, please look into the help-"
    Say " panels of PC/2 for further information."
End
Else Do
    Say " It seems that you don't run the WPS (WorkPlace Shell). You may use PC/2 as"
    Say " a replacement for the WPS by adding to or modifying your CONFIG.SYS:"
    Say " SET RUNWORKPLACE="InstallationPathDirectory"\PC2.EXE"
    Say " But be sure that PC2HOOK.DLL and PC2.HLP are in a path pointed to by the"
    Say " LIBPATH and HELP environment variable (the '.;' statement is not"
    Say " sufficient) or in the directory of PC/2. Please look into the help panels"
    Say " of PC/2 for further information."
End
Say
Say " Press Enter to continue!..."
Pull Ignore
Call DisplayLogo                        /* Display logo panel */
                                        /* Inform the user about safety an fee */
Say " Don't forget to backup your configuration file regularily to avoid possible"
Say " damages to your configuration file."
Say
Say " If you find this utility useful and want to honor four weeks of work, you are"
Say " welcome to send me a small fee. Please read the documentation for further"
Say " information - Thank you!"
Say
Parse Value SysCurPos() with Row Col
Say " Do you want to read the FAQ (Frequently Asked Questions) list? [Y/y/N/n]: "
                                        /* Ask the user if he wants to read the FAQ */
Col=Col+75
Call SysCurPos Row, Col
Pull FAQFlag
If FAQFlag='Y' | FAQFlag='y' Then Do
    Call SysCls
    Command="@Type PC2.faq |more"
    Command
End
Say
Say "   And now - enjoy! - And now - enjoy! - And now - enjoy! - And Now - enjoy!"
                                        /* Change to the drive where we installed from */
Command="@"Filespec("Drive", CurrentPathDirectory)" >NUL"
Command
                                        /* Change in the directory */
Command="@CD "Strip(Filespec("Path", CurrentPathDirectory), T, "\")" >NUL"
Command
Exit

/*--------------------------------------------------------------------------------------*\
 * Copy files from current directory to destination directory                           *
 * Req:                                                                                 *
 *      FileName ...... File to copy                                                    *
 *      Destination ... Destination directory                                           *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
FileCopy: Arg FileName, Destination
    
Command='@Copy 'FileName' 'Destination' >NUL'
Command
If rc\=0 Then Do
    Say "Sorry, the files couldn't be copied - exiting..."
    Exit
End
Return

/*--------------------------------------------------------------------------------------*\
 * Display the logo lines                                                               *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
DisplayLogo:
Call SysCls
Say
Say
Say "                 PC/2 - Program Commander/2 Version 1.30 for"
Say "                       IBM OS/2 2.x Presentation Manager"
Say "                    Copyright (C) by Stangl Roman 04, 1993"
Say
Return

/*--------------------------------------------------------------------------------------*\
 * The signal handler to exit after an exception                                        *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
SignalHandler:
Call SysCls
Say "PC/2 abnormal error - exiting..."
Exit

